/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.CommonArgParser;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.internal.commandline.GridConsole;
import org.apache.ignite.internal.commandline.GridConsoleAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLoggerFileHandler;
import org.apache.ignite.logger.java.JavaLoggerFormatter;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandHandler {
    static final String CMD_HELP = "--help";
    public static final String CONFIRM_MSG = "y";
    static final String DELIM = "--------------------------------------------------------------------------------";
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 1;
    public static final int EXIT_CODE_CONNECTION_FAILED = 2;
    public static final int ERR_AUTHENTICATION_FAILED = 3;
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 4;
    private static final long DFLT_PING_INTERVAL = 5000L;
    private static final long DFLT_PING_TIMEOUT = 30000L;
    private final Scanner in = new Scanner(System.in);
    public static final String UTILITY_NAME = "control.(sh|bat)";
    public static final String NULL = "null";
    private final Logger logger;
    protected final String ses = U.id8(UUID.randomUUID());
    public GridConsole console = GridConsoleAdapter.getInstance();
    private Object lastOperationRes;

    public static void main(String[] args) {
        CommandHandler hnd = new CommandHandler();
        System.exit(hnd.execute(Arrays.asList(args)));
    }

    private Logger setupJavaLogger() {
        Logger result = CommandHandler.initLogger(CommandHandler.class.getName() + "Log");
        try {
            String absPathPattern = new File(JavaLoggerFileHandler.logDirectory(U.defaultWorkDirectory()), "control-utility-%g.log").getAbsolutePath();
            FileHandler fileHandler = new FileHandler(absPathPattern, 0x500000, 5);
            fileHandler.setFormatter(new JavaLoggerFormatter());
            result.addHandler(fileHandler);
        }
        catch (Exception e) {
            System.out.println("Failed to configure logging to file");
        }
        result.addHandler(CommandHandler.setupStreamHandler());
        return result;
    }

    public static StreamHandler setupStreamHandler() {
        return new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
    }

    public static Logger initLogger(@Nullable String loggerName) {
        Logger result = loggerName == null ? Logger.getAnonymousLogger() : Logger.getLogger(loggerName);
        result.setLevel(Level.INFO);
        result.setUseParentHandlers(false);
        return result;
    }

    public CommandHandler() {
        this.logger = this.setupJavaLogger();
    }

    public CommandHandler(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(List<String> rawArgs) {
        LocalDateTime startTime = LocalDateTime.now();
        Thread.currentThread().setName("session=" + this.ses);
        this.logger.info("Control utility [ver. " + IgniteVersionUtils.ACK_VER_STR + "]");
        this.logger.info(IgniteVersionUtils.COPYRIGHT);
        this.logger.info("User: " + System.getProperty("user.name"));
        this.logger.info("Time: " + startTime);
        String commandName = "";
        try {
            if (F.isEmpty(rawArgs) || rawArgs.size() == 1 && CMD_HELP.equalsIgnoreCase(rawArgs.get(0))) {
                this.printHelp();
                int n = 0;
                return n;
            }
            ConnectionAndSslParameters args = new CommonArgParser(this.logger).parseAndValidate(rawArgs.iterator());
            Command command = args.command();
            commandName = command.name();
            GridClientConfiguration clientCfg = this.getClientConfiguration(args);
            int tryConnectMaxCount = 3;
            boolean suppliedAuth = !F.isEmpty(args.userName()) && !F.isEmpty(args.password());
            boolean credentialsRequested = false;
            while (true) {
                block27: {
                    try {
                        if (args.autoConfirmation()) break block27;
                        command.prepareConfirmation(clientCfg);
                        if (this.confirm(command.confirmationPrompt())) break block27;
                        this.logger.info("Operation cancelled.");
                        int n = 0;
                        return n;
                    }
                    catch (Throwable e) {
                        if (!CommandHandler.isAuthError(e)) {
                            throw e;
                        }
                        if (suppliedAuth) {
                            throw new GridClientAuthenticationException("Wrong credentials.");
                        }
                        if (tryConnectMaxCount == 0) {
                            throw new GridClientAuthenticationException("Maximum number of retries exceeded");
                        }
                        this.logger.info(credentialsRequested ? "Authentication error, please try again." : "This cluster requires authentication.");
                        if (credentialsRequested) {
                            --tryConnectMaxCount;
                        }
                        String user = this.retrieveUserName(args, clientCfg);
                        String pwd = new String(this.requestPasswordFromConsole("password: "));
                        clientCfg = this.getClientConfiguration(user, pwd, args);
                        credentialsRequested = true;
                        continue;
                    }
                }
                this.logger.info("Command [" + commandName + "] started");
                this.logger.info("Arguments: " + String.join((CharSequence)" ", rawArgs));
                this.logger.info(DELIM);
                this.lastOperationRes = command.execute(clientCfg, this.logger);
                break;
            }
            this.logger.info("Command [" + commandName + "] finished with code: " + 0);
            int n = 0;
            return n;
        }
        catch (IllegalArgumentException e) {
            this.logger.severe("Check arguments. " + CommandLogger.errorMessage(e));
            this.logger.info("Command [" + commandName + "] finished with code: " + 1);
            int command = 1;
            return command;
        }
        catch (Throwable e2) {
            if (CommandHandler.isAuthError(e2)) {
                this.logger.severe("Authentication error. " + CommandLogger.errorMessage(e2));
                this.logger.info("Command [" + commandName + "] finished with code: " + 3);
                int command = 3;
                return command;
            }
            if (CommandHandler.isConnectionError(e2)) {
                IgniteCheckedException cause = X.cause(e2, IgniteCheckedException.class);
                if (this.isConnectionClosedSilentlyException(e2)) {
                    this.logger.severe("Connection to cluster failed. Please check firewall settings and client and server are using the same SSL configuration.");
                } else {
                    IgniteCheckedException e2;
                    if (this.isSSLMisconfigurationError(cause)) {
                        e2 = cause;
                    }
                    this.logger.severe("Connection to cluster failed. " + CommandLogger.errorMessage(e2));
                }
                this.logger.info("Command [" + commandName + "] finished with code: " + 2);
                int endTime = 2;
                return endTime;
            }
            if (X.hasCause(e2, IllegalArgumentException.class)) {
                IllegalArgumentException iae = X.cause(e2, IllegalArgumentException.class);
                this.logger.severe("Check arguments. " + CommandLogger.errorMessage(iae));
                this.logger.info("Command [" + commandName + "] finished with code: " + 1);
                int endTime = 1;
                return endTime;
            }
            this.logger.severe(CommandLogger.errorMessage(e2));
            this.logger.info("Command [" + commandName + "] finished with code: " + 4);
            int n = 4;
            return n;
        }
        finally {
            LocalDateTime endTime = LocalDateTime.now();
            Duration diff = Duration.between(startTime, endTime);
            this.logger.info("Control utility has completed execution at: " + endTime);
            this.logger.info("Execution time: " + diff.toMillis() + " ms");
            Arrays.stream(this.logger.getHandlers()).filter(handler -> handler instanceof FileHandler).forEach(Handler::close);
        }
    }

    private boolean isSSLMisconfigurationError(Throwable e) {
        return e != null && e.getMessage() != null && e.getMessage().contains("SSL");
    }

    private boolean isConnectionClosedSilentlyException(Throwable e) {
        if (!(e instanceof GridClientDisconnectedException)) {
            return false;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return false;
        }
        return (cause = cause.getCause()) instanceof GridClientConnectionResetException && cause.getMessage() != null && cause.getMessage().contains("Failed to perform handshake");
    }

    private String retrieveUserName(ConnectionAndSslParameters args, GridClientConfiguration clientCfg) throws IgniteCheckedException {
        if (!F.isEmpty(args.userName())) {
            return args.userName();
        }
        if (clientCfg.getSecurityCredentialsProvider() == null) {
            return this.requestDataFromConsole("user: ");
        }
        return (String)clientCfg.getSecurityCredentialsProvider().credentials().getLogin();
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(ConnectionAndSslParameters args) throws IgniteCheckedException {
        return this.getClientConfiguration(args.userName(), args.password(), args);
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(String userName, String password, ConnectionAndSslParameters args) throws IgniteCheckedException {
        GridClientConfiguration clientCfg = new GridClientConfiguration();
        clientCfg.setPingInterval(args.pingInterval());
        clientCfg.setPingTimeout(args.pingTimeout());
        clientCfg.setServers(Collections.singletonList(args.host() + ":" + args.port()));
        if (!F.isEmpty(userName)) {
            clientCfg.setSecurityCredentialsProvider(this.getSecurityCredentialsProvider(userName, password, clientCfg));
        }
        if (!F.isEmpty(args.sslKeyStorePath())) {
            clientCfg.setSslContextFactory(this.createSslSupportFactory(args));
        }
        return clientCfg;
    }

    @NotNull
    private SecurityCredentialsProvider getSecurityCredentialsProvider(String userName, String password, GridClientConfiguration clientCfg) throws IgniteCheckedException {
        SecurityCredentialsProvider securityCredential = clientCfg.getSecurityCredentialsProvider();
        if (securityCredential == null) {
            return new SecurityCredentialsBasicProvider(new SecurityCredentials(userName, password));
        }
        SecurityCredentials credential = securityCredential.credentials();
        credential.setLogin(userName);
        credential.setPassword(password);
        return securityCredential;
    }

    @NotNull
    private GridSslBasicContextFactory createSslSupportFactory(ConnectionAndSslParameters args) {
        GridSslBasicContextFactory factory = new GridSslBasicContextFactory();
        List<String> sslProtocols = CommandHandler.split(args.sslProtocol(), ",");
        String sslProtocol = F.isEmpty(sslProtocols) ? "TLS" : sslProtocols.get(0);
        factory.setProtocol(sslProtocol);
        factory.setKeyAlgorithm(args.sslKeyAlgorithm());
        if (sslProtocols.size() > 1) {
            factory.setProtocols(sslProtocols);
        }
        factory.setCipherSuites(CommandHandler.split(args.getSslCipherSuites(), ","));
        factory.setKeyStoreFilePath(args.sslKeyStorePath());
        if (args.sslKeyStorePassword() != null) {
            factory.setKeyStorePassword(args.sslKeyStorePassword());
        } else {
            factory.setKeyStorePassword(this.requestPasswordFromConsole("SSL keystore password: "));
        }
        factory.setKeyStoreType(args.sslKeyStoreType());
        if (F.isEmpty(args.sslTrustStorePath())) {
            factory.setTrustManagers(GridSslBasicContextFactory.getDisabledTrustManager());
        } else {
            factory.setTrustStoreFilePath(args.sslTrustStorePath());
            if (args.sslTrustStorePassword() != null) {
                factory.setTrustStorePassword(args.sslTrustStorePassword());
            } else {
                factory.setTrustStorePassword(this.requestPasswordFromConsole("SSL truststore password: "));
            }
            factory.setTrustStoreType(args.sslTrustStoreType());
        }
        return factory;
    }

    public <T> T getLastOperationResult() {
        return (T)this.lastOperationRes;
    }

    private String readLine(String prompt) {
        System.out.print(prompt);
        return this.in.nextLine();
    }

    private boolean confirm(String str) {
        if (str == null) {
            return true;
        }
        String prompt = str + System.lineSeparator() + "Press '" + CONFIRM_MSG + "' to continue . . . ";
        return CONFIRM_MSG.equalsIgnoreCase(this.readLine(prompt));
    }

    public static boolean isAuthError(Throwable e) {
        return X.hasCause(e, GridClientAuthenticationException.class);
    }

    private static boolean isConnectionError(Throwable e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException;
    }

    private char[] requestPasswordFromConsole(String msg) {
        if (this.console == null) {
            throw new UnsupportedOperationException("Failed to securely read password (console is unavailable): " + msg);
        }
        return this.console.readPassword(msg, new Object[0]);
    }

    private String requestDataFromConsole(String msg) {
        if (this.console != null) {
            return this.console.readLine(msg, new Object[0]);
        }
        Scanner scanner = new Scanner(System.in);
        this.logger.info(msg);
        return scanner.nextLine();
    }

    private static List<String> split(String s, String delim) {
        if (F.isEmpty(s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(s.split(delim)).map(String::trim).filter(item -> !item.isEmpty()).collect(Collectors.toList());
    }

    private void printHelp() {
        this.logger.info("Control utility script is used to execute admin commands on cluster or get common cluster info. The command has the following syntax:");
        this.logger.info("");
        this.logger.info("  " + CommandLogger.join(" ", CommandLogger.join(" ", UTILITY_NAME, CommandLogger.join(" ", CommonArgParser.getCommonOptions())), CommandLogger.optional("command"), "<command_parameters>"));
        this.logger.info("");
        this.logger.info("");
        this.logger.info("This utility can do the following commands:");
        Arrays.stream(CommandList.values()).forEach(c -> c.command().printUsage(this.logger));
        this.logger.info("By default commands affecting the cluster require interactive confirmation.");
        this.logger.info("Use --yes option to disable it.");
        this.logger.info("");
        this.logger.info("Default values:");
        this.logger.info("    HOST_OR_IP=127.0.0.1");
        this.logger.info("    PORT=11211");
        this.logger.info("    PING_INTERVAL=5000");
        this.logger.info("    PING_TIMEOUT=30000");
        this.logger.info("    SSL_PROTOCOL=TLS");
        this.logger.info("    SSL_KEY_ALGORITHM=SunX509");
        this.logger.info("    KEYSTORE_TYPE=JKS");
        this.logger.info("    TRUSTSTORE_TYPE=JKS");
        this.logger.info("");
        this.logger.info("Exit codes:");
        this.logger.info("    0 - successful execution.");
        this.logger.info("    1 - invalid arguments.");
        this.logger.info("    2 - connection failed.");
        this.logger.info("    3 - authentication failed.");
        this.logger.info("    4 - unexpected error.");
    }
}

