/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.igfs.VisorIgfsResetMetricsTaskArg;

@GridInternal
@GridVisorManagementTask
public class VisorIgfsResetMetricsTask
extends VisorOneNodeTask<VisorIgfsResetMetricsTaskArg, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorIgfsResetMetricsJob job(VisorIgfsResetMetricsTaskArg arg) {
        return new VisorIgfsResetMetricsJob(arg, this.debug);
    }

    private static class VisorIgfsResetMetricsJob
    extends VisorJob<VisorIgfsResetMetricsTaskArg, Void> {
        private static final long serialVersionUID = 0L;

        private VisorIgfsResetMetricsJob(VisorIgfsResetMetricsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Void run(VisorIgfsResetMetricsTaskArg arg) {
            for (String igfsName : arg.getIgfsNames()) {
                try {
                    this.ignite.fileSystem(igfsName).resetMetrics();
                }
                catch (IllegalArgumentException iae) {
                    throw new IgniteException("Failed to reset metrics for IGFS: " + igfsName, iae);
                }
            }
            return null;
        }

        public String toString() {
            return S.toString(VisorIgfsResetMetricsJob.class, this);
        }
    }
}

