/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public class PlatformBalancingSingleClosureAffinityTask
extends PlatformAbstractTask {
    private static final long serialVersionUID = 0L;
    private PlatformJob job;
    private ClusterNode node;

    public PlatformBalancingSingleClosureAffinityTask(PlatformContext ctx, long taskPtr) {
        super(ctx, taskPtr);
    }

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (this.job != null) : "Job null-check must be performed in native platform.";
        return Collections.singletonMap(this.job, this.node);
    }

    public void job(PlatformJob job) {
        this.job = job;
    }

    public void affinity(String cacheName, Object affKey, GridKernalContext ctx) {
        try {
            Object affKey0 = ctx.affinity().affinityKey(cacheName, affKey);
            this.node = ctx.affinity().mapKeyToNode(cacheName, affKey0);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }
}

