/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to Ignite transactions.")
public interface TransactionsMXBean {
    @MXBeanDescription(value="Returns or kills transactions matching the filter conditions.")
    @MXBeanParametersNames(value={"minDuration", "minSize", "prj", "consistentIds", "xid", "lbRegex", "limit", "order", "detailed", "kill"})
    @MXBeanParametersDescriptions(value={"Minimum duration (seconds).", "Minimum size.", "Projection (servers|clients).", "Consistent ids (separated by comma).", "Transaction XID.", "Label regexp.", "Limit a number of transactions collected on each node.", "Order by DURATION|SIZE.", "Show detailed description, otherwise only count.", "Kill matching transactions (be careful)."})
    public String getActiveTransactions(Long var1, Integer var2, String var3, String var4, String var5, String var6, Integer var7, String var8, boolean var9, boolean var10);

    @MXBeanDescription(value="Returns transaction timeout on partition map exchange in milliseconds.")
    public long getTxTimeoutOnPartitionMapExchange();

    @MXBeanDescription(value="Sets transaction timeout on partition map exchange in milliseconds.")
    @MXBeanParametersNames(value={"timeout"})
    @MXBeanParametersDescriptions(value={"Transaction timeout on partition map exchange in milliseconds."})
    public void setTxTimeoutOnPartitionMapExchange(long var1);

    @MXBeanDescription(value="Shows if dump requests from local node to near node are allowed, when long running transaction  is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread.")
    public boolean getTxOwnerDumpRequestsAllowed();

    @MXBeanDescription(value="Shows if dump requests from local node to near node are allowed, when long running transaction  is found. If allowed, the compute request to near node will be made to get thread dump of transaction owner thread.")
    @MXBeanParametersNames(value={"allowed"})
    @MXBeanParametersDescriptions(value={"whether to allow"})
    public void setTxOwnerDumpRequestsAllowed(boolean var1);

    @MXBeanDescription(value="Returns threshold timeout in milliseconds for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while aquiring locks, preparing, commiting, etc.)and user time (time when client node runs some code while holding transaction). Returns 0 if not set. No transactions are dumped in log if this parameter is not set.")
    public long getLongTransactionTimeDumpThreshold();

    @MXBeanDescription(value="Sets threshold timeout in milliseconds for long transactions, if transaction exceeds it, it will be dumped in log with information about how much time did it spent in system time (time while aquiring locks, preparing, commiting, etc.) and user time (time when client node runs some code while holding transaction). Can be set to 0 - no transactions will be dumped in log in this case.")
    @MXBeanParametersNames(value={"threshold"})
    @MXBeanParametersDescriptions(value={"threshold timeout"})
    public void setLongTransactionTimeDumpThreshold(long var1);

    @MXBeanDescription(value="Returns the coefficient for samples of completed transactions that will be dumped in log.")
    public double getTransactionTimeDumpSamplesCoefficient();

    @MXBeanDescription(value="Sets the coefficient for samples of completed transactions that will be dumped in log.")
    @MXBeanParametersNames(value={"coefficient"})
    @MXBeanParametersDescriptions(value={"Samples coefficient."})
    public void setTransactionTimeDumpSamplesCoefficient(double var1);

    @MXBeanDescription(value="Returns the limit of samples of completed transactions that will be dumped in log per second, if {@link #getTransactionTimeDumpSamplesCoefficient} is above <code>0.0</code>. Must be integer value greater than <code>0</code>.")
    public int getTransactionTimeDumpSamplesPerSecondLimit();

    @MXBeanDescription(value="Sets the limit of samples of completed transactions that will be dumped in log per second, if {@link #getTransactionTimeDumpSamplesCoefficient} is above <code>0.0</code>. Must be integer value greater than <code>0</code>.")
    @MXBeanParametersNames(value={"limit"})
    @MXBeanParametersDescriptions(value={"Samples per second limit."})
    public void setTransactionTimeDumpSamplesPerSecondLimit(int var1);
}

