/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;

public class TcpCrusherSocketOptions
implements Serializable {
    public static final long DEFAULT_CONNECTION_TIMEOUT_MS = 5000L;
    public static final int DEFAULT_BACKLOG = 10;
    private int backlog = 10;
    private int rcvBufferSize = 0;
    private int sndBufferSize = 0;
    private long connectionTimeoutMs = 5000L;
    private boolean tcpNoDelay = true;
    private boolean keepAlive = true;
    private int lingerMs = -1;

    public TcpCrusherSocketOptions copy() {
        TcpCrusherSocketOptions copy = new TcpCrusherSocketOptions();
        copy.backlog = this.backlog;
        copy.rcvBufferSize = this.rcvBufferSize;
        copy.sndBufferSize = this.sndBufferSize;
        copy.connectionTimeoutMs = this.connectionTimeoutMs;
        copy.tcpNoDelay = this.tcpNoDelay;
        copy.keepAlive = this.keepAlive;
        copy.lingerMs = this.lingerMs;
        return copy;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getRcvBufferSize() {
        return this.rcvBufferSize;
    }

    public void setRcvBufferSize(int rcvBufferSize) {
        this.rcvBufferSize = rcvBufferSize;
    }

    public int getSndBufferSize() {
        return this.sndBufferSize;
    }

    public void setSndBufferSize(int sndBufferSize) {
        this.sndBufferSize = sndBufferSize;
    }

    public long getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(int lingerMs) {
        this.lingerMs = lingerMs;
    }

    void setupSocketChannel(SocketChannel socketChannel) throws IOException {
        socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)this.keepAlive);
        socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.rcvBufferSize > 0) {
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.rcvBufferSize);
        }
        if (this.sndBufferSize > 0) {
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sndBufferSize);
        }
        if (this.lingerMs >= 0) {
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.lingerMs);
        }
    }
}

