/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.internal.processors.platform.memory.PlatformAbstractMemory;
import org.jetbrains.annotations.Nullable;

public class PlatformExternalMemory
extends PlatformAbstractMemory {
    private final PlatformCallbackGateway gate;

    public PlatformExternalMemory(@Nullable PlatformCallbackGateway gate, long memPtr) {
        super(memPtr);
        this.gate = gate;
    }

    @Override
    public void reallocate(int cap) {
        if (this.gate == null) {
            throw new IgniteException("Failed to re-allocate external memory chunk because it is read-only.");
        }
        this.gate.memoryReallocate(this.memPtr, cap);
    }

    @Override
    public void close() {
    }
}

