/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.sql.DataSource;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSession;
import org.apache.ignite.cache.store.jdbc.JdbcType;
import org.apache.ignite.cache.store.jdbc.JdbcTypeDefaultHasher;
import org.apache.ignite.cache.store.jdbc.JdbcTypeField;
import org.apache.ignite.cache.store.jdbc.JdbcTypeHasher;
import org.apache.ignite.cache.store.jdbc.JdbcTypesDefaultTransformer;
import org.apache.ignite.cache.store.jdbc.JdbcTypesTransformer;
import org.apache.ignite.cache.store.jdbc.dialect.BasicJdbcDialect;
import org.apache.ignite.cache.store.jdbc.dialect.DB2Dialect;
import org.apache.ignite.cache.store.jdbc.dialect.H2Dialect;
import org.apache.ignite.cache.store.jdbc.dialect.JdbcDialect;
import org.apache.ignite.cache.store.jdbc.dialect.MySQLDialect;
import org.apache.ignite.cache.store.jdbc.dialect.OracleDialect;
import org.apache.ignite.cache.store.jdbc.dialect.SQLServerDialect;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.CacheStoreSessionResource;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.transactions.Transaction;
import org.jetbrains.annotations.Nullable;

public abstract class CacheAbstractJdbcStore<K, V>
implements CacheStore<K, V>,
LifecycleAware {
    protected static final String ATTR_CONN_PROP = "JDBC_STORE_CONNECTION";
    private static final String CACHE_LOADER_THREAD_NAME = "jdbc-cache-loader";
    protected static final Collection<String> BUILT_IN_TYPES = new HashSet<String>();
    @CacheStoreSessionResource
    private CacheStoreSession ses;
    @IgniteInstanceResource
    protected Ignite ignite;
    @LoggerResource
    protected IgniteLogger log;
    @GridToStringExclude
    private final Lock cacheMappingsLock = new ReentrantLock();
    protected volatile DataSource dataSrc;
    protected volatile Map<String, Map<Object, EntryMapping>> cacheMappings = Collections.emptyMap();
    private int batchSize = 512;
    protected JdbcDialect dialect;
    private int maxWrtAttempts = 2;
    private int maxPoolSize = Runtime.getRuntime().availableProcessors();
    private int parallelLoadCacheMinThreshold = 512;
    private JdbcType[] types;
    protected JdbcTypeHasher hasher = JdbcTypeDefaultHasher.INSTANCE;
    protected JdbcTypesTransformer transformer = JdbcTypesDefaultTransformer.INSTANCE;
    private boolean sqlEscapeAll;

    @Nullable
    protected abstract Object extractParameter(@Nullable String var1, String var2, TypeKind var3, String var4, Object var5) throws CacheException;

    protected abstract <R> R buildObject(@Nullable String var1, String var2, TypeKind var3, JdbcTypeField[] var4, Map<String, Integer> var5, ResultSet var6) throws CacheLoaderException;

    protected abstract Object typeIdForObject(Object var1) throws CacheException;

    protected abstract Object typeIdForTypeName(TypeKind var1, String var2) throws CacheException;

    protected abstract void prepareBuilders(@Nullable String var1, Collection<JdbcType> var2) throws CacheException;

    protected JdbcDialect resolveDialect() throws CacheException {
        Connection conn = null;
        String dbProductName = null;
        try {
            conn = this.openConnection(false);
            dbProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new CacheException("Failed access to metadata for detect database dialect.", e);
        }
        finally {
            U.closeQuiet(conn);
        }
        if ("H2".equals(dbProductName)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(dbProductName)) {
            return new MySQLDialect();
        }
        if (dbProductName.startsWith("Microsoft SQL Server")) {
            return new SQLServerDialect();
        }
        if ("Oracle".equals(dbProductName)) {
            return new OracleDialect();
        }
        if (dbProductName.startsWith("DB2/")) {
            return new DB2Dialect();
        }
        U.warn(this.log, "Failed to resolve dialect (BasicJdbcDialect will be used): " + dbProductName);
        return new BasicJdbcDialect();
    }

    @Override
    public void start() throws IgniteException {
        if (this.dataSrc == null) {
            throw new IgniteException("Failed to initialize cache store (data source is not provided).");
        }
        if (this.dialect == null) {
            this.dialect = this.resolveDialect();
            if (this.log.isDebugEnabled() && this.dialect.getClass() != BasicJdbcDialect.class) {
                this.log.debug("Resolved database dialect: " + U.getSimpleName(this.dialect.getClass()));
            }
        }
    }

    @Override
    public void stop() throws IgniteException {
    }

    protected Connection openConnection(boolean autocommit) throws SQLException {
        Connection conn = this.dataSrc.getConnection();
        conn.setAutoCommit(autocommit);
        return conn;
    }

    protected Connection connection() throws SQLException {
        CacheStoreSession ses = this.session();
        if (ses.transaction() != null) {
            Map<String, Connection> prop = ses.properties();
            Connection conn = (Connection)prop.get(ATTR_CONN_PROP);
            if (conn == null) {
                conn = this.openConnection(false);
                prop.put(ATTR_CONN_PROP, conn);
            }
            return conn;
        }
        return this.openConnection(true);
    }

    protected void closeConnection(@Nullable Connection conn) {
        CacheStoreSession ses = this.session();
        if (ses.transaction() == null) {
            U.closeQuiet(conn);
        }
    }

    protected void end(@Nullable Connection conn, @Nullable Statement st) {
        U.closeQuiet(st);
        this.closeConnection(conn);
    }

    @Override
    public void sessionEnd(boolean commit) throws CacheWriterException {
        CacheStoreSession ses = this.session();
        Transaction tx = ses.transaction();
        if (tx != null) {
            Map sesProps = ses.properties();
            Connection conn = (Connection)sesProps.get(ATTR_CONN_PROP);
            if (conn != null) {
                sesProps.remove(ATTR_CONN_PROP);
                try {
                    if (commit) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                }
                catch (SQLException e) {
                    throw new CacheWriterException("Failed to end transaction [xid=" + tx.xid() + ", commit=" + commit + ']', e);
                }
                finally {
                    U.closeQuiet(conn);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transaction ended [xid=" + tx.xid() + ", commit=" + commit + ']');
            }
        }
    }

    private Callable<Void> loadCacheRange(final EntryMapping em, final IgniteBiInClosure<K, V> clo, final @Nullable Object[] lowerBound, final @Nullable Object[] upperBound, final int fetchSize) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Connection conn = null;
                PreparedStatement stmt = null;
                try {
                    int j;
                    int i;
                    conn = CacheAbstractJdbcStore.this.openConnection(true);
                    stmt = conn.prepareStatement(lowerBound == null && upperBound == null ? em.loadCacheQry : em.loadCacheRangeQuery(lowerBound != null, upperBound != null));
                    stmt.setFetchSize(fetchSize);
                    int idx = 1;
                    if (lowerBound != null) {
                        for (i = lowerBound.length; i > 0; --i) {
                            for (j = 0; j < i; ++j) {
                                stmt.setObject(idx++, lowerBound[j]);
                            }
                        }
                    }
                    if (upperBound != null) {
                        for (i = upperBound.length; i > 0; --i) {
                            for (j = 0; j < i; ++j) {
                                stmt.setObject(idx++, upperBound[j]);
                            }
                        }
                    }
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        Object key = CacheAbstractJdbcStore.this.buildObject(em.cacheName, em.keyType(), em.keyKind(), em.keyColumns(), em.loadColIdxs, rs);
                        Object val = CacheAbstractJdbcStore.this.buildObject(em.cacheName, em.valueType(), em.valueKind(), em.valueColumns(), em.loadColIdxs, rs);
                        clo.apply(key, val);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new IgniteCheckedException("Failed to load cache", e);
                    }
                    catch (Throwable throwable) {
                        U.closeQuiet(stmt);
                        U.closeQuiet(conn);
                        throw throwable;
                    }
                }
                U.closeQuiet(stmt);
                U.closeQuiet(conn);
                return null;
            }
        };
    }

    private Callable<Void> loadCacheFull(EntryMapping m, IgniteBiInClosure<K, V> clo) {
        return this.loadCacheRange(m, clo, null, null, this.dialect.getFetchSize());
    }

    private void checkTypeConfiguration(@Nullable String cacheName, TypeKind kind, String typeName, JdbcTypeField[] flds) throws CacheException {
        try {
            if (kind == TypeKind.BUILT_IN) {
                if (flds.length != 1) {
                    throw new CacheException("More than one field for built in type [cache=" + U.maskName(cacheName) + ", type=" + typeName + " ]");
                }
                JdbcTypeField field = flds[0];
                if (field.getDatabaseFieldName() == null) {
                    throw new CacheException("Missing database name in mapping description [cache=" + U.maskName(cacheName) + ", type=" + typeName + " ]");
                }
                field.setJavaFieldType(Class.forName(typeName));
            } else {
                for (JdbcTypeField field : flds) {
                    if (field.getDatabaseFieldName() == null) {
                        throw new CacheException("Missing database name in mapping description [cache=" + U.maskName(cacheName) + ", type=" + typeName + " ]");
                    }
                    if (field.getJavaFieldName() == null) {
                        throw new CacheException("Missing field name in mapping description [cache=" + U.maskName(cacheName) + ", type=" + typeName + " ]");
                    }
                    if (field.getJavaFieldType() != null) continue;
                    throw new CacheException("Missing field type in mapping description [cache=" + U.maskName(cacheName) + ", type=" + typeName + " ]");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed to find class: " + typeName, e);
        }
    }

    protected TypeKind kindForName(String type, boolean binarySupported) {
        if (BUILT_IN_TYPES.contains(type)) {
            return TypeKind.BUILT_IN;
        }
        if (binarySupported) {
            return TypeKind.BINARY;
        }
        try {
            Class.forName(type);
            return TypeKind.POJO;
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed to find class " + type + " (make sure the class is present in classPath or use BinaryMarshaller)", e);
        }
    }

    protected TypeKind kindForName(String type) {
        return this.kindForName(type, this.ignite.configuration().getMarshaller() instanceof BinaryMarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, EntryMapping> getOrCreateCacheMappings(@Nullable String cacheName) throws CacheException {
        Map<Object, EntryMapping> entryMappings = this.cacheMappings.get(cacheName);
        if (entryMappings != null) {
            return entryMappings;
        }
        this.cacheMappingsLock.lock();
        try {
            entryMappings = this.cacheMappings.get(cacheName);
            if (entryMappings != null) {
                Map<Object, EntryMapping> map = entryMappings;
                return map;
            }
            ArrayList<JdbcType> cacheTypes = new ArrayList<JdbcType>(this.types.length);
            for (JdbcType type : this.types) {
                if ((cacheName == null || !cacheName.equals(type.getCacheName())) && (cacheName != null || type.getCacheName() != null)) continue;
                cacheTypes.add(type);
            }
            entryMappings = U.newHashMap(cacheTypes.size());
            if (!cacheTypes.isEmpty()) {
                boolean bl = this.ignite.configuration().getMarshaller() instanceof BinaryMarshaller;
                for (JdbcType type : cacheTypes) {
                    String keyType = type.getKeyType();
                    String valType = type.getValueType();
                    TypeKind keyKind = this.kindForName(keyType, bl);
                    this.checkTypeConfiguration(cacheName, keyKind, keyType, type.getKeyFields());
                    Object keyTypeId = this.typeIdForTypeName(keyKind, keyType);
                    if (entryMappings.containsKey(keyTypeId)) {
                        throw new CacheException("Key type must be unique in type metadata [cache=" + U.maskName(cacheName) + ", type=" + keyType + "]");
                    }
                    TypeKind valKind = this.kindForName(valType, bl);
                    this.checkTypeConfiguration(cacheName, valKind, valType, type.getValueFields());
                    entryMappings.put(keyTypeId, new EntryMapping(cacheName, this.dialect, type, keyKind, valKind, this.sqlEscapeAll));
                }
                HashMap<String, Map<Object, EntryMapping>> mappings = new HashMap<String, Map<Object, EntryMapping>>(this.cacheMappings);
                mappings.put(cacheName, entryMappings);
                this.prepareBuilders(cacheName, cacheTypes);
                this.cacheMappings = mappings;
            }
            Map<Object, EntryMapping> map = entryMappings;
            return map;
        }
        finally {
            this.cacheMappingsLock.unlock();
        }
    }

    private EntryMapping entryMapping(String cacheName, Object typeId) throws CacheException {
        Map<Object, EntryMapping> mappings = this.getOrCreateCacheMappings(cacheName);
        EntryMapping em = mappings.get(typeId);
        if (em == null) {
            String maskedCacheName = U.maskName(cacheName);
            throw new CacheException("Failed to find mapping description [cache=" + maskedCacheName + ", typeId=" + typeId + "]. Please configure JdbcType to associate cache '" + maskedCacheName + "' with JdbcPojoStore.");
        }
        return em;
    }

    protected Integer columnIndex(Map<String, Integer> loadColIdxs, String dbName) {
        Integer colIdx = loadColIdxs.get(dbName.toUpperCase());
        if (colIdx == null) {
            throw new IllegalStateException("Failed to find column index for database field: " + dbName);
        }
        return colIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCache(IgniteBiInClosure<K, V> clo, Object ... args) throws CacheLoaderException {
        ExecutorService pool = null;
        String cacheName = this.session().cacheName();
        try {
            PreparedStatement stmt;
            pool = Executors.newFixedThreadPool(this.maxPoolSize, new IgniteThreadFactory(this.ignite.name(), CACHE_LOADER_THREAD_NAME));
            ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
            Map<Object, EntryMapping> mappings = this.getOrCreateCacheMappings(cacheName);
            if (args != null && args.length > 0) {
                if (args.length % 2 != 0) {
                    throw new CacheLoaderException("Expected even number of arguments, but found: " + args.length);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Start loading entries from db using user queries from arguments...");
                }
                for (int i = 0; i < args.length; i += 2) {
                    LoadCacheCustomQueryWorker task;
                    final String string = args[i].toString();
                    if (!F.exist(mappings.values(), new IgnitePredicate<EntryMapping>(){

                        @Override
                        public boolean apply(EntryMapping em) {
                            return em.keyType().equals(string);
                        }
                    })) {
                        throw new CacheLoaderException("Provided key type is not found in store or cache configuration [cache=" + U.maskName(cacheName) + ", key=" + string + ']');
                    }
                    EntryMapping em = this.entryMapping(cacheName, this.typeIdForTypeName(this.kindForName(string), string));
                    Object arg = args[i + 1];
                    if (arg instanceof PreparedStatement) {
                        stmt = (PreparedStatement)arg;
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Started load cache using custom statement [cache=" + U.maskName(cacheName) + ", keyType=" + string + ", stmt=" + stmt + ']');
                        }
                        task = new LoadCacheCustomQueryWorker(em, stmt, clo);
                    } else {
                        String qry = arg.toString();
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Started load cache using custom query [cache=" + U.maskName(cacheName) + ", keyType=" + string + ", query=" + qry + ']');
                        }
                        task = new LoadCacheCustomQueryWorker(em, qry, clo);
                    }
                    futs.add(pool.submit(task));
                }
            } else {
                HashSet<String> processedKeyTypes = new HashSet<String>();
                for (EntryMapping em : mappings.values()) {
                    String keyType = em.keyType();
                    if (processedKeyTypes.contains(keyType)) continue;
                    processedKeyTypes.add(keyType);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Started load cache [cache=" + U.maskName(cacheName) + ", keyType=" + keyType + ']');
                    }
                    if (this.parallelLoadCacheMinThreshold > 0) {
                        Connection conn = null;
                        try {
                            conn = this.connection();
                            stmt = conn.prepareStatement(em.loadCacheSelRangeQry);
                            stmt.setInt(1, this.parallelLoadCacheMinThreshold);
                            ResultSet rs = stmt.executeQuery();
                            if (rs.next()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Multithread loading entries from db [cache=" + U.maskName(cacheName) + ", keyType=" + keyType + ']');
                                }
                                int keyCnt = em.keyCols.size();
                                Object[] upperBound = new Object[keyCnt];
                                for (int i = 0; i < keyCnt; ++i) {
                                    upperBound[i] = rs.getObject(i + 1);
                                }
                                futs.add(pool.submit(this.loadCacheRange(em, clo, null, upperBound, 0)));
                                while (rs.next()) {
                                    Object[] lowerBound = upperBound;
                                    upperBound = new Object[keyCnt];
                                    for (int i = 0; i < keyCnt; ++i) {
                                        upperBound[i] = rs.getObject(i + 1);
                                    }
                                    futs.add(pool.submit(this.loadCacheRange(em, clo, lowerBound, upperBound, 0)));
                                }
                                futs.add(pool.submit(this.loadCacheRange(em, clo, upperBound, null, 0)));
                                continue;
                            }
                        }
                        catch (SQLException e) {
                            this.log.warning("Failed to load entries from db in multithreaded mode, will try in single thread [cache=" + U.maskName(cacheName) + ", keyType=" + keyType + ']', e);
                        }
                        finally {
                            U.closeQuiet(conn);
                            continue;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Single thread loading entries from db [cache=" + U.maskName(cacheName) + ", keyType=" + keyType + ']');
                    }
                    futs.add(pool.submit(this.loadCacheFull(em, clo)));
                }
            }
            for (Future future : futs) {
                U.get(future);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished load cache: " + U.maskName(cacheName));
            }
        }
        catch (IgniteCheckedException e) {
            try {
                throw new CacheLoaderException("Failed to load cache: " + U.maskName(cacheName), e.getCause());
            }
            catch (Throwable throwable) {
                U.shutdownNow(this.getClass(), pool, this.log);
                throw throwable;
            }
        }
        U.shutdownNow(this.getClass(), pool, this.log);
    }

    @Override
    @Nullable
    public V load(K key) throws CacheLoaderException {
        PreparedStatement stmt;
        Connection conn;
        block6: {
            Object r;
            assert (key != null);
            EntryMapping em = this.entryMapping(this.session().cacheName(), this.typeIdForObject(key));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Load value from db [table= " + em.fullTableName() + ", key=" + key + ']');
            }
            conn = null;
            stmt = null;
            try {
                conn = this.connection();
                stmt = conn.prepareStatement(em.loadQrySingle);
                this.fillKeyParameters(stmt, em, key);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                r = this.buildObject(em.cacheName, em.valueType(), em.valueKind(), em.valueColumns(), em.loadColIdxs, rs);
                this.end(conn, stmt);
            }
            catch (SQLException e) {
                try {
                    throw new CacheLoaderException("Failed to load object [table=" + em.fullTableName() + ", key=" + key + "]", e);
                }
                catch (Throwable throwable) {
                    this.end(conn, stmt);
                    throw throwable;
                }
            }
            return (V)r;
        }
        this.end(conn, stmt);
        return null;
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        assert (keys != null);
        Connection conn = null;
        try {
            conn = this.connection();
            String cacheName = this.session().cacheName();
            HashMap workers = U.newHashMap(this.getOrCreateCacheMappings(cacheName).size());
            HashMap res = new HashMap();
            for (K key : keys) {
                Object keyTypeId = this.typeIdForObject(key);
                EntryMapping em = this.entryMapping(cacheName, keyTypeId);
                LoadWorker worker = (LoadWorker)workers.get(keyTypeId);
                if (worker == null) {
                    worker = new LoadWorker(conn, em);
                    workers.put(keyTypeId, worker);
                }
                worker.keys.add(key);
                if (worker.keys.size() != em.maxKeysPerStmt) continue;
                res.putAll(((LoadWorker)workers.remove(keyTypeId)).call());
            }
            for (LoadWorker worker : workers.values()) {
                res.putAll(worker.call());
            }
            HashMap hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            throw new CacheWriterException("Failed to load entries from database", e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void writeUpsert(PreparedStatement insStmt, PreparedStatement updStmt, EntryMapping em, Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
        try {
            Throwable we = null;
            for (int attempt = 0; attempt < this.maxWrtAttempts; ++attempt) {
                int paramIdx = this.fillValueParameters(updStmt, 1, em, entry.getValue());
                this.fillKeyParameters(updStmt, paramIdx, em, entry.getKey());
                if (updStmt.executeUpdate() == 0) {
                    paramIdx = this.fillKeyParameters(insStmt, em, entry.getKey());
                    this.fillValueParameters(insStmt, paramIdx, em, entry.getValue());
                    try {
                        insStmt.executeUpdate();
                        if (attempt > 0) {
                            U.warn(this.log, "Entry was inserted in database on second try [table=" + em.fullTableName() + ", entry=" + entry + "]");
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        for (SQLException nested = e.getNextException(); sqlState == null && nested != null; nested = nested.getNextException()) {
                            sqlState = nested.getSQLState();
                        }
                        if ("23505".equals(sqlState) || "23000".equals(sqlState)) {
                            if (we == null) {
                                we = new CacheWriterException("Failed insert entry in database, violate a unique index or primary key [table=" + em.fullTableName() + ", entry=" + entry + "]");
                            }
                            we.addSuppressed(e);
                            U.warn(this.log, "Failed insert entry in database, violate a unique index or primary key [table=" + em.fullTableName() + ", entry=" + entry + "]");
                            continue;
                        }
                        throw new CacheWriterException("Failed insert entry in database [table=" + em.fullTableName() + ", entry=" + entry, e);
                    }
                }
                if (attempt > 0) {
                    U.warn(this.log, "Entry was updated in database on second try [table=" + em.fullTableName() + ", entry=" + entry + "]");
                }
                return;
            }
            throw we;
        }
        catch (SQLException e) {
            throw new CacheWriterException("Failed update entry in database [table=" + em.fullTableName() + ", entry=" + entry + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
        block13: {
            assert (entry != null);
            K key = entry.getKey();
            EntryMapping em = this.entryMapping(this.session().cacheName(), this.typeIdForObject(key));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Start write entry to database [table=" + em.fullTableName() + ", entry=" + entry + "]");
            }
            Connection conn = null;
            try {
                conn = this.connection();
                if (this.dialect.hasMerge()) {
                    PreparedStatement stmt;
                    block12: {
                        stmt = null;
                        try {
                            stmt = conn.prepareStatement(em.mergeQry);
                            int idx = this.fillKeyParameters(stmt, em, key);
                            this.fillValueParameters(stmt, idx, em, entry.getValue());
                            int updCnt = stmt.executeUpdate();
                            if (updCnt == 1) break block12;
                            U.warn(this.log, "Unexpected number of updated entries [table=" + em.fullTableName() + ", entry=" + entry + "expected=1, actual=" + updCnt + "]");
                        }
                        catch (Throwable throwable) {
                            U.closeQuiet(stmt);
                            throw throwable;
                        }
                    }
                    U.closeQuiet(stmt);
                    break block13;
                }
                PreparedStatement insStmt = null;
                PreparedStatement updStmt = null;
                try {
                    insStmt = conn.prepareStatement(em.insQry);
                    updStmt = conn.prepareStatement(em.updQry);
                    this.writeUpsert(insStmt, updStmt, em, entry);
                }
                catch (Throwable throwable) {
                    U.closeQuiet(insStmt);
                    U.closeQuiet(updStmt);
                    throw throwable;
                }
                U.closeQuiet(insStmt);
                U.closeQuiet(updStmt);
            }
            catch (SQLException e) {
                throw new CacheWriterException("Failed to write entry to database [table=" + em.fullTableName() + ", entry=" + entry + "]", e);
            }
            finally {
                this.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(final Collection<Cache.Entry<? extends K, ? extends V>> entries) throws CacheWriterException {
        block23: {
            assert (entries != null);
            Connection conn = null;
            try {
                conn = this.connection();
                String cacheName = this.session().cacheName();
                Object currKeyTypeId = null;
                if (this.dialect.hasMerge()) {
                    PreparedStatement mergeStmt = null;
                    try {
                        EntryMapping em = null;
                        LazyValue<Object[]> lazyEntries = new LazyValue<Object[]>(){

                            @Override
                            public Object[] create() {
                                return entries.toArray();
                            }
                        };
                        int fromIdx = 0;
                        int prepared = 0;
                        for (Cache.Entry<K, V> entry : entries) {
                            K key = entry.getKey();
                            Object keyTypeId = this.typeIdForObject(key);
                            em = this.entryMapping(cacheName, keyTypeId);
                            if (currKeyTypeId == null || !currKeyTypeId.equals(keyTypeId)) {
                                if (mergeStmt != null) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Write entries to db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                                    }
                                    this.executeBatch(em, mergeStmt, "writeAll", fromIdx, prepared, lazyEntries);
                                    U.closeQuiet(mergeStmt);
                                }
                                mergeStmt = conn.prepareStatement(em.mergeQry);
                                currKeyTypeId = keyTypeId;
                                fromIdx += prepared;
                                prepared = 0;
                            }
                            int idx = this.fillKeyParameters(mergeStmt, em, key);
                            this.fillValueParameters(mergeStmt, idx, em, entry.getValue());
                            mergeStmt.addBatch();
                            if (++prepared % this.batchSize != 0) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Write entries to db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                            }
                            this.executeBatch(em, mergeStmt, "writeAll", fromIdx, prepared, lazyEntries);
                            fromIdx += prepared;
                            prepared = 0;
                        }
                        if (mergeStmt != null && prepared % this.batchSize != 0) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Write entries to db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                            }
                            this.executeBatch(em, mergeStmt, "writeAll", fromIdx, prepared, lazyEntries);
                        }
                        break block23;
                    }
                    finally {
                        U.closeQuiet(mergeStmt);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Write entries to db one by one using update and insert statements [cache=" + U.maskName(cacheName) + ", cnt=" + entries.size() + "]");
                }
                PreparedStatement insStmt = null;
                PreparedStatement updStmt = null;
                try {
                    for (Cache.Entry<K, V> entry : entries) {
                        K key = entry.getKey();
                        Object keyTypeId = this.typeIdForObject(key);
                        EntryMapping em = this.entryMapping(cacheName, keyTypeId);
                        if (currKeyTypeId == null || !currKeyTypeId.equals(keyTypeId)) {
                            U.closeQuiet(insStmt);
                            insStmt = conn.prepareStatement(em.insQry);
                            U.closeQuiet(updStmt);
                            updStmt = conn.prepareStatement(em.updQry);
                            currKeyTypeId = keyTypeId;
                        }
                        this.writeUpsert(insStmt, updStmt, em, entry);
                    }
                }
                finally {
                    U.closeQuiet(insStmt);
                    U.closeQuiet(updStmt);
                }
            }
            catch (SQLException e) {
                throw new CacheWriterException("Failed to write entries in database", e);
            }
            finally {
                this.closeConnection(conn);
            }
        }
    }

    @Override
    public void delete(Object key) throws CacheWriterException {
        assert (key != null);
        EntryMapping em = this.entryMapping(this.session().cacheName(), this.typeIdForObject(key));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove value from db [table=" + em.fullTableName() + ", key=" + key + "]");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.connection();
            stmt = conn.prepareStatement(em.remQry);
            this.fillKeyParameters(stmt, em, key);
            int delCnt = stmt.executeUpdate();
            if (delCnt != 1) {
                U.warn(this.log, "Unexpected number of deleted entries [table=" + em.fullTableName() + ", key=" + key + ", expected=1, actual=" + delCnt + "]");
            }
            this.end(conn, stmt);
        }
        catch (SQLException e) {
            try {
                throw new CacheWriterException("Failed to remove value from database [table=" + em.fullTableName() + ", key=" + key + "]", e);
            }
            catch (Throwable throwable) {
                this.end(conn, stmt);
                throw throwable;
            }
        }
    }

    private void executeBatch(EntryMapping em, Statement stmt, String desc, int fromIdx, int prepared, LazyValue<Object[]> lazyObjs) throws SQLException {
        try {
            int[] rowCounts = stmt.executeBatch();
            int numOfRowCnt = rowCounts.length;
            if (numOfRowCnt != prepared) {
                U.warn(this.log, "Unexpected number of updated rows [table=" + em.fullTableName() + ", expected=" + prepared + ", actual=" + numOfRowCnt + "]");
            }
            for (int i = 0; i < numOfRowCnt; ++i) {
                int cnt = rowCounts[i];
                if (cnt == 1 || cnt == -2) continue;
                Object[] objs = lazyObjs.value();
                U.warn(this.log, "Batch " + desc + " returned unexpected updated row count [table=" + em.fullTableName() + ", entry=" + objs[fromIdx + i] + ", expected=1, actual=" + cnt + "]");
            }
        }
        catch (BatchUpdateException be) {
            int[] rowCounts = be.getUpdateCounts();
            for (int i = 0; i < rowCounts.length; ++i) {
                if (rowCounts[i] != -3) continue;
                Object[] objs = lazyObjs.value();
                U.warn(this.log, "Batch " + desc + " failed on execution [table=" + em.fullTableName() + ", entry=" + objs[fromIdx + i] + "]");
            }
            throw be;
        }
    }

    @Override
    public void deleteAll(final Collection<?> keys) throws CacheWriterException {
        assert (keys != null);
        Connection conn = null;
        try {
            conn = this.connection();
            LazyValue<Object[]> lazyKeys = new LazyValue<Object[]>(){

                @Override
                public Object[] create() {
                    return keys.toArray();
                }
            };
            String cacheName = this.session().cacheName();
            Object currKeyTypeId = null;
            EntryMapping em = null;
            PreparedStatement delStmt = null;
            int fromIdx = 0;
            int prepared = 0;
            for (Object key : keys) {
                Object keyTypeId = this.typeIdForObject(key);
                em = this.entryMapping(cacheName, keyTypeId);
                if (delStmt == null) {
                    delStmt = conn.prepareStatement(em.remQry);
                    currKeyTypeId = keyTypeId;
                }
                if (!currKeyTypeId.equals(keyTypeId)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Delete entries from db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                    }
                    this.executeBatch(em, delStmt, "deleteAll", fromIdx, prepared, lazyKeys);
                    fromIdx += prepared;
                    prepared = 0;
                    currKeyTypeId = keyTypeId;
                }
                this.fillKeyParameters(delStmt, em, key);
                delStmt.addBatch();
                if (++prepared % this.batchSize != 0) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Delete entries from db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                }
                this.executeBatch(em, delStmt, "deleteAll", fromIdx, prepared, lazyKeys);
                fromIdx += prepared;
                prepared = 0;
            }
            if (delStmt != null && prepared % this.batchSize != 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Delete entries from db [cache=" + U.maskName(cacheName) + ", keyType=" + em.keyType() + ", cnt=" + prepared + "]");
                }
                this.executeBatch(em, delStmt, "deleteAll", fromIdx, prepared, lazyKeys);
            }
        }
        catch (SQLException e) {
            throw new CacheWriterException("Failed to remove values from database", e);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    protected void fillParameter(PreparedStatement stmt, int idx, JdbcTypeField field, @Nullable Object fieldVal) throws CacheException {
        try {
            if (fieldVal != null) {
                if (field.getJavaFieldType() == UUID.class) {
                    switch (field.getDatabaseFieldType()) {
                        case -2: {
                            fieldVal = U.uuidToBytes((UUID)fieldVal);
                            break;
                        }
                        case 1: 
                        case 12: {
                            fieldVal = fieldVal.toString();
                            break;
                        }
                    }
                } else if (field.getJavaFieldType().isEnum()) {
                    if (fieldVal instanceof Enum) {
                        Enum val = (Enum)fieldVal;
                        fieldVal = JdbcTypesTransformer.NUMERIC_TYPES.contains(field.getDatabaseFieldType()) ? Integer.valueOf(val.ordinal()) : val.name();
                    } else if (fieldVal instanceof BinaryEnumObjectImpl) {
                        BinaryEnumObjectImpl val = (BinaryEnumObjectImpl)fieldVal;
                        fieldVal = val.enumOrdinal();
                    }
                }
                stmt.setObject(idx, fieldVal);
            } else {
                stmt.setNull(idx, field.getDatabaseFieldType());
            }
        }
        catch (SQLException e) {
            throw new CacheException("Failed to set statement parameter name: " + field.getDatabaseFieldName(), e);
        }
    }

    protected int fillKeyParameters(PreparedStatement stmt, int idx, EntryMapping em, Object key) throws CacheException {
        for (JdbcTypeField field : em.keyColumns()) {
            Object fieldVal = this.extractParameter(em.cacheName, em.keyType(), em.keyKind(), field.getJavaFieldName(), key);
            this.fillParameter(stmt, idx++, field, fieldVal);
        }
        return idx;
    }

    protected int fillKeyParameters(PreparedStatement stmt, EntryMapping m, Object key) throws CacheException {
        return this.fillKeyParameters(stmt, 1, m, key);
    }

    protected int fillValueParameters(PreparedStatement stmt, int idx, EntryMapping em, Object val) throws CacheWriterException {
        for (JdbcTypeField field : em.uniqValFlds) {
            Object fieldVal = this.extractParameter(em.cacheName, em.valueType(), em.valueKind(), field.getJavaFieldName(), val);
            this.fillParameter(stmt, idx++, field, fieldVal);
        }
        return idx;
    }

    public DataSource getDataSource() {
        return this.dataSrc;
    }

    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(JdbcDialect dialect) {
        this.dialect = dialect;
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaximumPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaximumWriteAttempts() {
        return this.maxWrtAttempts;
    }

    public void setMaximumWriteAttempts(int maxWrtAttempts) {
        this.maxWrtAttempts = maxWrtAttempts;
    }

    public JdbcType[] getTypes() {
        return this.types;
    }

    public void setTypes(JdbcType ... types) {
        this.types = types;
    }

    public JdbcTypeHasher getHasher() {
        return this.hasher;
    }

    public void setHasher(JdbcTypeHasher hasher) {
        this.hasher = hasher;
    }

    public JdbcTypesTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(JdbcTypesTransformer transformer) {
        this.transformer = transformer;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getParallelLoadCacheMinimumThreshold() {
        return this.parallelLoadCacheMinThreshold;
    }

    public void setParallelLoadCacheMinimumThreshold(int parallelLoadCacheMinThreshold) {
        this.parallelLoadCacheMinThreshold = parallelLoadCacheMinThreshold;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public void setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
    }

    protected Ignite ignite() {
        return this.ignite;
    }

    protected CacheStoreSession session() {
        return this.ses;
    }

    static {
        BUILT_IN_TYPES.add("java.math.BigDecimal");
        BUILT_IN_TYPES.add("java.lang.Boolean");
        BUILT_IN_TYPES.add("java.lang.Byte");
        BUILT_IN_TYPES.add("java.lang.Character");
        BUILT_IN_TYPES.add("java.lang.Double");
        BUILT_IN_TYPES.add("java.util.Date");
        BUILT_IN_TYPES.add("java.sql.Date");
        BUILT_IN_TYPES.add("java.lang.Float");
        BUILT_IN_TYPES.add("java.lang.Integer");
        BUILT_IN_TYPES.add("java.lang.Long");
        BUILT_IN_TYPES.add("java.lang.Short");
        BUILT_IN_TYPES.add("java.lang.String");
        BUILT_IN_TYPES.add("java.sql.Timestamp");
        BUILT_IN_TYPES.add("java.util.UUID");
    }

    private class LoadWorker<K1, V1>
    implements Callable<Map<K1, V1>> {
        private final Connection conn;
        private final Collection<K1> keys;
        private final EntryMapping em;

        private LoadWorker(Connection conn, EntryMapping em) {
            this.conn = conn;
            this.em = em;
            this.keys = new ArrayList<K1>(em.maxKeysPerStmt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<K1, V1> call() throws Exception {
            HashMap hashMap;
            if (CacheAbstractJdbcStore.this.log.isDebugEnabled()) {
                CacheAbstractJdbcStore.this.log.debug("Load values from db [table= " + this.em.fullTableName() + ", keysCnt=" + this.keys.size() + "]");
            }
            PreparedStatement stmt = null;
            try {
                stmt = this.conn.prepareStatement(this.em.loadQuery(this.keys.size()));
                int idx = 1;
                for (K1 key : this.keys) {
                    for (JdbcTypeField field : this.em.keyColumns()) {
                        Object fieldVal = CacheAbstractJdbcStore.this.extractParameter(this.em.cacheName, this.em.keyType(), this.em.keyKind(), field.getJavaFieldName(), key);
                        CacheAbstractJdbcStore.this.fillParameter(stmt, idx++, field, fieldVal);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                HashMap entries = U.newHashMap(this.keys.size());
                while (rs.next()) {
                    Object r = CacheAbstractJdbcStore.this.buildObject(this.em.cacheName, this.em.keyType(), this.em.keyKind(), this.em.keyColumns(), this.em.loadColIdxs, rs);
                    Object val = CacheAbstractJdbcStore.this.buildObject(this.em.cacheName, this.em.valueType(), this.em.valueKind(), this.em.valueColumns(), this.em.loadColIdxs, rs);
                    entries.put(r, val);
                }
                hashMap = entries;
            }
            catch (Throwable throwable) {
                U.closeQuiet(stmt);
                throw throwable;
            }
            U.closeQuiet(stmt);
            return hashMap;
        }
    }

    private static abstract class LazyValue<T> {
        private T val;

        private LazyValue() {
        }

        protected abstract T create();

        public T value() {
            if (this.val == null) {
                this.val = this.create();
            }
            return this.val;
        }
    }

    private class LoadCacheCustomQueryWorker<K1, V1>
    implements Callable<Void> {
        private final EntryMapping em;
        private PreparedStatement stmt;
        private String qry;
        private final IgniteBiInClosure<K1, V1> clo;

        private LoadCacheCustomQueryWorker(EntryMapping em, PreparedStatement stmt, IgniteBiInClosure<K1, V1> clo) {
            this.em = em;
            this.stmt = stmt;
            this.clo = clo;
        }

        private LoadCacheCustomQueryWorker(EntryMapping em, String qry, IgniteBiInClosure<K1, V1> clo) {
            this.em = em;
            this.qry = qry;
            this.clo = clo;
        }

        @Override
        public Void call() throws Exception {
            Connection conn = null;
            try {
                if (this.stmt == null) {
                    conn = CacheAbstractJdbcStore.this.openConnection(true);
                    this.stmt = conn.prepareStatement(this.qry);
                }
                this.stmt.setFetchSize(CacheAbstractJdbcStore.this.dialect.getFetchSize());
                ResultSet rs = this.stmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                HashMap<String, Integer> colIdxs = U.newHashMap(meta.getColumnCount());
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    colIdxs.put(meta.getColumnLabel(i).toUpperCase(), i);
                }
                while (rs.next()) {
                    Object key = CacheAbstractJdbcStore.this.buildObject(this.em.cacheName, this.em.keyType(), this.em.keyKind(), this.em.keyColumns(), colIdxs, rs);
                    Object val = CacheAbstractJdbcStore.this.buildObject(this.em.cacheName, this.em.valueType(), this.em.valueKind(), this.em.valueColumns(), colIdxs, rs);
                    this.clo.apply(key, val);
                }
                Void void_ = null;
                return void_;
            }
            catch (SQLException e) {
                throw new CacheLoaderException("Failed to execute custom query for load cache", e);
            }
            finally {
                if (conn != null) {
                    U.closeQuiet(this.stmt);
                    U.closeQuiet(conn);
                }
            }
        }
    }

    protected static class EntryMapping {
        private final String cacheName;
        private final JdbcDialect dialect;
        private final String loadCacheSelRangeQry;
        private final String loadCacheQry;
        private final String loadQrySingle;
        private final String loadQry;
        private final String mergeQry;
        private final String insQry;
        private final String updQry;
        private final String remQry;
        private final int maxKeysPerStmt;
        private final Collection<String> keyCols;
        private final Collection<String> sqlKeyCols;
        private final Collection<String> cols;
        private final Collection<String> sqlCols;
        private final Map<String, Integer> loadColIdxs;
        private final Collection<JdbcTypeField> uniqValFlds;
        private final JdbcType typeMeta;
        private final TypeKind keyKind;
        private final TypeKind valKind;
        private final String fullTblName;
        private final String sqlFullTblName;

        private static Collection<String> escape(JdbcDialect dialect, Collection<String> cols) {
            ArrayList<String> res = new ArrayList<String>(cols.size());
            for (String col : cols) {
                res.add(dialect.escape(col));
            }
            return res;
        }

        public EntryMapping(@Nullable String cacheName, JdbcDialect dialect, JdbcType typeMeta, TypeKind keyKind, TypeKind valKind, boolean escape) {
            Collection<String> sqlUniqueValCols;
            this.cacheName = cacheName;
            this.dialect = dialect;
            this.typeMeta = typeMeta;
            this.keyKind = keyKind;
            this.valKind = valKind;
            JdbcTypeField[] keyFields = typeMeta.getKeyFields();
            JdbcTypeField[] valFields = typeMeta.getValueFields();
            this.keyCols = EntryMapping.databaseColumns(F.asList(keyFields));
            this.uniqValFlds = F.view(F.asList(valFields), new IgnitePredicate<JdbcTypeField>(){

                @Override
                public boolean apply(JdbcTypeField col) {
                    return !keyCols.contains(col.getDatabaseFieldName());
                }
            });
            String schema = typeMeta.getDatabaseSchema();
            String tblName = typeMeta.getDatabaseTable();
            Collection<String> uniqueValCols = EntryMapping.databaseColumns(this.uniqValFlds);
            this.cols = F.concat(false, this.keyCols, uniqueValCols);
            this.loadColIdxs = U.newHashMap(this.cols.size());
            int idx = 1;
            for (String col : this.cols) {
                this.loadColIdxs.put(col.toUpperCase(), idx++);
            }
            String string = this.fullTblName = F.isEmpty(schema) ? tblName : schema + "." + tblName;
            if (escape) {
                this.sqlFullTblName = F.isEmpty(schema) ? dialect.escape(tblName) : dialect.escape(schema) + "." + dialect.escape(tblName);
                this.sqlCols = EntryMapping.escape(dialect, this.cols);
                this.sqlKeyCols = EntryMapping.escape(dialect, this.keyCols);
                sqlUniqueValCols = EntryMapping.escape(dialect, uniqueValCols);
            } else {
                this.sqlFullTblName = this.fullTblName;
                this.sqlCols = this.cols;
                this.sqlKeyCols = this.keyCols;
                sqlUniqueValCols = uniqueValCols;
            }
            this.loadCacheQry = dialect.loadCacheQuery(this.sqlFullTblName, this.sqlCols);
            this.loadCacheSelRangeQry = dialect.loadCacheSelectRangeQuery(this.sqlFullTblName, this.sqlKeyCols);
            this.loadQrySingle = dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, 1);
            this.maxKeysPerStmt = dialect.getMaxParameterCount() / this.sqlKeyCols.size();
            this.loadQry = dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, this.maxKeysPerStmt);
            this.insQry = dialect.insertQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.updQry = dialect.updateQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.mergeQry = dialect.mergeQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.remQry = dialect.removeQuery(this.sqlFullTblName, this.sqlKeyCols);
        }

        private static Collection<String> databaseColumns(Collection<JdbcTypeField> dsc) {
            return F.transform(dsc, new C1<JdbcTypeField, String>(){

                @Override
                public String apply(JdbcTypeField col) {
                    return col.getDatabaseFieldName();
                }
            });
        }

        protected String keyType() {
            return this.typeMeta.getKeyType();
        }

        protected TypeKind keyKind() {
            return this.keyKind;
        }

        protected String valueType() {
            return this.typeMeta.getValueType();
        }

        protected TypeKind valueKind() {
            return this.valKind;
        }

        protected String loadQuery(int keyCnt) {
            assert (keyCnt <= this.maxKeysPerStmt);
            if (keyCnt == this.maxKeysPerStmt) {
                return this.loadQry;
            }
            if (keyCnt == 1) {
                return this.loadQrySingle;
            }
            return this.dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, keyCnt);
        }

        protected String loadCacheRangeQuery(boolean appendLowerBound, boolean appendUpperBound) {
            return this.dialect.loadCacheRangeQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, appendLowerBound, appendUpperBound);
        }

        protected JdbcTypeField[] keyColumns() {
            return this.typeMeta.getKeyFields();
        }

        protected JdbcTypeField[] valueColumns() {
            return this.typeMeta.getValueFields();
        }

        protected String fullTableName() {
            return this.fullTblName;
        }
    }

    protected static enum TypeKind {
        BUILT_IN,
        POJO,
        BINARY;

    }
}

