/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tms.security.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;

public class TmsClientSecurityConfig {
    private final URI trustStoreUri;
    private final String trustStorePassword;
    private final String username;
    private final String password;

    public TmsClientSecurityConfig(String trustStorePassword, URI trustStoreUri, String username, String password) {
        this.trustStorePassword = trustStorePassword;
        this.trustStoreUri = trustStoreUri;
        this.username = username;
        this.password = password;
    }

    public TrustManagerFactory getTrustManagerFactory() throws IOException, GeneralSecurityException {
        FileInputStream truststoreStream = new FileInputStream(this.trustStoreUri.getPath());
        KeyStore truststore = KeyStore.getInstance("JKS");
        truststore.load(truststoreStream, this.trustStorePassword.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(truststore);
        return trustManagerFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TmsClientSecurityConfig that = (TmsClientSecurityConfig)o;
        return Objects.equals(this.trustStoreUri, that.trustStoreUri) && Objects.equals(this.trustStorePassword, that.trustStorePassword) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.trustStoreUri, this.trustStorePassword, this.username, this.password);
    }

    public String toString() {
        return "TmsClientSecurityConfig{trustStoreUri=" + this.trustStoreUri + ", trustStorePassword='" + this.trustStorePassword + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
    }
}

