/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.distribution.WatchedProcess;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecureTcConfig;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.HostAndIpValidator;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.OS;
import org.terracotta.angela.common.util.ProcessUtil;
import org.terracotta.angela.common.util.TriggeringOutputStream;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class Distribution102Controller
extends DistributionController {
    private static final Logger logger = LoggerFactory.getLogger(Distribution102Controller.class);
    private final boolean tsaFullLogging = AngelaProperties.TSA_FULL_LOGGING.getBooleanValue();
    private final boolean tmsFullLogging = AngelaProperties.TMS_FULL_LOGGING.getBooleanValue();

    Distribution102Controller(Distribution distribution) {
        super(distribution);
    }

    @Override
    public TerracottaServerInstance.TerracottaServerInstanceProcess createTsa(TerracottaServer terracottaServer, File kitDir, File workingDir, Topology topology, Map<ServerSymbolicName, Integer> proxiedPorts, TerracottaCommandLineEnvironment tcEnv, Map<String, String> envOverrides, List<String> startUpArgs) {
        Map<String, String> env = tcEnv.buildEnv(this.javaLocationResolver, envOverrides);
        AtomicReference<TerracottaServerState> stateRef = new AtomicReference<TerracottaServerState>(TerracottaServerState.STOPPED);
        AtomicInteger javaPid = new AtomicInteger(-1);
        TriggeringOutputStream serverLogOutputStream = TriggeringOutputStream.triggerOn(Pattern.compile("^.*\\QTerracotta Server instance has started up as ACTIVE\\E.*$"), mr -> stateRef.set(TerracottaServerState.STARTED_AS_ACTIVE)).andTriggerOn(Pattern.compile("^.*\\QMoved to State[ PASSIVE-STANDBY ]\\E.*$"), mr -> stateRef.set(TerracottaServerState.STARTED_AS_PASSIVE)).andTriggerOn(Pattern.compile("^.*\\QL2 Exiting\\E.*$"), mr -> stateRef.set(TerracottaServerState.STOPPED)).andTriggerOn(Pattern.compile("^.*PID is (\\d+).*$"), mr -> {
            javaPid.set(Integer.parseInt(mr.group(1)));
            stateRef.compareAndSet(TerracottaServerState.STOPPED, TerracottaServerState.STARTING);
        });
        serverLogOutputStream = this.tsaFullLogging ? serverLogOutputStream.andForward(line -> ExternalLoggers.tsaLogger.info("[{}] {}", (Object)terracottaServer.getServerSymbolicName().getSymbolicName(), line)) : serverLogOutputStream.andTriggerOn(Pattern.compile("^.*(WARN|ERROR).*$"), mr -> ExternalLoggers.tsaLogger.info("[{}] {}", (Object)terracottaServer.getServerSymbolicName().getSymbolicName(), (Object)mr.group()));
        WatchedProcess<TerracottaServerState> watchedProcess = new WatchedProcess<TerracottaServerState>(new ProcessExecutor().command(this.createTsaCommand(terracottaServer.getServerSymbolicName(), terracottaServer.getId(), topology, proxiedPorts, kitDir, workingDir, startUpArgs)).directory(workingDir).environment(env).redirectErrorStream(true).redirectOutput(serverLogOutputStream), stateRef, TerracottaServerState.STOPPED);
        while (javaPid.get() == -1 && watchedProcess.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!watchedProcess.isAlive()) {
            throw new RuntimeException("Terracotta server process died in its infancy : " + terracottaServer.getServerSymbolicName());
        }
        return new TerracottaServerInstance.TerracottaServerInstanceProcess(stateRef, watchedProcess.getPid(), javaPid);
    }

    @Override
    public ToolExecutionResult configureCluster(File kitDir, File workingDir, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, License license, SecurityRootDirectory securityDir, TerracottaCommandLineEnvironment env, Map<String, String> envOverrides, String ... arguments) {
        List<String> command = this.createClusterConfigureCommand(kitDir, workingDir, topology, proxyTsaPorts, license, securityDir, arguments);
        return this.executeCommand(command, env, workingDir, envOverrides);
    }

    @Override
    public ToolExecutionResult invokeClusterTool(File kitDir, File workingDir, SecurityRootDirectory securityDir, TerracottaCommandLineEnvironment env, Map<String, String> envOverrides, String ... arguments) {
        List<String> command = this.createClusterToolCommand(kitDir, workingDir, securityDir, arguments);
        return this.executeCommand(command, env, workingDir, envOverrides);
    }

    @Override
    public ToolExecutionResult invokeConfigTool(File kitDir, File workingDir, SecurityRootDirectory securityDir, TerracottaCommandLineEnvironment env, Map<String, String> envOverrides, String ... arguments) {
        throw new UnsupportedOperationException("Running config tool is not supported in this distribution version");
    }

    @Override
    public ToolExecutionResult activateCluster(File kitDir, File workingDir, License license, SecurityRootDirectory securityDir, TerracottaCommandLineEnvironment env, Map<String, String> envOverrides, String ... arguments) {
        throw new UnsupportedOperationException("Running config tool is not supported in this distribution version");
    }

    @Override
    public TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv, Map<String, String> envOverrides) {
        Map<String, String> env = tcEnv.buildEnv(this.javaLocationResolver, envOverrides);
        AtomicReference<TerracottaManagementServerState> stateRef = new AtomicReference<TerracottaManagementServerState>(TerracottaManagementServerState.STOPPED);
        AtomicInteger javaPid = new AtomicInteger(-1);
        TriggeringOutputStream outputStream = TriggeringOutputStream.triggerOn(Pattern.compile("^.*\\Qstarted on port\\E.*$"), mr -> stateRef.set(TerracottaManagementServerState.STARTED)).andTriggerOn(Pattern.compile("^.*\\QStarting TmsApplication\\E.*with PID (\\d+).*$"), mr -> javaPid.set(Integer.parseInt(mr.group(1))));
        outputStream = this.tmsFullLogging ? outputStream.andForward(ExternalLoggers.tmsLogger::info) : outputStream.andTriggerOn(Pattern.compile("^.*(WARN|ERROR).*$"), mr -> ExternalLoggers.tmsLogger.info(mr.group()));
        WatchedProcess<TerracottaManagementServerState> watchedProcess = new WatchedProcess<TerracottaManagementServerState>(new ProcessExecutor().command(this.startTmsCommand(kitDir)).directory(workingDir).environment(env).redirectErrorStream(true).redirectOutput(outputStream), stateRef, TerracottaManagementServerState.STOPPED);
        while ((javaPid.get() == -1 || stateRef.get() == TerracottaManagementServerState.STOPPED) && watchedProcess.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!watchedProcess.isAlive()) {
            throw new RuntimeException("TMS process died before reaching STARTED state");
        }
        int wrapperPid = watchedProcess.getPid();
        int javaProcessPid = javaPid.get();
        return new TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess(stateRef, wrapperPid, javaProcessPid);
    }

    @Override
    public void stopTms(File installLocation, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess terracottaServerInstanceProcess, TerracottaCommandLineEnvironment tcEnv) {
        logger.debug("Destroying TMS process");
        for (Number pid : terracottaServerInstanceProcess.getPids()) {
            try {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(pid.intValue());
            }
            catch (Exception e) {
                logger.error("Could not destroy TMS process {}", (Object)pid, (Object)e);
            }
        }
    }

    @Override
    public TerracottaVoterInstance.TerracottaVoterInstanceProcess startVoter(TerracottaVoter terracottaVoter, File kitDir, File workingDir, SecurityRootDirectory securityDir, TerracottaCommandLineEnvironment tcEnv, Map<String, String> envOverrides) {
        throw new UnsupportedOperationException("Running voter is not supported in this distribution version");
    }

    @Override
    public void stopVoter(TerracottaVoterInstance.TerracottaVoterInstanceProcess terracottaVoterInstanceProcess) {
        throw new UnsupportedOperationException("Running voter is not supported in this distribution version");
    }

    @Override
    public URI tsaUri(Collection<TerracottaServer> servers, Map<ServerSymbolicName, Integer> proxyTsaPorts) {
        return URI.create(servers.stream().map(s -> new HostPort(s.getHostname(), proxyTsaPorts.getOrDefault(s.getServerSymbolicName(), s.getTsaPort())).getHostPort()).collect(Collectors.joining(",", "terracotta://", "")));
    }

    @Override
    public String clientJarsRootFolderName(Distribution distribution) {
        if (distribution.getPackageType() == PackageType.KIT) {
            return "client";
        }
        if (distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return "common" + File.separator + "lib";
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String pluginJarsRootFolderName(Distribution distribution) {
        return "server" + File.separator + "plugins" + File.separator + "lib";
    }

    @Override
    public String terracottaInstallationRoot() {
        return "TerracottaDB";
    }

    private List<String> createClusterToolCommand(File installLocation, File workingDir, SecurityRootDirectory securityDir, String[] arguments) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getClusterToolExecutable(installLocation));
        if (securityDir != null) {
            Path securityDirPath = workingDir.toPath().resolve("cluster-tool-security-dir");
            securityDir.createSecurityRootDirectory(securityDirPath);
            command.add("-srd");
            command.add(securityDirPath.toString());
        }
        command.addAll(Arrays.asList(arguments));
        return command;
    }

    private List<String> createClusterConfigureCommand(File installLocation, File workingDir, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPort, License license, SecurityRootDirectory securityDir, String[] arguments) {
        List<String> command = this.createClusterToolCommand(installLocation, workingDir, securityDir, arguments);
        if (license != null) {
            Path licensePath = workingDir.toPath().resolve(license.getFilename());
            command.add("-l");
            command.add(licensePath.toString());
        }
        command.addAll(this.addConfigureRelatedCommands(topology, proxyTsaPort));
        return command;
    }

    private List<String> addConfigureRelatedCommands(Topology topology, Map<ServerSymbolicName, Integer> proxiedTsaPorts) {
        ArrayList<String> commands = new ArrayList<String>();
        File tmpConfigDir = new File(FileUtils.getTempDirectory(), "tmp-tc-configs");
        if (!tmpConfigDir.mkdir() && !tmpConfigDir.isDirectory()) {
            throw new RuntimeException("Error creating temporary cluster tool TC config folder : " + tmpConfigDir);
        }
        ConfigurationManager configurationProvider = topology.getConfigurationManager();
        TcConfigManager tcConfigProvider = (TcConfigManager)configurationProvider;
        List<TcConfig> tcConfigs = tcConfigProvider.getTcConfigs();
        ArrayList<TcConfig> modifiedConfigs = new ArrayList<TcConfig>();
        for (TcConfig tcConfig : tcConfigs) {
            TcConfig modifiedConfig = TcConfig.copy(tcConfig);
            if (topology.isNetDisruptionEnabled()) {
                modifiedConfig.updateServerTsaPort(proxiedTsaPorts);
            }
            modifiedConfig.writeTcConfigFile(tmpConfigDir);
            modifiedConfigs.add(modifiedConfig);
        }
        for (TcConfig tcConfig : modifiedConfigs) {
            commands.add(tcConfig.getPath());
        }
        return commands;
    }

    private ToolExecutionResult executeCommand(List<String> command, TerracottaCommandLineEnvironment env, File workingDir, Map<String, String> envOverrides) {
        try {
            logger.info("Cluster tool command: {}", (Object)command);
            ProcessResult processResult = new ProcessExecutor(command).directory(workingDir).environment(env.buildEnv(this.javaLocationResolver, envOverrides)).readOutput(true).redirectOutputAlsoTo(Slf4jStream.of(ExternalLoggers.clusterToolLogger).asInfo()).redirectErrorStream(true).exitValue(0).execute();
            return new ToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getClusterToolExecutable(File installLocation) {
        String execPath = "tools" + File.separator + "cluster-tool" + File.separator + "bin" + File.separator + "cluster-tool" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return installLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return installLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define cluster tool command for distribution: " + this.distribution);
    }

    private List<String> startTmsCommand(File kitDir) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getStartTmsExecutable(kitDir));
        StringBuilder sb = new StringBuilder();
        for (String option : options) {
            sb.append(option).append(" ");
        }
        logger.debug(" Start TMS command = {}", (Object)sb.toString());
        return options;
    }

    private String getStartTmsExecutable(File installLocation) {
        String execPath = "tools" + File.separator + "management" + File.separator + "bin" + File.separator + "start" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return installLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return installLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define TMS Start Command for distribution: " + this.distribution);
    }

    private List<String> createTsaCommand(ServerSymbolicName serverSymbolicName, UUID serverId, Topology topology, Map<ServerSymbolicName, Integer> proxiedPorts, File kitLocation, File installLocation, List<String> startUpArgs) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getTsaCreateExecutable(kitLocation));
        String symbolicName = serverSymbolicName.getSymbolicName();
        if (HostAndIpValidator.isValidHost(symbolicName) || HostAndIpValidator.isValidIPv4(symbolicName) || HostAndIpValidator.isValidIPv6(symbolicName) || symbolicName.isEmpty()) {
            options.add("-n");
            options.add(symbolicName);
        }
        TcConfigManager configurationProvider = (TcConfigManager)topology.getConfigurationManager();
        TcConfig tcConfig = configurationProvider.findTcConfig(serverId);
        SecurityRootDirectory securityRootDirectory = null;
        if (tcConfig instanceof SecureTcConfig) {
            SecureTcConfig secureTcConfig = (SecureTcConfig)tcConfig;
            securityRootDirectory = secureTcConfig.securityRootDirectoryFor(serverSymbolicName);
        }
        TcConfig modifiedConfig = TcConfig.copy(configurationProvider.findTcConfig(serverId));
        configurationProvider.setUpInstallation(modifiedConfig, serverSymbolicName, serverId, proxiedPorts, installLocation, securityRootDirectory);
        if (modifiedConfig.getPath() != null) {
            options.add("-f");
            options.add(modifiedConfig.getPath());
        }
        options.addAll(startUpArgs);
        StringBuilder sb = new StringBuilder();
        for (String option : options) {
            sb.append(option).append(" ");
        }
        logger.debug("Create TSA command = {}", (Object)sb.toString());
        return options;
    }

    private String getTsaCreateExecutable(File kitLocation) {
        String execPath = "server" + File.separator + "bin" + File.separator + "start-tc-server" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return kitLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return kitLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define Terracotta server Start Command for distribution: " + this.distribution);
    }
}

