/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.util.Collection;
import java.util.HashMap;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueHeaderKey;
import org.apache.ignite.internal.processors.datastructures.QueueItemKey;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridAtomicCacheQueueImpl<T>
extends GridCacheQueueAdapter<T> {
    private static final long RETRY_TIMEOUT = Integer.getInteger("IGNITE_ATOMIC_CACHE_QUEUE_RETRY_TIMEOUT", 10000).intValue();

    public GridAtomicCacheQueueImpl(String queueName, GridCacheQueueHeader hdr, GridCacheContext<?, ?> cctx) {
        super(queueName, hdr, cctx);
    }

    @Override
    public boolean offer(T item) throws IgniteException {
        try {
            Long idx = this.transformHeader(new GridCacheQueueAdapter.AddProcessor(this.id, 1));
            if (idx == null) {
                return false;
            }
            this.checkRemoved(idx);
            QueueItemKey key = this.itemKey(idx);
            this.cache.getAndPut(key, item);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    @Nullable
    public T poll() throws IgniteException {
        try {
            while (true) {
                Long idx;
                if ((idx = this.transformHeader(new GridCacheQueueAdapter.PollProcessor(this.id))) == null) {
                    return null;
                }
                this.checkRemoved(idx);
                QueueItemKey key = this.itemKey(idx);
                Object data = this.cache.getAndRemove(key);
                if (data != null) {
                    return (T)data;
                }
                long stop = U.currentTimeMillis() + RETRY_TIMEOUT;
                while (U.currentTimeMillis() < stop) {
                    data = this.cache.getAndRemove(key);
                    if (data == null) continue;
                    return (T)data;
                }
                U.warn(this.log, "Failed to get item due to poll timeout [queue=" + this.queueName + ", idx=" + idx + "]. Poll timeout can be redefined by 'IGNITE_ATOMIC_CACHE_QUEUE_RETRY_TIMEOUT' system property.");
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> items) {
        A.notNull(items, "items");
        try {
            Long idx = this.transformHeader(new GridCacheQueueAdapter.AddProcessor(this.id, items.size()));
            if (idx == null) {
                return false;
            }
            this.checkRemoved(idx);
            HashMap<QueueItemKey, T> putMap = new HashMap<QueueItemKey, T>();
            for (T item : items) {
                putMap.put(this.itemKey(idx), item);
                Long l = idx;
                Long l2 = idx = Long.valueOf(idx + 1L);
            }
            this.cache.putAll(putMap);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    protected void removeItem(long rmvIdx) throws IgniteCheckedException {
        Long idx = this.cache.invoke(this.queueKey, new GridCacheQueueAdapter.RemoveProcessor(this.id, rmvIdx), new Object[0]).get();
        if (idx != null) {
            this.checkRemoved(idx);
            QueueItemKey key = this.itemKey(idx);
            if (this.cache.remove(key)) {
                return;
            }
            long stop = U.currentTimeMillis() + RETRY_TIMEOUT;
            while (U.currentTimeMillis() < stop) {
                if (!this.cache.remove(key)) continue;
                return;
            }
            U.warn(this.log, "Failed to remove item, [queue=" + this.queueName + ", idx=" + idx + ']');
        }
    }

    @Nullable
    private Long transformHeader(EntryProcessor<GridCacheQueueHeaderKey, GridCacheQueueHeader, Long> c) throws IgniteCheckedException {
        return this.cache.invoke(this.queueKey, c, new Object[0]).get();
    }
}

