/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final SSLParameters parameters;

    SSLSocketFactoryWrapper(SSLSocketFactory delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    private Socket configureSocket(Socket socket) {
        if (this.parameters != null) {
            ((SSLSocket)socket).setSSLParameters(this.parameters);
        }
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.configureSocket(this.delegate.createSocket());
    }

    @Override
    public Socket createSocket(Socket sock, String host, int port, boolean autoClose) throws IOException {
        return this.configureSocket(this.delegate.createSocket(sock, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.configureSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress locAddr, int locPort) throws IOException {
        return this.configureSocket(this.delegate.createSocket(host, port, locAddr, locPort));
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        return this.configureSocket(this.delegate.createSocket(addr, port));
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress locAddr, int locPort) throws IOException {
        return this.configureSocket(this.delegate.createSocket(addr, port, locAddr, locPort));
    }
}

