/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingOutputStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingOutputStream.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Map<Level, MethodHandle> LOG_METHODS = new ConcurrentHashMap<Level, MethodHandle>();
    private final MethodHandle handle;
    private final boolean twoByteLineSeparator;
    private final byte eol;
    private final byte eolLeader;
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"}, justification="Awaiting option to disable autoFlush")
    private final boolean autoFlush = true;
    private volatile boolean closed = false;
    private byte[] buffer = new byte[4096];
    private int bufferSize = 4096;
    private int byteCount = 0;
    private boolean haveLeader = false;

    public LoggingOutputStream(Logger logger, Level level) {
        try {
            this.handle = LOG_METHODS.computeIfAbsent(level, LoggingOutputStream::getHandle).bindTo(logger);
        }
        catch (AssertionError e) {
            LOGGER.error("Failed to create " + LoggingOutputStream.class.getSimpleName() + " instance for Logger \"" + logger.getName() + "[" + (Object)((Object)level) + "]\"", (Throwable)((Object)e));
            throw e;
        }
        String lineSeparator = System.lineSeparator();
        this.twoByteLineSeparator = lineSeparator.length() == 2;
        this.eol = (byte)lineSeparator.charAt(lineSeparator.length() - 1);
        this.eolLeader = (byte)(this.twoByteLineSeparator ? lineSeparator.charAt(0) : (char)'\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            this.checkOpen();
            if (this.twoByteLineSeparator && (byte)b == this.eolLeader) {
                this.haveLeader = true;
            } else {
                if ((byte)b == this.eol) {
                    this.haveLeader = false;
                    this.flushInternal();
                    return;
                }
                if (this.haveLeader) {
                    this.appendByte(this.eolLeader);
                    this.haveLeader = false;
                }
                this.appendByte((byte)b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            this.checkOpen();
            this.flushInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            this.flushInternal();
            this.closed = true;
        }
    }

    private void flushInternal() throws IOException {
        if (this.haveLeader) {
            this.appendByte(this.eolLeader);
            this.haveLeader = false;
        }
        if (this.byteCount == 0) {
            return;
        }
        this.log(new String(this.buffer, 0, this.byteCount, StandardCharsets.UTF_8));
        this.byteCount = 0;
    }

    private void log(String line) throws IOException {
        try {
            this.handle.invokeExact(line);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Unexpected error calling %s: %s", this.handle, throwable), throwable);
        }
    }

    private void appendByte(byte b) {
        if (this.byteCount == this.bufferSize) {
            int newBufferSize = this.bufferSize + 4096;
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.byteCount);
            this.buffer = newBuffer;
            this.bufferSize = newBufferSize;
        }
        this.buffer[this.byteCount++] = b;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    private static MethodHandle getHandle(Level level) {
        String methodName = level.name().toLowerCase(Locale.ROOT);
        try {
            return MethodHandles.publicLookup().findVirtual(Logger.class, methodName, MethodType.methodType(Void.TYPE, String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

