/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMultiTxFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDhtCacheEntry
extends GridDistributedCacheEntry {
    private static final int DHT_SIZE_OVERHEAD = 16;
    private static final IgniteClosure<ReaderId, UUID> R2N = new C1<ReaderId, UUID>(){

        @Override
        public UUID apply(ReaderId e) {
            return e.nodeId();
        }
    };
    @GridToStringInclude
    private volatile ReaderId[] rdrs = ReaderId.access$000();
    @GridToStringExclude
    private final GridDhtLocalPartition locPart;

    public GridDhtCacheEntry(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key) {
        super(ctx, key);
        int p = this.cctx.affinity().partition(key);
        this.locPart = ctx.topology().localPartition(p, topVer, true, true);
        assert (this.locPart != null) : p;
    }

    @Override
    protected long nextPartitionCounter(AffinityTopologyVersion topVer, boolean primary, boolean init, @Nullable Long primaryCntr) {
        try {
            return this.locPart.nextUpdateCounter(this.cctx.cacheId(), topVer, primary, init, primaryCntr);
        }
        catch (Throwable t) {
            log.error("Failed to update counter for atomic cache [, initial=" + init + ", primaryCntr=" + primaryCntr + ", part=" + this.locPart + ']', t);
            throw t;
        }
    }

    @Override
    protected long nextPartitionCounter(IgniteInternalTx tx, @Nullable Long primaryCntr) {
        try {
            return this.locPart.nextUpdateCounter(this.cctx.cacheId(), tx, primaryCntr);
        }
        catch (Throwable t) {
            log.error("Failed to update counter for tx cache [, primaryCntr=" + primaryCntr + ", part=" + this.locPart + ", tx=" + CU.txString(tx) + ']', t);
            throw t;
        }
    }

    @Override
    public int memorySize() throws IgniteCheckedException {
        int rdrsOverhead;
        this.lockEntry();
        try {
            rdrsOverhead = 24 * this.rdrs.length;
        }
        finally {
            this.unlockEntry();
        }
        return super.memorySize() + 16 + rdrsOverhead;
    }

    @Override
    public int partition() {
        return this.locPart.id();
    }

    @Override
    protected GridDhtLocalPartition localPartition() {
        return this.locPart;
    }

    @Override
    public boolean isDht() {
        return true;
    }

    @Override
    public boolean partitionValid() {
        return this.locPart.valid();
    }

    @Override
    public void onMarkedObsolete() {
        assert (!this.lockedByCurrentThread());
        this.cctx.topology().onRemoved(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate localCandidateByNearVersion(GridCacheVersion nearVer, boolean rmv) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                for (GridCacheMvccCandidate c : mvcc.localCandidatesNoCopy(false)) {
                    GridCacheVersion ver = c.otherVersion();
                    if (ver == null || !ver.equals(nearVer)) continue;
                    GridCacheMvccCandidate gridCacheMvccCandidate = c;
                    return gridCacheMvccCandidate;
                }
            }
            if (rmv) {
                this.addRemoved(nearVer);
            }
            Iterator<GridCacheMvccCandidate> iterator = null;
            return iterator;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addDhtLocal(UUID nearNodeId, GridCacheVersion nearVer, AffinityTopologyVersion topVer, long threadId, GridCacheVersion ver, @Nullable GridCacheVersion serOrder, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        CacheObject val;
        CacheLockCandidates owner;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        assert (!reenter || serOrder == null);
        this.lockEntry();
        try {
            this.checkRemoved(ver);
            this.checkRemoved(nearVer);
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            cand = mvcc.addLocal(this, nearNodeId, nearVer, threadId, ver, timeout, serOrder, reenter, tx, implicitSingle, true, read);
            if (cand == null) {
                GridCacheMvccCandidate gridCacheMvccCandidate = null;
                return gridCacheMvccCandidate;
            }
            cand.topologyVersion(topVer);
            owner = mvcc.allOwners();
            if (owner != null) {
                cand.ownerVersion(owner.candidate(0).version());
            }
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            if (mvcc.isEmpty(new GridCacheVersion[0])) {
                this.mvccExtras(null);
            }
        }
        finally {
            this.unlockEntry();
        }
        if (!cand.reentry()) {
            this.cctx.mvcc().addNext(this.cctx, cand);
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    @Override
    public boolean tmLock(IgniteInternalTx tx, long timeout, @Nullable GridCacheVersion serOrder, GridCacheVersion serReadVer, boolean read) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        if (tx.local()) {
            GridDhtTxLocalAdapter dhtTx = (GridDhtTxLocalAdapter)tx;
            return this.addDhtLocal(dhtTx.nearNodeId(), dhtTx.nearXidVersion(), tx.topologyVersion(), tx.threadId(), tx.xidVersion(), serOrder, timeout, false, true, tx.implicitSingle(), read) != null;
        }
        try {
            this.addRemote(tx.nodeId(), tx.otherNodeId(), tx.threadId(), tx.xidVersion(), true, tx.implicit(), null);
            return true;
        }
        catch (GridDistributedLockCancelledException ignored) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to enter tx lock for cancelled ID (will ignore): " + tx);
            }
            return false;
        }
    }

    @Override
    public GridCacheMvccCandidate removeLock() {
        GridCacheMvccCandidate ret = super.removeLock();
        this.locPart.onUnlock();
        return ret;
    }

    @Override
    public boolean removeLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        boolean ret = super.removeLock(ver);
        this.locPart.onUnlock();
        return ret;
    }

    @Override
    public void onUnlock() {
        this.locPart.onUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgniteBiTuple<GridCacheVersion, CacheObject> versionedValue(AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            if (this.isNew() || !this.valid(AffinityTopologyVersion.NONE) || this.deletedUnlocked()) {
                IgniteBiTuple<GridCacheVersion, CacheObject> igniteBiTuple = null;
                return igniteBiTuple;
            }
            CacheObject val0 = this.val;
            IgniteBiTuple<GridCacheVersion, CacheObject> igniteBiTuple = F.t(this.ver, val0);
            return igniteBiTuple;
        }
        finally {
            this.unlockEntry();
        }
    }

    public Collection<UUID> readers() throws GridCacheEntryRemovedException {
        return F.viewReadOnly(this.checkReaders(), R2N, new IgnitePredicate[0]);
    }

    @Nullable
    public ReaderId readerId(UUID nodeId) {
        ReaderId[] rdrs;
        for (ReaderId reader : rdrs = this.rdrs) {
            if (!reader.nodeId().equals(nodeId)) continue;
            return reader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgniteInternalFuture<Boolean> addReader(UUID nodeId, long msgId, AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        ReaderId reader;
        if (this.cctx.nodeId().equals(nodeId)) {
            return null;
        }
        ClusterNode node = this.cctx.discovery().node(nodeId);
        if (node == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring near reader because node left the grid: " + nodeId);
            }
            return null;
        }
        if (this.cctx.affinity().partitionBelongs(node, this.partition(), topVer)) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring near reader because remote node is affinity node [locNodeId=" + this.cctx.localNodeId() + ", rmtNodeId=" + nodeId + ", key=" + this.key + ']');
            }
            return null;
        }
        boolean ret = false;
        GridCacheMultiTxFuture txFut = null;
        Collection<GridCacheMvccCandidate> cands = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            reader = this.readerId(nodeId);
            if (reader == null) {
                reader = new ReaderId(nodeId, msgId);
                ReaderId[] rdrs = Arrays.copyOf(this.rdrs, this.rdrs.length + 1);
                rdrs[rdrs.length - 1] = reader;
                this.rdrs = rdrs;
                if (!this.cctx.atomic()) {
                    txFut = reader.getOrCreateTxFuture(this.cctx);
                    cands = this.localCandidates(new GridCacheVersion[0]);
                    ret = true;
                }
            } else {
                txFut = reader.txFuture();
                long id = reader.messageId();
                if (id < msgId) {
                    reader.messageId(msgId);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
        if (ret) {
            assert (txFut != null);
            if (!F.isEmpty(cands)) {
                for (GridCacheMvccCandidate c : cands) {
                    Object tx = this.cctx.tm().tx(c.version());
                    if (tx == null || !tx.local()) continue;
                    txFut.addTx((IgniteInternalTx)tx);
                }
            }
            txFut.init();
            if (!txFut.isDone()) {
                final ReaderId reader0 = reader;
                txFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        GridDhtCacheEntry.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                            @Override
                            public void run() {
                                GridDhtCacheEntry.this.lockEntry();
                                try {
                                    reader0.resetTxFuture();
                                }
                                finally {
                                    GridDhtCacheEntry.this.unlockEntry();
                                }
                            }
                        });
                    }
                });
            } else {
                this.lockEntry();
                try {
                    reader.resetTxFuture();
                }
                finally {
                    this.unlockEntry();
                }
                txFut = null;
            }
        }
        return txFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReader(UUID nodeId, long msgId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            int i;
            this.checkObsolete();
            ReaderId[] rdrs = this.rdrs;
            int readerIdx = -1;
            for (i = 0; i < rdrs.length; ++i) {
                if (!rdrs[i].nodeId().equals(nodeId)) continue;
                readerIdx = i;
                break;
            }
            if (readerIdx == -1 || rdrs[readerIdx].messageId() > msgId && msgId >= 0L) {
                i = 0;
                return i != 0;
            }
            if (rdrs.length == 1) {
                this.rdrs = ReaderId.EMPTY_ARRAY;
            } else {
                ReaderId[] newRdrs = Arrays.copyOf(rdrs, rdrs.length - 1);
                System.arraycopy(rdrs, readerIdx + 1, newRdrs, readerIdx, rdrs.length - readerIdx - 1);
                this.rdrs = newRdrs;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public void clearReaders() {
        this.lockEntry();
        try {
            this.rdrs = ReaderId.EMPTY_ARRAY;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    public void clearReader(UUID nodeId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.removeReader(nodeId, -1L);
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearInternal(GridCacheVersion ver, GridCacheObsoleteEntryExtras extras) throws IgniteCheckedException {
        boolean rmv = false;
        this.lockEntry();
        try {
            if (!this.markObsolete0(ver, false, extras)) {
                if (log.isDebugEnabled()) {
                    log.debug("Entry could not be marked obsolete (it is still used or has readers): " + this);
                }
                boolean bl = false;
                return bl;
            }
            this.rdrs = ReaderId.EMPTY_ARRAY;
            if (log.isDebugEnabled()) {
                log.debug("Entry has been marked obsolete: " + this);
            }
            if (log.isTraceEnabled()) {
                log.trace("clearInternal [key=" + this.key + ", entry=" + System.identityHashCode(this) + ']');
            }
            if (this.cctx.mvccEnabled()) {
                this.cctx.offheap().mvccRemoveAll(this);
            } else {
                this.removeValue();
            }
            this.update(null, 0L, 0L, ver, true);
            if (this.cctx.store().isLocal()) {
                this.cctx.store().remove(null, this.key);
            }
            rmv = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockEntry();
            if (rmv) {
                this.cctx.cache().removeEntry(this);
            }
        }
    }

    public Collection<ReaderId> checkReaders() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            Collection<ReaderId> collection = this.checkReadersLocked();
            return collection;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Nullable
    public ReaderId[] readersLocked() {
        assert (this.lockedByCurrentThread());
        return this.rdrs;
    }

    protected Collection<ReaderId> checkReadersLocked() throws GridCacheEntryRemovedException {
        assert (this.lockedByCurrentThread());
        this.checkObsolete();
        ReaderId[] rdrs = this.rdrs;
        if (rdrs.length == 0) {
            return Collections.emptySet();
        }
        ArrayList<ReaderId> newRdrs = null;
        for (int i = 0; i < rdrs.length; ++i) {
            ClusterNode node = this.cctx.discovery().getAlive(rdrs[i].nodeId());
            if (node == null) {
                if (newRdrs != null) continue;
                newRdrs = new ArrayList<ReaderId>(rdrs.length);
                for (int k = 0; k < i; ++k) {
                    newRdrs.add(rdrs[k]);
                }
                continue;
            }
            if (newRdrs == null) continue;
            newRdrs.add(rdrs[i]);
        }
        if (newRdrs != null) {
            this.rdrs = rdrs = newRdrs.toArray(new ReaderId[newRdrs.size()]);
        }
        return Arrays.asList(rdrs);
    }

    @Override
    protected boolean hasReaders() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkReadersLocked();
            boolean bl = this.rdrs.length > 0;
            return bl;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate mappings(GridCacheVersion ver, Collection<ClusterNode> dhtNodeIds, Collection<ClusterNode> nearNodeIds) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            GridCacheMvccCandidate cand;
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
            if (cand != null) {
                cand.mappedNodeIds(dhtNodeIds, nearNodeIds);
            }
            GridCacheMvccCandidate gridCacheMvccCandidate2 = cand;
            return gridCacheMvccCandidate2;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(GridCacheVersion ver, ClusterNode mappedNode) {
        this.lockEntry();
        try {
            GridCacheMvccCandidate cand;
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
            if (cand != null) {
                cand.removeMappedNode(mappedNode);
            }
        }
        finally {
            this.unlockEntry();
        }
    }

    protected final String cacheName() {
        return this.cctx.name();
    }

    @Override
    public String toString() {
        this.lockEntry();
        try {
            String string = S.toString(GridDhtCacheEntry.class, this, "part", this.locPart.id(), "super", super.toString());
            return string;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    protected void incrementMapPublicSize() {
        this.locPart.incrementPublicSize(null, this);
    }

    @Override
    protected void decrementMapPublicSize() {
        this.locPart.decrementPublicSize(null, this);
    }

    public static class ReaderId {
        private static final ReaderId[] EMPTY_ARRAY = new ReaderId[0];
        private static final int READER_ID_SIZE = 24;
        private UUID nodeId;
        private long msgId;
        private GridCacheMultiTxFuture txFut;

        ReaderId(UUID nodeId, long msgId) {
            this.nodeId = nodeId;
            this.msgId = msgId;
        }

        public static boolean contains(@Nullable ReaderId[] readers, UUID nodeId) {
            if (readers == null) {
                return false;
            }
            for (int i = 0; i < readers.length; ++i) {
                if (!nodeId.equals(readers[i].nodeId)) continue;
                return true;
            }
            return false;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        long messageId() {
            return this.msgId;
        }

        void messageId(long msgId) {
            this.msgId = msgId;
        }

        GridCacheMultiTxFuture getOrCreateTxFuture(GridCacheContext cctx) {
            if (this.txFut == null) {
                this.txFut = new GridCacheMultiTxFuture(cctx);
            }
            return this.txFut;
        }

        GridCacheMultiTxFuture txFuture() {
            return this.txFut;
        }

        GridCacheMultiTxFuture resetTxFuture() {
            GridCacheMultiTxFuture txFut = this.txFut;
            this.txFut = null;
            return txFut;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReaderId)) {
                return false;
            }
            ReaderId readerId = (ReaderId)o;
            return this.msgId == readerId.msgId && this.nodeId.equals(readerId.nodeId);
        }

        public int hashCode() {
            int res = this.nodeId.hashCode();
            res = 31 * res + (int)(this.msgId ^ this.msgId >>> 32);
            return res;
        }

        public String toString() {
            return S.toString(ReaderId.class, this);
        }
    }
}

