/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram;

import java.net.InetSocketAddress;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.filter.PassFilterFactory;
import org.netcrusher.core.filter.TransformFilterFactory;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.Throttler;
import org.netcrusher.core.throttle.ThrottlerFactory;
import org.netcrusher.datagram.DatagramCrusherSocketOptions;
import org.netcrusher.datagram.callback.DatagramClientCreation;
import org.netcrusher.datagram.callback.DatagramClientDeletion;

public class DatagramCrusherOptions {
    public static final int DEFAULT_BUFFER_COUNT = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private InetSocketAddress bindAddress;
    private InetSocketAddress connectAddress;
    private InetSocketAddress bindBeforeConnectAddress;
    private NioReactor reactor;
    private DatagramCrusherSocketOptions socketOptions = new DatagramCrusherSocketOptions();
    private DatagramClientCreation creationListener;
    private DatagramClientDeletion deletionListener;
    private boolean deferredListeners;
    private TransformFilterFactory incomingTransformFilterFactory;
    private TransformFilterFactory outgoingTransformFilterFactory;
    private PassFilterFactory incomingPassFilterFactory;
    private PassFilterFactory outgoingPassFilterFactory;
    private Throttler incomingGlobalThrottler;
    private ThrottlerFactory outgoingThrottlerFactory;
    private BufferOptions bufferOptions = new BufferOptions();

    public DatagramCrusherOptions() {
        this.bufferOptions.setCount(1024);
        this.bufferOptions.setSize(8192);
        this.bufferOptions.setDirect(true);
        this.deferredListeners = true;
    }

    public void validate() {
        if (this.bindAddress == null) {
            throw new IllegalArgumentException("Bind address is not set");
        }
        if (this.connectAddress == null) {
            throw new IllegalArgumentException("Connect address is not set");
        }
        if (this.reactor == null) {
            throw new IllegalArgumentException("Reactor is not set");
        }
        if (this.socketOptions == null) {
            throw new IllegalArgumentException("Socket options are not set");
        }
        if (this.bufferOptions == null) {
            throw new IllegalArgumentException("Buffer options are not set");
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    public void setConnectAddress(InetSocketAddress connectAddress) {
        this.connectAddress = connectAddress;
    }

    public InetSocketAddress getBindBeforeConnectAddress() {
        return this.bindBeforeConnectAddress;
    }

    public void setBindBeforeConnectAddress(InetSocketAddress bindBeforeConnectAddress) {
        this.bindBeforeConnectAddress = bindBeforeConnectAddress;
    }

    public NioReactor getReactor() {
        return this.reactor;
    }

    public void setReactor(NioReactor reactor) {
        this.reactor = reactor;
    }

    public DatagramCrusherSocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(DatagramCrusherSocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public DatagramClientCreation getCreationListener() {
        return this.creationListener;
    }

    public void setCreationListener(DatagramClientCreation creationListener) {
        this.creationListener = creationListener;
    }

    public DatagramClientDeletion getDeletionListener() {
        return this.deletionListener;
    }

    public void setDeletionListener(DatagramClientDeletion deletionListener) {
        this.deletionListener = deletionListener;
    }

    public boolean isDeferredListeners() {
        return this.deferredListeners;
    }

    public void setDeferredListeners(boolean deferredListeners) {
        this.deferredListeners = deferredListeners;
    }

    public TransformFilterFactory getIncomingTransformFilterFactory() {
        return this.incomingTransformFilterFactory;
    }

    public void setIncomingTransformFilterFactory(TransformFilterFactory incomingTransformFilterFactory) {
        this.incomingTransformFilterFactory = incomingTransformFilterFactory;
    }

    public TransformFilterFactory getOutgoingTransformFilterFactory() {
        return this.outgoingTransformFilterFactory;
    }

    public void setOutgoingTransformFilterFactory(TransformFilterFactory outgoingTransformFilterFactory) {
        this.outgoingTransformFilterFactory = outgoingTransformFilterFactory;
    }

    public PassFilterFactory getIncomingPassFilterFactory() {
        return this.incomingPassFilterFactory;
    }

    public void setIncomingPassFilterFactory(PassFilterFactory incomingPassFilterFactory) {
        this.incomingPassFilterFactory = incomingPassFilterFactory;
    }

    public PassFilterFactory getOutgoingPassFilterFactory() {
        return this.outgoingPassFilterFactory;
    }

    public void setOutgoingPassFilterFactory(PassFilterFactory outgoingPassFilterFactory) {
        this.outgoingPassFilterFactory = outgoingPassFilterFactory;
    }

    public Throttler getIncomingGlobalThrottler() {
        return this.incomingGlobalThrottler;
    }

    public void setIncomingGlobalThrottler(Throttler incomingGlobalThrottler) {
        this.incomingGlobalThrottler = incomingGlobalThrottler;
    }

    public ThrottlerFactory getOutgoingThrottlerFactory() {
        return this.outgoingThrottlerFactory;
    }

    public void setOutgoingThrottlerFactory(ThrottlerFactory outgoingThrottlerFactory) {
        this.outgoingThrottlerFactory = outgoingThrottlerFactory;
    }

    public BufferOptions getBufferOptions() {
        return this.bufferOptions;
    }

    public void setBufferOptions(BufferOptions bufferOptions) {
        this.bufferOptions = bufferOptions;
    }
}

