/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.concurrent.Callable;

public class RetryUtils {
    public static boolean waitFor(Callable<Boolean> condition, int maxWaitTimeMillis) {
        int currentRetryAttempt = 0;
        int totalBackOffMillis = 0;
        while (totalBackOffMillis < maxWaitTimeMillis) {
            ++currentRetryAttempt;
            try {
                if (!condition.call().booleanValue()) {
                    Thread.sleep(totalBackOffMillis += 100 * currentRetryAttempt);
                    continue;
                }
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

