/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV2
extends PagePartitionMetaIO {
    private static final int PENDING_TREE_ROOT_OFF = 137;

    public PagePartitionMetaIOV2(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setPendingTreeRoot(pageAddr, 0L);
    }

    @Override
    public long getPendingTreeRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 137);
    }

    @Override
    public void setPendingTreeRoot(long pageAddr, long treeRoot) {
        PageUtils.putLong(pageAddr, 137, treeRoot);
    }

    @Override
    protected void printPage(long pageAddr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        byte state = this.getPartitionState(pageAddr);
        sb.a("PagePartitionMeta[\n\ttreeRoot=").a(this.getReuseListRoot(pageAddr));
        sb.a(",\n\tpendingTreeRoot=").a(this.getLastSuccessfulFullSnapshotId(pageAddr));
        sb.a(",\n\tlastSuccessfulFullSnapshotId=").a(this.getLastSuccessfulFullSnapshotId(pageAddr));
        sb.a(",\n\tlastSuccessfulSnapshotId=").a(this.getLastSuccessfulSnapshotId(pageAddr));
        sb.a(",\n\tnextSnapshotTag=").a(this.getNextSnapshotTag(pageAddr));
        sb.a(",\n\tlastSuccessfulSnapshotTag=").a(this.getLastSuccessfulSnapshotTag(pageAddr));
        sb.a(",\n\tlastAllocatedPageCount=").a(this.getLastAllocatedPageCount(pageAddr));
        sb.a(",\n\tcandidatePageCount=").a(this.getCandidatePageCount(pageAddr));
        sb.a(",\n\tsize=").a(this.getSize(pageAddr));
        sb.a(",\n\tupdateCounter=").a(this.getUpdateCounter(pageAddr));
        sb.a(",\n\tglobalRemoveId=").a(this.getGlobalRemoveId(pageAddr));
        sb.a(",\n\tpartitionState=").a(state).a("(").a((Object)GridDhtPartitionState.fromOrdinal(state)).a(")");
        sb.a(",\n\tcountersPageId=").a(this.getCountersPageId(pageAddr));
        sb.a("\n]");
    }

    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        assert (PageIO.getVersion(pageAddr) < 2);
        PageIO.setVersion(pageAddr, this.getVersion());
        this.setPendingTreeRoot(pageAddr, 0L);
    }
}

