/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheMvccObsoleteEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;
    private GridCacheVersion obsoleteVer;

    GridCacheMvccObsoleteEntryExtras(GridCacheMvcc mvcc, GridCacheVersion obsoleteVer) {
        assert (mvcc != null);
        assert (obsoleteVer != null);
        this.mvcc = mvcc;
        this.obsoleteVer = obsoleteVer;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheObsoleteEntryExtras(this.obsoleteVer);
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        return this.obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        if (obsoleteVer != null) {
            this.obsoleteVer = obsoleteVer;
            return this;
        }
        return new GridCacheMvccEntryExtras(this.mvcc);
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        return expireTime != 0L ? new GridCacheMvccObsoleteTtlEntryExtras(this.mvcc, this.obsoleteVer, ttl, expireTime) : this;
    }

    @Override
    public int size() {
        return 16;
    }

    public String toString() {
        return S.toString(GridCacheMvccObsoleteEntryExtras.class, this);
    }
}

