/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.compute.ComputeTaskSessionAttributeListener;
import org.apache.ignite.compute.ComputeTaskSessionScope;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

public class ComputeTaskInternalFuture<R>
extends GridFutureAdapter<R> {
    private ComputeTaskSession ses;
    private GridKernalContext ctx;
    @GridToStringExclude
    private ComputeFuture<R> userFut;
    private transient IgniteLogger log;

    public ComputeTaskInternalFuture(ComputeTaskSession ses, GridKernalContext ctx) {
        assert (ses != null);
        assert (ctx != null);
        this.ses = ses;
        this.ctx = ctx;
        this.userFut = new ComputeFuture(this);
        this.log = ctx.log(ComputeTaskInternalFuture.class);
    }

    public static <R> ComputeTaskInternalFuture<R> finishedFuture(final GridKernalContext ctx, final Class<?> taskCls, IgniteCheckedException e) {
        assert (ctx != null);
        assert (taskCls != null);
        assert (e != null);
        final long time = U.currentTimeMillis();
        final IgniteUuid id = IgniteUuid.fromUuid(ctx.localNodeId());
        ComputeTaskSession ses = new ComputeTaskSession(){

            @Override
            public String getTaskName() {
                return taskCls.getName();
            }

            @Override
            public UUID getTaskNodeId() {
                return ctx.localNodeId();
            }

            @Override
            public long getStartTime() {
                return time;
            }

            @Override
            public long getEndTime() {
                return time;
            }

            @Override
            public IgniteUuid getId() {
                return id;
            }

            @Override
            public ClassLoader getClassLoader() {
                return null;
            }

            @Override
            public Collection<ComputeJobSibling> getJobSiblings() throws IgniteException {
                return Collections.emptyList();
            }

            @Override
            public Collection<ComputeJobSibling> refreshJobSiblings() throws IgniteException {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public ComputeJobSibling getJobSibling(IgniteUuid jobId) throws IgniteException {
                return null;
            }

            @Override
            public void setAttribute(Object key, @Nullable Object val) throws IgniteException {
            }

            @Override
            @Nullable
            public <K, V> V getAttribute(K key) {
                return null;
            }

            @Override
            public void setAttributes(Map<?, ?> attrs) throws IgniteException {
            }

            @Override
            public Map<?, ?> getAttributes() {
                return Collections.emptyMap();
            }

            @Override
            public void addAttributeListener(ComputeTaskSessionAttributeListener lsnr, boolean rewind) {
            }

            @Override
            public boolean removeAttributeListener(ComputeTaskSessionAttributeListener lsnr) {
                return false;
            }

            @Override
            public <K, V> V waitForAttribute(K key, long timeout) throws InterruptedException {
                throw new InterruptedException("Session was closed.");
            }

            @Override
            public <K, V> boolean waitForAttribute(K key, @Nullable V val, long timeout) throws InterruptedException {
                throw new InterruptedException("Session was closed.");
            }

            @Override
            public Map<?, ?> waitForAttributes(Collection<?> keys, long timeout) throws InterruptedException {
                throw new InterruptedException("Session was closed.");
            }

            @Override
            public boolean waitForAttributes(Map<?, ?> attrs, long timeout) throws InterruptedException {
                throw new InterruptedException("Session was closed.");
            }

            @Override
            public void saveCheckpoint(String key, Object state) {
                throw new IgniteException("Session was closed.");
            }

            @Override
            public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout) {
                throw new IgniteException("Session was closed.");
            }

            @Override
            public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout, boolean overwrite) {
                throw new IgniteException("Session was closed.");
            }

            @Override
            @Nullable
            public <T> T loadCheckpoint(String key) throws IgniteException {
                throw new IgniteException("Session was closed.");
            }

            @Override
            public boolean removeCheckpoint(String key) throws IgniteException {
                throw new IgniteException("Session was closed.");
            }

            @Override
            public Collection<UUID> getTopology() {
                return Collections.emptyList();
            }

            @Override
            public IgniteFuture<?> mapFuture() {
                return new IgniteFinishedFutureImpl();
            }
        };
        ComputeTaskInternalFuture<R> fut = new ComputeTaskInternalFuture<R>(ses, ctx);
        fut.onDone(e);
        return fut;
    }

    public ComputeTaskFuture<R> publicFuture() {
        return this.userFut;
    }

    public ComputeTaskSession getTaskSession() {
        if (this.ses == null) {
            throw new IllegalStateException("Cannot access task session after future has been deserialized.");
        }
        return this.ses;
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        this.ctx.security().authorize(this.ses.getTaskName(), SecurityPermission.TASK_CANCEL);
        if (this.onCancelled()) {
            this.ctx.task().onCancelled(this.ses.getId());
            return true;
        }
        return this.isCancelled();
    }

    @Override
    public String toString() {
        return S.toString(ComputeTaskInternalFuture.class, this, "super", super.toString());
    }

    @Override
    public IgniteLogger logger() {
        return this.log;
    }

    private static class ComputeFuture<R>
    extends IgniteFutureImpl<R>
    implements ComputeTaskFuture<R> {
        private ComputeFuture(ComputeTaskInternalFuture<R> fut) {
            super(fut);
        }

        @Override
        public ComputeTaskSession getTaskSession() {
            return ((ComputeTaskInternalFuture)this.fut).getTaskSession();
        }
    }
}

