/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.diagnostic;

import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.diagnostic.DiagnosticSubCommand;

public class DiagnosticCommand
implements Command<DiagnosticSubCommand> {
    private DiagnosticSubCommand subcommand;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        if (this.subcommand == DiagnosticSubCommand.HELP) {
            this.printDiagnosticHelp(logger);
            return null;
        }
        Command command = this.subcommand.subcommand();
        if (command == null) {
            throw new IllegalStateException("Unknown command " + (Object)((Object)this.subcommand));
        }
        return command.execute(clientCfg, logger);
    }

    @Override
    public DiagnosticSubCommand arg() {
        return this.subcommand;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.subcommand = DiagnosticSubCommand.HELP;
            return;
        }
        String str = argIter.nextArg("").toLowerCase();
        DiagnosticSubCommand cmd = DiagnosticSubCommand.of(str);
        if (cmd == null) {
            cmd = DiagnosticSubCommand.HELP;
        }
        switch (cmd) {
            case HELP: {
                break;
            }
            case PAGE_LOCKS: {
                cmd.subcommand().parseArguments(argIter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diagnostic subcommand " + (Object)((Object)cmd));
            }
        }
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument of diagnostic subcommand: " + argIter.peekNextArg());
        }
        this.subcommand = cmd;
    }

    @Override
    public String name() {
        return "diagnostic";
    }

    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "View diagnostic information in a cluster. For more details type:", CommandList.DIAGNOSTIC, new String[0]);
    }

    private void printDiagnosticHelp(Logger logger) {
        logger.info("  " + CommandLogger.join(" ", new Object[]{"control.(sh|bat)", CommandList.DIAGNOSTIC, (Object)((Object)DiagnosticSubCommand.PAGE_LOCKS) + " - dump page locks info."}));
        logger.info("  Subcommands:");
        Arrays.stream(DiagnosticSubCommand.values()).forEach(c -> {
            if (c.subcommand() != null) {
                c.subcommand().printUsage(logger);
            }
        });
        logger.info("");
    }
}

