/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheConfigurationSerializer;

public class ClientCacheCreateWithConfigurationRequest
extends ClientRequest {
    private final CacheConfiguration cacheCfg;

    public ClientCacheCreateWithConfigurationRequest(BinaryRawReader reader, ClientListenerProtocolVersion ver) {
        super(reader);
        this.cacheCfg = ClientCacheConfigurationSerializer.read(reader, ver);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            ctx.kernalContext().grid().createCache(this.cacheCfg);
        }
        catch (CacheExistsException e) {
            throw new IgniteClientException(1001, e.getMessage());
        }
        return super.process(ctx);
    }
}

