/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

public class VisorFindAndDeleteGarbageInPersistenceClosure
implements IgniteCallable<VisorFindAndDeleteGarbageInPersistenceJobResult> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;
    private Set<String> grpNames;
    private final boolean deleteGarbage;
    private final AtomicInteger processedPartitions = new AtomicInteger(0);
    private volatile int totalPartitions;
    private final AtomicLong lastProgressPrintTs = new AtomicLong(0L);
    private volatile ExecutorService calcExecutor;

    public VisorFindAndDeleteGarbageInPersistenceClosure(Set<String> grpNames, boolean deleteGarbage) {
        this.grpNames = grpNames;
        this.deleteGarbage = deleteGarbage;
    }

    @Override
    public VisorFindAndDeleteGarbageInPersistenceJobResult call() throws Exception {
        this.calcExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            VisorFindAndDeleteGarbageInPersistenceJobResult visorFindAndDeleteGarbageInPersistenceJobResult = this.call0();
            return visorFindAndDeleteGarbageInPersistenceJobResult;
        }
        finally {
            this.calcExecutor.shutdown();
        }
    }

    private VisorFindAndDeleteGarbageInPersistenceJobResult call0() {
        Set<Integer> grpIds = this.calcCacheGroupIds();
        List<T2<CacheGroupContext, GridDhtLocalPartition>> partArgs = this.calcListOfPartitions(grpIds);
        this.totalPartitions = partArgs.size();
        ArrayList<Future<Map<Integer, Map<Integer, Long>>>> procPartFutures = new ArrayList<Future<Map<Integer, Map<Integer, Long>>>>();
        for (final T2<CacheGroupContext, GridDhtLocalPartition> t2 : partArgs) {
            procPartFutures.add(this.calcExecutor.submit(new Callable<Map<Integer, Map<Integer, Long>>>(){

                @Override
                public Map<Integer, Map<Integer, Long>> call() throws Exception {
                    return VisorFindAndDeleteGarbageInPersistenceClosure.this.processPartition((CacheGroupContext)t2.get1(), (GridDhtLocalPartition)t2.get2());
                }
            }));
        }
        HashMap<Integer, Map<Integer, Long>> grpIdToPartIdToGarbageCount = new HashMap<Integer, Map<Integer, Long>>();
        try {
            for (int curPart = 0; curPart < procPartFutures.size(); ++curPart) {
                Future fut = (Future)procPartFutures.get(curPart);
                Map partRes = (Map)fut.get();
                for (Map.Entry e : partRes.entrySet()) {
                    Map map = grpIdToPartIdToGarbageCount.computeIfAbsent((Integer)e.getKey(), (Function<Integer, Map<Integer, Long>>)((Function<Integer, Map>)x -> new HashMap()));
                    for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                        map.compute(entry.getKey(), (k, v) -> (v == null ? 0L : v) + (Long)entry.getValue());
                    }
                }
            }
            if (this.deleteGarbage) {
                this.cleanup(grpIdToPartIdToGarbageCount);
            }
            this.log.warning("VisorFindAndDeleteGarbageInPersistenceClosure finished: processed " + this.totalPartitions + " partitions.");
        }
        catch (InterruptedException | ExecutionException | IgniteCheckedException e) {
            for (int j = curPart; j < procPartFutures.size(); ++j) {
                ((Future)procPartFutures.get(j)).cancel(false);
            }
            throw this.unwrapFutureException(e);
        }
        return new VisorFindAndDeleteGarbageInPersistenceJobResult(grpIdToPartIdToGarbageCount);
    }

    private void cleanup(Map<Integer, Map<Integer, Long>> grpIdToPartIdToGarbageCount) throws IgniteCheckedException {
        for (Map.Entry<Integer, Map<Integer, Long>> e : grpIdToPartIdToGarbageCount.entrySet()) {
            int grpId = e.getKey();
            CacheGroupContext groupContext = this.ignite.context().cache().cacheGroup(grpId);
            assert (groupContext != null);
            for (Integer cacheId : e.getValue().keySet()) {
                groupContext.offheap().stopCache(cacheId, true);
                ((GridCacheOffheapManager)groupContext.offheap()).findAndCleanupLostIndexesForStoppedCache(cacheId);
            }
        }
    }

    private List<T2<CacheGroupContext, GridDhtLocalPartition>> calcListOfPartitions(Set<Integer> grpIds) {
        ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>> partArgs = new ArrayList<T2<CacheGroupContext, GridDhtLocalPartition>>();
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(grpId);
            List<GridDhtLocalPartition> parts = grpCtx.topology().localPartitions();
            for (GridDhtLocalPartition part : parts) {
                partArgs.add(new T2<CacheGroupContext, GridDhtLocalPartition>(grpCtx, part));
            }
        }
        Collections.shuffle(partArgs);
        return partArgs;
    }

    private Set<Integer> calcCacheGroupIds() {
        HashSet<Integer> grpIds = new HashSet<Integer>();
        HashSet<String> missingCacheGroups = new HashSet<String>();
        if (!F.isEmpty(this.grpNames)) {
            for (String grpName : this.grpNames) {
                CacheGroupContext groupContext = this.ignite.context().cache().cacheGroup(CU.cacheId(grpName));
                if (groupContext == null) {
                    missingCacheGroups.add(grpName);
                    continue;
                }
                if (groupContext.sharedGroup()) {
                    grpIds.add(groupContext.groupId());
                    continue;
                }
                this.log.warning("Group[name=" + grpName + "] is not shared one, it couldn't contain garbage from destroyed caches.");
            }
            if (!missingCacheGroups.isEmpty()) {
                StringBuilder strBuilder = new StringBuilder("The following cache groups do not exist: ");
                for (String name : missingCacheGroups) {
                    strBuilder.append(name).append(", ");
                }
                strBuilder.delete(strBuilder.length() - 2, strBuilder.length());
                throw new IgniteException(strBuilder.toString());
            }
        } else {
            Collection<CacheGroupContext> groups = this.ignite.context().cache().cacheGroups();
            for (CacheGroupContext grp : groups) {
                if (grp.systemCache() || grp.isLocal()) continue;
                grpIds.add(grp.groupId());
            }
        }
        return grpIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Map<Integer, Long>> processPartition(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
        if (!part.reserve()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Map<Integer, Long>> stoppedCachesForGrpId = new HashMap<Integer, Map<Integer, Long>>();
        try {
            if (part.state() != GridDhtPartitionState.OWNING) {
                Map<Integer, Map<Integer, Long>> map = Collections.emptyMap();
                return map;
            }
            GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part.id());
            while (it.hasNextX()) {
                CacheDataRow row = it.nextX();
                if (row.cacheId() == 0) {
                    break;
                }
                int cacheId = row.cacheId();
                GridCacheContext cacheCtx = grpCtx.shared().cacheContext(row.cacheId());
                if (cacheCtx != null) continue;
                stoppedCachesForGrpId.computeIfAbsent(grpCtx.groupId(), x -> new HashMap()).compute(cacheId, (x, y) -> y == null ? 1L : y + 1L);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to process partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]", e);
            Map<Integer, Map<Integer, Long>> map = Collections.emptyMap();
            return map;
        }
        finally {
            part.release();
        }
        this.processedPartitions.incrementAndGet();
        this.printProgressIfNeeded();
        return stoppedCachesForGrpId;
    }

    private void printProgressIfNeeded() {
        long lastTs;
        long curTs = U.currentTimeMillis();
        if (curTs - (lastTs = this.lastProgressPrintTs.get()) >= 60000L && this.lastProgressPrintTs.compareAndSet(lastTs, curTs)) {
            this.log.warning("Current progress of VisorFindAndDeleteGarbageInPersistenceClosure: checked " + this.processedPartitions.get() + " partitions out of " + this.totalPartitions);
        }
    }

    private IgniteException unwrapFutureException(Exception e) {
        assert (e instanceof InterruptedException || e instanceof ExecutionException) : "Expecting either InterruptedException or ExecutionException";
        if (e instanceof InterruptedException) {
            return new IgniteInterruptedException((InterruptedException)e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (IgniteException)e.getCause();
        }
        return new IgniteException(e.getCause());
    }
}

