/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.igfs.IgfsGroupDataBlocksKeyMapper;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.mapreduce.IgfsJob;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.igfs.IgfsAttributes;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsFragmentizerManager;
import org.apache.ignite.internal.processors.igfs.IgfsJobImpl;
import org.apache.ignite.internal.processors.igfs.IgfsManager;
import org.apache.ignite.internal.processors.igfs.IgfsMetaManager;
import org.apache.ignite.internal.processors.igfs.IgfsProcessorAdapter;
import org.apache.ignite.internal.processors.igfs.IgfsServerManager;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgfsProcessor
extends IgfsProcessorAdapter {
    private static final IgniteClosure<IgfsContext, IgniteFileSystem> CTX_TO_IGFS = new C1<IgfsContext, IgniteFileSystem>(){

        @Override
        public IgniteFileSystem apply(IgfsContext igfsCtx) {
            return igfsCtx.igfs();
        }
    };
    private final ConcurrentMap<String, IgfsContext> igfsCache = new ConcurrentHashMap<String, IgfsContext>();

    public IgfsProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        IgniteConfiguration igniteCfg = this.ctx.config();
        if (igniteCfg.isDaemon()) {
            return;
        }
        FileSystemConfiguration[] cfgs = igniteCfg.getFileSystemConfiguration();
        assert (cfgs != null && cfgs.length > 0);
        for (FileSystemConfiguration cfg : cfgs) {
            assert (cfg.getName() != null);
            FileSystemConfiguration cfg0 = new FileSystemConfiguration(cfg);
            boolean metaClient = true;
            CacheConfiguration[] cacheCfgs = igniteCfg.getCacheConfiguration();
            String metaCacheName = cfg.getMetaCacheConfiguration().getName();
            if (cacheCfgs != null) {
                for (CacheConfiguration cacheCfg : cacheCfgs) {
                    if (!F.eq(cacheCfg.getName(), metaCacheName)) continue;
                    metaClient = false;
                    break;
                }
            }
            if (igniteCfg.isClientMode() != null && igniteCfg.isClientMode().booleanValue()) {
                metaClient = true;
            }
            IgfsContext igfsCtx = new IgfsContext(this.ctx, cfg0, new IgfsMetaManager(cfg0.isRelaxedConsistency(), metaClient), new IgfsDataManager(), new IgfsServerManager(), new IgfsFragmentizerManager());
            for (IgfsManager mgr : igfsCtx.managers()) {
                mgr.start(igfsCtx);
            }
            this.igfsCache.put(cfg0.getName(), igfsCtx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("IGFS processor started.");
        }
        if (igniteCfg.isDaemon() || F.isEmpty(igniteCfg.getFileSystemConfiguration()) || F.isEmpty(igniteCfg.getCacheConfiguration())) {
            return;
        }
        HashMap<String, CacheConfiguration> cacheCfgs = new HashMap<String, CacheConfiguration>();
        assert (igniteCfg.getCacheConfiguration() != null);
        for (CacheConfiguration ccfg : igniteCfg.getCacheConfiguration()) {
            cacheCfgs.put(ccfg.getName(), ccfg);
        }
        ArrayList<IgfsAttributes> attrVals = new ArrayList<IgfsAttributes>();
        assert (igniteCfg.getFileSystemConfiguration() != null);
        for (FileSystemConfiguration igfsCfg : igniteCfg.getFileSystemConfiguration()) {
            AffinityKeyMapper affMapper;
            String dataCacheName = igfsCfg.getDataCacheConfiguration().getName();
            CacheConfiguration cacheCfg = (CacheConfiguration)cacheCfgs.get(dataCacheName);
            if (cacheCfg == null || !((affMapper = cacheCfg.getAffinityMapper()) instanceof IgfsGroupDataBlocksKeyMapper)) continue;
            attrVals.add(new IgfsAttributes(igfsCfg.getName(), igfsCfg.getBlockSize(), ((IgfsGroupDataBlocksKeyMapper)affMapper).getGroupSize(), igfsCfg.getMetaCacheConfiguration().getName(), dataCacheName, igfsCfg.getDefaultMode(), igfsCfg.getPathModes(), igfsCfg.isFragmentizerEnabled()));
        }
        this.ctx.addNodeAttribute("org.apache.ignite.igfs", attrVals.toArray(new IgfsAttributes[attrVals.size()]));
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (!active || this.ctx.config().isDaemon()) {
            return;
        }
        if (!IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")) {
            for (ClusterNode n : this.ctx.discovery().remoteNodes()) {
                this.checkIgfsOnRemoteNode(n);
            }
        }
        for (IgfsContext igfsCtx : this.igfsCache.values()) {
            for (IgfsManager mgr : igfsCtx.managers()) {
                mgr.onKernalStart();
            }
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.onKernalStart(true);
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.onKernalStop(true);
    }

    @Override
    public void stop(boolean cancel) {
        for (IgfsContext igfsCtx : this.igfsCache.values()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping igfs: " + igfsCtx.configuration().getName());
            }
            List<IgfsManager> mgrs = igfsCtx.managers();
            ListIterator<IgfsManager> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                IgfsManager mgr = it.previous();
                mgr.stop(cancel);
            }
            igfsCtx.igfs().stop(cancel);
        }
        this.igfsCache.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("IGFS processor stopped.");
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        for (IgfsContext igfsCtx : this.igfsCache.values()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping igfs: " + igfsCtx.configuration().getName());
            }
            List<IgfsManager> mgrs = igfsCtx.managers();
            ListIterator<IgfsManager> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                IgfsManager mgr = it.previous();
                mgr.onKernalStop(cancel);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished executing IGFS processor onKernalStop() callback.");
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> IGFS processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>   igfsCacheSize: " + this.igfsCache.size(), new Object[0]);
    }

    @Override
    public Collection<IgniteFileSystem> igfss() {
        return F.viewReadOnly(this.igfsCache.values(), CTX_TO_IGFS, new IgnitePredicate[0]);
    }

    @Override
    @Nullable
    public IgniteFileSystem igfs(String name) {
        if (name == null) {
            throw new IllegalArgumentException("IGFS name cannot be null");
        }
        IgfsContext igfsCtx = (IgfsContext)this.igfsCache.get(name);
        return igfsCtx == null ? null : igfsCtx.igfs();
    }

    @Override
    @Nullable
    public Collection<IpcServerEndpoint> endpoints(String name) {
        if (name == null) {
            throw new IllegalArgumentException("IGFS name cannot be null");
        }
        IgfsContext igfsCtx = (IgfsContext)this.igfsCache.get(name);
        return igfsCtx == null ? Collections.emptyList() : igfsCtx.server().endpoints();
    }

    @Override
    @Nullable
    public ComputeJob createJob(IgfsJob job, @Nullable String igfsName, IgfsPath path, long start, long len, IgfsRecordResolver recRslv) {
        return new IgfsJobImpl(job, igfsName, path, start, len, recRslv);
    }

    private void checkIgfsOnRemoteNode(ClusterNode rmtNode) throws IgniteCheckedException {
        IgfsAttributes[] locAttrs = (IgfsAttributes[])this.ctx.discovery().localNode().attribute("org.apache.ignite.igfs");
        IgfsAttributes[] rmtAttrs = (IgfsAttributes[])rmtNode.attribute("org.apache.ignite.igfs");
        if (F.isEmpty(locAttrs) || F.isEmpty(rmtAttrs)) {
            return;
        }
        assert (rmtAttrs != null && locAttrs != null);
        for (IgfsAttributes rmtAttr : rmtAttrs) {
            for (IgfsAttributes locAttr : locAttrs) {
                if (!F.eq(rmtAttr.igfsName(), locAttr.igfsName())) {
                    if (F.eq(rmtAttr.metaCacheName(), locAttr.metaCacheName())) {
                        throw new IgniteCheckedException("Meta cache names should be different for different IGFS instances configuration (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [metaCacheName=" + rmtAttr.metaCacheName() + ", locNodeId=" + this.ctx.localNodeId() + ", rmtNodeId=" + rmtNode.id() + ", locIgfsName=" + locAttr.igfsName() + ", rmtIgfsName=" + rmtAttr.igfsName() + ']');
                    }
                    if (!F.eq(rmtAttr.dataCacheName(), locAttr.dataCacheName())) continue;
                    throw new IgniteCheckedException("Data cache names should be different for different IGFS instances configuration (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property)[dataCacheName=" + rmtAttr.dataCacheName() + ", locNodeId=" + this.ctx.localNodeId() + ", rmtNodeId=" + rmtNode.id() + ", locIgfsName=" + locAttr.igfsName() + ", rmtIgfsName=" + rmtAttr.igfsName() + ']');
                }
                this.checkSame("Data block size", "BlockSize", rmtNode.id(), rmtAttr.blockSize(), locAttr.blockSize(), rmtAttr.igfsName());
                this.checkSame("Affinity mapper group size", "GrpSize", rmtNode.id(), rmtAttr.groupSize(), locAttr.groupSize(), rmtAttr.igfsName());
                this.checkSame("Meta cache name", "MetaCacheName", rmtNode.id(), rmtAttr.metaCacheName(), locAttr.metaCacheName(), rmtAttr.igfsName());
                this.checkSame("Data cache name", "DataCacheName", rmtNode.id(), rmtAttr.dataCacheName(), locAttr.dataCacheName(), rmtAttr.igfsName());
                this.checkSame("Default mode", "DefaultMode", rmtNode.id(), (Object)rmtAttr.defaultMode(), (Object)locAttr.defaultMode(), rmtAttr.igfsName());
                this.checkSame("Path modes", "PathModes", rmtNode.id(), rmtAttr.pathModes(), locAttr.pathModes(), rmtAttr.igfsName());
                this.checkSame("Fragmentizer enabled", "FragmentizerEnabled", rmtNode.id(), rmtAttr.fragmentizerEnabled(), locAttr.fragmentizerEnabled(), rmtAttr.igfsName());
            }
        }
    }

    private void checkSame(String name, String propName, UUID rmtNodeId, Object rmtVal, Object locVal, String igfsName) throws IgniteCheckedException {
        if (!F.eq(rmtVal, locVal)) {
            throw new IgniteCheckedException(name + " should be the same on all nodes in grid for IGFS configuration (fix configuration or set -D" + "IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK" + "=true system property ) [rmtNodeId=" + rmtNodeId + ", rmt" + propName + "=" + rmtVal + ", loc" + propName + "=" + locVal + ", ggfName=" + igfsName + ']');
        }
    }
}

