/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearOptimisticTxPrepareFutureAdapter
extends GridNearTxPrepareFutureAdapter {
    private static final long serialVersionUID = 7460376140787916619L;
    @GridToStringExclude
    protected KeyLockFuture keyLockFut;

    protected GridNearOptimisticTxPrepareFutureAdapter(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic()) : tx;
        if (tx.timeout() > 0L) {
            for (IgniteTxEntry e : tx.writeEntries()) {
                if (!e.context().isNear() && !e.context().isLocal()) continue;
                this.keyLockFut = new KeyLockFuture();
                break;
            }
            if (tx.serializable() && this.keyLockFut == null) {
                for (IgniteTxEntry e : tx.readEntries()) {
                    if (!e.context().isNear() && !e.context().isLocal()) continue;
                    this.keyLockFut = new KeyLockFuture();
                    break;
                }
            }
            if (this.keyLockFut != null) {
                this.add(this.keyLockFut);
            }
        }
    }

    @Override
    public final void onNearTxLocalTimeout() {
        if (this.keyLockFut != null && !this.keyLockFut.isDone()) {
            ERR_UPD.compareAndSet(this, null, new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.tx.timeout() + ", tx=" + this.tx + ']'));
            this.keyLockFut.onDone();
        }
    }

    @Override
    public final void prepare() {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx.system() && (topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx)) == null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            this.tx.topologyVersion(topVer);
            this.cctx.mvcc().addFuture(this);
            this.prepare0(false, true);
            return;
        }
        this.prepareOnTopology(false, null);
    }

    protected final GridDhtTopologyFuture topologyReadLock() {
        return this.tx.txState().topologyReadLock(this.cctx, this);
    }

    protected final void topologyReadUnlock() {
        this.tx.txState().topologyReadUnlock(this.cctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void prepareOnTopology(boolean remap, @Nullable Runnable c) {
        GridDhtTopologyFuture topFut = this.topologyReadLock();
        AffinityTopologyVersion topVer = null;
        try {
            if (topFut == null) {
                assert (this.isDone());
                return;
            }
            if (topFut.isDone()) {
                topVer = topFut.topologyVersion();
                if (topVer == null && topFut.error() != null) {
                    this.onDone(topFut.error());
                    return;
                }
                if (remap) {
                    this.tx.onRemap(topVer, true);
                } else {
                    this.tx.topologyVersion(topVer);
                }
                if (!remap) {
                    this.cctx.mvcc().addFuture(this);
                }
            }
        }
        finally {
            this.topologyReadUnlock();
        }
        if (topVer != null) {
            IgniteCheckedException err = this.tx.txState().validateTopology(this.cctx, this.tx.writeMap().isEmpty(), topFut);
            if (err != null) {
                this.onDone(err);
                return;
            }
            if (this.tx.isRollbackOnly()) {
                this.onDone(new IgniteTxRollbackCheckedException("Failed to prepare the transaction, due to the transaction is marked as rolled back [tx=" + CU.txString(this.tx) + ']'));
                return;
            }
            this.prepare0(remap, false);
            if (c != null) {
                c.run();
            }
        } else {
            this.cctx.time().waitAsync(topFut, this.tx.remainingTime(), (e, timedOut) -> {
                if (this.errorOrTimeoutOnTopologyVersion((IgniteCheckedException)e, (boolean)timedOut)) {
                    return;
                }
                try {
                    if (this.tx.isRollbackOnly()) {
                        this.onDone(new IgniteTxRollbackCheckedException("Failed to prepare the transaction, due to the transaction is marked as rolled back [tx=" + CU.txString(this.tx) + ']'));
                        return;
                    }
                    this.prepareOnTopology(remap, c);
                }
                finally {
                    this.cctx.txContextReset();
                }
            });
        }
    }

    protected abstract void prepare0(boolean var1, boolean var2);

    protected boolean errorOrTimeoutOnTopologyVersion(IgniteCheckedException e, boolean timedOut) {
        if (e != null || timedOut) {
            if (timedOut) {
                e = this.tx.timeoutException();
            }
            ERR_UPD.compareAndSet(this, null, e);
            this.onDone(e);
            return true;
        }
        return false;
    }

    protected static class KeyLockFuture
    extends GridFutureAdapter<Void> {
        @GridToStringInclude
        protected Collection<IgniteTxKey> lockKeys = new GridConcurrentHashSet<IgniteTxKey>();
        protected volatile boolean allKeysAdded;

        protected KeyLockFuture() {
        }

        protected void addLockKey(IgniteTxKey key) {
            assert (!this.allKeysAdded);
            this.lockKeys.add(key);
        }

        protected void onKeyLocked(IgniteTxKey key) {
            this.lockKeys.remove(key);
            this.checkLocks();
        }

        protected void onAllKeysAdded() {
            this.allKeysAdded = true;
            this.checkLocks();
        }

        private void checkLocks() {
            boolean locked = this.lockKeys.isEmpty();
            if (locked && this.allKeysAdded) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("All locks are acquired for near prepare future: " + this);
                }
                this.onDone((Void)null);
            } else if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Still waiting for locks [fut=" + this + ", keys=" + this.lockKeys + ']');
            }
        }

        @Override
        public String toString() {
            return S.toString(KeyLockFuture.class, this, super.toString());
        }
    }
}

