/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

@GridToStringExclude
public class GridSpinReadWriteLock {
    private static final long PENDING_WLOCKS_OFFS;
    private static final long STATE_OFFS;
    private final ThreadLocal<Integer> readLockEntryCnt = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private volatile int state;
    private volatile int pendingWLocks;
    private long writeLockOwner = -1L;
    private int writeLockEntryCnt;

    public void readLock() {
        int cnt = this.readLockEntryCnt.get();
        if (cnt > 0 || Thread.currentThread().getId() == this.writeLockOwner) {
            assert (this.state > 0 || this.state == -1);
            this.readLockEntryCnt.set(cnt + 1);
            return;
        }
        boolean interrupted = false;
        while (true) {
            int cur = this.state;
            assert (cur >= -1);
            if (cur == -1 || this.pendingWLocks > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
                continue;
            }
            if (this.compareAndSet(STATE_OFFS, cur, cur + 1)) break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.readLockEntryCnt.set(1);
    }

    public boolean tryReadLock() {
        int cur;
        int cnt = this.readLockEntryCnt.get();
        if (cnt > 0 || Thread.currentThread().getId() == this.writeLockOwner) {
            assert (this.state > 0 || this.state == -1);
            this.readLockEntryCnt.set(cnt + 1);
            return true;
        }
        do {
            if ((cur = this.state) != -1 && this.pendingWLocks <= 0) continue;
            return false;
        } while (!this.compareAndSet(STATE_OFFS, cur, cur + 1));
        this.readLockEntryCnt.set(1);
        return true;
    }

    public void readUnlock() {
        int cur;
        int cnt = this.readLockEntryCnt.get();
        if (cnt == 0) {
            throw new IllegalMonitorStateException();
        }
        if (cnt > 1 || Thread.currentThread().getId() == this.writeLockOwner) {
            assert (this.state > 0 || this.state == -1);
            this.readLockEntryCnt.set(cnt - 1);
            return;
        }
        do {
            cur = this.state;
            assert (cur > 0);
        } while (!this.compareAndSet(STATE_OFFS, cur, cur - 1));
        this.readLockEntryCnt.set(0);
    }

    public void writeLock() {
        int pendingWLocks0;
        int pendingWLocks02;
        long threadId = Thread.currentThread().getId();
        if (threadId == this.writeLockOwner) {
            assert (this.state == -1);
            ++this.writeLockEntryCnt;
            return;
        }
        while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks02 = this.pendingWLocks, pendingWLocks02 + 1)) {
        }
        boolean interrupted = false;
        while (!this.compareAndSet(STATE_OFFS, 0, -1)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignored) {
                interrupted = true;
            }
        }
        do {
            pendingWLocks0 = this.pendingWLocks;
            assert (pendingWLocks0 > 0);
        } while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks0, pendingWLocks0 - 1));
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        assert (this.writeLockOwner == -1L);
        this.writeLockOwner = threadId;
        this.writeLockEntryCnt = 1;
    }

    public void writeLock0() {
        int pendingWLocks0;
        long threadId = Thread.currentThread().getId();
        if (threadId == this.writeLockOwner) {
            assert (this.state == -1);
            ++this.writeLockEntryCnt;
            return;
        }
        while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks0 = this.pendingWLocks, pendingWLocks0 + 1)) {
        }
        while (!this.compareAndSet(STATE_OFFS, 0, -1)) {
        }
        do {
            pendingWLocks0 = this.pendingWLocks;
            assert (pendingWLocks0 > 0);
        } while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks0, pendingWLocks0 - 1));
        assert (this.writeLockOwner == -1L);
        this.writeLockOwner = threadId;
        this.writeLockEntryCnt = 1;
    }

    public boolean writeLockedByCurrentThread() {
        return this.writeLockOwner == Thread.currentThread().getId();
    }

    public boolean tryWriteLock() {
        long threadId = Thread.currentThread().getId();
        if (threadId == this.writeLockOwner) {
            assert (this.state == -1);
            ++this.writeLockEntryCnt;
            return true;
        }
        if (this.compareAndSet(STATE_OFFS, 0, -1)) {
            assert (this.writeLockOwner == -1L);
            this.writeLockOwner = threadId;
            this.writeLockEntryCnt = 1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteLock(long timeout, TimeUnit unit) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        if (threadId == this.writeLockOwner) {
            assert (this.state == -1);
            ++this.writeLockEntryCnt;
            return true;
        }
        try {
            int pendingWLocks0;
            while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks0 = this.pendingWLocks, pendingWLocks0 + 1)) {
            }
            long startNanos = System.nanoTime();
            long timeoutNanos = unit.toNanos(timeout);
            do {
                if (this.compareAndSet(STATE_OFFS, 0, -1)) {
                    assert (this.writeLockOwner == -1L);
                    this.writeLockOwner = threadId;
                    this.writeLockEntryCnt = 1;
                    boolean bl = true;
                    return bl;
                }
                Thread.sleep(10L);
            } while (System.nanoTime() - startNanos < timeoutNanos);
            boolean bl = false;
            return bl;
        }
        finally {
            int pendingWLocks0;
            do {
                pendingWLocks0 = this.pendingWLocks;
                assert (pendingWLocks0 > 0);
            } while (!this.compareAndSet(PENDING_WLOCKS_OFFS, pendingWLocks0, pendingWLocks0 - 1));
        }
    }

    public void writeUnlock() {
        long threadId = Thread.currentThread().getId();
        if (threadId != this.writeLockOwner) {
            throw new IllegalMonitorStateException();
        }
        if (this.writeLockEntryCnt > 1) {
            --this.writeLockEntryCnt;
            return;
        }
        this.writeLockEntryCnt = 0;
        this.writeLockOwner = -1L;
        int update = this.readLockEntryCnt.get() > 0 ? 1 : 0;
        boolean b = this.compareAndSet(STATE_OFFS, -1, update);
        assert (b);
    }

    private boolean compareAndSet(long offs, int expect, int update) {
        return GridUnsafe.compareAndSwapInt(this, offs, expect, update);
    }

    public String toString() {
        return S.toString(GridSpinReadWriteLock.class, this);
    }

    static {
        try {
            STATE_OFFS = GridUnsafe.objectFieldOffset(GridSpinReadWriteLock.class.getDeclaredField("state"));
            PENDING_WLOCKS_OFFS = GridUnsafe.objectFieldOffset(GridSpinReadWriteLock.class.getDeclaredField("pendingWLocks"));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

