/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.ClusterToolExecutionResult;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.distribution.WatchedProcess;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.topology.Version;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.HostAndIpValidator;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.OS;
import org.terracotta.angela.common.util.TriggeringOutputStream;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public class Distribution43Controller
extends DistributionController {
    private static final Logger logger = LoggerFactory.getLogger(Distribution43Controller.class);
    private final boolean tsaFullLogging = AngelaProperties.TSA_FULL_LOGGING.getBooleanValue();

    Distribution43Controller(Distribution distribution) {
        super(distribution);
        Version version = distribution.getVersion();
        if (version.getMajor() != 4) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " cannot work with distribution version " + version);
        }
    }

    @Override
    public TerracottaServerInstance.TerracottaServerInstanceProcess createTsa(TerracottaServer terracottaServer, File kitDir, File workingDir, Topology topology, Map<ServerSymbolicName, Integer> proxiedPorts, TerracottaCommandLineEnvironment tcEnv, List<String> startUpArgs) {
        AtomicReference<TerracottaServerState> stateRef = new AtomicReference<TerracottaServerState>(TerracottaServerState.STOPPED);
        AtomicReference<TerracottaServerState> tempStateRef = new AtomicReference<TerracottaServerState>(TerracottaServerState.STOPPED);
        TriggeringOutputStream serverLogOutputStream = TriggeringOutputStream.triggerOn(Pattern.compile("^.*\\QTerracotta Server instance has started up as ACTIVE\\E.*$"), mr -> {
            if (stateRef.get() == TerracottaServerState.STOPPED) {
                tempStateRef.set(TerracottaServerState.STARTED_AS_ACTIVE);
            } else {
                stateRef.set(TerracottaServerState.STARTED_AS_ACTIVE);
            }
        }).andTriggerOn(Pattern.compile("^.*\\QMoved to State[ PASSIVE-STANDBY ]\\E.*$"), mr -> tempStateRef.set(TerracottaServerState.STARTED_AS_PASSIVE)).andTriggerOn(Pattern.compile("^.*\\QManagement server started\\E.*$"), mr -> stateRef.set((TerracottaServerState)((Object)tempStateRef.get()))).andTriggerOn(Pattern.compile("^.*\\QServer exiting\\E.*$"), mr -> stateRef.set(TerracottaServerState.STOPPED));
        serverLogOutputStream = this.tsaFullLogging ? serverLogOutputStream.andForward(line -> ExternalLoggers.tsaLogger.info("[{}] {}", (Object)terracottaServer.getServerSymbolicName().getSymbolicName(), line)) : serverLogOutputStream.andTriggerOn(Pattern.compile("^.*(WARN|ERROR).*$"), mr -> ExternalLoggers.tsaLogger.info("[{}] {}", (Object)terracottaServer.getServerSymbolicName().getSymbolicName(), (Object)mr.group()));
        Map<String, String> env = this.buildEnv(tcEnv);
        env.compute("JAVA_OPTS", (key, value) -> {
            String prop = " -Dangela.processIdentifier=" + terracottaServer.getId();
            return value == null ? prop : value + prop;
        });
        WatchedProcess<TerracottaServerState> watchedProcess = new WatchedProcess<TerracottaServerState>(new ProcessExecutor().command(this.createTsaCommand(terracottaServer.getServerSymbolicName(), terracottaServer.getId(), topology.getConfigurationManager(), proxiedPorts, kitDir, workingDir, startUpArgs)).directory(workingDir).environment(env).redirectErrorStream(true).redirectOutput(serverLogOutputStream), stateRef, TerracottaServerState.STOPPED);
        int wrapperPid = watchedProcess.getPid();
        Number javaPid = this.findWithJcmdJavaPidOf(terracottaServer.getId().toString(), tcEnv);
        return new TerracottaServerInstance.TerracottaServerInstanceProcess(stateRef, wrapperPid, javaPid);
    }

    private Number findWithJcmdJavaPidOf(String serverUuid, TerracottaCommandLineEnvironment tcEnv) {
        String javaHome = tcEnv.getJavaHome().orElseGet(() -> this.javaLocationResolver.resolveJavaLocation(tcEnv).getHome());
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (OS.INSTANCE.isWindows()) {
            cmdLine.add(javaHome + "\\bin\\jcmd.exe");
        } else {
            cmdLine.add(javaHome + "/bin/jcmd");
        }
        cmdLine.add("com.tc.server.TCServerMain");
        cmdLine.add("VM.system_properties");
        int retries = 100;
        for (int i = 0; i < 100; ++i) {
            List<String> lines;
            Number pid;
            ProcessResult processResult;
            try {
                processResult = new ProcessExecutor((List<String>)cmdLine).redirectErrorStream(true).readOutput(true).execute();
            }
            catch (Exception e) {
                logger.warn("Unable to get server pid with jcmd", e);
                return null;
            }
            if (processResult.getExitValue() == 0 && (pid = this.parseOutputAndFindUuid(lines = processResult.getOutput().getLines(), serverUuid)) != null) {
                return pid;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (i != 99) continue;
            logger.warn("Unable to get server pid with jcmd (rc={})", (Object)processResult.getExitValue());
            logger.warn("{}", (Object)processResult.getOutput().getString());
        }
        return null;
    }

    private Number parseOutputAndFindUuid(List<String> lines, String serverUuid) {
        int pid = 0;
        for (String line : lines) {
            if (line.endsWith(":")) {
                try {
                    pid = Integer.parseInt(line.substring(0, line.length() - 1));
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (!line.equals("angela.processIdentifier=" + serverUuid)) continue;
            return pid;
        }
        logger.warn("Unable to parse jcmd output: {} to find serverUuid {}", (Object)lines, (Object)serverUuid);
        return null;
    }

    @Override
    public void configure(String clusterName, File kitDir, File workingDir, String licensePath, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv, boolean verbose) {
        logger.info("There is no licensing step in 4.x");
    }

    @Override
    public ClusterToolExecutionResult invokeClusterTool(File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        throw new UnsupportedOperationException("4.x does not have a cluster tool");
    }

    @Override
    public ConfigToolExecutionResult invokeConfigTool(File kitDir, File workingDir, TerracottaCommandLineEnvironment env, Path securityDir, String ... arguments) {
        throw new UnsupportedOperationException("4.x does not support config tool");
    }

    private List<String> createTsaCommand(ServerSymbolicName serverSymbolicName, UUID serverId, ConfigurationManager configurationManager, Map<ServerSymbolicName, Integer> proxiedPorts, File kitLocation, File installLocation, List<String> startUpArgs) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getStartCmd(kitLocation));
        String symbolicName = serverSymbolicName.getSymbolicName();
        if (HostAndIpValidator.isValidHost(symbolicName) || HostAndIpValidator.isValidIPv4(symbolicName) || HostAndIpValidator.isValidIPv6(symbolicName) || symbolicName.isEmpty()) {
            options.add("-n");
            options.add(symbolicName);
        }
        TcConfigManager tcConfigProvider = (TcConfigManager)configurationManager;
        TcConfig tcConfig = TcConfig.copy(tcConfigProvider.findTcConfig(serverId));
        tcConfigProvider.setUpInstallation(tcConfig, serverSymbolicName, serverId, proxiedPorts, installLocation, null);
        if (tcConfig.getPath() != null) {
            try {
                String modifiedTcConfigPath = tcConfig.getPath().substring(0, tcConfig.getPath().length() - 4) + "-" + serverSymbolicName.getSymbolicName() + ".xml";
                String modifiedConfig = FileUtils.readFileToString(new File(tcConfig.getPath())).replaceAll(Pattern.quote("${restart-data}"), "restart-data/" + serverSymbolicName).replaceAll(Pattern.quote("${SERVER_NAME_TEMPLATE}"), serverSymbolicName.getSymbolicName());
                FileUtils.write(new File(modifiedTcConfigPath), modifiedConfig);
                options.add("-f");
                options.add(modifiedTcConfigPath);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error when modifying tc config", ioe);
            }
        }
        options.addAll(startUpArgs);
        StringBuilder sb = new StringBuilder();
        for (String option : options) {
            sb.append(option).append(" ");
        }
        logger.debug("TSA create command = {}", (Object)sb.toString());
        return options;
    }

    private String getStartCmd(File kitLocation) {
        String execPath = "server" + File.separator + "bin" + File.separator + "start-tc-server" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return kitLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return kitLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define Terracotta server Start Command for distribution: " + this.distribution);
    }

    @Override
    public TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv) {
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public void stopTms(File installLocation, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess terracottaServerInstanceProcess, TerracottaCommandLineEnvironment tcEnv) {
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public TerracottaVoterInstance.TerracottaVoterInstanceProcess startVoter(TerracottaVoter terracottaVoter, File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv) {
        throw new UnsupportedOperationException("Running voter is supported not in this distribution version");
    }

    @Override
    public void stopVoter(TerracottaVoterInstance.TerracottaVoterInstanceProcess terracottaVoterInstanceProcess) {
        throw new UnsupportedOperationException("Running voter is supported not in this distribution version");
    }

    @Override
    public URI tsaUri(Collection<TerracottaServer> servers, Map<ServerSymbolicName, Integer> proxyTsaPorts) {
        return URI.create(servers.stream().map(s -> new HostPort(s.getHostname(), proxyTsaPorts.getOrDefault(s.getServerSymbolicName(), s.getTsaPort())).getHostPort()).collect(Collectors.joining(",", "", "")));
    }

    @Override
    public String clientJarsRootFolderName(Distribution distribution) {
        if (distribution.getPackageType() == PackageType.KIT) {
            return "apis";
        }
        if (distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return "common" + File.separator + "lib";
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String pluginJarsRootFolderName(Distribution distribution) {
        throw new UnsupportedOperationException("4.x does not support plugins");
    }

    @Override
    public String terracottaInstallationRoot() {
        return "Terracotta";
    }
}

