/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterState;
import org.terracotta.angela.common.distribution.DistributionController;

public class TerracottaVoterInstance {
    private final TerracottaVoter terracottaVoter;
    private final File kitDir;
    private final DistributionController distributionController;
    private final File workingDir;
    private final TerracottaCommandLineEnvironment tcEnv;
    private volatile TerracottaVoterInstanceProcess terracottaVoterInstanceProcess = new TerracottaVoterInstanceProcess(new AtomicReference<TerracottaVoterState>(TerracottaVoterState.STOPPED), new Number[0]);

    public TerracottaVoterInstance(TerracottaVoter terracottaVoter, DistributionController distributionController, File kitDir, File workingDir, TerracottaCommandLineEnvironment tcEnv) {
        this.terracottaVoter = terracottaVoter;
        this.distributionController = distributionController;
        this.kitDir = kitDir;
        this.workingDir = workingDir;
        this.tcEnv = tcEnv;
    }

    public void start() {
        this.terracottaVoterInstanceProcess = this.distributionController.startVoter(this.terracottaVoter, this.kitDir, this.workingDir, this.tcEnv);
    }

    public void stop() {
        this.distributionController.stopVoter(this.terracottaVoterInstanceProcess);
    }

    public TerracottaVoterState getTerracottaVoterState() {
        return this.terracottaVoterInstanceProcess.getState();
    }

    public static class TerracottaVoterInstanceProcess {
        private final Set<Number> pids;
        private final AtomicReference<TerracottaVoterState> state;

        public TerracottaVoterInstanceProcess(AtomicReference<TerracottaVoterState> state, Number ... pids) {
            for (Number pid : pids) {
                if (pid.intValue() >= 1) continue;
                throw new IllegalArgumentException("Pid cannot be < 1");
            }
            this.pids = new HashSet<Number>(Arrays.asList(pids));
            this.state = state;
        }

        public TerracottaVoterState getState() {
            return this.state.get();
        }

        public Set<Number> getPids() {
            return Collections.unmodifiableSet(this.pids);
        }
    }
}

