/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheSqlQuery
implements Message {
    private static final long serialVersionUID = 0L;
    public static final Object[] EMPTY_PARAMS = new Object[0];
    @GridToStringInclude(sensitive=true)
    private String qry;
    @GridToStringInclude
    private int[] paramIdxs;
    @GridToStringInclude
    @GridDirectTransient
    private LinkedHashMap<String, ?> cols;
    private String alias;
    @GridToStringInclude
    @GridDirectTransient
    private transient List<?> sort;
    @GridToStringInclude
    @GridDirectTransient
    private transient boolean partitioned;
    private UUID node;
    @GridToStringInclude
    @GridDirectTransient
    private transient Object derivedPartitions;
    @GridToStringInclude
    @GridDirectTransient
    private transient boolean hasSubQries;

    public GridCacheSqlQuery() {
    }

    public GridCacheSqlQuery(String qry) {
        A.ensure(!F.isEmpty(qry), "qry must not be empty");
        this.qry = qry;
    }

    public LinkedHashMap<String, ?> columns() {
        return this.cols;
    }

    public GridCacheSqlQuery columns(LinkedHashMap<String, ?> columns) {
        this.cols = columns;
        return this;
    }

    public String query() {
        return this.qry;
    }

    public GridCacheSqlQuery query(String qry) {
        this.qry = qry;
        return this;
    }

    public int[] parameterIndexes() {
        return this.paramIdxs;
    }

    public GridCacheSqlQuery parameterIndexes(int[] paramIdxs) {
        this.paramIdxs = paramIdxs;
        return this;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridCacheSqlQuery.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("alias", this.alias)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeUuid("node", this.node)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeIntArray("paramIdxs", this.paramIdxs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeString("qry", this.qry)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.alias = reader.readString("alias");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.node = reader.readUuid("node");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.paramIdxs = reader.readIntArray("paramIdxs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.qry = reader.readString("qry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheSqlQuery.class);
    }

    @Override
    public short directType() {
        return 112;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    public GridCacheSqlQuery copy() {
        GridCacheSqlQuery cp = new GridCacheSqlQuery();
        cp.qry = this.qry;
        cp.cols = this.cols;
        cp.paramIdxs = this.paramIdxs;
        cp.sort = this.sort;
        cp.partitioned = this.partitioned;
        cp.derivedPartitions = this.derivedPartitions;
        cp.hasSubQries = this.hasSubQries;
        return cp;
    }

    public void sortColumns(List<?> sort) {
        this.sort = sort;
    }

    public List<?> sortColumns() {
        return this.sort;
    }

    public void partitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public UUID node() {
        return this.node;
    }

    public GridCacheSqlQuery node(UUID node) {
        this.node = node;
        return this;
    }

    public Object[] parameters(Object[] allParams) {
        if (F.isEmpty(this.paramIdxs)) {
            return EMPTY_PARAMS;
        }
        assert (!F.isEmpty(allParams));
        int maxIdx = this.paramIdxs[this.paramIdxs.length - 1];
        Object[] res = new Object[maxIdx + 1];
        for (int i = 0; i < this.paramIdxs.length; ++i) {
            int idx = this.paramIdxs[i];
            res[idx] = allParams[idx];
        }
        return res;
    }

    public Object derivedPartitions() {
        return this.derivedPartitions;
    }

    public void derivedPartitions(Object derivedPartitions) {
        this.derivedPartitions = derivedPartitions;
    }

    public boolean hasSubQueries() {
        return this.hasSubQries;
    }

    public GridCacheSqlQuery hasSubQueries(boolean hasSubQries) {
        this.hasSubQries = hasSubQries;
        return this;
    }
}

