/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.hadoop.HadoopInputSplit;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.HadoopTaskType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class HadoopTaskInfo
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private HadoopTaskType type;
    private HadoopJobId jobId;
    private int taskNum;
    private int attempt;
    private HadoopInputSplit inputSplit;
    private boolean mapperIdxSet;
    private int mapperIdx;

    public HadoopTaskInfo() {
    }

    public HadoopTaskInfo(HadoopTaskType type, HadoopJobId jobId, int taskNum, int attempt, @Nullable HadoopInputSplit inputSplit) {
        this.type = type;
        this.jobId = jobId;
        this.taskNum = taskNum;
        this.attempt = attempt;
        this.inputSplit = inputSplit;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        out.writeObject(this.jobId);
        out.writeInt(this.taskNum);
        out.writeInt(this.attempt);
        out.writeObject(this.inputSplit);
        if (this.mapperIdxSet) {
            out.writeBoolean(true);
            out.writeInt(this.mapperIdx);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = HadoopTaskType.fromOrdinal(in.readByte());
        this.jobId = (HadoopJobId)in.readObject();
        this.taskNum = in.readInt();
        this.attempt = in.readInt();
        this.inputSplit = (HadoopInputSplit)in.readObject();
        if (in.readBoolean()) {
            this.mapperIdxSet = true;
            this.mapperIdx = in.readInt();
        } else {
            this.mapperIdxSet = false;
        }
    }

    public HadoopTaskType type() {
        return this.type;
    }

    public HadoopJobId jobId() {
        return this.jobId;
    }

    public int taskNumber() {
        return this.taskNum;
    }

    public int attempt() {
        return this.attempt;
    }

    public void mapperIndex(int mapperIdx) {
        this.mapperIdx = mapperIdx;
        this.mapperIdxSet = true;
    }

    public int mapperIndex() {
        return this.mapperIdx;
    }

    public boolean hasMapperIndex() {
        return this.mapperIdxSet;
    }

    @Nullable
    public HadoopInputSplit inputSplit() {
        return this.inputSplit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HadoopTaskInfo)) {
            return false;
        }
        HadoopTaskInfo that = (HadoopTaskInfo)o;
        return this.attempt == that.attempt && this.taskNum == that.taskNum && this.jobId.equals(that.jobId) && this.type == that.type;
    }

    public int hashCode() {
        int res = this.type.hashCode();
        res = 31 * res + this.jobId.hashCode();
        res = 31 * res + this.taskNum;
        res = 31 * res + this.attempt;
        return res;
    }

    public String toString() {
        return S.toString(HadoopTaskInfo.class, this);
    }
}

