/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.systemview.SystemViewAdapter;
import org.apache.ignite.internal.managers.systemview.SystemViewInnerCollectionsAdapter;
import org.apache.ignite.internal.managers.systemview.walker.CacheGroupViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.CacheViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ClientConnectionViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ClusterNodeViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ComputeTaskViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ContinuousQueryViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ScanQueryViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.ServiceViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.StripedExecutorTaskViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.TransactionViewWalker;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.systemview.ReadOnlySystemViewRegistry;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;
import org.apache.ignite.spi.systemview.view.CacheGroupView;
import org.apache.ignite.spi.systemview.view.CacheView;
import org.apache.ignite.spi.systemview.view.ClientConnectionView;
import org.apache.ignite.spi.systemview.view.ClusterNodeView;
import org.apache.ignite.spi.systemview.view.ComputeTaskView;
import org.apache.ignite.spi.systemview.view.ContinuousQueryView;
import org.apache.ignite.spi.systemview.view.ScanQueryView;
import org.apache.ignite.spi.systemview.view.ServiceView;
import org.apache.ignite.spi.systemview.view.StripedExecutorTaskView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.apache.ignite.spi.systemview.view.TransactionView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSystemViewManager
extends GridManagerAdapter<SystemViewExporterSpi>
implements ReadOnlySystemViewRegistry {
    public static final String SYS_POOL_QUEUE_VIEW = MetricUtils.metricName("striped", "threadpool", "queue");
    public static final String SYS_POOL_QUEUE_VIEW_DESC = "Striped thread pool task queue";
    public static final String STREAM_POOL_QUEUE_VIEW = MetricUtils.metricName("datastream", "threadpool", "queue");
    public static final String STREAM_POOL_QUEUE_VIEW_DESC = "Datastream thread pool task queue";
    private final ConcurrentHashMap<String, SystemView<?>> systemViews = new ConcurrentHashMap();
    private final List<Consumer<SystemView<?>>> viewCreationLsnrs = new CopyOnWriteArrayList();
    private final Map<Class<?>, SystemViewRowAttributeWalker<?>> walkers = new HashMap();

    public GridSystemViewManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])ctx.config().getSystemViewExporterSpi());
        this.registerWalker(CacheGroupView.class, new CacheGroupViewWalker());
        this.registerWalker(CacheView.class, new CacheViewWalker());
        this.registerWalker(ServiceView.class, new ServiceViewWalker());
        this.registerWalker(ComputeTaskView.class, new ComputeTaskViewWalker());
        this.registerWalker(ClientConnectionView.class, new ClientConnectionViewWalker());
        this.registerWalker(TransactionView.class, new TransactionViewWalker());
        this.registerWalker(ContinuousQueryView.class, new ContinuousQueryViewWalker());
        this.registerWalker(ClusterNodeView.class, new ClusterNodeViewWalker());
        this.registerWalker(ScanQueryView.class, new ScanQueryViewWalker());
        this.registerWalker(StripedExecutorTaskView.class, new StripedExecutorTaskViewWalker());
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (SystemViewExporterSpi spi : (SystemViewExporterSpi[])this.getSpis()) {
            spi.setSystemViewRegistry(this);
        }
        this.startSpi();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
    }

    public void registerThreadPools(StripedExecutor stripedExecSvc, StripedExecutor dataStreamExecSvc) {
        this.ctx.systemView().registerInnerCollectionView(SYS_POOL_QUEUE_VIEW, SYS_POOL_QUEUE_VIEW_DESC, StripedExecutorTaskView.class, Arrays.asList(stripedExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
        this.ctx.systemView().registerInnerCollectionView(STREAM_POOL_QUEUE_VIEW, STREAM_POOL_QUEUE_VIEW_DESC, StripedExecutorTaskView.class, Arrays.asList(dataStreamExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
    }

    public <R> void registerView(SystemView<R> sysView) {
        this.registerView0(sysView.name(), sysView);
    }

    public <R, D> void registerView(String name, String desc, Class<R> rowCls, Collection<D> data, Function<D, R> rowFunc) {
        this.registerView0(name, new SystemViewAdapter<R, D>(name, desc, rowCls, this.walkers.get(rowCls), data, rowFunc));
    }

    public <C, R, D> void registerInnerCollectionView(String name, String desc, Class<R> rowCls, Collection<C> container, Function<C, Collection<D>> dataExtractor, BiFunction<C, D, R> rowFunc) {
        this.registerView0(name, new SystemViewInnerCollectionsAdapter<C, R, D>(name, desc, rowCls, this.walkers.get(rowCls), container, dataExtractor, rowFunc));
    }

    public <C, R, D> void registerInnerArrayView(String name, String desc, Class<R> rowCls, Collection<C> container, Function<C, D[]> dataExtractor, BiFunction<C, D, R> rowFunc) {
        this.registerView0(name, new SystemViewInnerCollectionsAdapter<Object, R, D>(name, desc, rowCls, this.walkers.get(rowCls), container, c -> Arrays.asList((Object[])dataExtractor.apply(c)), rowFunc));
    }

    public <R, D> void registerView(String name, String desc, Class<R> rowCls, Supplier<Collection<D>> dataSupplier, Function<D, R> rowFunc) {
        this.registerView0(name, new SystemViewAdapter<R, D>(name, desc, rowCls, this.walkers.get(rowCls), dataSupplier, rowFunc));
    }

    private void registerView0(String name, SystemView sysView) {
        SystemView old = this.systemViews.putIfAbsent(name, sysView);
        assert (old == null);
        IgniteUtils.notifyListeners(sysView, this.viewCreationLsnrs, this.log);
    }

    @Nullable
    public <R> SystemView<R> view(String name) {
        return this.systemViews.get(name);
    }

    public <R> void registerWalker(Class<R> rowClass, SystemViewRowAttributeWalker<R> walker) {
        this.walkers.put(rowClass, walker);
    }

    @Override
    public void addSystemViewCreationListener(Consumer<SystemView<?>> lsnr) {
        this.viewCreationLsnrs.add(lsnr);
    }

    @Override
    @NotNull
    public Iterator<SystemView<?>> iterator() {
        return this.systemViews.values().iterator();
    }
}

