/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MultipleIterator<T>
implements Iterator<T>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Iterator<Iterator<T>> iters;
    private Iterator<T> it;
    private Iterator<T> last;
    private T next;

    public MultipleIterator(Iterator<Iterator<T>> iters) {
        this.iters = iters;
        this.it = iters.next();
        this.advance();
    }

    private void advance() {
        while (true) {
            if (this.it.hasNext()) {
                this.next = this.it.next();
                assert (this.next != null);
                return;
            }
            if (!this.iters.hasNext()) {
                return;
            }
            this.it = this.iters.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T res = this.next;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.next = null;
        this.last = this.it;
        this.advance();
        return res;
    }

    @Override
    public void remove() {
        if (this.last == null) {
            throw new IllegalStateException();
        }
        this.last.remove();
    }

    public String toString() {
        return S.toString(MultipleIterator.class, this);
    }
}

