/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorage;

public class MetastorageRowStore {
    private final PartitionMetaStorage<MetastorageDataRow> partStorage;
    protected final IgniteCacheDatabaseSharedManager db;

    public MetastorageRowStore(PartitionMetaStorage<MetastorageDataRow> partStorage, IgniteCacheDatabaseSharedManager db) {
        this.partStorage = partStorage;
        this.db = db;
    }

    public MetastorageDataRow dataRow(String key, long link) throws IgniteCheckedException {
        return new MetastorageDataRow(link, key, this.partStorage.readRow(link));
    }

    public void removeRow(long link) throws IgniteCheckedException {
        assert (link != 0L);
        this.db.checkpointReadLock();
        try {
            this.partStorage.removeDataRowByLink(link, IoStatisticsHolderNoOp.INSTANCE);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    public void addRow(MetastorageDataRow row) throws IgniteCheckedException {
        this.db.checkpointReadLock();
        try {
            this.partStorage.insertDataRow(row, IoStatisticsHolderNoOp.INSTANCE);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }
}

