/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    byte lastReceivedByte;

    @Override
    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (c == 13 || c == 10 && this.lastReceivedByte != 13 && this.lastReceivedByte != 10) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.lastReceivedByte = c;
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    protected void processBuffer() {
        this.processLine(this.buffer.toString());
        this.buffer.reset();
    }

    protected abstract void processLine(String var1);
}

