/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.UUID;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.QueryRunningFuture;
import org.apache.ignite.internal.processors.query.QueryUtils;

public class GridRunningQueryInfo {
    private final long id;
    private final UUID nodeId;
    private final String qry;
    private final GridCacheQueryType qryType;
    private final String schemaName;
    private final long startTime;
    private final GridQueryCancel cancel;
    private final boolean loc;
    private final QueryRunningFuture fut = new QueryRunningFuture();

    public GridRunningQueryInfo(long id, UUID nodeId, String qry, GridCacheQueryType qryType, String schemaName, long startTime, GridQueryCancel cancel, boolean loc) {
        this.id = id;
        this.nodeId = nodeId;
        this.qry = qry;
        this.qryType = qryType;
        this.schemaName = schemaName;
        this.startTime = startTime;
        this.cancel = cancel;
        this.loc = loc;
    }

    public long id() {
        return this.id;
    }

    public String globalQueryId() {
        return QueryUtils.globalQueryId(this.nodeId, this.id);
    }

    public String query() {
        return this.qry;
    }

    public GridCacheQueryType queryType() {
        return this.qryType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public long startTime() {
        return this.startTime;
    }

    public boolean longQuery(long curTime, long duration) {
        return curTime - this.startTime > duration;
    }

    public void cancel() {
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    public QueryRunningFuture runningFuture() {
        return this.fut;
    }

    public boolean cancelable() {
        return this.cancel != null;
    }

    public boolean local() {
        return this.loc;
    }

    public UUID nodeId() {
        return this.nodeId;
    }
}

