/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Stream;

public class FileUtils {
    public static void setCorrectPermissions(Path dest) {
        if (!FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dest, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String name = path.getFileName().toString();
                return name.endsWith(".sh") || name.endsWith("tms.jar");
            }).forEach(path -> {
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
                    perms.addAll(EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(path, perms);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

