/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.util.Random;
import org.terracotta.angela.common.net.port_locking.PortAllocator;

public class RandomPortAllocator
implements PortAllocator {
    private static final int LOWEST_PORT_INCLUSIVE = 1024;
    private static final int HIGHEST_PORT_INCLUSIVE = Short.MAX_VALUE;
    private final Random random;

    public RandomPortAllocator(Random random) {
        this.random = random;
    }

    @Override
    public int allocatePorts(int portCount) {
        int highestPortAdjustment = portCount - 1;
        return this.getRandomIntInRange(1024, Short.MAX_VALUE - highestPortAdjustment);
    }

    private int getRandomIntInRange(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }
}

