/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net.port_locking;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import org.terracotta.angela.common.net.port_locking.PortLock;
import org.terracotta.angela.common.net.port_locking.PortLockingException;

public class GlobalFilePortLock
implements PortLock {
    private final int port;
    private final RandomAccessFile file;
    private final Channel channel;
    private final FileLock lock;

    GlobalFilePortLock(int port, RandomAccessFile file, Channel channel, FileLock lock) {
        this.port = port;
        this.file = file;
        this.channel = channel;
        this.lock = lock;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void close() {
        PortLockingException closeError = new PortLockingException("Failed to unlock during close");
        try {
            this.lock.close();
        }
        catch (IOException e) {
            closeError.addSuppressed(e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            closeError.addSuppressed(e);
        }
        try {
            this.file.close();
        }
        catch (IOException e) {
            closeError.addSuppressed(e);
        }
        if (closeError.getSuppressed().length > 0) {
            throw closeError;
        }
    }
}

