/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.angela.common.net.PortAllocation;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.net.port_locking.LockingPortChooser;
import org.terracotta.angela.common.net.port_locking.LockingPortChoosers;
import org.terracotta.angela.common.net.port_locking.MuxPortLock;

public class DefaultPortAllocator
implements PortAllocator {
    private final LockingPortChooser lockingPortChooser = LockingPortChoosers.getFileLockingPortChooser();
    private final Collection<MuxPortLock> portLocks = new CopyOnWriteArrayList<MuxPortLock>();

    @Override
    public PortAllocation getNewRandomFreePorts(final int count) {
        final MuxPortLock muxPortLock = this.lockingPortChooser.choosePorts(count);
        this.portLocks.add(muxPortLock);
        return new PortAllocation(){

            @Override
            public int getBasePort() {
                return muxPortLock.getPort();
            }

            @Override
            public int getPortCount() {
                return count;
            }

            @Override
            public void close() {
                if (DefaultPortAllocator.this.portLocks.remove(muxPortLock)) {
                    muxPortLock.close();
                }
            }
        };
    }

    @Override
    public void close() {
        while (!this.portLocks.isEmpty() && !Thread.currentThread().isInterrupted()) {
            for (MuxPortLock muxPortLock : this.portLocks) {
                if (!this.portLocks.remove(muxPortLock)) continue;
                muxPortLock.close();
            }
        }
    }
}

