/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import org.apache.ignite.mxbean.MXBeanDescription;

@MXBeanDescription(value="MBean that provides access to information about executor service.")
public interface ThreadPoolMXBean {
    @MXBeanDescription(value="Approximate number of threads that are actively executing tasks.")
    public int getActiveCount();

    @MXBeanDescription(value="Approximate total number of tasks that have completed execution.")
    public long getCompletedTaskCount();

    @MXBeanDescription(value="The core number of threads.")
    public int getCorePoolSize();

    @MXBeanDescription(value="Largest number of threads that have ever simultaneously been in the pool.")
    public int getLargestPoolSize();

    @MXBeanDescription(value="The maximum allowed number of threads.")
    public int getMaximumPoolSize();

    @MXBeanDescription(value="Current number of threads in the pool.")
    public int getPoolSize();

    @MXBeanDescription(value="Approximate total number of tasks that have been scheduled for execution.")
    public long getTaskCount();

    @MXBeanDescription(value="Current size of the execution queue.")
    public int getQueueSize();

    @MXBeanDescription(value="Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.")
    public long getKeepAliveTime();

    @MXBeanDescription(value="True if this executor has been shut down.")
    public boolean isShutdown();

    @MXBeanDescription(value="True if all tasks have completed following shut down.")
    public boolean isTerminated();

    @MXBeanDescription(value="True if terminating but not yet terminated.")
    public boolean isTerminating();

    @MXBeanDescription(value="Class name of current rejection handler.")
    public String getRejectedExecutionHandlerClass();

    @MXBeanDescription(value="Class name of thread factory used to create new threads.")
    public String getThreadFactoryClass();
}

