/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.CommonArgParser;
import org.apache.ignite.internal.commandline.cache.CacheCommandList;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class CacheCommands
implements Command<CacheSubcommands> {
    protected static final String NODE_ID = "nodeId";
    protected static final String OP_NODE_ID = CommandLogger.optional("nodeId");
    private CacheSubcommands subcommand;

    @Override
    public void printUsage(Logger logger) {
        logger.info("  View caches information in a cluster. For more details type:");
        logger.info("    " + CommandLogger.join(" ", new Object[]{"control.(sh|bat)", CommandList.CACHE, CacheSubcommands.HELP}));
        logger.info("");
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        if (this.subcommand == CacheSubcommands.HELP) {
            this.printCacheHelp(logger);
            return null;
        }
        Command command = this.subcommand.subcommand();
        if (command == null) {
            throw new IllegalStateException("Unknown command " + (Object)((Object)this.subcommand));
        }
        return command.execute(clientCfg, logger);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Arguments are expected for --cache subcommand, run '--cache help' for more info.");
        }
        String str = argIter.nextArg("").toLowerCase();
        CacheSubcommands cmd = CacheSubcommands.of(str);
        if (cmd == null) {
            cmd = CacheSubcommands.HELP;
        }
        switch (cmd) {
            case HELP: {
                break;
            }
            case RESET_LOST_PARTITIONS: 
            case LIST: 
            case IDLE_VERIFY: 
            case VALIDATE_INDEXES: 
            case FIND_AND_DELETE_GARBAGE: 
            case CONTENTION: 
            case DISTRIBUTION: {
                cmd.subcommand().parseArguments(argIter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown --cache subcommand " + (Object)((Object)cmd));
            }
        }
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument of --cache subcommand: " + argIter.peekNextArg());
        }
        this.subcommand = cmd;
    }

    private void printCacheHelp(Logger logger) {
        logger.info("  The '" + (Object)((Object)CommandList.CACHE) + " subcommand' is used to get information about and perform actions with caches. The command has the following syntax:");
        logger.info("");
        logger.info("  " + CommandLogger.join(" ", "control.(sh|bat)", CommandLogger.join(" ", CommonArgParser.getCommonOptions())) + " " + (Object)((Object)CommandList.CACHE) + " [subcommand] <subcommand_parameters>");
        logger.info("");
        logger.info("  The subcommands that take " + OP_NODE_ID + " as an argument ('" + (Object)((Object)CacheSubcommands.LIST) + "', '" + (Object)((Object)CacheSubcommands.FIND_AND_DELETE_GARBAGE) + "', '" + (Object)((Object)CacheSubcommands.CONTENTION) + "' and '" + (Object)((Object)CacheSubcommands.VALIDATE_INDEXES) + "') will be executed on the given node or on all server nodes if the option is not specified. Other commands will run on a random server node.");
        logger.info("");
        logger.info("");
        logger.info("  Subcommands:");
        Arrays.stream(CacheCommandList.values()).forEach(c -> {
            if (c.subcommand() != null) {
                c.subcommand().printUsage(logger);
            }
        });
        logger.info("");
    }

    protected static void usageCache(Logger logger, CacheSubcommands cmd, String description, Map<String, String> paramsDesc, String ... args) {
        logger.info("");
        logger.info("  " + CommandLogger.join(" ", new Object[]{CommandList.CACHE, cmd, CommandLogger.join(" ", args)}));
        logger.info("    " + description);
        if (!F.isEmpty(paramsDesc)) {
            logger.info("");
            logger.info("    Parameters:");
            CacheCommands.usageCacheParams(paramsDesc, "      ", logger);
        }
    }

    private static void usageCacheParams(Map<String, String> paramsDesc, String indent, Logger logger) {
        int maxParamLen = paramsDesc.keySet().stream().max(Comparator.comparingInt(String::length)).get().length();
        for (Map.Entry<String, String> param : paramsDesc.entrySet()) {
            logger.info(indent + CacheCommands.extendToLen(param.getKey(), maxParamLen) + "  - " + param.getValue());
        }
    }

    private static String extendToLen(String s, int targetLen) {
        assert (targetLen >= 0);
        assert (s.length() <= targetLen);
        if (s.length() == targetLen) {
            return s;
        }
        SB sb = new SB(targetLen);
        sb.a(s);
        for (int i = 0; i < targetLen - s.length(); ++i) {
            sb.a(" ");
        }
        return sb.toString();
    }

    @Override
    public CacheSubcommands arg() {
        return this.subcommand;
    }

    @Override
    public String name() {
        return CommandList.CACHE.toCommandName();
    }
}

