/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.util.TimeBudget;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtils.class);

    public static boolean waitFor(Callable<Boolean> condition, long maxWaitTimeMillis) {
        return RetryUtils.waitFor(condition, maxWaitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(Callable<Boolean> condition, long maxWaitDuration, TimeUnit timeUnit) {
        TimeBudget timeBudget = new TimeBudget(maxWaitDuration, timeUnit);
        long currRetryTime = Math.min(maxWaitDuration, 100L);
        ExecutorService executorService = Executors.newSingleThreadExecutor(Thread::new);
        boolean success = false;
        while (timeBudget.remaining() > 0L && !Thread.currentThread().isInterrupted()) {
            Future<Boolean> future;
            long timeout = Math.min(currRetryTime, timeBudget.remaining());
            if (RetryUtils.getResult(timeout, future = executorService.submit(condition)).booleanValue()) {
                logger.info("Condition became true after {}{}", (Object)(maxWaitDuration - timeBudget.remaining()), (Object)timeUnit);
                success = true;
                break;
            }
            logger.debug("Callable failed. Retrying..");
            RetryUtils.sleep(currRetryTime);
            currRetryTime *= 2L;
        }
        RetryUtils.cleanup(executorService);
        return success;
    }

    private static void sleep(long currRetryTime) {
        try {
            Thread.sleep(currRetryTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static Boolean getResult(long timeout, Future<Boolean> future) {
        try {
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    private static void cleanup(ExecutorService executorService) {
        try {
            executorService.shutdownNow();
            executorService.awaitTermination(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

