/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaDirectoryCreateProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long accessTime;
    private long modificationTime;
    private Map<String, String> props;
    private String childName;
    private IgfsListingEntry childEntry;

    public IgfsMetaDirectoryCreateProcessor() {
    }

    public IgfsMetaDirectoryCreateProcessor(long accessTime, long modificationTime, Map<String, String> props) {
        this(accessTime, modificationTime, props, null, null);
    }

    public IgfsMetaDirectoryCreateProcessor(long accessTime, long modificationTime, Map<String, String> props, String childName, IgfsListingEntry childEntry) {
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
        this.props = props;
        this.childName = childName;
        this.childEntry = childEntry;
    }

    @Override
    public IgfsEntryInfo process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo info = IgfsUtils.createDirectory((IgniteUuid)entry.getKey(), null, this.props, this.accessTime, this.modificationTime);
        if (this.childName != null) {
            info = ((IgfsEntryInfo)info).listing(Collections.singletonMap(this.childName, this.childEntry));
        }
        entry.setValue(info);
        return info;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        IgfsUtils.writeProperties(out, this.props);
        U.writeString(out, this.childName);
        if (this.childName != null) {
            IgfsUtils.writeListingEntry(out, this.childEntry);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.props = IgfsUtils.readProperties(in);
        this.childName = U.readString(in);
        if (this.childName != null) {
            this.childEntry = IgfsUtils.readListingEntry(in);
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        IgfsUtils.writeProperties(out, this.props);
        out.writeString(this.childName);
        if (this.childName != null) {
            IgfsUtils.writeListingEntry(out, this.childEntry);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.props = IgfsUtils.readProperties(in);
        this.childName = in.readString();
        if (this.childName != null) {
            this.childEntry = IgfsUtils.readListingEntry(in);
        }
    }

    public String toString() {
        return S.toString(IgfsMetaDirectoryCreateProcessor.class, this);
    }
}

