/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridJobExecuteResponse
implements Message {
    private static final long serialVersionUID = 0L;
    private UUID nodeId;
    private IgniteUuid sesId;
    private IgniteUuid jobId;
    private byte[] gridExBytes;
    @GridDirectTransient
    private IgniteException gridEx;
    private byte[] resBytes;
    @GridDirectTransient
    private Object res;
    private byte[] jobAttrsBytes;
    @GridDirectTransient
    private Map<Object, Object> jobAttrs;
    private boolean isCancelled;
    @GridToStringExclude
    @GridDirectTransient
    private IgniteException fakeEx;
    private AffinityTopologyVersion retry;

    public GridJobExecuteResponse() {
    }

    public GridJobExecuteResponse(UUID nodeId, IgniteUuid sesId, IgniteUuid jobId, byte[] gridExBytes, IgniteException gridEx, byte[] resBytes, Object res, byte[] jobAttrsBytes, Map<Object, Object> jobAttrs, boolean isCancelled, AffinityTopologyVersion retry) {
        assert (nodeId != null);
        assert (sesId != null);
        assert (jobId != null);
        this.nodeId = nodeId;
        this.sesId = sesId;
        this.jobId = jobId;
        this.gridExBytes = gridExBytes;
        this.gridEx = gridEx;
        this.resBytes = resBytes;
        this.res = res;
        this.jobAttrsBytes = jobAttrsBytes;
        this.jobAttrs = jobAttrs;
        this.isCancelled = isCancelled;
        this.retry = retry;
    }

    public IgniteUuid getSessionId() {
        return this.sesId;
    }

    public IgniteUuid getJobId() {
        return this.jobId;
    }

    @Nullable
    public byte[] getJobResultBytes() {
        return this.resBytes;
    }

    @Nullable
    public Object getJobResult() {
        return this.res;
    }

    @Nullable
    public byte[] getExceptionBytes() {
        return this.gridExBytes;
    }

    @Nullable
    public IgniteException getException() {
        return this.gridEx;
    }

    @Nullable
    public byte[] getJobAttributesBytes() {
        return this.jobAttrsBytes;
    }

    @Nullable
    public Map<Object, Object> getJobAttributes() {
        return this.jobAttrs;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public IgniteException getFakeException() {
        return this.fakeEx;
    }

    public void setFakeException(IgniteException fakeEx) {
        this.fakeEx = fakeEx;
    }

    public boolean retry() {
        return this.retry != null;
    }

    public AffinityTopologyVersion getRetryTopologyVersion() {
        return this.retry != null ? this.retry : AffinityTopologyVersion.NONE;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("gridExBytes", this.gridExBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("isCancelled", this.isCancelled)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("jobAttrsBytes", this.jobAttrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeIgniteUuid("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeUuid("nodeId", this.nodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByteArray("resBytes", this.resBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("retry", this.retry)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeIgniteUuid("sesId", this.sesId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.gridExBytes = reader.readByteArray("gridExBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.isCancelled = reader.readBoolean("isCancelled");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.jobAttrsBytes = reader.readByteArray("jobAttrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.jobId = reader.readIgniteUuid("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.nodeId = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.resBytes = reader.readByteArray("resBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.retry = (AffinityTopologyVersion)reader.readMessage("retry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.sesId = reader.readIgniteUuid("sesId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridJobExecuteResponse.class);
    }

    @Override
    public short directType() {
        return 2;
    }

    @Override
    public byte fieldsCount() {
        return 8;
    }

    public String toString() {
        return S.toString(GridJobExecuteResponse.class, this);
    }
}

