/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private int part;
    @GridToStringInclude(sensitive=true)
    private Object key;
    @GridToStringInclude
    private final IgniteUuid xid;
    @GridToStringInclude
    private final Object lockId;
    @GridToStringInclude(sensitive=true)
    private final Object newVal;
    @GridToStringInclude(sensitive=true)
    private final Object oldVal;
    @GridToStringInclude
    private final boolean hasOldVal;
    @GridToStringInclude
    private final boolean hasNewVal;
    @GridToStringExclude
    @Nullable
    private final ClusterNode evtNode;
    @GridToStringInclude
    private boolean near;
    @GridToStringInclude
    private UUID subjId;
    @GridToStringInclude
    private String cloClsName;
    @GridToStringInclude
    private String taskName;

    public CacheEvent(String cacheName, ClusterNode node, @Nullable ClusterNode evtNode, String msg, int type, int part, boolean near, Object key, IgniteUuid xid, Object lockId, Object newVal, boolean hasNewVal, Object oldVal, boolean hasOldVal, UUID subjId, String cloClsName, String taskName) {
        super(node, msg, type);
        this.cacheName = cacheName;
        this.evtNode = evtNode;
        this.part = part;
        this.near = near;
        this.key = key;
        this.xid = xid;
        this.lockId = lockId;
        this.newVal = newVal;
        this.hasNewVal = hasNewVal;
        this.oldVal = oldVal;
        this.hasOldVal = hasOldVal;
        this.subjId = subjId;
        this.cloClsName = cloClsName;
        this.taskName = taskName;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public int partition() {
        return this.part;
    }

    public boolean isNear() {
        return this.near;
    }

    public ClusterNode eventNode() {
        return this.evtNode;
    }

    public <K> K key() {
        return (K)this.key;
    }

    public IgniteUuid xid() {
        return this.xid;
    }

    public Object lockId() {
        return this.lockId;
    }

    public Object newValue() {
        return this.newVal;
    }

    public Object oldValue() {
        return this.oldVal;
    }

    public boolean hasOldValue() {
        return this.hasOldVal;
    }

    public boolean hasNewValue() {
        return this.hasNewVal;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public String closureClassName() {
        return this.cloClsName;
    }

    public String taskName() {
        return this.taskName;
    }

    @Override
    public String shortDisplay() {
        return this.name() + ": near=" + this.near + ", key=" + this.key + ", hasNewVal=" + this.hasNewVal + ", hasOldVal=" + this.hasOldVal + ", nodeId8=" + U.id8(this.node().id());
    }

    @Override
    public String toString() {
        return S.toString(CacheEvent.class, this, "nodeId8", U.id8(this.node().id()), "evtNodeId8", U.id8(this.evtNode.id()), "msg", this.message(), "type", this.name(), "tstamp", this.timestamp());
    }
}

