/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.terracotta.angela.common.net.DisruptionProvider;

public class DisruptionProviderFactory {
    private static final DisruptionProvider DEFAULT_PROVIDER = DisruptionProviderFactory.loadDefault();

    public static DisruptionProvider getDefault() {
        return DEFAULT_PROVIDER;
    }

    private static DisruptionProvider loadDefault() {
        ServiceLoader<DisruptionProvider> serviceLoader = ServiceLoader.load(DisruptionProvider.class);
        ArrayList<DisruptionProvider> providers = new ArrayList<DisruptionProvider>();
        for (DisruptionProvider provider : serviceLoader) {
            providers.add(provider);
        }
        if (providers.size() != 1) {
            throw new RuntimeException("Expected number of disrution provider is 1 but found " + providers.size());
        }
        return (DisruptionProvider)providers.iterator().next();
    }
}

