/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.ClusterToolExecutionResult;
import org.terracotta.angela.common.ConfigToolExecutionResult;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaManagementServerState;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.TerracottaServerState;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.distribution.WatchedProcess;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.OS;
import org.terracotta.angela.common.util.ProcessUtil;
import org.terracotta.angela.common.util.TriggeringOutputStream;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class Distribution107Controller
extends DistributionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(Distribution107Controller.class);
    private final boolean tsaFullLogging = Boolean.parseBoolean(AngelaProperties.TSA_FULL_LOGGING.getValue());
    private final boolean tmsFullLogging = Boolean.parseBoolean(AngelaProperties.TMS_FULL_LOGGING.getValue());

    public Distribution107Controller(Distribution distribution) {
        super(distribution);
    }

    @Override
    public TerracottaServerInstance.TerracottaServerInstanceProcess createTsa(TerracottaServer terracottaServer, File installLocation, Topology topology, Map<ServerSymbolicName, Integer> proxiedPorts, TerracottaCommandLineEnvironment tcEnv, List<String> startUpArgs) {
        Map<String, String> env = this.buildEnv(tcEnv);
        AtomicReference<TerracottaServerState> stateRef = new AtomicReference<TerracottaServerState>(TerracottaServerState.STOPPED);
        AtomicInteger javaPid = new AtomicInteger(-1);
        TriggeringOutputStream serverLogOutputStream = TriggeringOutputStream.triggerOn(Pattern.compile("^.*\\QStarted the server in diagnostic mode\\E.*$"), mr -> stateRef.set(TerracottaServerState.STARTED_IN_DIAGNOSTIC_MODE)).andTriggerOn(Pattern.compile("^.*\\QTerracotta Server instance has started up as ACTIVE\\E.*$"), mr -> stateRef.set(TerracottaServerState.STARTED_AS_ACTIVE)).andTriggerOn(Pattern.compile("^.*\\QMoved to State[ PASSIVE-STANDBY ]\\E.*$"), mr -> stateRef.set(TerracottaServerState.STARTED_AS_PASSIVE)).andTriggerOn(Pattern.compile("^.*\\QL2 exiting\\E.*$"), mr -> stateRef.set(TerracottaServerState.STOPPED)).andTriggerOn(Pattern.compile("^.*PID is (\\d+).*$"), mr -> {
            javaPid.set(Integer.parseInt(mr.group(1)));
            stateRef.compareAndSet(TerracottaServerState.STOPPED, TerracottaServerState.STARTING);
        }).andTriggerOn(this.tsaFullLogging ? Pattern.compile("^.*$") : Pattern.compile("^.*(WARN|ERROR).*$"), mr -> ExternalLoggers.tsaLogger.info("[{}] {}", (Object)terracottaServer.getServerSymbolicName().getSymbolicName(), (Object)mr.group()));
        WatchedProcess<TerracottaServerState> watchedProcess = new WatchedProcess<TerracottaServerState>(new ProcessExecutor().command(this.createTsaCommand(terracottaServer, installLocation, startUpArgs)).directory(installLocation).environment(env).redirectError(System.err).redirectOutput(serverLogOutputStream), stateRef, TerracottaServerState.STOPPED);
        while (javaPid.get() == -1 && watchedProcess.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!watchedProcess.isAlive()) {
            throw new RuntimeException("Terracotta server process died in its infancy : " + terracottaServer.getServerSymbolicName());
        }
        return new TerracottaServerInstance.TerracottaServerInstanceProcess(stateRef, watchedProcess.getPid(), javaPid);
    }

    @Override
    public TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File installLocation, TerracottaCommandLineEnvironment tcEnv) {
        Map<String, String> env = this.buildEnv(tcEnv);
        AtomicReference<TerracottaManagementServerState> stateRef = new AtomicReference<TerracottaManagementServerState>(TerracottaManagementServerState.STOPPED);
        AtomicInteger javaPid = new AtomicInteger(-1);
        TriggeringOutputStream outputStream = TriggeringOutputStream.triggerOn(Pattern.compile("^.*\\Qstarted on port\\E.*$"), mr -> stateRef.set(TerracottaManagementServerState.STARTED)).andTriggerOn(Pattern.compile("^.*\\QStarting TmsApplication\\E.*with PID (\\d+).*$"), mr -> javaPid.set(Integer.parseInt(mr.group(1)))).andTriggerOn(this.tmsFullLogging ? Pattern.compile("^.*$") : Pattern.compile("^.*(WARN|ERROR).*$"), mr -> ExternalLoggers.tmsLogger.info(mr.group()));
        WatchedProcess<TerracottaManagementServerState> watchedProcess = new WatchedProcess<TerracottaManagementServerState>(new ProcessExecutor().command(this.startTmsCommand(installLocation)).directory(installLocation).environment(env).redirectError(System.err).redirectOutput(outputStream), stateRef, TerracottaManagementServerState.STOPPED);
        while ((javaPid.get() == -1 || stateRef.get() == TerracottaManagementServerState.STOPPED) && watchedProcess.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!watchedProcess.isAlive()) {
            throw new RuntimeException("TMS process died before reaching STARTED state");
        }
        int wrapperPid = watchedProcess.getPid();
        int javaProcessPid = javaPid.get();
        return new TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess(stateRef, wrapperPid, javaProcessPid);
    }

    @Override
    public void stopTms(File installLocation, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess terracottaServerInstanceProcess, TerracottaCommandLineEnvironment tcEnv) {
        LOGGER.debug("Destroying TMS process");
        for (Number pid : terracottaServerInstanceProcess.getPids()) {
            try {
                ProcessUtil.destroyGracefullyOrForcefullyAndWait(pid.intValue());
            }
            catch (Exception e) {
                LOGGER.error("Could not destroy TMS process {}", (Object)pid, (Object)e);
            }
        }
    }

    @Override
    public void configure(String clusterName, File location, String licensePath, Topology topology, Map<ServerSymbolicName, Integer> proxyTsaPorts, SecurityRootDirectory srd, TerracottaCommandLineEnvironment tcEnv, boolean verbose) {
        TerracottaServer server = topology.getServers().get(0);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("activate", "-n", clusterName, "-s", server.getHostPort()));
        if (licensePath != null) {
            args.add("-l");
            args.add(licensePath);
        }
        this.invokeConfigTool(location, tcEnv, args.toArray(new String[0]));
    }

    @Override
    public ClusterToolExecutionResult invokeClusterTool(File installLocation, TerracottaCommandLineEnvironment env, String ... arguments) {
        throw new UnsupportedOperationException("Dynamic config doesn't use cluster-tool");
    }

    @Override
    public ConfigToolExecutionResult invokeConfigTool(File installLocation, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(installLocation + File.separator + "tools" + File.separator + "config-tool" + File.separator + "bin" + File.separator + "config-tool" + OS.INSTANCE.getShellExtension());
        command.addAll(Arrays.asList(arguments));
        LOGGER.info("Invoking config tool with args: {}", (Object)Arrays.asList(arguments));
        try {
            ProcessResult processResult = new ProcessExecutor((List<String>)command).directory(installLocation).environment(this.buildEnv(tcEnv)).readOutput(true).redirectErrorStream(true).redirectOutputAlsoTo(Slf4jStream.of(ExternalLoggers.configToolLogger).asInfo()).redirectErrorAlsoTo(Slf4jStream.of(ExternalLoggers.configToolLogger).asError()).execute();
            return new ConfigToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI tsaUri(Collection<TerracottaServer> servers, Map<ServerSymbolicName, Integer> proxyTsaPorts) {
        return URI.create(servers.stream().map(s -> new HostPort(s.getHostname(), proxyTsaPorts.getOrDefault(s.getServerSymbolicName(), s.getTsaPort())).getHostPort()).collect(Collectors.joining(",", "terracotta://", "")));
    }

    @Override
    public String clientJarsRootFolderName(Distribution distribution) {
        if (distribution.getPackageType() == PackageType.KIT) {
            return "client";
        }
        if (distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return "common" + File.separator + "lib";
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String pluginJarsRootFolderName(Distribution distribution) {
        return "server" + File.separator + "plugins" + File.separator + "lib";
    }

    private List<String> createTsaCommand(TerracottaServer terracottaServer, File installLocation, List<String> startUpArgs) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getTsaCreateExecutable(installLocation));
        if (startUpArgs != null && !startUpArgs.isEmpty()) {
            command.addAll(startUpArgs);
        } else {
            List<String> dynamicArguments = this.addOptions(terracottaServer);
            command.addAll(dynamicArguments);
        }
        LOGGER.debug(" Create TSA command = {}", (Object)command);
        return command;
    }

    private List<String> addOptions(TerracottaServer server) {
        ArrayList<String> options = new ArrayList<String>();
        if (server.getConfigFile() != null) {
            options.add("-f");
            options.add(server.getConfigFile());
        } else {
            options.add("-n");
            options.add(server.getServerSymbolicName().getSymbolicName());
        }
        options.add("-s");
        options.add(server.getHostname());
        if (server.getTsaPort() != 0) {
            options.add("-p");
            options.add(String.valueOf(server.getTsaPort()));
        }
        if (server.getTsaGroupPort() != 0) {
            options.add("-g");
            options.add(String.valueOf(server.getTsaGroupPort()));
        }
        if (server.getBindAddress() != null) {
            options.add("-a");
            options.add(server.getBindAddress());
        }
        if (server.getGroupBindAddress() != null) {
            options.add("-A");
            options.add(server.getGroupBindAddress());
        }
        if (server.getConfigRepo() != null) {
            options.add("-r");
            options.add(server.getConfigRepo());
        }
        if (server.getMetaData() != null) {
            options.add("-m");
            options.add(server.getMetaData());
        }
        if (server.getDataDir() != null) {
            options.add("-d");
            options.add(server.getDataDir());
        }
        if (server.getOffheap() != null) {
            options.add("-o");
            options.add(server.getOffheap());
        }
        if (server.getLogs() != null) {
            options.add("-L");
            options.add(server.getLogs());
        }
        if (server.getFailoverPriority() != null) {
            options.add("-y");
            options.add(server.getFailoverPriority());
        }
        if (server.getClientLeaseDuration() != null) {
            options.add("-i");
            options.add(server.getClientLeaseDuration());
        }
        LOGGER.info("Server startup options: {}", (Object)options);
        return options;
    }

    private String getTsaCreateExecutable(File installLocation) {
        String execPath = "server" + File.separator + "bin" + File.separator + "start-tc-server" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return installLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return installLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define Terracotta server Start Command for distribution: " + this.distribution);
    }

    private List<String> startTmsCommand(File installLocation) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getStartTmsExecutable(installLocation));
        LOGGER.debug(" Start TMS command = {}", (Object)command);
        return command;
    }

    private String getStartTmsExecutable(File installLocation) {
        String execPath = "tools" + File.separator + "management" + File.separator + "bin" + File.separator + "start" + OS.INSTANCE.getShellExtension();
        if (this.distribution.getPackageType() == PackageType.KIT) {
            return installLocation.getAbsolutePath() + File.separator + execPath;
        }
        if (this.distribution.getPackageType() == PackageType.SAG_INSTALLER) {
            return installLocation.getAbsolutePath() + File.separator + this.terracottaInstallationRoot() + File.separator + execPath;
        }
        throw new IllegalStateException("Can not define TMS Start Command for distribution: " + this.distribution);
    }

    @Override
    public String terracottaInstallationRoot() {
        return "TerracottaDB";
    }
}

