/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.KitResolver;
import org.terracotta.angela.agent.kit.KitManager;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;

public class LocalKitManager
extends KitManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalKitManager.class);
    private final Map<String, File> clientJars = new HashMap<String, File>();
    private final KitResolver kitResolver;
    static final String INSTALLATION_LOCK_FILE_NAME = "angela-install.lock";

    public LocalKitManager(Distribution distribution) {
        super(distribution);
        if (distribution != null) {
            ServiceLoader<KitResolver> kitResolvers = ServiceLoader.load(KitResolver.class);
            KitResolver currentKitResolver = null;
            int kitResolverCount = 0;
            for (KitResolver kitResolver : kitResolvers) {
                ++kitResolverCount;
                if (!kitResolver.supports(distribution.getLicenseType())) continue;
                if (currentKitResolver != null) {
                    throw new IllegalStateException("Found several service implementation for KitResolver for LicenseType " + (Object)((Object)distribution.getLicenseType()));
                }
                currentKitResolver = kitResolver;
            }
            if (currentKitResolver == null) {
                throw new IllegalArgumentException("Current LicenceType " + (Object)((Object)distribution.getLicenseType()) + " can't find a corresponding KitResolver service (" + kitResolverCount + " services available)");
            }
            this.kitResolver = currentKitResolver;
        } else {
            this.kitResolver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupLocalInstall(License license, String kitInstallationPath, boolean offline) {
        if (kitInstallationPath != null) {
            logger.info("Using kitInstallationPath: {}", (Object)kitInstallationPath);
            Path path = Paths.get(kitInstallationPath, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("kitInstallationPath: " + kitInstallationPath + " isn't a directory");
            }
            this.kitInstallationPath = path;
        } else if (this.rootInstallationPath != null) {
            Path localInstallerPath = this.rootInstallationPath.resolve(this.kitResolver.resolveLocalInstallerPath(this.distribution.getVersion(), this.distribution.getLicenseType(), this.distribution.getPackageType()));
            logger.info("Checking if local kit is available at: {}", (Object)localInstallerPath);
            try {
                this.lockConcurrentInstall(localInstallerPath);
                if (!this.isValidLocalInstallerFilePath(offline, localInstallerPath)) {
                    logger.info("Local kit at: {} found to be invalid. Downloading a fresh installer", (Object)localInstallerPath);
                    this.kitResolver.downloadLocalInstaller(this.distribution.getVersion(), this.distribution.getLicenseType(), this.distribution.getPackageType(), localInstallerPath);
                }
                this.kitInstallationPath = this.kitResolver.resolveKitInstallationPath(this.distribution.getVersion(), this.distribution.getPackageType(), localInstallerPath, this.rootInstallationPath);
                if (!Files.isDirectory(this.kitInstallationPath, new LinkOption[0])) {
                    logger.info("Local install not available at: {}", (Object)this.kitInstallationPath);
                    if (offline) {
                        throw new IllegalArgumentException("Can not install the kit version " + this.distribution + " in offline mode because the kit compressed package is not available. Please run in online mode with an internet connection.");
                    }
                    this.kitResolver.createLocalInstallFromInstaller(this.distribution.getVersion(), this.distribution.getPackageType(), license, localInstallerPath, this.rootInstallationPath);
                }
            }
            finally {
                this.unlockConcurrentInstall(localInstallerPath);
            }
        }
        if (this.kitInstallationPath != null) {
            this.initClientJarsMap();
            logger.info("Local distribution is located in {}", (Object)this.kitInstallationPath);
        }
    }

    void unlockConcurrentInstall(Path localInstallerPath) {
        logger.debug(Thread.currentThread().getId() + " unlock");
        File file = localInstallerPath.getParent().resolve(INSTALLATION_LOCK_FILE_NAME).toFile();
        boolean deleted = file.delete();
        if (!deleted) {
            logger.error("Installer lock file {} could not be deleted", (Object)file.getAbsolutePath());
        } else {
            logger.info("Deleted installer lock file {}", (Object)file);
        }
    }

    void lockConcurrentInstall(Path localInstallerPath) {
        block6: {
            logger.debug(Thread.currentThread().getId() + " lock");
            Path lockDir = localInstallerPath.getParent();
            lockDir.toFile().mkdirs();
            File file = lockDir.resolve(INSTALLATION_LOCK_FILE_NAME).toFile();
            logger.info("Creating Installer lock file at: {}", (Object)file);
            try {
                if (file.createNewFile()) break block6;
                long diff = new Date().getTime() - file.lastModified();
                if (diff > TimeUnit.MINUTES.toMillis(5L)) {
                    boolean created;
                    boolean deleted = file.delete();
                    if (!deleted) {
                        logger.error("Angela Installer lock file can not be deleted when locking at {}", (Object)file.getAbsolutePath());
                    }
                    if (!(created = file.createNewFile())) {
                        logger.error("Angela Installer lock file can not be created at {}", (Object)file.getAbsolutePath());
                    }
                }
                logger.debug(Thread.currentThread().getId() + " wait");
                for (int i = 0; i < 20; ++i) {
                    Thread.sleep(6000L);
                    if (!file.createNewFile()) continue;
                    logger.debug(Thread.currentThread().getId() + " pass");
                    break;
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                logger.error("Angela Installer lock file issue at {}", (Object)file.getAbsolutePath());
            }
        }
        logger.debug(Thread.currentThread().getId() + " pass");
    }

    private void initClientJarsMap() {
        if (this.kitInstallationPath == null) {
            return;
        }
        try {
            String clientJarsRootFolderName = this.distribution.createDistributionController().clientJarsRootFolderName(this.distribution);
            List clientJars = Files.walk(this.kitInstallationPath.resolve(clientJarsRootFolderName), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
            for (File clientJar : clientJars) {
                String bundleSymbolicName = this.loadManifestBundleSymbolicName(clientJar);
                if (bundleSymbolicName == null || !bundleSymbolicName.startsWith("com.terracotta")) continue;
                this.clientJars.put(bundleSymbolicName, clientJar);
            }
            logger.debug("Kit client jars : {}", (Object)this.clientJars);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error listing client jars in " + this.kitInstallationPath, ioe);
        }
    }

    public String getKitInstallationName() {
        return this.kitInstallationPath.getFileName().toString();
    }

    public File equivalentClientJar(File file) {
        String sourceBundleSymbolicName = this.loadManifestBundleSymbolicName(file);
        return this.clientJars.get(sourceBundleSymbolicName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadManifestBundleSymbolicName(File file) {
        try {
            if (!file.getName().endsWith(".jar")) return null;
            try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));){
                Manifest manifest = jarInputStream.getManifest();
                String string = manifest == null ? null : manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                return string;
            }
        }
        catch (IOException ioe) {
            logger.error("Error loading the JAR manifest of " + file, ioe);
            return null;
        }
    }
}

