/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheManager;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.AbstractContinuousQuery;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.ContinuousQueryWithTransformer;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SpiQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheLockImpl;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GatewayProtectedCacheProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheFutureImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheProxyImpl<K, V>
extends AsyncSupportAdapter<IgniteCache<K, V>>
implements IgniteCacheProxy<K, V> {
    private static final long serialVersionUID = 0L;
    private static final IgniteProductVersion CONT_QRY_WITH_TRANSFORMER_SINCE = IgniteProductVersion.fromString("2.5.0");
    private volatile GridCacheContext<K, V> ctx;
    @GridToStringInclude
    private volatile IgniteInternalCache<K, V> delegate;
    private volatile IgniteCacheProxy<K, V> cachedProxy;
    @GridToStringExclude
    private CacheManager cacheMgr;
    private final AtomicReference<RestartFuture> restartFut;
    private volatile boolean closed;
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public IgniteCacheProxyImpl() {
        this.restartFut = new AtomicReference<Object>(null);
    }

    public IgniteCacheProxyImpl(@NotNull GridCacheContext<K, V> ctx, @NotNull IgniteInternalCache<K, V> delegate, boolean async) {
        this(ctx, delegate, new AtomicReference<Object>(null), async);
    }

    private IgniteCacheProxyImpl(@NotNull GridCacheContext<K, V> ctx, @NotNull IgniteInternalCache<K, V> delegate, @NotNull AtomicReference<RestartFuture> restartFut, boolean async) {
        super(async);
        assert (ctx != null);
        assert (delegate != null);
        this.ctx = ctx;
        this.delegate = delegate;
        this.restartFut = restartFut;
    }

    public CountDownLatch getInitLatch() {
        return this.initLatch;
    }

    @Override
    public GridCacheContext<K, V> context() {
        return this.ctx;
    }

    @Override
    public IgniteCacheProxy<K, V> cacheNoGate() {
        return new GatewayProtectedCacheProxy(this, new CacheOperationContext(), false);
    }

    public IgniteCacheProxy<K, V> gatewayWrapper() {
        if (this.cachedProxy != null) {
            return this.cachedProxy;
        }
        this.cachedProxy = new GatewayProtectedCacheProxy(this, new CacheOperationContext(), true);
        return this.cachedProxy;
    }

    @Override
    public CacheMetrics metrics() {
        return this.ctx.cache().clusterMetrics();
    }

    @Override
    public CacheMetrics metrics(ClusterGroup grp) {
        return this.ctx.cache().clusterMetrics(grp);
    }

    @Override
    public CacheMetrics localMetrics() {
        return this.ctx.cache().localMetrics();
    }

    @Override
    public CacheMetricsMXBean mxBean() {
        return this.ctx.cache().clusterMxBean();
    }

    @Override
    public CacheMetricsMXBean localMxBean() {
        return this.ctx.cache().localMxBean();
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        CacheConfiguration cfg = this.ctx.config();
        if (!clazz.isAssignableFrom(cfg.getClass())) {
            throw new IllegalArgumentException();
        }
        return (C)((Configuration)clazz.cast(cfg));
    }

    @Override
    public IgniteCache<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> withSkipStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K1, V1> IgniteCache<K1, V1> withKeepBinary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> withNoRetries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> withPartitionRecover() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) {
        try {
            if (this.isAsync()) {
                if (this.ctx.cache().isLocal()) {
                    this.setFuture(this.ctx.cache().localLoadCacheAsync(p, args));
                } else {
                    this.setFuture(this.ctx.cache().globalLoadCacheAsync(p, args));
                }
            } else if (this.ctx.cache().isLocal()) {
                this.ctx.cache().localLoadCache(p, args);
            } else {
                this.ctx.cache().globalLoadCache(p, args);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> loadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        try {
            if (this.ctx.cache().isLocal()) {
                return this.createFuture(this.ctx.cache().localLoadCacheAsync(p, args));
            }
            return this.createFuture(this.ctx.cache().globalLoadCacheAsync(p, args));
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public void localLoadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.localLoadCacheAsync(p, args));
            } else {
                this.delegate.localLoadCache(p, args);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> localLoadCacheAsync(@Nullable IgniteBiPredicate<K, V> p, Object ... args) throws CacheException {
        return this.createFuture(this.delegate.localLoadCacheAsync(p, args));
    }

    @Override
    @Nullable
    public V getAndPutIfAbsent(K key, V val) throws CacheException {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAndPutIfAbsentAsync(key, val));
                return null;
            }
            return this.delegate.getAndPutIfAbsent(key, val);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<V> getAndPutIfAbsentAsync(K key, V val) throws CacheException {
        return this.createFuture(this.delegate.getAndPutIfAbsentAsync(key, val));
    }

    @Override
    public Lock lock(K key) throws CacheException {
        return this.lockAll(Collections.singleton(key));
    }

    @Override
    public Lock lockAll(Collection<? extends K> keys) {
        MvccUtils.verifyMvccOperationSupport(this.ctx, "Lock");
        return new CacheLockImpl<K, V>(this.ctx.gate(), this.delegate, this.ctx.operationContextPerCall(), keys);
    }

    @Override
    public boolean isLocalLocked(K key, boolean byCurrThread) {
        return byCurrThread ? this.delegate.isLockedByThread(key) : this.delegate.isLocked(key);
    }

    private <T, R> QueryCursor<R> query(ScanQuery scanQry, @Nullable IgniteClosure<T, R> transformer, @Nullable ClusterGroup grp) throws IgniteCheckedException {
        CacheOperationContext opCtxCall = this.ctx.operationContextPerCall();
        boolean isKeepBinary = opCtxCall != null && opCtxCall.isKeepBinary();
        IgniteBiPredicate p = scanQry.getFilter();
        final CacheQuery<R> qry = this.ctx.queries().createScanQuery(p, transformer, scanQry.getPartition(), isKeepBinary, scanQry.isLocal());
        if (scanQry.getPageSize() > 0) {
            qry.pageSize(scanQry.getPageSize());
        }
        if (grp != null) {
            qry.projection(grp);
        }
        GridCloseableIterator iter = (GridCloseableIterator)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.SCAN, this.ctx.name(), this.ctx, new IgniteOutClosureX<GridCloseableIterator<R>>(){

            @Override
            public GridCloseableIterator<R> applyx() throws IgniteCheckedException {
                return qry.executeScanQuery();
            }
        }, true);
        return new QueryCursorImpl(iter);
    }

    private QueryCursor<Cache.Entry<K, V>> query(final Query filter, @Nullable ClusterGroup grp) throws IgniteCheckedException {
        CacheQueryFuture fut;
        boolean isKeepBinary;
        CacheOperationContext opCtxCall = this.ctx.operationContextPerCall();
        boolean bl = isKeepBinary = opCtxCall != null && opCtxCall.isKeepBinary();
        if (filter instanceof TextQuery) {
            TextQuery p = (TextQuery)filter;
            final CacheQuery<Map.Entry<K, V>> qry = this.ctx.queries().createFullTextQuery(p.getType(), p.getText(), isKeepBinary);
            if (grp != null) {
                qry.projection(grp);
            }
            fut = (CacheQueryFuture)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.TEXT, p.getText(), this.ctx, new IgniteOutClosureX<CacheQueryFuture<Map.Entry<K, V>>>(){

                @Override
                public CacheQueryFuture<Map.Entry<K, V>> applyx() {
                    return qry.execute(new Object[0]);
                }
            }, false);
        } else if (filter instanceof SpiQuery) {
            final CacheQuery qry = this.ctx.queries().createSpiQuery(isKeepBinary);
            if (grp != null) {
                qry.projection(grp);
            }
            fut = (CacheQueryFuture)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.SPI, filter.getClass().getSimpleName(), this.ctx, new IgniteOutClosureX<CacheQueryFuture<Map.Entry<K, V>>>(){

                @Override
                public CacheQueryFuture<Map.Entry<K, V>> applyx() {
                    return qry.execute(((SpiQuery)filter).getArgs());
                }
            }, false);
        } else {
            if (filter instanceof SqlFieldsQuery) {
                throw new CacheException("Use methods 'queryFields' and 'localQueryFields' for " + SqlFieldsQuery.class.getSimpleName() + ".");
            }
            throw new CacheException("Unsupported query type: " + filter);
        }
        return new QueryCursorImpl<Cache.Entry<K, V>>(new GridCloseableIteratorAdapter<Cache.Entry<K, V>>(){
            private Cache.Entry<K, V> cur;

            @Override
            protected Cache.Entry<K, V> onNext() throws IgniteCheckedException {
                if (!this.onHasNext()) {
                    throw new NoSuchElementException();
                }
                Cache.Entry e = this.cur;
                this.cur = null;
                return e;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.cur != null) {
                    return true;
                }
                Object next = fut.next();
                if (next == null) {
                    return false;
                }
                if (next instanceof Cache.Entry) {
                    this.cur = (Cache.Entry)next;
                } else {
                    Map.Entry e = (Map.Entry)next;
                    this.cur = new CacheEntryImpl(e.getKey(), e.getValue());
                }
                return true;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                fut.cancel();
            }
        });
    }

    private ClusterGroup projection(boolean loc) {
        if (loc || this.ctx.isLocal() || this.ctx.isReplicatedAffinityNode()) {
            return this.ctx.kernalContext().grid().cluster().forLocal();
        }
        if (this.ctx.isReplicated()) {
            return this.ctx.kernalContext().grid().cluster().forDataNodes(this.ctx.name()).forRandom();
        }
        return null;
    }

    private QueryCursor<Cache.Entry<K, V>> queryContinuous(AbstractContinuousQuery qry, boolean loc, boolean keepBinary) {
        AbstractContinuousQuery qry0;
        assert (qry instanceof ContinuousQuery || qry instanceof ContinuousQueryWithTransformer);
        if (qry.getInitialQuery() instanceof ContinuousQuery || qry.getInitialQuery() instanceof ContinuousQueryWithTransformer) {
            throw new IgniteException("Initial predicate for continuous query can't be an instance of another continuous query. Use SCAN or SQL query for initial iteration.");
        }
        CacheEntryUpdatedListener locLsnr = null;
        ContinuousQueryWithTransformer.EventListener locTransLsnr = null;
        CacheEntryEventSerializableFilter rmtFilter = null;
        Factory rmtTransFactory = null;
        if (qry instanceof ContinuousQuery) {
            qry0 = (ContinuousQuery)qry;
            if (((ContinuousQuery)qry0).getLocalListener() == null) {
                throw new IgniteException("Mandatory local listener is not set for the query: " + qry);
            }
            if (((ContinuousQuery)qry0).getRemoteFilter() != null && qry0.getRemoteFilterFactory() != null) {
                throw new IgniteException("Should be used either RemoterFilter or RemoteFilterFactory.");
            }
            locLsnr = ((ContinuousQuery)qry0).getLocalListener();
            rmtFilter = ((ContinuousQuery)qry0).getRemoteFilter();
        } else {
            qry0 = (ContinuousQueryWithTransformer)qry;
            if (((ContinuousQueryWithTransformer)qry0).getLocalListener() == null) {
                throw new IgniteException("Mandatory local transformed event listener is not set for the query: " + qry);
            }
            if (((ContinuousQueryWithTransformer)qry0).getRemoteTransformerFactory() == null) {
                throw new IgniteException("Mandatory RemoteTransformerFactory is not set for the query: " + qry);
            }
            Collection<ClusterNode> nodes = this.context().grid().cluster().nodes();
            for (ClusterNode node : nodes) {
                if (node.version().compareTo(CONT_QRY_WITH_TRANSFORMER_SINCE) >= 0) continue;
                throw new IgniteException("Can't start ContinuousQueryWithTransformer, because some nodes in cluster doesn't support this feature: " + node);
            }
            locTransLsnr = ((ContinuousQueryWithTransformer)qry0).getLocalListener();
            rmtTransFactory = ((ContinuousQueryWithTransformer)qry0).getRemoteTransformerFactory();
        }
        try {
            final UUID routineId = this.ctx.continuousQueries().executeQuery(locLsnr, locTransLsnr, rmtFilter, qry.getRemoteFilterFactory(), rmtTransFactory, qry.getPageSize(), qry.getTimeInterval(), qry.isAutoUnsubscribe(), loc, keepBinary, qry.isIncludeExpired());
            final QueryCursor cur = qry.getInitialQuery() != null ? this.query(qry.getInitialQuery()) : null;
            return new QueryCursor<Cache.Entry<K, V>>(){

                @Override
                public Iterator<Cache.Entry<K, V>> iterator() {
                    return cur != null ? cur.iterator() : new GridEmptyIterator();
                }

                @Override
                public List<Cache.Entry<K, V>> getAll() {
                    return cur != null ? cur.getAll() : Collections.emptyList();
                }

                @Override
                public void close() {
                    if (cur != null) {
                        cur.close();
                    }
                    try {
                        IgniteCacheProxyImpl.this.ctx.kernalContext().continuous().stopRoutine(routineId).get();
                    }
                    catch (IgniteCheckedException e) {
                        throw U.convertException(e);
                    }
                }
            };
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        return (FieldsQueryCursor)this.query((Query)qry);
    }

    @Override
    public List<FieldsQueryCursor<List<?>>> queryMultipleStatements(SqlFieldsQuery qry) {
        A.notNull(qry, "qry");
        try {
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            this.validate(qry);
            this.convertToBinary(qry);
            CacheOperationContext opCtxCall = this.ctx.operationContextPerCall();
            boolean keepBinary = opCtxCall != null && opCtxCall.isKeepBinary();
            return this.ctx.kernalContext().query().querySqlFields(this.ctx, qry, null, keepBinary, false);
        }
        catch (Exception e) {
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException(e);
        }
    }

    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        A.notNull(qry, "qry");
        try {
            boolean keepBinary;
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            this.validate(qry);
            this.convertToBinary(qry);
            CacheOperationContext opCtxCall = this.ctx.operationContextPerCall();
            boolean bl = keepBinary = opCtxCall != null && opCtxCall.isKeepBinary();
            if (qry instanceof ContinuousQuery || qry instanceof ContinuousQueryWithTransformer) {
                return this.queryContinuous((AbstractContinuousQuery)qry, qry.isLocal(), keepBinary);
            }
            if (qry instanceof SqlQuery) {
                return this.ctx.kernalContext().query().querySql(this.ctx, (SqlQuery)qry, keepBinary);
            }
            if (qry instanceof SqlFieldsQuery) {
                return this.ctx.kernalContext().query().querySqlFields(this.ctx, (SqlFieldsQuery)qry, null, keepBinary, true).get(0);
            }
            if (qry instanceof ScanQuery) {
                return this.query((ScanQuery)qry, null, this.projection(qry.isLocal()));
            }
            return this.query(qry, this.projection(qry.isLocal()));
        }
        catch (Exception e) {
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException(e.getMessage(), e);
        }
    }

    @Override
    public <T, R> QueryCursor<R> query(Query<T> qry, IgniteClosure<T, R> transformer) {
        A.notNull(qry, "qry");
        A.notNull(transformer, "transformer");
        if (!(qry instanceof ScanQuery)) {
            throw new UnsupportedOperationException("Transformers are supported only for SCAN queries.");
        }
        try {
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            this.validate(qry);
            return this.query((ScanQuery)qry, transformer, this.projection(qry.isLocal()));
        }
        catch (Exception e) {
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException(e);
        }
    }

    private void convertToBinary(Query qry) {
        if (this.ctx.binaryMarshaller()) {
            if (qry instanceof SqlQuery) {
                SqlQuery sqlQry = (SqlQuery)qry;
                this.convertToBinary(sqlQry.getArgs());
            } else if (qry instanceof SpiQuery) {
                SpiQuery spiQry = (SpiQuery)qry;
                this.convertToBinary(spiQry.getArgs());
            } else if (qry instanceof SqlFieldsQuery) {
                SqlFieldsQuery fieldsQry = (SqlFieldsQuery)qry;
                this.convertToBinary(fieldsQry.getArgs());
            }
        }
    }

    private void convertToBinary(Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.ctx.cacheObjects().binary().toBinary(args[i]);
        }
    }

    private void validate(Query qry) {
        if (!(QueryUtils.isEnabled(this.ctx.config()) || qry instanceof ScanQuery || qry instanceof ContinuousQuery || qry instanceof ContinuousQueryWithTransformer || qry instanceof SpiQuery || qry instanceof SqlQuery || qry instanceof SqlFieldsQuery)) {
            throw new CacheException("Indexing is disabled for cache: " + this.ctx.cache().name() + ". Use setIndexedTypes or setTypeMetadata methods on CacheConfiguration to enable.");
        }
        if (!this.ctx.kernalContext().query().moduleEnabled() && (qry instanceof SqlQuery || qry instanceof SqlFieldsQuery || qry instanceof TextQuery)) {
            throw new CacheException("Failed to execute query. Add module 'ignite-indexing' to the classpath of all Ignite nodes.");
        }
    }

    @Override
    public Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode ... peekModes) throws CacheException {
        try {
            return this.delegate.localEntries(peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public QueryMetrics queryMetrics() {
        return this.delegate.context().queries().metrics();
    }

    @Override
    public void resetQueryMetrics() {
        this.delegate.context().queries().resetMetrics();
    }

    @Override
    public Collection<? extends QueryDetailMetrics> queryDetailMetrics() {
        return this.delegate.context().queries().detailMetrics();
    }

    @Override
    public void resetQueryDetailMetrics() {
        this.delegate.context().queries().resetDetailMetrics();
    }

    @Override
    public void localEvict(Collection<? extends K> keys) {
        this.delegate.evictAll(keys);
    }

    @Override
    @Nullable
    public V localPeek(K key, CachePeekMode ... peekModes) {
        try {
            return this.delegate.localPeek(key, peekModes, null);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public int size(CachePeekMode ... peekModes) throws CacheException {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeAsync(peekModes));
                return 0;
            }
            return this.delegate.size(peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Integer> sizeAsync(CachePeekMode ... peekModes) throws CacheException {
        return this.createFuture(this.delegate.sizeAsync(peekModes));
    }

    @Override
    public long sizeLong(CachePeekMode ... peekModes) throws CacheException {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeLongAsync(peekModes));
                return 0L;
            }
            return this.delegate.sizeLong(peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Long> sizeLongAsync(CachePeekMode ... peekModes) throws CacheException {
        return this.createFuture(this.delegate.sizeLongAsync(peekModes));
    }

    @Override
    public long sizeLong(int part, CachePeekMode ... peekModes) throws CacheException {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeLongAsync(part, peekModes));
                return 0L;
            }
            return this.delegate.sizeLong(part, peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Long> sizeLongAsync(int part, CachePeekMode ... peekModes) throws CacheException {
        return this.createFuture(this.delegate.sizeLongAsync(part, peekModes));
    }

    @Override
    public int localSize(CachePeekMode ... peekModes) {
        try {
            return this.delegate.localSize(peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public long localSizeLong(CachePeekMode ... peekModes) {
        try {
            return this.delegate.localSizeLong(peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public long localSizeLong(int part, CachePeekMode ... peekModes) {
        try {
            return this.delegate.localSizeLong(part, peekModes);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public V get(K key) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAsync(key));
                return null;
            }
            return this.delegate.get(key);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<V> getAsync(K key) {
        return this.createFuture(this.delegate.getAsync(key));
    }

    @Override
    public CacheEntry<K, V> getEntry(K key) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getEntryAsync(key));
                return null;
            }
            return this.delegate.getEntry(key);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<CacheEntry<K, V>> getEntryAsync(K key) {
        return this.createFuture(this.delegate.getEntryAsync(key));
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAllAsync(keys));
                return null;
            }
            return this.delegate.getAll(keys);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.getAllAsync(keys));
    }

    @Override
    public Collection<CacheEntry<K, V>> getEntries(Set<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getEntriesAsync(keys));
                return null;
            }
            return this.delegate.getEntries(keys);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Collection<CacheEntry<K, V>>> getEntriesAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.getEntriesAsync(keys));
    }

    @Override
    public Map<K, V> getAllOutTx(Set<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAllOutTxAsync(keys));
                return null;
            }
            return this.delegate.getAllOutTx(keys);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Map<K, V>> getAllOutTxAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.getAllOutTxAsync(keys));
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAllAsync(keys));
                return null;
            }
            return this.delegate.getAll(keys);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public boolean containsKey(K key) {
        if (this.isAsync()) {
            this.setFuture(this.delegate.containsKeyAsync(key));
            return false;
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public IgniteFuture<Boolean> containsKeyAsync(K key) {
        return this.createFuture(this.delegate.containsKeyAsync(key));
    }

    @Override
    public boolean containsKeys(Set<? extends K> keys) {
        if (this.isAsync()) {
            this.setFuture(this.delegate.containsKeysAsync(keys));
            return false;
        }
        return this.delegate.containsKeys(keys);
    }

    @Override
    public IgniteFuture<Boolean> containsKeysAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.containsKeysAsync(keys));
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExisting, final @Nullable CompletionListener completionLsnr) {
        IgniteInternalFuture<?> fut = this.ctx.cache().loadAll(keys, replaceExisting);
        if (completionLsnr != null) {
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> fut) {
                    try {
                        fut.get();
                        completionLsnr.onCompletion();
                    }
                    catch (IgniteCheckedException e) {
                        completionLsnr.onException(IgniteCacheProxyImpl.this.cacheException(e));
                    }
                }
            });
        }
    }

    @Override
    public void put(K key, V val) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.putAsync0(key, val));
            } else {
                this.delegate.put(key, val);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> putAsync(K key, V val) {
        return this.createFuture(this.putAsync0(key, val));
    }

    private IgniteInternalFuture<Void> putAsync0(K key, V val) {
        IgniteInternalFuture<Boolean> fut = this.delegate.putAsync(key, val);
        return fut.chain(new CX1<IgniteInternalFuture<Boolean>, Void>(){

            @Override
            public Void applyx(IgniteInternalFuture<Boolean> fut1) throws IgniteCheckedException {
                try {
                    fut1.get();
                }
                catch (RuntimeException e) {
                    throw new GridClosureException(e);
                }
                return null;
            }
        });
    }

    @Override
    public V getAndPut(K key, V val) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAndPutAsync(key, val));
                return null;
            }
            return this.delegate.getAndPut(key, val);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<V> getAndPutAsync(K key, V val) {
        return this.createFuture(this.delegate.getAndPutAsync(key, val));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.putAllAsync(map));
            } else {
                this.delegate.putAll(map);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        return this.createFuture(this.delegate.putAllAsync(map));
    }

    @Override
    public boolean putIfAbsent(K key, V val) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.putIfAbsentAsync(key, val));
                return false;
            }
            return this.delegate.putIfAbsent(key, val);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> putIfAbsentAsync(K key, V val) {
        return this.createFuture(this.delegate.putIfAbsentAsync(key, val));
    }

    @Override
    public boolean remove(K key) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.removeAsync(key));
                return false;
            }
            return this.delegate.remove(key);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> removeAsync(K key) {
        return this.createFuture(this.delegate.removeAsync(key));
    }

    @Override
    public boolean remove(K key, V oldVal) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.removeAsync(key, oldVal));
                return false;
            }
            return this.delegate.remove(key, oldVal);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> removeAsync(K key, V oldVal) {
        return this.createFuture(this.delegate.removeAsync(key, oldVal));
    }

    @Override
    public V getAndRemove(K key) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAndRemoveAsync(key));
                return null;
            }
            return this.delegate.getAndRemove(key);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<V> getAndRemoveAsync(K key) {
        return this.createFuture(this.delegate.getAndRemoveAsync(key));
    }

    @Override
    public boolean replace(K key, V oldVal, V newVal) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.replaceAsync(key, oldVal, newVal));
                return false;
            }
            return this.delegate.replace(key, oldVal, newVal);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) {
        return this.createFuture(this.delegate.replaceAsync(key, oldVal, newVal));
    }

    @Override
    public boolean replace(K key, V val) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.replaceAsync(key, val));
                return false;
            }
            return this.delegate.replace(key, val);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Boolean> replaceAsync(K key, V val) {
        return this.createFuture(this.delegate.replaceAsync(key, val));
    }

    @Override
    public V getAndReplace(K key, V val) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.getAndReplaceAsync(key, val));
                return null;
            }
            return this.delegate.getAndReplace(key, val);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<V> getAndReplaceAsync(K key, V val) {
        return this.createFuture(this.delegate.getAndReplaceAsync(key, val));
    }

    @Override
    public void removeAll(Set<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.removeAllAsync(keys));
            } else {
                this.delegate.removeAll(keys);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> removeAllAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.removeAllAsync(keys));
    }

    @Override
    public void removeAll() {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.removeAllAsync());
            } else {
                this.delegate.removeAll();
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> removeAllAsync() {
        return this.createFuture(this.delegate.removeAllAsync());
    }

    @Override
    public void clear(K key) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAsync(key));
            } else {
                this.delegate.clear(key);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> clearAsync(K key) {
        return this.createFuture(this.delegate.clearAsync(key));
    }

    @Override
    public void clearAll(Set<? extends K> keys) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAllAsync(keys));
            } else {
                this.delegate.clearAll(keys);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> clearAllAsync(Set<? extends K> keys) {
        return this.createFuture(this.delegate.clearAllAsync(keys));
    }

    @Override
    public void clear() {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAsync());
            } else {
                this.delegate.clear();
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public IgniteFuture<Void> clearAsync() {
        return this.createFuture(this.delegate.clearAsync());
    }

    @Override
    public void localClear(K key) {
        this.delegate.clearLocally(key);
    }

    @Override
    public void localClearAll(Set<? extends K> keys) {
        for (K key : keys) {
            this.delegate.clearLocally(key);
        }
    }

    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        try {
            if (this.isAsync()) {
                this.setFuture(this.invokeAsync0(key, entryProcessor, args));
                return null;
            }
            EntryProcessorResult<T> res = this.delegate.invoke(key, entryProcessor, args);
            return res != null ? (T)res.get() : null;
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> IgniteFuture<T> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.createFuture(this.invokeAsync0(key, entryProcessor, args));
    }

    private <T> IgniteInternalFuture<T> invokeAsync0(K key, EntryProcessor<K, V, T> entryProcessor, Object[] args) {
        IgniteInternalFuture<EntryProcessorResult<T>> fut = this.delegate.invokeAsync(key, entryProcessor, args);
        return fut.chain(new CX1<IgniteInternalFuture<EntryProcessorResult<T>>, T>(){

            @Override
            public T applyx(IgniteInternalFuture<EntryProcessorResult<T>> fut1) throws IgniteCheckedException {
                try {
                    return fut1.get().get();
                }
                catch (RuntimeException e) {
                    throw new GridClosureException(e);
                }
            }
        });
    }

    @Override
    public <T> T invoke(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        return this.invoke(key, (EntryProcessor<K, V, T>)entryProcessor, args);
    }

    @Override
    public <T> IgniteFuture<T> invokeAsync(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.invokeAsync(key, (EntryProcessor<K, V, T>)entryProcessor, args);
    }

    public <T> T invoke(@Nullable AffinityTopologyVersion topVer, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            if (this.isAsync()) {
                throw new UnsupportedOperationException();
            }
            EntryProcessorResult<T> res = this.delegate.invoke(topVer, key, entryProcessor, args);
            return res != null ? (T)res.get() : null;
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
                return null;
            }
            return this.delegate.invokeAll(keys, entryProcessor, args);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.createFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
                return null;
            }
            return this.delegate.invokeAll(keys, entryProcessor, args);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.createFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.invokeAllAsync(map, args));
                return null;
            }
            return this.delegate.invokeAll(map, args);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> IgniteFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        return this.createFuture(this.delegate.invokeAllAsync(map, args));
    }

    @Override
    public String getName() {
        return this.delegate.name();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public void setCacheManager(CacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    @Override
    public void destroy() {
        this.destroyAsync().get();
    }

    @Override
    public IgniteFuture<?> destroyAsync() {
        return new IgniteFutureImpl<Boolean>(this.ctx.kernalContext().cache().dynamicDestroyCache(this.ctx.name(), false, true, false));
    }

    @Override
    public void close() {
        this.closeAsync().get();
    }

    @Override
    public IgniteFuture<?> closeAsync() {
        return new IgniteFutureImpl(this.ctx.kernalContext().cache().dynamicCloseCache(this.ctx.name()));
    }

    @Override
    public boolean isClosed() {
        return this.ctx.kernalContext().cache().context().closed(this.ctx);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (clazz.isAssignableFrom(IgniteEx.class)) {
            return (T)this.ctx.grid();
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + clazz);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> lsnrCfg) {
        try {
            CacheOperationContext opCtx = this.ctx.operationContextPerCall();
            this.ctx.continuousQueries().executeJCacheQuery(lsnrCfg, false, opCtx != null && opCtx.isKeepBinary());
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> lsnrCfg) {
        try {
            this.ctx.continuousQueries().cancelJCacheQuery(lsnrCfg);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        try {
            return this.ctx.cache().igniteIterator();
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    protected IgniteCache<K, V> createAsyncInstance() {
        return new IgniteCacheProxyImpl<K, V>(this.ctx, this.delegate, true);
    }

    @Override
    public <K1, V1> IgniteCache<K1, V1> keepBinary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> withDataCenterId(byte dataCenterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> skipStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IgniteCache<K, V> withAllowAtomicOpsInTx() {
        throw new UnsupportedOperationException();
    }

    private RuntimeException cacheException(Exception e) {
        GridFutureAdapter restartFut = this.restartFut.get();
        if (restartFut != null && (X.hasCause(e, CacheStoppedException.class) || X.hasSuppressed(e, CacheStoppedException.class))) {
            throw new IgniteCacheRestartingException(new IgniteFutureImpl(restartFut), "Cache is restarting: " + this.ctx.name(), e);
        }
        if (e instanceof IgniteException && X.hasCause(e, CacheException.class)) {
            e = X.cause(e, CacheException.class);
        }
        if (e instanceof IgniteCheckedException) {
            return CU.convertToCacheException((IgniteCheckedException)e);
        }
        if (X.hasCause(e, CacheStoppedException.class)) {
            return CU.convertToCacheException(X.cause(e, CacheStoppedException.class));
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        throw new IllegalStateException("Unknown exception", e);
    }

    private <R> void setFuture(IgniteInternalFuture<R> fut) {
        this.curFut.set(this.createFuture(fut));
    }

    @Override
    protected <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        return new IgniteCacheFutureImpl<R>(fut);
    }

    @Override
    public GridCacheProxyImpl<K, V> internalProxy() {
        this.checkRestart();
        return new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, this.ctx.operationContextPerCall());
    }

    @Override
    public boolean isProxyClosed() {
        return this.closed;
    }

    @Override
    public void closeProxy() {
        this.closed = true;
    }

    @Override
    public Collection<Integer> lostPartitions() {
        return this.delegate.lostPartitions();
    }

    @Override
    public void enableStatistics(boolean enabled) {
        try {
            this.ctx.kernalContext().cache().enableStatistics(Collections.singleton(this.getName()), enabled);
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public void clearStatistics() {
        try {
            this.ctx.kernalContext().cache().clearStatistics(Collections.singleton(this.getName()));
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridCacheContext)in.readObject();
        this.delegate = (IgniteInternalCache)in.readObject();
    }

    @Override
    public IgniteFuture<Boolean> rebalance() {
        return new IgniteFutureImpl<Boolean>(this.ctx.preloader().forceRebalance());
    }

    @Override
    public IgniteFuture<?> indexReadyFuture() {
        IgniteInternalFuture fut = this.ctx.shared().database().indexRebuildFuture(this.ctx.cacheId());
        if (fut == null) {
            return new IgniteFinishedFutureImpl();
        }
        return new IgniteFutureImpl(fut);
    }

    public void checkRestart() {
        RestartFuture currentFut = this.restartFut.get();
        if (currentFut != null) {
            currentFut.checkRestartOrAwait();
        }
    }

    public boolean isRestarting() {
        return this.restartFut.get() != null;
    }

    public boolean restart() {
        RestartFuture restartFut = new RestartFuture(this.ctx.name());
        final RestartFuture curFut = this.restartFut.get();
        boolean changed = this.restartFut.compareAndSet(curFut, restartFut);
        if (changed && curFut != null) {
            restartFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                @Override
                public void apply(IgniteInternalFuture<Void> fut) {
                    if (fut.error() != null) {
                        curFut.onDone(fut.error());
                    } else {
                        curFut.onDone();
                    }
                }
            });
        }
        return changed;
    }

    public void registrateFutureRestart(GridFutureAdapter<?> fut) {
        RestartFuture currentFut = this.restartFut.get();
        if (currentFut != null) {
            currentFut.addRestartFinishedFuture(fut);
        }
    }

    public GridFutureAdapter<Void> opportunisticRestart() {
        GridFutureAdapter curFut;
        RestartFuture restartFut = new RestartFuture(this.ctx.name());
        do {
            if (!this.restartFut.compareAndSet(null, restartFut)) continue;
            return null;
        } while ((curFut = (GridFutureAdapter)this.restartFut.get()) == null);
        return curFut;
    }

    public void onRestarted(GridCacheContext ctx, IgniteInternalCache delegate) {
        RestartFuture restartFut = this.restartFut.get();
        assert (restartFut != null);
        this.ctx = ctx;
        this.delegate = delegate;
        this.restartFut.compareAndSet(restartFut, null);
        restartFut.onDone();
    }

    public String toString() {
        return S.toString(IgniteCacheProxyImpl.class, this);
    }

    private class RestartFuture
    extends GridFutureAdapter<Void> {
        private final String name;
        private volatile GridFutureAdapter<?> restartFinishFut;

        private RestartFuture(String name) {
            this.name = name;
        }

        void checkRestartOrAwait() {
            GridFutureAdapter<?> fut = this.restartFinishFut;
            if (fut != null) {
                try {
                    fut.get();
                }
                catch (IgniteCheckedException e) {
                    throw U.convertException(e);
                }
                return;
            }
            throw new IgniteCacheRestartingException(new IgniteFutureImpl<Void>(this), "Cache is restarting: " + this.name);
        }

        void addRestartFinishedFuture(GridFutureAdapter<?> fut) {
            this.restartFinishFut = fut;
        }
    }
}

