/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsAdapter;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.DataStorageMetricsAdapter;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.Ignition;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.PersistenceMetrics;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.ClusterLocalNodeMetricsMXBeanImpl;
import org.apache.ignite.internal.ClusterMetricsMXBeanImpl;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridDiagnostic;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridKernalGatewayImpl;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.GridPluginComponent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.IgniteSchedulerImpl;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.StripedExecutorMXBeanAdapter;
import org.apache.ignite.internal.ThreadPoolMXBeanAdapter;
import org.apache.ignite.internal.TransactionMetricsMxBeanImpl;
import org.apache.ignite.internal.TransactionsMXBeanImpl;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.managers.GridManager;
import org.apache.ignite.internal.managers.checkpoint.GridCheckpointManager;
import org.apache.ignite.internal.managers.collision.GridCollisionManager;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.failover.GridFailoverManager;
import org.apache.ignite.internal.managers.indexing.GridIndexingManager;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerManager;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtilityKey;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsConsistentIdProcessor;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.hadoop.Hadoop;
import org.apache.ignite.internal.processors.hadoop.HadoopProcessorAdapter;
import org.apache.ignite.internal.processors.job.GridJobProcessor;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetricsProcessor;
import org.apache.ignite.internal.processors.marshaller.GridMarshallerMappingProcessor;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.nodevalidation.OsDiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.platform.PlatformNoopProcessor;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.plugin.PlatformPluginProcessor;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.processors.rest.GridRestProcessor;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.processors.service.GridServiceProcessor;
import org.apache.ignite.internal.processors.session.GridTaskSessionProcessor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.suggestions.JvmConfigurationSuggestions;
import org.apache.ignite.internal.suggestions.OsConfigurationSuggestions;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.FailureHandlingMxBeanImpl;
import org.apache.ignite.internal.worker.WorkersControlMXBeanImpl;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.lifecycle.LifecycleEventType;
import org.apache.ignite.marshaller.MarshallerExclusions;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.ClusterMetricsMXBean;
import org.apache.ignite.mxbean.DataStorageMXBean;
import org.apache.ignite.mxbean.FailureHandlingMxBean;
import org.apache.ignite.mxbean.IgniteMXBean;
import org.apache.ignite.mxbean.StripedExecutorMXBean;
import org.apache.ignite.mxbean.ThreadPoolMXBean;
import org.apache.ignite.mxbean.TransactionMetricsMxBean;
import org.apache.ignite.mxbean.TransactionsMXBean;
import org.apache.ignite.mxbean.WorkersControlMXBean;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiVersionCheckException;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgniteKernal
implements IgniteEx,
IgniteMXBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final String SITE = "ignite.apache.org";
    private static final String NL = U.nl();
    private static final long PERIODIC_STARVATION_CHECK_FREQ = 30000L;
    private static final Object STOP_RECONNECT = new Object();
    public static final String COORDINATOR_PROPERTIES_SEPARATOR = ",";
    private LongJVMPauseDetector longJVMPauseDetector;
    @GridToStringExclude
    private GridKernalContextImpl ctx;
    @GridToStringExclude
    private final MBeansManager mBeansMgr = new MBeansManager();
    private IgniteConfiguration cfg;
    @GridToStringExclude
    private GridLoggerProxy log;
    private String igniteInstanceName;
    private long startTime = U.currentTimeMillis();
    private GridSpringResourceContext rsrcCtx;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask starveTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask metricsLogTask;
    @GridToStringExclude
    private GridTimeoutProcessor.CancelableTask longOpDumpTask;
    @GridToStringExclude
    private boolean errOnStop;
    @GridToStringExclude
    private IgniteScheduler scheduler;
    @GridToStringExclude
    private final AtomicReference<GridKernalGateway> gw = new AtomicReference();
    @GridToStringExclude
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ReconnectState reconnectState = new ReconnectState();

    public IgniteKernal() {
        this(null);
    }

    public IgniteKernal(@Nullable GridSpringResourceContext rsrcCtx) {
        this.rsrcCtx = rsrcCtx;
    }

    @Override
    public IgniteClusterEx cluster() {
        return this.ctx.cluster().get();
    }

    @Override
    public ClusterNode localNode() {
        return this.ctx.cluster().get().localNode();
    }

    @Override
    public IgniteCompute compute() {
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).compute();
    }

    @Override
    public IgniteMessaging message() {
        return this.ctx.cluster().get().message();
    }

    @Override
    public IgniteEvents events() {
        return this.ctx.cluster().get().events();
    }

    @Override
    public IgniteServices services() {
        this.checkClusterState();
        return ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).services();
    }

    @Override
    public ExecutorService executorService() {
        return this.ctx.cluster().get().executorService();
    }

    @Override
    public final IgniteCompute compute(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).compute();
    }

    @Override
    public final IgniteMessaging message(ClusterGroup prj) {
        return ((ClusterGroupAdapter)prj).message();
    }

    @Override
    public final IgniteEvents events(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).events();
    }

    @Override
    public IgniteServices services(ClusterGroup grp) {
        this.checkClusterState();
        return ((ClusterGroupAdapter)grp).services();
    }

    @Override
    public ExecutorService executorService(ClusterGroup grp) {
        return ((ClusterGroupAdapter)grp).executorService();
    }

    @Override
    public String name() {
        return this.igniteInstanceName;
    }

    @Override
    public String getCopyright() {
        return "2019 Copyright(C) Apache Software Foundation";
    }

    @Override
    public long getStartTimestamp() {
        return this.startTime;
    }

    @Override
    public String getStartTimestampFormatted() {
        return DateFormat.getDateTimeInstance().format(new Date(this.startTime));
    }

    @Override
    public boolean isRebalanceEnabled() {
        return this.ctx.cache().context().isRebalanceEnabled();
    }

    @Override
    public void rebalanceEnabled(boolean rebalanceEnabled) {
        this.ctx.cache().context().rebalanceEnabled(rebalanceEnabled);
    }

    @Override
    public long getUpTime() {
        return U.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getLongJVMPausesCount() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPausesCount() : 0L;
    }

    @Override
    public long getLongJVMPausesTotalDuration() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPausesTotalDuration() : 0L;
    }

    @Override
    public Map<Long, Long> getLongJVMPauseLastEvents() {
        return this.longJVMPauseDetector != null ? this.longJVMPauseDetector.longPauseEvents() : Collections.emptyMap();
    }

    @Override
    public String getUpTimeFormatted() {
        return X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime);
    }

    @Override
    public String getFullVersion() {
        return IgniteVersionUtils.VER_STR + '-' + IgniteVersionUtils.BUILD_TSTAMP_STR;
    }

    @Override
    public String getCheckpointSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getCheckpointSpi());
    }

    @Override
    public String getCurrentCoordinatorFormatted() {
        ClusterNode node = this.ctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
        if (node == null) {
            return "";
        }
        return node.addresses() + COORDINATOR_PROPERTIES_SEPARATOR + node.id() + COORDINATOR_PROPERTIES_SEPARATOR + node.order() + COORDINATOR_PROPERTIES_SEPARATOR + node.hostNames();
    }

    @Override
    public boolean isNodeInBaseline() {
        ClusterNode locNode = this.localNode();
        if (locNode.isClient() || locNode.isDaemon()) {
            return false;
        }
        DiscoveryDataClusterState clusterState = this.ctx.state().clusterState();
        return clusterState.hasBaselineTopology() && CU.baselineNode(locNode, clusterState);
    }

    @Override
    public String getCommunicationSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCommunicationSpi().toString();
    }

    @Override
    public String getDeploymentSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDeploymentSpi().toString();
    }

    @Override
    public String getDiscoverySpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getDiscoverySpi().toString();
    }

    @Override
    public String getEventStorageSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getEventStorageSpi().toString();
    }

    @Override
    public String getCollisionSpiFormatted() {
        assert (this.cfg != null);
        return this.cfg.getCollisionSpi().toString();
    }

    @Override
    public String getFailoverSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getFailoverSpi());
    }

    @Override
    public String getLoadBalancingSpiFormatted() {
        assert (this.cfg != null);
        return Arrays.toString(this.cfg.getLoadBalancingSpi());
    }

    @Override
    public String getOsInformation() {
        return U.osString();
    }

    @Override
    public String getJdkInformation() {
        return U.jdkString();
    }

    @Override
    public String getOsUser() {
        return System.getProperty("user.name");
    }

    @Override
    public void printLastErrors() {
        this.ctx.exceptionRegistry().printErrors(this.log);
    }

    @Override
    public String getVmName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    @Override
    public String getInstanceName() {
        return this.igniteInstanceName;
    }

    @Override
    public String getExecutorServiceFormatted() {
        assert (this.cfg != null);
        return String.valueOf(this.cfg.getPublicThreadPoolSize());
    }

    @Override
    public String getIgniteHome() {
        assert (this.cfg != null);
        return this.cfg.getIgniteHome();
    }

    @Override
    public String getGridLoggerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getGridLogger().toString();
    }

    @Override
    public String getMBeanServerFormatted() {
        assert (this.cfg != null);
        return this.cfg.getMBeanServer().toString();
    }

    @Override
    public UUID getLocalNodeId() {
        assert (this.cfg != null);
        return this.cfg.getNodeId();
    }

    @Override
    public List<String> getUserAttributesFormatted() {
        assert (this.cfg != null);
        return (List)F.transform(this.cfg.getUserAttributes().entrySet(), new C1<Map.Entry<String, ?>, String>(){

            @Override
            public String apply(Map.Entry<String, ?> e) {
                return e.getKey() + ", " + e.getValue().toString();
            }
        });
    }

    @Override
    public boolean isPeerClassLoadingEnabled() {
        assert (this.cfg != null);
        return this.cfg.isPeerClassLoadingEnabled();
    }

    @Override
    public List<String> getLifecycleBeansFormatted() {
        LifecycleBean[] beans = this.cfg.getLifecycleBeans();
        if (F.isEmpty(beans)) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(beans.length);
        for (LifecycleBean bean : beans) {
            res.add(String.valueOf(bean));
        }
        return res;
    }

    private void add(String name, @Nullable Serializable val) throws IgniteCheckedException {
        assert (name != null);
        if (this.ctx.addNodeAttribute(name, val) != null) {
            if (name.endsWith("org.apache.ignite.spi.class")) {
                throw new IgniteCheckedException("Failed to set SPI attribute. Duplicated SPI name found: " + name.substring(0, name.length() - "org.apache.ignite.spi.class".length()));
            }
            assert (false) : "Duplicate attribute: " + name;
        }
    }

    private void notifyLifecycleBeans(LifecycleEventType evt) throws IgniteCheckedException {
        if (!this.cfg.isDaemon() && this.cfg.getLifecycleBeans() != null) {
            for (LifecycleBean bean : this.cfg.getLifecycleBeans()) {
                if (bean == null) continue;
                try {
                    bean.onLifecycleEvent(evt);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException(e);
                }
            }
        }
    }

    private void notifyLifecycleBeansEx(LifecycleEventType evt) {
        block2: {
            try {
                this.notifyLifecycleBeans(evt);
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to notify lifecycle bean (safely ignored) [evt=" + (Object)((Object)evt) + (this.igniteInstanceName == null ? "" : ", igniteInstanceName=" + this.igniteInstanceName) + ']', e);
                if (!(e instanceof Error)) break block2;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(IgniteConfiguration cfg, ExecutorService utilityCachePool, final ExecutorService execSvc, ExecutorService svcExecSvc, final ExecutorService sysExecSvc, final StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, ExecutorService igfsExecSvc, StripedExecutor dataStreamExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, ExecutorService qryExecSvc, ExecutorService schemaExecSvc, final @Nullable Map<String, ? extends ExecutorService> customExecSvcs, GridAbsClosure errHnd, WorkersRegistry workerRegistry, Thread.UncaughtExceptionHandler hnd) throws IgniteCheckedException {
        long longOpDumpTimeout;
        long metricsLogFreq;
        boolean starveCheck;
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(cfg.getIgniteInstanceName()));
        GridKernalGateway gw = this.gw.get();
        gw.writeLock();
        try {
            switch (gw.getState()) {
                case STARTED: {
                    U.warn(this.log, "Grid has already been started (ignored).");
                    return;
                }
                case STARTING: {
                    U.warn(this.log, "Grid is already in process of being started (ignored).");
                    return;
                }
                case STOPPING: {
                    throw new IgniteCheckedException("Grid is in process of being stopped");
                }
            }
            gw.setState(GridKernalState.STARTING);
        }
        finally {
            gw.writeUnlock();
        }
        assert (cfg != null);
        this.validateCommon(cfg);
        this.igniteInstanceName = cfg.getIgniteInstanceName();
        this.cfg = cfg;
        this.log = (GridLoggerProxy)cfg.getGridLogger().getLogger(this.getClass().getName() + (this.igniteInstanceName != null ? '%' + this.igniteInstanceName : ""));
        this.longJVMPauseDetector = new LongJVMPauseDetector(this.log);
        this.longJVMPauseDetector.start();
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        this.ackAsciiLogo();
        this.ackConfigUrl();
        this.ackConfiguration(cfg);
        this.ackDaemon();
        this.ackOsInfo();
        this.ackLanguageRuntime();
        this.ackRemoteManagement();
        this.ackLogger();
        this.ackVmArguments(rtBean);
        this.ackClassPaths(rtBean);
        this.ackSystemProperties();
        this.ackEnvironmentVariables();
        this.ackMemoryConfiguration();
        this.ackCacheConfiguration();
        this.ackP2pConfiguration();
        this.ackRebalanceConfiguration();
        this.ackIPv4StackFlagIsSet();
        GridDiagnostic.runBackgroundCheck(this.igniteInstanceName, execSvc, this.log);
        if (this.log.isInfoEnabled() && cfg.getIgniteHome() != null) {
            this.log.info("3-rd party licenses can be found at: " + cfg.getIgniteHome() + File.separatorChar + "libs" + File.separatorChar + "licenses");
        }
        for (String name : cfg.getUserAttributes().keySet()) {
            if (!name.startsWith("org.apache.ignite")) continue;
            throw new IgniteCheckedException("User attribute has illegal name: '" + name + "'. Note that all names starting with '" + "org.apache.ignite" + "' are reserved for internal use.");
        }
        this.logNodeUserAttributes();
        this.ackSpis();
        List<PluginProvider> plugins = U.allPluginProviders();
        try {
            boolean active;
            this.ctx = new GridKernalContextImpl(this.log, this, cfg, gw, utilityCachePool, execSvc, svcExecSvc, sysExecSvc, stripedExecSvc, p2pExecSvc, mgmtExecSvc, igfsExecSvc, dataStreamExecSvc, restExecSvc, affExecSvc, idxExecSvc, callbackExecSvc, qryExecSvc, schemaExecSvc, customExecSvcs, plugins, MarshallerUtils.classNameFilter(this.getClass().getClassLoader()), workerRegistry, hnd);
            cfg.getMarshaller().setContext(this.ctx.marshallerContext());
            GridInternalSubscriptionProcessor subscriptionProc = new GridInternalSubscriptionProcessor(this.ctx);
            this.startProcessor(subscriptionProc);
            ClusterProcessor clusterProc = new ClusterProcessor(this.ctx);
            this.startProcessor(clusterProc);
            U.onGridStart();
            GridResourceProcessor rsrcProc = new GridResourceProcessor(this.ctx);
            rsrcProc.setSpringContext(this.rsrcCtx);
            this.scheduler = new IgniteSchedulerImpl(this.ctx);
            this.startProcessor(rsrcProc);
            if (!cfg.isDaemon() && cfg.getLifecycleBeans() != null) {
                for (LifecycleBean bean : cfg.getLifecycleBeans()) {
                    if (bean == null) continue;
                    rsrcProc.inject(bean);
                }
            }
            this.notifyLifecycleBeans(LifecycleEventType.BEFORE_NODE_START);
            U.startLifecycleAware(this.lifecycleAwares(cfg));
            this.addHelper(IgniteComponentType.IGFS_HELPER.create(F.isEmpty(cfg.getFileSystemConfiguration())));
            this.addHelper(IgniteComponentType.HADOOP_HELPER.createIfInClassPath(this.ctx, false));
            this.startProcessor(new IgnitePluginProcessor(this.ctx, cfg, plugins));
            this.startProcessor(new FailureProcessor(this.ctx));
            this.startProcessor(new PoolProcessor(this.ctx));
            this.startProcessor(new GridClosureProcessor(this.ctx));
            this.startProcessor(new GridPortProcessor(this.ctx));
            this.startProcessor(new GridJobMetricsProcessor(this.ctx));
            this.startProcessor(new GridTimeoutProcessor(this.ctx));
            this.startProcessor(IgniteKernal.createComponent(GridSecurityProcessor.class, this.ctx));
            this.startManager(new GridIoManager(this.ctx));
            this.startManager(new GridCheckpointManager(this.ctx));
            this.startManager(new GridEventStorageManager(this.ctx));
            this.startManager(new GridDeploymentManager(this.ctx));
            this.startManager(new GridLoadBalancerManager(this.ctx));
            this.startManager(new GridFailoverManager(this.ctx));
            this.startManager(new GridCollisionManager(this.ctx));
            this.startManager(new GridIndexingManager(this.ctx));
            this.startManager(new GridEncryptionManager(this.ctx));
            this.ackSecurity();
            GridDiscoveryManager discoMgr = new GridDiscoveryManager(this.ctx);
            this.ctx.add(discoMgr, false);
            try {
                this.startProcessor(new PdsConsistentIdProcessor(this.ctx));
                this.startProcessor(new MvccProcessorImpl(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(DiscoveryNodeValidationProcessor.class, this.ctx));
                this.startProcessor(new GridAffinityProcessor(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(GridSegmentationProcessor.class, this.ctx));
                this.startProcessor(IgniteKernal.createComponent(IgniteCacheObjectProcessor.class, this.ctx));
                this.startProcessor(IgniteKernal.createComponent(IGridClusterStateProcessor.class, this.ctx));
                this.startProcessor(new IgniteAuthenticationProcessor(this.ctx));
                this.startProcessor(new GridCacheProcessor(this.ctx));
                this.startProcessor(new GridQueryProcessor(this.ctx));
                this.startProcessor(new ClientListenerProcessor(this.ctx));
                this.startProcessor(new GridServiceProcessor(this.ctx));
                this.startProcessor(new GridTaskSessionProcessor(this.ctx));
                this.startProcessor(new GridJobProcessor(this.ctx));
                this.startProcessor(new GridTaskProcessor(this.ctx));
                this.startProcessor((GridProcessor)IgniteComponentType.SCHEDULE.createOptional(this.ctx));
                this.startProcessor(new GridRestProcessor(this.ctx));
                this.startProcessor(new DataStreamProcessor(this.ctx));
                this.startProcessor((GridProcessor)IgniteComponentType.IGFS.create(this.ctx, F.isEmpty(cfg.getFileSystemConfiguration())));
                this.startProcessor(new GridContinuousProcessor(this.ctx));
                this.startProcessor(this.createHadoopComponent());
                this.startProcessor(new DataStructuresProcessor(this.ctx));
                this.startProcessor(IgniteKernal.createComponent(PlatformProcessor.class, this.ctx));
                this.startProcessor(new GridMarshallerMappingProcessor(this.ctx));
                for (PluginProvider provider : this.ctx.plugins().allProviders()) {
                    this.ctx.add(new GridPluginComponent(provider));
                    provider.start((PluginContext)this.ctx.plugins().pluginContextForProvider(provider));
                }
                if (this.ctx.config().getPlatformConfiguration() != null) {
                    this.startProcessor(new PlatformPluginProcessor(this.ctx));
                }
                this.ctx.cluster().initDiagnosticListeners();
                this.fillNodeAttributes(clusterProc.updateNotifierEnabled());
                this.ctx.cache().context().database().notifyMetaStorageSubscribersOnReadyForRead();
            }
            catch (Throwable e) {
                U.error(this.log, "Exception during start processors, node will be stopped and close connections", e);
                this.ctx.discovery().stop(true);
                throw e;
            }
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STARTED);
                this.startManager(discoMgr);
            }
            finally {
                gw.writeUnlock();
            }
            this.checkPhysicalRam();
            this.suggestOptimizations(cfg);
            this.ctx.performance().addAll(JvmConfigurationSuggestions.getSuggestions());
            this.ctx.performance().addAll(OsConfigurationSuggestions.getSuggestions());
            DiscoveryLocalJoinData joinData = this.ctx.discovery().localJoin();
            IgniteInternalFuture<Boolean> transitionWaitFut = joinData.transitionWaitFuture();
            if (transitionWaitFut != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Join cluster while cluster state transition is in progress, waiting when transition finish.");
                }
                active = transitionWaitFut.get();
            } else {
                active = joinData.active();
            }
            this.ctx.discovery().onKernalStart(active);
            this.ctx.io().onKernalStart(active);
            boolean recon = false;
            for (GridComponent comp : this.ctx) {
                if (comp instanceof GridDiscoveryManager || comp instanceof GridIoManager || comp instanceof GridPluginComponent || this.skipDaemon(comp)) continue;
                try {
                    comp.onKernalStart(active);
                }
                catch (IgniteNeedReconnectException e) {
                    ClusterNode locNode = this.ctx.discovery().localNode();
                    assert (locNode.isClient());
                    if (!this.ctx.discovery().reconnectSupported()) {
                        throw new IgniteCheckedException("Client node in forceServerMode is not allowed to reconnect to the cluster and will be stopped.");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to start node components on node start, will wait for reconnect: " + e);
                    }
                    recon = true;
                }
            }
            for (PluginProvider provider : this.ctx.plugins().allProviders()) {
                provider.onIgniteStart();
            }
            if (recon) {
                this.reconnectState.waitFirstReconnect();
            }
            this.mBeansMgr.registerAllMBeans(utilityCachePool, execSvc, svcExecSvc, sysExecSvc, stripedExecSvc, p2pExecSvc, mgmtExecSvc, igfsExecSvc, dataStreamExecSvc, restExecSvc, affExecSvc, idxExecSvc, callbackExecSvc, qryExecSvc, schemaExecSvc, customExecSvcs, this.ctx.workersRegistry());
            this.notifyLifecycleBeans(LifecycleEventType.AFTER_NODE_START);
        }
        catch (Throwable e) {
            IgniteSpiVersionCheckException verCheckErr = X.cause(e, IgniteSpiVersionCheckException.class);
            if (verCheckErr != null) {
                U.error(this.log, verCheckErr.getMessage());
            } else if (X.hasCause(e, InterruptedException.class, IgniteInterruptedCheckedException.class)) {
                U.warn(this.log, "Grid startup routine has been interrupted (will rollback).");
            } else {
                U.error(this.log, "Got exception while starting (will rollback startup routine).", e);
            }
            errHnd.apply();
            this.stop(true);
            if (e instanceof Error) {
                throw e;
            }
            if (e instanceof IgniteCheckedException) {
                throw (IgniteCheckedException)e;
            }
            throw new IgniteCheckedException(e);
        }
        this.startTime = U.currentTimeMillis();
        String intervalStr = IgniteSystemProperties.getString("IGNITE_STARVATION_CHECK_INTERVAL");
        boolean bl = starveCheck = !this.isDaemon() && !"0".equals(intervalStr);
        if (starveCheck) {
            final long interval = F.isEmpty(intervalStr) ? 30000L : Long.parseLong(intervalStr);
            this.starveTask = this.ctx.timeout().schedule(new Runnable(){
                private long lastCompletedCntPub;
                private long lastCompletedCntSys;

                @Override
                public void run() {
                    ThreadPoolExecutor exec;
                    if (execSvc instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)execSvc;
                        this.lastCompletedCntPub = this.checkPoolStarvation(exec, this.lastCompletedCntPub, "public");
                    }
                    if (sysExecSvc instanceof ThreadPoolExecutor) {
                        exec = (ThreadPoolExecutor)sysExecSvc;
                        this.lastCompletedCntSys = this.checkPoolStarvation(exec, this.lastCompletedCntSys, "system");
                    }
                    if (stripedExecSvc != null) {
                        stripedExecSvc.checkStarvation();
                    }
                }

                private long checkPoolStarvation(ThreadPoolExecutor exec, long lastCompletedCnt, String pool) {
                    long completedCnt = exec.getCompletedTaskCount();
                    if (exec.getPoolSize() == exec.getActiveCount() && completedCnt == lastCompletedCnt && !exec.getQueue().isEmpty()) {
                        LT.warn(IgniteKernal.this.log, "Possible thread pool starvation detected (no task completed in last " + interval + "ms, is " + pool + " thread pool size large enough?)");
                    }
                    return completedCnt;
                }
            }, interval, interval);
        }
        if ((metricsLogFreq = cfg.getMetricsLogFrequency()) > 0L) {
            this.metricsLogTask = this.ctx.timeout().schedule(new Runnable(){
                private final DecimalFormat dblFmt = new DecimalFormat("#.##");

                @Override
                public void run() {
                    IgniteKernal.this.ackNodeMetrics(this.dblFmt, execSvc, sysExecSvc, customExecSvcs);
                }
            }, metricsLogFreq, metricsLogFreq);
        }
        if ((longOpDumpTimeout = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT", 60000L)) > 0L) {
            this.longOpDumpTask = this.ctx.timeout().schedule(new Runnable(){

                @Override
                public void run() {
                    GridKernalContextImpl ctx = IgniteKernal.this.ctx;
                    if (ctx != null) {
                        ctx.cache().context().exchange().dumpLongRunningOperations(longOpDumpTimeout);
                    }
                }
            }, longOpDumpTimeout, longOpDumpTimeout);
        }
        this.ctx.performance().add("Disable assertions (remove '-ea' from JVM options)", !U.assertionsEnabled());
        this.ctx.performance().logSuggestions(this.log, this.igniteInstanceName);
        U.quietAndInfo(this.log, "To start Console Management & Monitoring run ignitevisorcmd.{sh|bat}");
        this.ackStart(rtBean);
        if (!this.isDaemon()) {
            this.ctx.discovery().ackTopology(this.ctx.discovery().localJoin().joinTopologyVersion().topologyVersion(), 10, this.localNode());
        }
    }

    private String createExecutorDescription(String execSvcName, ExecutorService execSvc) {
        int poolActiveThreads = 0;
        int poolIdleThreads = 0;
        int poolQSize = 0;
        if (execSvc instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor exec = (ThreadPoolExecutor)execSvc;
            int poolSize = exec.getPoolSize();
            poolActiveThreads = Math.min(poolSize, exec.getActiveCount());
            poolIdleThreads = poolSize - poolActiveThreads;
            poolQSize = exec.getQueue().size();
        }
        return execSvcName + " [active=" + poolActiveThreads + ", idle=" + poolIdleThreads + ", qSize=" + poolQSize + "]";
    }

    private HadoopProcessorAdapter createHadoopComponent() throws IgniteCheckedException {
        boolean mandatory;
        boolean bl = mandatory = this.cfg.getHadoopConfiguration() != null;
        if (mandatory) {
            if (this.cfg.isPeerClassLoadingEnabled()) {
                throw new IgniteCheckedException("Hadoop module cannot be used with peer class loading enabled (set IgniteConfiguration.peerClassLoadingEnabled to \"false\").");
            }
            HadoopProcessorAdapter res = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.createIfInClassPath(this.ctx, true);
            res.validateEnvironment();
            return res;
        }
        HadoopProcessorAdapter cmp = null;
        if (!this.ctx.hadoopHelper().isNoOp() && this.cfg.isPeerClassLoadingEnabled()) {
            U.warn(this.log, "Hadoop module is found in classpath, but will not be started because peer class loading is enabled (set IgniteConfiguration.peerClassLoadingEnabled to \"false\" if you want to use Hadoop module).");
        } else {
            cmp = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.createIfInClassPath(this.ctx, false);
            try {
                cmp.validateEnvironment();
            }
            catch (IgniteCheckedException | IgniteException e) {
                U.quietAndWarn(this.log, "Hadoop module will not start due to exception: " + e.getMessage());
                cmp = null;
            }
        }
        if (cmp == null) {
            cmp = (HadoopProcessorAdapter)IgniteComponentType.HADOOP.create(this.ctx, true);
        }
        return cmp;
    }

    private void validateCommon(IgniteConfiguration cfg) {
        A.notNull(cfg.getNodeId(), "cfg.getNodeId()");
        if (!U.IGNITE_MBEANS_DISABLED) {
            A.notNull(cfg.getMBeanServer(), "cfg.getMBeanServer()");
        }
        A.notNull(cfg.getGridLogger(), "cfg.getGridLogger()");
        A.notNull(cfg.getMarshaller(), "cfg.getMarshaller()");
        A.notNull(cfg.getUserAttributes(), "cfg.getUserAttributes()");
        A.notNull(cfg.getCheckpointSpi(), "cfg.getCheckpointSpi()");
        A.notNull(cfg.getCommunicationSpi(), "cfg.getCommunicationSpi()");
        A.notNull(cfg.getDeploymentSpi(), "cfg.getDeploymentSpi()");
        A.notNull(cfg.getDiscoverySpi(), "cfg.getDiscoverySpi()");
        A.notNull(cfg.getEventStorageSpi(), "cfg.getEventStorageSpi()");
        A.notNull(cfg.getCollisionSpi(), "cfg.getCollisionSpi()");
        A.notNull(cfg.getFailoverSpi(), "cfg.getFailoverSpi()");
        A.notNull(cfg.getLoadBalancingSpi(), "cfg.getLoadBalancingSpi()");
        A.notNull(cfg.getIndexingSpi(), "cfg.getIndexingSpi()");
        A.ensure(cfg.getNetworkTimeout() > 0L, "cfg.getNetworkTimeout() > 0");
        A.ensure(cfg.getNetworkSendRetryDelay() > 0L, "cfg.getNetworkSendRetryDelay() > 0");
        A.ensure(cfg.getNetworkSendRetryCount() > 0, "cfg.getNetworkSendRetryCount() > 0");
    }

    private void checkPhysicalRam() {
        long ram = (Long)this.ctx.discovery().localNode().attribute("org.apache.ignite.phy.ram");
        if (ram != -1L) {
            long safeToUse;
            String macs = (String)this.ctx.discovery().localNode().attribute("org.apache.ignite.macs");
            long totalHeap = 0L;
            long totalOffheap = 0L;
            for (ClusterNode node : this.ctx.discovery().allNodes()) {
                if (!macs.equals(node.attribute("org.apache.ignite.macs"))) continue;
                long heap = node.metrics().getHeapMemoryMaximum();
                Long offheap = (Long)node.attribute("org.apache.ignite.offheap.size");
                if (heap != -1L) {
                    totalHeap += heap;
                }
                if (offheap == null) continue;
                totalOffheap += offheap.longValue();
            }
            long total = totalHeap + totalOffheap;
            if (total < 0L) {
                total = Long.MAX_VALUE;
            }
            if (total > (safeToUse = ram - Math.max(0x100000000L, (long)((double)ram * 0.2)))) {
                U.quietAndWarn(this.log, "Nodes started on local machine require more than 80% of physical RAM what can lead to significant slowdown due to swapping (please decrease JVM heap size, data region size or checkpoint buffer size) [required=" + (total >> 20) + "MB, available=" + (ram >> 20) + "MB]");
            }
        }
    }

    private void suggestOptimizations(IgniteConfiguration cfg) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        if (this.ctx.collision().enabled()) {
            perf.add("Disable collision resolution (remove 'collisionSpi' from configuration)");
        }
        if (this.ctx.checkpoint().enabled()) {
            perf.add("Disable checkpoints (remove 'checkpointSpi' from configuration)");
        }
        if (cfg.isMarshalLocalJobs()) {
            perf.add("Disable local jobs marshalling (set 'marshalLocalJobs' to false)");
        }
        if (cfg.getIncludeEventTypes() != null && cfg.getIncludeEventTypes().length != 0) {
            perf.add("Disable grid events (remove 'includeEventTypes' from configuration)");
        }
        if (BinaryMarshaller.available() && cfg.getMarshaller() != null && !(cfg.getMarshaller() instanceof BinaryMarshaller)) {
            perf.add("Use default binary marshaller (do not set 'marshaller' explicitly)");
        }
    }

    private void fillNodeAttributes(boolean notifyEnabled) throws IgniteCheckedException {
        String portStr;
        this.ctx.addNodeAttribute("org.apache.ignite.rebalance.pool.size", this.configuration().getRebalanceThreadPoolSize());
        this.ctx.addNodeAttribute("org.apache.ignite.data.streamer.pool.size", this.configuration().getDataStreamerThreadPoolSize());
        String[] incProps = this.cfg.getIncludeProperties();
        try {
            for (Map.Entry<String, String> sysEntry : System.getenv().entrySet()) {
                String name = sysEntry.getKey();
                if (incProps != null && !U.containsStringArray(incProps, name, true) && !U.isVisorNodeStartProperty(name) && !U.isVisorRequiredProperty(name)) continue;
                this.ctx.addNodeAttribute(name, sysEntry.getValue());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added environment properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add environment properties to node attributes due to security violation: " + e.getMessage());
        }
        try {
            for (Map.Entry<Object, Object> e : IgniteSystemProperties.snapshot().entrySet()) {
                String key = (String)e.getKey();
                if (incProps != null && !U.containsStringArray(incProps, key, true) && !U.isVisorRequiredProperty(key)) continue;
                Object val = this.ctx.nodeAttribute(key);
                if (val != null && !val.equals(e.getValue())) {
                    U.warn(this.log, "System property will override environment variable with the same name: " + key);
                }
                this.ctx.addNodeAttribute(key, e.getValue());
            }
            this.ctx.addNodeAttribute("org.apache.ignite.update.notifier.enabled", notifyEnabled);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added system properties to node attributes.");
            }
        }
        catch (SecurityException e) {
            throw new IgniteCheckedException("Failed to add system properties to node attributes due to security violation: " + e.getMessage());
        }
        String ips = F.concat(U.allLocalIps(), ", ");
        String macs = F.concat(U.allLocalMACs(), ", ");
        if (this.log.isInfoEnabled()) {
            this.log.info("Non-loopback local IPs: " + (F.isEmpty(ips) ? "N/A" : ips));
            this.log.info("Enabled local MACs: " + (F.isEmpty(macs) ? "N/A" : macs));
        }
        if (ips.isEmpty() && macs.isEmpty()) {
            U.warn(this.log, "Ignite is starting on loopback address... Only nodes on the same physical computer can participate in topology.");
        }
        this.add("org.apache.ignite.ips", (Serializable)((Object)(ips.isEmpty() ? "" : ips)));
        Map<String, ?> userAttrs = this.configuration().getUserAttributes();
        if (userAttrs != null && userAttrs.get("override.org.apache.ignite.macs") != null) {
            this.add("org.apache.ignite.macs", (Serializable)userAttrs.get("override.org.apache.ignite.macs"));
        } else {
            this.add("org.apache.ignite.macs", (Serializable)((Object)(macs.isEmpty() ? "" : macs)));
        }
        this.add("org.apache.ignite.jit.name", (Serializable)((Object)(U.getCompilerMx() == null ? "" : U.getCompilerMx().getName())));
        this.add("org.apache.ignite.build.ver", (Serializable)((Object)IgniteVersionUtils.VER_STR));
        this.add("org.apache.ignite.build.date", (Serializable)((Object)IgniteVersionUtils.BUILD_TSTAMP_STR));
        this.add("org.apache.ignite.marshaller", (Serializable)((Object)this.cfg.getMarshaller().getClass().getName()));
        this.add("org.apache.ignite.marshaller.useDefaultSUID", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID", OptimizedMarshaller.USE_DFLT_SUID)));
        this.add("org.apache.ignite.cache.lateAffinity", Boolean.valueOf(this.cfg.isLateAffinityAssignment()));
        if (this.cfg.getMarshaller() instanceof BinaryMarshaller) {
            this.add("org.apache.ignite.marshaller.compactFooter", Boolean.valueOf(this.cfg.getBinaryConfiguration() == null ? true : this.cfg.getBinaryConfiguration().isCompactFooter()));
            this.add("org.apache.ignite.marshaller.utf8SerializationVer2", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2", BinaryUtils.USE_STR_SERIALIZATION_VER_2)));
        }
        this.add("org.apache.ignite.user.name", (Serializable)((Object)System.getProperty("user.name")));
        this.add("org.apache.ignite.ignite.name", (Serializable)((Object)this.igniteInstanceName));
        this.add("org.apache.ignite.peer.classloading.enabled", Boolean.valueOf(this.cfg.isPeerClassLoadingEnabled()));
        this.add("org.apache.ignite.ignite.dep.mode", (Serializable)((Object)this.cfg.getDeploymentMode()));
        this.add("org.apache.ignite.lang.rt", (Serializable)((Object)this.getLanguage()));
        this.add("org.apache.ignite.jvm.pid", Integer.valueOf(U.jvmPid()));
        this.add("org.apache.ignite.cache.client", this.cfg.isClientMode());
        this.add("org.apache.ignite.consistency.check.skipped", Boolean.valueOf(IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")));
        if (this.cfg.getConsistentId() != null) {
            this.add("org.apache.ignite.consistent.id", this.cfg.getConsistentId());
        }
        SB jvmArgs = new SB(512);
        for (String string : U.jvmArgs()) {
            if (string.startsWith("-")) {
                jvmArgs.a("@@@");
            } else {
                jvmArgs.a(' ');
            }
            jvmArgs.a(string);
        }
        this.add("org.apache.ignite.jvm.args", (Serializable)((Object)jvmArgs.toString()));
        if (this.isDaemon()) {
            this.add("org.apache.ignite.daemon", (Serializable)((Object)"true"));
        }
        if (this.isJmxRemoteEnabled() && (portStr = System.getProperty("com.sun.management.jmxremote.port")) != null) {
            try {
                this.add("org.apache.ignite.jmx.port", Integer.valueOf(Integer.parseInt(portStr)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.add("org.apache.ignite.restart.enabled", (Serializable)((Object)Boolean.toString(this.isRestartEnabled())));
        if (this.cfg.getConnectorConfiguration() != null) {
            this.add("org.apache.ignite.rest.port.range", Integer.valueOf(this.cfg.getConnectorConfiguration().getPortRange()));
        }
        this.add("org.apache.ignite.dynamic.cache.start.rollback.supported", Boolean.TRUE);
        this.addDataStorageConfigurationAttributes();
        this.add("org.apache.ignite.tx", this.cfg.getTransactionConfiguration());
        this.addSpiAttributes(this.cfg.getCollisionSpi());
        this.addSpiAttributes(this.cfg.getDiscoverySpi());
        this.addSpiAttributes(this.cfg.getFailoverSpi());
        this.addSpiAttributes(this.cfg.getCommunicationSpi());
        this.addSpiAttributes(this.cfg.getEventStorageSpi());
        this.addSpiAttributes(this.cfg.getCheckpointSpi());
        this.addSpiAttributes(this.cfg.getLoadBalancingSpi());
        this.addSpiAttributes(this.cfg.getDeploymentSpi());
        if (this.cfg.getUserAttributes() != null) {
            for (Map.Entry entry : this.cfg.getUserAttributes().entrySet()) {
                if (this.ctx.hasNodeAttribute((String)entry.getKey())) {
                    U.warn(this.log, "User or internal attribute has the same name as environment or system property and will take precedence: " + (String)entry.getKey());
                }
                this.ctx.addNodeAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addDataStorageConfigurationAttributes() throws IgniteCheckedException {
        MemoryConfiguration memCfg = this.cfg.getMemoryConfiguration();
        if (memCfg != null) {
            memCfg.setPageSize(this.cfg.getDataStorageConfiguration().getPageSize());
            this.add("org.apache.ignite.memory", memCfg);
        }
        this.add("org.apache.ignite.data.storage.config", (Serializable)new JdkMarshaller().marshal(this.cfg.getDataStorageConfiguration()));
    }

    private void addSpiAttributes(IgniteSpi ... spiList) throws IgniteCheckedException {
        for (IgniteSpi spi : spiList) {
            Class<?> spiCls = spi.getClass();
            this.add(U.spiAttribute(spi, "org.apache.ignite.spi.class"), (Serializable)((Object)spiCls.getName()));
        }
    }

    private void startManager(GridManager mgr) throws IgniteCheckedException {
        this.ctx.add(mgr);
        try {
            if (!this.skipDaemon(mgr)) {
                mgr.start();
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to start manager: " + mgr, e);
            throw new IgniteCheckedException("Failed to start manager: " + mgr, e);
        }
    }

    private void startProcessor(GridProcessor proc) throws IgniteCheckedException {
        this.ctx.add(proc);
        try {
            if (!this.skipDaemon(proc)) {
                proc.start();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to start processor: " + proc, e);
        }
    }

    private void addHelper(Object helper) {
        this.ctx.addHelper(helper);
    }

    private String onOff(boolean b) {
        return b ? "on" : "off";
    }

    private boolean isRestEnabled() {
        assert (this.cfg != null);
        return this.cfg.getConnectorConfiguration() != null && (!this.isClientNode() || this.isClientNode() && IgniteSystemProperties.getBoolean("IGNITE_REST_START_ON_CLIENT"));
    }

    private boolean isClientNode() {
        return this.cfg.isClientMode() != false || this.cfg.isDaemon();
    }

    private void ackRemoteManagement() {
        assert (this.log != null);
        if (!this.log.isInfoEnabled()) {
            return;
        }
        SB sb = new SB();
        sb.a("Remote Management [");
        boolean on = this.isJmxRemoteEnabled();
        sb.a("restart: ").a(this.onOff(this.isRestartEnabled())).a(", ");
        sb.a("REST: ").a(this.onOff(this.isRestEnabled())).a(", ");
        sb.a("JMX (");
        sb.a("remote: ").a(this.onOff(on));
        if (on) {
            sb.a(", ");
            sb.a("port: ").a(System.getProperty("com.sun.management.jmxremote.port", "<n/a>")).a(", ");
            sb.a("auth: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.authenticate"))).a(", ");
            sb.a("ssl: ").a(this.onOff(Boolean.getBoolean("com.sun.management.jmxremote.ssl") || System.getProperty("com.sun.management.jmxremote.ssl") == null));
        }
        sb.a(")");
        sb.a(']');
        this.log.info(sb.toString());
    }

    private void ackConfigUrl() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Config URL: " + System.getProperty("IGNITE_CONFIG_URL", "n/a"));
        }
    }

    private void ackConfiguration(IgniteConfiguration cfg) {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info(cfg.toString());
        }
    }

    private void ackLogger() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Logger: " + this.log.getLoggerInfo());
        }
    }

    private void ackAsciiLogo() {
        assert (this.log != null);
        if (System.getProperty("IGNITE_NO_ASCII") == null) {
            String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
            if (this.log.isInfoEnabled()) {
                this.log.info(NL + NL + ">>>    __________  ________________  " + NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/  " + NL + ">>>  _/ // (7 7    // /  / / / _/    " + NL + ">>> /___/\\___/_/|_/___/ /_/ /___/   " + NL + ">>> " + NL + ">>> " + ver + NL + ">>> " + "2019 Copyright(C) Apache Software Foundation" + NL + ">>> " + NL + ">>> Ignite documentation: http://" + SITE + NL);
            }
            if (this.log.isQuiet()) {
                U.quiet(false, "   __________  ________________ ", "  /  _/ ___/ |/ /  _/_  __/ __/ ", " _/ // (7 7    // /  / / / _/   ", "/___/\\___/_/|_/___/ /_/ /___/  ", "", ver, "2019 Copyright(C) Apache Software Foundation", "", "Ignite documentation: http://ignite.apache.org", "", "Quiet mode.");
                String fileName = this.log.fileName();
                if (fileName != null) {
                    U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
                }
                U.quiet(false, "  ^-- Logging by '" + this.log.getLoggerInfo() + '\'');
                U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite.{sh|bat}", "");
            }
        }
    }

    private void ackStart(RuntimeMXBean rtBean) {
        ClusterNode locNode = this.localNode();
        if (this.log.isQuiet()) {
            this.ackDataRegions(s -> {
                U.quiet(false, s);
                return null;
            });
            U.quiet(false, "");
            U.quiet(false, "Ignite node started OK (id=" + U.id8(locNode.id()) + (F.isEmpty(this.igniteInstanceName) ? "" : ", instance name=" + this.igniteInstanceName) + ')');
        }
        if (this.log.isInfoEnabled()) {
            this.ackDataRegions(s -> {
                this.log.info((String)s);
                return null;
            });
            String ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR;
            String dash = U.dash(ack.length());
            SB sb = new SB();
            for (GridPortRecord rec : this.ctx.ports().records()) {
                sb.a((Object)rec.protocol()).a(":").a(rec.port()).a(" ");
            }
            String str = NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + ">>> OS name: " + U.osString() + NL + ">>> CPU(s): " + locNode.metrics().getTotalCpus() + NL + ">>> Heap: " + U.heapSize(locNode, 2) + "GB" + NL + ">>> VM name: " + rtBean.getName() + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Local node [ID=" + locNode.id().toString().toUpperCase() + ", order=" + locNode.order() + ", clientMode=" + this.ctx.clientNode() + "]" + NL + ">>> Local node addresses: " + U.addressesAsString(locNode) + NL + ">>> Local ports: " + sb + NL;
            this.log.info(str);
        }
        if (!this.ctx.state().clusterState().active()) {
            U.quietAndInfo(this.log, ">>> Ignite cluster is not active (limited functionality available). Use control.(sh|bat) script or IgniteCluster interface to activate.");
        }
    }

    public void ackDataRegions(IgniteClosure<String, Void> clo) {
        DataStorageConfiguration memCfg = this.ctx.config().getDataStorageConfiguration();
        if (memCfg == null) {
            return;
        }
        clo.apply("Data Regions Configured:");
        clo.apply(this.dataRegionConfigurationMessage(memCfg.getDefaultDataRegionConfiguration()));
        DataRegionConfiguration[] dataRegions = memCfg.getDataRegionConfigurations();
        if (dataRegions != null) {
            for (DataRegionConfiguration dataRegion : dataRegions) {
                String msg = this.dataRegionConfigurationMessage(dataRegion);
                if (msg == null) continue;
                clo.apply(msg);
            }
        }
    }

    private String dataRegionConfigurationMessage(DataRegionConfiguration regCfg) {
        if (regCfg == null) {
            return null;
        }
        SB m = new SB();
        m.a("  ^-- ").a(regCfg.getName()).a(" [");
        m.a("initSize=").a(U.readableSize(regCfg.getInitialSize(), false));
        m.a(", maxSize=").a(U.readableSize(regCfg.getMaxSize(), false));
        m.a(", persistence=" + regCfg.isPersistenceEnabled()).a(']');
        return m.toString();
    }

    private void ackOsInfo() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "OS: " + U.osString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("OS: " + U.osString());
            this.log.info("OS user: " + System.getProperty("user.name"));
            int jvmPid = U.jvmPid();
            this.log.info("PID: " + (jvmPid == -1 ? "N/A" : Integer.valueOf(jvmPid)));
        }
    }

    private void ackLanguageRuntime() {
        assert (this.log != null);
        if (this.log.isQuiet()) {
            U.quiet(false, "VM information: " + U.jdkString());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Language runtime: " + this.getLanguage());
            this.log.info("VM information: " + U.jdkString());
            this.log.info("VM total memory: " + U.heapSize(2) + "GB");
        }
    }

    private void ackNodeMetrics(DecimalFormat dblFmt, ExecutorService execSvc, ExecutorService sysExecSvc, Map<String, ? extends ExecutorService> customExecSvcs) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        try {
            ClusterMetrics m = this.cluster().localNode().metrics();
            int MByte = 0x100000;
            double cpuLoadPct = m.getCurrentCpuLoad() * 100.0;
            double avgCpuLoadPct = m.getAverageCpuLoad() * 100.0;
            double gcPct = m.getCurrentGcCpuLoad() * 100.0;
            long heapUsed = m.getHeapMemoryUsed();
            long heapMax = m.getHeapMemoryMaximum();
            long heapUsedInMBytes = heapUsed / 0x100000L;
            long heapCommInMBytes = m.getHeapMemoryCommitted() / 0x100000L;
            double freeHeapPct = heapMax > 0L ? (double)((heapMax - heapUsed) * 100L) / (double)heapMax : -1.0;
            int hosts = 0;
            int nodes = 0;
            int cpus = 0;
            try {
                ClusterMetrics metrics = this.cluster().metrics();
                Collection<ClusterNode> nodes0 = this.cluster().nodes();
                hosts = U.neighborhood(nodes0).size();
                nodes = metrics.getTotalNodes();
                cpus = metrics.getTotalCpus();
            }
            catch (IgniteException metrics) {
                // empty catch block
            }
            int loadedPages = 0;
            Collection<DataRegion> regions = this.ctx.cache().context().database().dataRegions();
            StringBuilder dataRegionsInfo = new StringBuilder();
            StringBuilder pdsRegionsInfo = new StringBuilder();
            long offHeapUsedSummary = 0L;
            long offHeapMaxSummary = 0L;
            long offHeapCommSummary = 0L;
            long pdsUsedSummary = 0L;
            boolean persistenceDisabled = true;
            if (!F.isEmpty(regions)) {
                for (DataRegion region : regions) {
                    long pagesCnt = region.pageMemory().loadedPages();
                    long offHeapUsed = (long)region.pageMemory().systemPageSize() * pagesCnt;
                    long offHeapMax = region.config().getMaxSize();
                    long offHeapComm = region.memoryMetrics().getOffHeapSize();
                    long offHeapUsedInMBytes = offHeapUsed / 0x100000L;
                    long offHeapCommInMBytes = offHeapComm / 0x100000L;
                    double freeOffHeapPct = offHeapMax > 0L ? (double)((offHeapMax - offHeapUsed) * 100L) / (double)offHeapMax : -1.0;
                    offHeapUsedSummary += offHeapUsed;
                    offHeapMaxSummary += offHeapMax;
                    offHeapCommSummary += offHeapComm;
                    loadedPages = (int)((long)loadedPages + pagesCnt);
                    dataRegionsInfo.append("    ^--   ").append(region.config().getName()).append(" region").append(" [used=").append(dblFmt.format(offHeapUsedInMBytes)).append("MB, free=").append(dblFmt.format(freeOffHeapPct)).append("%, comm=").append(dblFmt.format(offHeapCommInMBytes)).append("MB]").append(NL);
                    if (!region.config().isPersistenceEnabled()) continue;
                    long pdsUsed = region.memoryMetrics().getTotalAllocatedSize();
                    long pdsUsedMBytes = pdsUsed / 0x100000L;
                    pdsUsedSummary += pdsUsed;
                    boolean metastore = "metastoreMemPlc".equals(region.config().getName());
                    String pdsUsedSize = metastore ? "unknown" : dblFmt.format(pdsUsedMBytes) + "MB";
                    pdsRegionsInfo.append("    ^--   ").append(region.config().getName()).append(" region").append(" [used=").append(pdsUsedSize).append("]").append(NL);
                    persistenceDisabled = false;
                }
            }
            long offHeapUsedInMBytes = offHeapUsedSummary / 0x100000L;
            long offHeapCommInMBytes = offHeapCommSummary / 0x100000L;
            long pdsUsedMBytes = pdsUsedSummary / 0x100000L;
            double freeOffHeapPct = offHeapMaxSummary > 0L ? (double)((offHeapMaxSummary - offHeapUsedSummary) * 100L) / (double)offHeapMaxSummary : -1.0;
            String pdsInfo = persistenceDisabled ? "" : "    ^-- Ignite persistence [used=" + dblFmt.format(pdsUsedMBytes) + "MB]" + NL + pdsRegionsInfo;
            String id = U.id8(this.localNode().id());
            String msg = NL + "Metrics for local node (to disable set 'metricsLogFrequency' to 0)" + NL + "    ^-- Node [id=" + id + (this.name() != null ? ", name=" + this.name() : "") + ", uptime=" + this.getUpTimeFormatted() + "]" + NL + "    ^-- H/N/C [hosts=" + hosts + ", nodes=" + nodes + ", CPUs=" + cpus + "]" + NL + "    ^-- CPU [cur=" + dblFmt.format(cpuLoadPct) + "%, avg=" + dblFmt.format(avgCpuLoadPct) + "%, GC=" + dblFmt.format(gcPct) + "%]" + NL + "    ^-- PageMemory [pages=" + loadedPages + "]" + NL + "    ^-- Heap [used=" + dblFmt.format(heapUsedInMBytes) + "MB, free=" + dblFmt.format(freeHeapPct) + "%, comm=" + dblFmt.format(heapCommInMBytes) + "MB]" + NL + "    ^-- Off-heap [used=" + dblFmt.format(offHeapUsedInMBytes) + "MB, free=" + dblFmt.format(freeOffHeapPct) + "%, comm=" + dblFmt.format(offHeapCommInMBytes) + "MB]" + NL + dataRegionsInfo + pdsInfo + "    ^-- Outbound messages queue [size=" + m.getOutboundMessagesQueueSize() + "]" + NL + "    ^-- " + this.createExecutorDescription("Public thread pool", execSvc) + NL + "    ^-- " + this.createExecutorDescription("System thread pool", sysExecSvc);
            if (customExecSvcs != null) {
                StringBuilder customSvcsMsg = new StringBuilder();
                for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                    customSvcsMsg.append(NL).append("    ^-- ").append(this.createExecutorDescription(entry.getKey(), entry.getValue()));
                }
                msg = msg + customSvcsMsg;
            }
            this.log.info(msg);
            this.ctx.cache().context().database().dumpStatistics(this.log);
        }
        catch (IgniteClientDisconnectedException igniteClientDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLanguage() {
        boolean scala = false;
        boolean groovy = false;
        boolean clojure = false;
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            String s = elem.getClassName().toLowerCase();
            if (s.contains("scala")) {
                scala = true;
                break;
            }
            if (s.contains("groovy")) {
                groovy = true;
                break;
            }
            if (!s.contains("clojure")) continue;
            clojure = true;
            break;
        }
        if (scala) {
            try (InputStream in = this.getClass().getResourceAsStream("/library.properties");){
                Properties props = new Properties();
                if (in != null) {
                    props.load(in);
                }
                String string = "Scala ver. " + props.getProperty("version.number", "<unknown>");
                return string;
            }
            catch (Exception ignore) {
                return "Scala ver. <unknown>";
            }
        }
        if (groovy) {
            return "Groovy";
        }
        if (clojure) {
            return "Clojure";
        }
        String string = U.jdkName() + " ver. " + U.jdkVersion();
        return string;
    }

    public void stop(boolean cancel) {
        boolean interrupted = Thread.interrupted();
        try {
            this.stop0(cancel);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isStopping() {
        return this.stopGuard.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0(boolean cancel) {
        this.gw.compareAndSet(null, new GridKernalGatewayImpl(this.igniteInstanceName));
        GridKernalGateway gw = this.gw.get();
        if (this.stopGuard.compareAndSet(false, true)) {
            boolean firstStop = false;
            GridKernalState state = gw.getState();
            if (state == GridKernalState.STARTED || state == GridKernalState.DISCONNECTED) {
                firstStop = true;
            } else if (state == GridKernalState.STARTING) {
                U.warn(this.log, "Attempt to stop starting grid. This operation cannot be guaranteed to be successful.");
            }
            if (firstStop) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying lifecycle beans.");
                }
                this.notifyLifecycleBeansEx(LifecycleEventType.BEFORE_NODE_STOP);
            }
            List<GridComponent> comps = this.ctx.components();
            ListIterator<GridComponent> it = comps.listIterator(comps.size());
            while (it.hasPrevious()) {
                GridComponent comp = it.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.onKernalStop(cancel);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to pre-stop processor: " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw e;
                }
            }
            if (this.ctx.hadoopHelper() != null) {
                this.ctx.hadoopHelper().close();
            }
            if (this.starveTask != null) {
                this.starveTask.close();
            }
            if (this.metricsLogTask != null) {
                this.metricsLogTask.close();
            }
            if (this.longOpDumpTask != null) {
                this.longOpDumpTask.close();
            }
            if (this.longJVMPauseDetector != null) {
                this.longJVMPauseDetector.stop();
            }
            boolean interrupted = false;
            while (true) {
                try {
                    while (!gw.tryWriteLock(10L)) {
                    }
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            try {
                assert (gw.getState() == GridKernalState.STARTED || gw.getState() == GridKernalState.STARTING || gw.getState() == GridKernalState.DISCONNECTED);
                gw.setState(GridKernalState.STOPPING);
                this.ctx.cluster().get().clearNodeMap();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid " + (this.igniteInstanceName == null ? "" : '\'' + this.igniteInstanceName + "' ") + "is stopping.");
                }
            }
            finally {
                gw.writeUnlock();
            }
            GridCacheProcessor cache = this.ctx.cache();
            if (cache != null) {
                cache.blockGateways();
            }
            if (!this.mBeansMgr.unregisterAllMBeans()) {
                this.errOnStop = true;
            }
            ListIterator<GridComponent> it2 = comps.listIterator(comps.size());
            while (it2.hasPrevious()) {
                GridComponent comp = it2.previous();
                try {
                    if (this.skipDaemon(comp)) continue;
                    comp.stop(cancel);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Component stopped: " + comp);
                }
                catch (Throwable e) {
                    this.errOnStop = true;
                    U.error(this.log, "Failed to stop component (ignoring): " + comp, e);
                    if (!(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
            U.stopLifecycleAware(this.log, this.lifecycleAwares(this.cfg));
            this.notifyLifecycleBeansEx(LifecycleEventType.AFTER_NODE_STOP);
            U.clearClassCache();
            MarshallerExclusions.clearCache();
            BinaryEnumCache.clear();
            gw.writeLock();
            try {
                gw.setState(GridKernalState.STOPPED);
            }
            finally {
                gw.writeUnlock();
            }
            if (this.log.isQuiet()) {
                String nodeName;
                String string = nodeName = this.igniteInstanceName == null ? "" : "name=" + this.igniteInstanceName + ", ";
                if (!this.errOnStop) {
                    U.quiet(false, "Ignite node stopped OK [" + nodeName + "uptime=" + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + ']');
                } else {
                    U.quiet(true, "Ignite node stopped wih ERRORS [" + nodeName + "uptime=" + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + ']');
                }
            }
            if (this.log.isInfoEnabled()) {
                String dash;
                String ack;
                if (!this.errOnStop) {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped OK";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + dash + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Grid uptime: " + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + NL + NL);
                } else {
                    ack = "Ignite ver. " + IgniteVersionUtils.VER_STR + '#' + IgniteVersionUtils.BUILD_TSTAMP_STR + "-sha1:" + IgniteVersionUtils.REV_HASH_STR + " stopped with ERRORS";
                    dash = U.dash(ack.length());
                    this.log.info(NL + NL + ">>> " + ack + NL + ">>> " + dash + NL + (this.igniteInstanceName == null ? "" : ">>> Ignite instance name: " + this.igniteInstanceName + NL) + ">>> Grid uptime: " + X.timeSpan2DHMSM(U.currentTimeMillis() - this.startTime) + NL + ">>> See log above for detailed error message." + NL + ">>> Note that some errors during stop can prevent grid from" + NL + ">>> maintaining correct topology since this node may have" + NL + ">>> not exited grid properly." + NL + NL);
                }
            }
            try {
                U.onGridStop();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        } else if (this.log.isDebugEnabled()) {
            if (gw.getState() == GridKernalState.STOPPED) {
                this.log.debug("Grid is already stopped. Nothing to do.");
            } else {
                this.log.debug("Grid is being stopped by another thread. Aborting this stop sequence allowing other thread to finish.");
            }
        }
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(String name) {
        CU.validateCacheName(name);
        this.checkClusterState();
        return this.ctx.cache().internalCache(name);
    }

    @Override
    public GridKernalContext context() {
        return this.ctx;
    }

    private void ackSystemProperties() {
        assert (this.log != null);
        if (this.log.isDebugEnabled() && S.INCLUDE_SENSITIVE) {
            for (Map.Entry<Object, Object> entry : IgniteSystemProperties.snapshot().entrySet()) {
                this.log.debug("System property [" + entry.getKey() + '=' + entry.getValue() + ']');
            }
        }
    }

    private void logNodeUserAttributes() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            for (Map.Entry<String, ?> attr : this.cfg.getUserAttributes().entrySet()) {
                this.log.info("Local node user attribute [" + attr.getKey() + '=' + attr.getValue() + ']');
            }
        }
    }

    private void ackEnvironmentVariables() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            for (Map.Entry<String, String> envVar : System.getenv().entrySet()) {
                this.log.debug("Environment variable [" + envVar.getKey() + '=' + envVar.getValue() + ']');
            }
        }
    }

    private void ackDaemon() {
        assert (this.log != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Daemon mode: " + (this.isDaemon() ? "on" : "off"));
        }
    }

    private boolean isDaemon() {
        assert (this.cfg != null);
        return this.cfg.isDaemon() || IgniteSystemProperties.getBoolean("IGNITE_DAEMON");
    }

    @Override
    public boolean isJmxRemoteEnabled() {
        return System.getProperty("com.sun.management.jmxremote") != null;
    }

    @Override
    public boolean isRestartEnabled() {
        return System.getProperty("IGNITE_SUCCESS_FILE") != null;
    }

    private void ackSpis() {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("+-------------+");
            this.log.debug("START SPI LIST:");
            this.log.debug("+-------------+");
            this.log.debug("Grid checkpoint SPI     : " + Arrays.toString(this.cfg.getCheckpointSpi()));
            this.log.debug("Grid collision SPI      : " + this.cfg.getCollisionSpi());
            this.log.debug("Grid communication SPI  : " + this.cfg.getCommunicationSpi());
            this.log.debug("Grid deployment SPI     : " + this.cfg.getDeploymentSpi());
            this.log.debug("Grid discovery SPI      : " + this.cfg.getDiscoverySpi());
            this.log.debug("Grid event storage SPI  : " + this.cfg.getEventStorageSpi());
            this.log.debug("Grid failover SPI       : " + Arrays.toString(this.cfg.getFailoverSpi()));
            this.log.debug("Grid load balancing SPI : " + Arrays.toString(this.cfg.getLoadBalancingSpi()));
        }
    }

    private void ackRebalanceConfiguration() throws IgniteCheckedException {
        if (this.cfg.getSystemThreadPoolSize() <= this.cfg.getRebalanceThreadPoolSize()) {
            throw new IgniteCheckedException("Rebalance thread pool size exceed or equals System thread pool size. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
        }
        if (this.cfg.getRebalanceThreadPoolSize() < 1) {
            throw new IgniteCheckedException("Rebalance thread pool size minimal allowed value is 1. Change IgniteConfiguration.rebalanceThreadPoolSize property before next start.");
        }
        for (CacheConfiguration ccfg : this.cfg.getCacheConfiguration()) {
            if (ccfg.getRebalanceBatchesPrefetchCount() >= 1L) continue;
            throw new IgniteCheckedException("Rebalance batches prefetch count minimal allowed value is 1. Change CacheConfiguration.rebalanceBatchesPrefetchCount property before next start. [cache=" + ccfg.getName() + "]");
        }
    }

    private void ackMemoryConfiguration() {
        DataStorageConfiguration memCfg = this.cfg.getDataStorageConfiguration();
        if (memCfg == null) {
            return;
        }
        U.log(this.log, "System cache's DataRegion size is configured to " + memCfg.getSystemRegionInitialSize() / 0x100000L + " MB. Use DataStorageConfiguration.systemRegionInitialSize property to change the setting.");
    }

    private void ackCacheConfiguration() {
        CacheConfiguration[] cacheCfgs = this.cfg.getCacheConfiguration();
        if (cacheCfgs == null || cacheCfgs.length == 0) {
            U.warn(this.log, "Cache is not configured - in-memory data grid is off.");
        } else {
            SB sb = new SB();
            HashMap memPlcNamesMapping = new HashMap();
            for (CacheConfiguration c : cacheCfgs) {
                String cacheName = U.maskName(c.getName());
                String memPlcName = c.getDataRegionName();
                if (CU.isSystemCache(cacheName)) {
                    memPlcName = "sysMemPlc";
                } else if (memPlcName == null && this.cfg.getDataStorageConfiguration() != null) {
                    memPlcName = this.cfg.getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
                }
                if (!memPlcNamesMapping.containsKey(memPlcName)) {
                    memPlcNamesMapping.put(memPlcName, new ArrayList());
                }
                ArrayList cacheNames = (ArrayList)memPlcNamesMapping.get(memPlcName);
                cacheNames.add(cacheName);
            }
            for (Map.Entry entry : memPlcNamesMapping.entrySet()) {
                sb.a("in '").a((String)entry.getKey()).a("' dataRegion: [");
                for (String s : (ArrayList)entry.getValue()) {
                    sb.a("'").a(s).a("', ");
                }
                sb.d(sb.length() - 2, sb.length()).a("], ");
            }
            U.log(this.log, "Configured caches [" + sb.d(sb.length() - 2, sb.length()).toString() + ']');
        }
    }

    private void ackP2pConfiguration() {
        assert (this.cfg != null);
        if (this.cfg.isPeerClassLoadingEnabled()) {
            U.warn(this.log, "Peer class loading is enabled (disable it in production for performance and deployment consistency reasons)");
        }
    }

    private void ackSecurity() {
        assert (this.log != null);
        U.quietAndInfo(this.log, "Security status [authentication=" + this.onOff(this.ctx.security().enabled()) + ", tls/ssl=" + this.onOff(this.ctx.config().getSslContextFactory() != null) + ']');
    }

    private void ackVmArguments(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isInfoEnabled() && S.INCLUDE_SENSITIVE) {
            this.log.info("IGNITE_HOME=" + this.cfg.getIgniteHome());
            this.log.info("VM arguments: " + rtBean.getInputArguments());
        }
    }

    private void ackClassPaths(RuntimeMXBean rtBean) {
        assert (this.log != null);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug("Boot class path: " + rtBean.getBootClassPath());
                this.log.debug("Class path: " + rtBean.getClassPath());
                this.log.debug("Library path: " + rtBean.getLibraryPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ackIPv4StackFlagIsSet() {
        boolean preferIPv4 = Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack"));
        if (!preferIPv4) {
            assert (this.log != null);
            U.quietAndWarn(this.log, "Please set system property '-Djava.net.preferIPv4Stack=true' to avoid possible problems in mixed environments.");
        }
    }

    private Iterable<Object> lifecycleAwares(IgniteConfiguration cfg) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (cfg.getLifecycleBeans() != null) {
            Collections.addAll(objs, cfg.getLifecycleBeans());
        }
        if (cfg.getSegmentationResolvers() != null) {
            Collections.addAll(objs, cfg.getSegmentationResolvers());
        }
        if (cfg.getConnectorConfiguration() != null) {
            objs.add(cfg.getConnectorConfiguration().getMessageInterceptor());
            objs.add(cfg.getConnectorConfiguration().getSslContextFactory());
        }
        objs.add(cfg.getMarshaller());
        objs.add(cfg.getGridLogger());
        objs.add(cfg.getMBeanServer());
        if (cfg.getCommunicationFailureResolver() != null) {
            objs.add(cfg.getCommunicationFailureResolver());
        }
        return objs;
    }

    @Override
    public IgniteConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public IgniteLogger log() {
        return this.cfg.getGridLogger();
    }

    @Override
    public boolean removeCheckpoint(String key) {
        A.notNull(key, "key");
        this.guard();
        try {
            this.checkClusterState();
            boolean bl = this.ctx.checkpoint().removeCheckpoint(key);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean pingNode(String nodeId) {
        A.notNull(nodeId, "nodeId");
        return this.cluster().pingNode(UUID.fromString(nodeId));
    }

    @Override
    public void undeployTaskFromGrid(String taskName) throws JMException {
        A.notNull(taskName, "taskName");
        try {
            this.compute().undeployTask(taskName);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public String executeTask(String taskName, String arg) throws JMException {
        try {
            return (String)this.compute().execute(taskName, arg);
        }
        catch (IgniteException e) {
            throw U.jmException(e);
        }
    }

    @Override
    public boolean pingNodeByAddress(String host) {
        this.guard();
        try {
            for (ClusterNode n : this.cluster().nodes()) {
                if (!n.addresses().contains(host)) continue;
                boolean bl = this.ctx.discovery().pingNode(n.id());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean eventUserRecordable(int type) {
        this.guard();
        try {
            boolean bl = this.ctx.event().isUserRecordable(type);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public boolean allEventsUserRecordable(int[] types) {
        A.notNull(types, "types");
        this.guard();
        try {
            boolean bl = this.ctx.event().isAllUserRecordable(types);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteTransactions transactions() {
        this.guard();
        try {
            this.checkClusterState();
            IgniteTransactionsEx igniteTransactionsEx = this.ctx.cache().transactions();
            return igniteTransactionsEx;
        }
        finally {
            this.unguard();
        }
    }

    public <K, V> IgniteInternalCache<K, V> getCache(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().publicCache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> cache(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(name, false, true);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg.getName());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), null, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        CU.validateConfigurationCacheNames(cacheCfgs);
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCaches(cacheCfgs, true, true, false).get();
            ArrayList createdCaches = new ArrayList(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(String cacheName) {
        CU.validateNewCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().createFromTemplate(cacheName).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        return this.getOrCreateCache0(cacheCfg, false).get1();
    }

    @Override
    public <K, V> IgniteBiTuple<IgniteCache<K, V>, Boolean> getOrCreateCache0(CacheConfiguration<K, V> cacheCfg, boolean sql) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg.getName());
        this.guard();
        try {
            this.checkClusterState();
            Boolean res = false;
            if (this.ctx.cache().cache(cacheCfg.getName()) == null) {
                res = sql ? this.ctx.cache().dynamicStartSqlCache(cacheCfg).get() : this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), null, false, true, true).get();
            }
            IgniteBiTuple<IgniteCache<K, V>, Boolean> igniteBiTuple = new IgniteBiTuple<IgniteCache<K, V>, Boolean>(this.ctx.cache().publicJCache(cacheCfg.getName()), res);
            return igniteBiTuple;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) {
        A.notNull(cacheCfgs, "cacheCfgs");
        CU.validateConfigurationCacheNames(cacheCfgs);
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCaches(cacheCfgs, false, true, false).get();
            ArrayList createdCaches = new ArrayList(cacheCfgs.size());
            for (CacheConfiguration cacheCfg : cacheCfgs) {
                createdCaches.add(this.ctx.cache().publicJCache(cacheCfg.getName()));
            }
            ArrayList arrayList = createdCaches;
            return arrayList;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg.getName());
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, true, true, true).get();
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg.getName());
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache cache = this.ctx.cache().cache(cacheCfg.getName());
            if (cache == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            } else if (cache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(cacheCfg, cacheCfg.getName(), nearCfg, false, true, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheCfg.getName());
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        CU.validateNewCacheName(cacheName);
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, true, true, true).get();
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        CU.validateNewCacheName(cacheName);
        A.notNull(nearCfg, "nearCfg");
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache internalCache = this.ctx.cache().cache(cacheName);
            if (internalCache == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            } else if (internalCache.configuration().getNearConfiguration() == null) {
                this.ctx.cache().dynamicStartCache(null, cacheName, nearCfg, false, true, true).get();
            }
            IgniteCacheProxy cache = this.ctx.cache().publicJCache(cacheName);
            this.checkNearCacheStarted(cache);
            IgniteCacheProxy igniteCacheProxy = cache;
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void checkNearCacheStarted(IgniteCacheProxy<?, ?> cache) throws IgniteCheckedException {
        if (!cache.context().isNear()) {
            throw new IgniteCheckedException("Failed to start near cache (a cache with the same name without near cache is already started)");
        }
    }

    @Override
    public void destroyCache(String cacheName) {
        this.destroyCache0(cacheName, false);
    }

    @Override
    public boolean destroyCache0(String cacheName, boolean sql) throws CacheException {
        CU.validateCacheName(cacheName);
        IgniteInternalFuture<Boolean> stopFut = this.destroyCacheAsync(cacheName, sql, true);
        try {
            return stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    @Override
    public void destroyCaches(Collection<String> cacheNames) {
        CU.validateCacheNames(cacheNames);
        IgniteInternalFuture<?> stopFut = this.destroyCachesAsync(cacheNames, true);
        try {
            stopFut.get();
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Boolean> destroyCacheAsync(String cacheName, boolean sql, boolean checkThreadTx) {
        CU.validateCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.ctx.cache().dynamicDestroyCache(cacheName, sql, checkThreadTx, false);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> destroyCachesAsync(Collection<String> cacheNames, boolean checkThreadTx) {
        CU.validateCacheNames(cacheNames);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().dynamicDestroyCaches(cacheNames, checkThreadTx, false);
            return igniteInternalFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) {
        CU.validateNewCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            if (this.ctx.cache().cache(cacheName) == null) {
                this.ctx.cache().getOrCreateFromTemplate(cacheName, true).get();
            }
            IgniteCacheProxy igniteCacheProxy = this.ctx.cache().publicJCache(cacheName);
            return igniteCacheProxy;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> getOrCreateCacheAsync(String cacheName, String templateName, CacheConfigurationOverride cfgOverride, boolean checkThreadTx) {
        CU.validateNewCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            if (this.ctx.cache().cache(cacheName) == null) {
                IgniteInternalFuture<?> igniteInternalFuture = this.ctx.cache().getOrCreateFromTemplate(cacheName, templateName, cfgOverride, checkThreadTx);
                return igniteInternalFuture;
            }
            GridFinishedFuture gridFinishedFuture = new GridFinishedFuture();
            return gridFinishedFuture;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) {
        A.notNull(cacheCfg, "cacheCfg");
        CU.validateNewCacheName(cacheCfg.getName());
        this.guard();
        try {
            this.checkClusterState();
            this.ctx.cache().addCacheConfiguration(cacheCfg);
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
        finally {
            this.unguard();
        }
    }

    public Collection<IgniteCacheProxy<?, ?>> caches() {
        this.guard();
        try {
            this.checkClusterState();
            Collection<IgniteCacheProxy<?, ?>> collection = this.ctx.cache().publicCaches();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<String> cacheNames() {
        this.guard();
        try {
            this.checkClusterState();
            Collection<String> collection = this.ctx.cache().publicCacheNames();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K extends GridCacheUtilityKey, V> IgniteInternalCache<K, V> utilityCache() {
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().utilityCache();
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteInternalCache<K, V> cachex(String name) {
        CU.validateCacheName(name);
        this.guard();
        try {
            this.checkClusterState();
            IgniteInternalCache igniteInternalCache = this.ctx.cache().cache(name);
            return igniteInternalCache;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteInternalCache<?, ?>> cachesx(IgnitePredicate<? super IgniteInternalCache<?, ?>>[] p) {
        this.guard();
        try {
            this.checkClusterState();
            Collection<IgniteInternalCache<?, ?>> collection = F.retain(this.ctx.cache().caches(), true, p);
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <K, V> IgniteDataStreamer<K, V> dataStreamer(String cacheName) {
        CU.validateCacheName(cacheName);
        this.guard();
        try {
            this.checkClusterState();
            DataStreamerImpl dataStreamerImpl = this.ctx.dataStream().dataStreamer(cacheName);
            return dataStreamerImpl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFileSystem fileSystem(String name) {
        if (name == null) {
            throw new IllegalArgumentException("IGFS name cannot be null");
        }
        this.guard();
        try {
            this.checkClusterState();
            IgniteFileSystem fs = this.ctx.igfs().igfs(name);
            if (fs == null) {
                throw new IllegalArgumentException("IGFS is not configured: " + name);
            }
            IgniteFileSystem igniteFileSystem = fs;
            return igniteFileSystem;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteFileSystem igfsx(String name) {
        if (name == null) {
            throw new IllegalArgumentException("IGFS name cannot be null");
        }
        this.guard();
        try {
            this.checkClusterState();
            IgniteFileSystem igniteFileSystem = this.ctx.igfs().igfs(name);
            return igniteFileSystem;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<IgniteFileSystem> fileSystems() {
        this.guard();
        try {
            this.checkClusterState();
            Collection<IgniteFileSystem> collection = this.ctx.igfs().igfss();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Hadoop hadoop() {
        this.guard();
        try {
            this.checkClusterState();
            Hadoop hadoop = this.ctx.hadoop().hadoop();
            return hadoop;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        this.guard();
        try {
            this.checkClusterState();
            Object t = this.ctx.pluginProvider(name).plugin();
            return t;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public IgniteBinary binary() {
        this.checkClusterState();
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        return objProc.binary();
    }

    @Override
    public IgniteProductVersion version() {
        return IgniteVersionUtils.VER;
    }

    @Override
    public String latestVersion() {
        this.ctx.gateway().readLock();
        try {
            String string = this.ctx.cluster().latestVersion();
            return string;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public IgniteScheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void close() throws IgniteException {
        Ignition.stop(this.igniteInstanceName, true);
    }

    @Override
    public <K> Affinity<K> affinity(String cacheName) {
        CU.validateCacheName(cacheName);
        this.checkClusterState();
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache != null) {
            return cache.affinity();
        }
        return this.ctx.affinity().affinityProxy(cacheName);
    }

    @Override
    public boolean active() {
        this.guard();
        try {
            boolean bl = this.context().state().publicApiActiveState(true);
            return bl;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public void active(boolean active) {
        this.cluster().active(active);
    }

    private Collection<BaselineNode> baselineNodes() {
        Collection<ClusterNode> srvNodes = this.cluster().forServers().nodes();
        ArrayList<BaselineNode> baselineNodes = new ArrayList<BaselineNode>(srvNodes.size());
        for (ClusterNode clN : srvNodes) {
            baselineNodes.add(clN);
        }
        return baselineNodes;
    }

    @Override
    public void resetLostPartitions(Collection<String> cacheNames) {
        CU.validateCacheNames(cacheNames);
        this.guard();
        try {
            this.ctx.cache().resetCacheState(cacheNames).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<DataRegionMetrics> dataRegionMetrics() {
        this.guard();
        try {
            Collection<DataRegionMetrics> collection = this.ctx.cache().context().database().memoryMetrics();
            return collection;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public DataRegionMetrics dataRegionMetrics(String memPlcName) {
        this.guard();
        try {
            DataRegionMetrics dataRegionMetrics = this.ctx.cache().context().database().memoryMetrics(memPlcName);
            return dataRegionMetrics;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public DataStorageMetrics dataStorageMetrics() {
        this.guard();
        try {
            DataStorageMetrics dataStorageMetrics = this.ctx.cache().context().database().persistentStoreMetrics();
            return dataStorageMetrics;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public Collection<MemoryMetrics> memoryMetrics() {
        return DataRegionMetricsAdapter.collectionOf(this.dataRegionMetrics());
    }

    @Override
    @Nullable
    public MemoryMetrics memoryMetrics(String memPlcName) {
        return DataRegionMetricsAdapter.valueOf(this.dataRegionMetrics(memPlcName));
    }

    @Override
    public PersistenceMetrics persistentStoreMetrics() {
        return DataStorageMetricsAdapter.valueOf(this.dataStorageMetrics());
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) {
        return this.atomicSequence(name, null, initVal, create);
    }

    @Override
    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicSequence igniteAtomicSequence = this.ctx.dataStructures().sequence(name, cfg, initVal, create);
            return igniteAtomicSequence;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) {
        return this.atomicLong(name, null, initVal, create);
    }

    @Override
    @Nullable
    public IgniteAtomicLong atomicLong(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicLong igniteAtomicLong = this.ctx.dataStructures().atomicLong(name, cfg, initVal, create);
            return igniteAtomicLong;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) {
        return this.atomicReference(name, null, initVal, create);
    }

    @Override
    public <T> IgniteAtomicReference<T> atomicReference(String name, AtomicConfiguration cfg, @Nullable T initVal, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicReference<T> igniteAtomicReference = this.ctx.dataStructures().atomicReference(name, cfg, initVal, create);
            return igniteAtomicReference;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) {
        return this.atomicStamped(name, null, initVal, initStamp, create);
    }

    @Override
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, AtomicConfiguration cfg, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        this.guard();
        try {
            this.checkClusterState();
            IgniteAtomicStamped<T, S> igniteAtomicStamped = this.ctx.dataStructures().atomicStamped(name, cfg, initVal, initStamp, create);
            return igniteAtomicStamped;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteCountDownLatch igniteCountDownLatch = this.ctx.dataStructures().countDownLatch(name, null, cnt, autoDel, create);
            return igniteCountDownLatch;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteSemaphore igniteSemaphore = this.ctx.dataStructures().semaphore(name, null, cnt, failoverSafe, create);
            return igniteSemaphore;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteLock igniteLock = this.ctx.dataStructures().reentrantLock(name, null, failoverSafe, fair, create);
            return igniteLock;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteQueue<T> queue(String name, int cap, CollectionConfiguration cfg) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteQueue igniteQueue = this.ctx.dataStructures().queue(name, null, cap, cfg);
            return igniteQueue;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    @Override
    @Nullable
    public <T> IgniteSet<T> set(String name, CollectionConfiguration cfg) {
        this.guard();
        try {
            this.checkClusterState();
            IgniteSet igniteSet = this.ctx.dataStructures().set(name, null, cfg);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        assert (this.ctx != null);
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        assert (this.ctx != null);
        this.ctx.gateway().readUnlock();
    }

    private void checkClusterState() throws IgniteException {
        if (!this.ctx.state().publicApiActiveState(true)) {
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    public void onDisconnected() {
        IgniteFutureImpl userFut;
        Throwable err = null;
        this.reconnectState.waitPreviousReconnect();
        GridFutureAdapter<?> reconnectFut = this.ctx.gateway().onDisconnected();
        if (reconnectFut == null) {
            assert (this.ctx.gateway().getState() != GridKernalState.STARTED) : this.ctx.gateway().getState();
            return;
        }
        IgniteFutureImpl curFut = (IgniteFutureImpl)this.ctx.cluster().get().clientReconnectFuture();
        if (curFut != null && curFut.internalFuture() == reconnectFut) {
            userFut = curFut;
        } else {
            userFut = new IgniteFutureImpl(reconnectFut);
            this.ctx.cluster().get().clientReconnectFuture(userFut);
        }
        this.ctx.disconnected(true);
        List<GridComponent> comps = this.ctx.components();
        ListIterator<GridComponent> it = comps.listIterator(comps.size());
        while (it.hasPrevious()) {
            GridComponent comp = it.previous();
            try {
                if (this.skipDaemon(comp)) continue;
                comp.onDisconnected(userFut);
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) continue;
                throw e;
            }
        }
        for (GridCacheContext cctx : this.ctx.cache().context().cacheContexts()) {
            cctx.gate().writeLock();
            cctx.gate().writeUnlock();
        }
        this.ctx.gateway().writeLock();
        this.ctx.gateway().writeUnlock();
        if (err != null) {
            reconnectFut.onDone(err);
            U.error(this.log, "Failed to reconnect, will stop node", err);
            this.close();
        }
    }

    public void onReconnected(boolean clusterRestarted) {
        Throwable err;
        block6: {
            err = null;
            try {
                this.ctx.disconnected(false);
                GridCompoundFuture curReconnectFut = this.reconnectState.curReconnectFut = new GridCompoundFuture();
                this.reconnectState.reconnectDone = new GridFutureAdapter();
                for (GridComponent comp : this.ctx.components()) {
                    IgniteInternalFuture<?> fut = comp.onReconnected(clusterRestarted);
                    if (fut == null) continue;
                    curReconnectFut.add(fut);
                }
                curReconnectFut.add(this.ctx.cache().context().exchange().reconnectExchangeFuture());
                curReconnectFut.markInitialized();
                final GridFutureAdapter reconnectDone = this.reconnectState.reconnectDone;
                curReconnectFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        try {
                            Object res = fut.get();
                            if (res == STOP_RECONNECT) {
                                return;
                            }
                            IgniteKernal.this.ctx.gateway().onReconnected();
                            IgniteKernal.this.reconnectState.firstReconnectFut.onDone();
                        }
                        catch (IgniteCheckedException e) {
                            if (!X.hasCause(e, IgniteNeedReconnectException.class, IgniteClientDisconnectedCheckedException.class, IgniteInterruptedCheckedException.class)) {
                                U.error(IgniteKernal.this.log, "Failed to reconnect, will stop node.", e);
                                IgniteKernal.this.reconnectState.firstReconnectFut.onDone(e);
                                IgniteKernal.this.close();
                            } else {
                                assert (IgniteKernal.this.ctx.discovery().reconnectSupported());
                                U.error(IgniteKernal.this.log, "Failed to finish reconnect, will retry [locNodeId=" + IgniteKernal.this.ctx.localNodeId() + ", err=" + e.getMessage() + ']');
                            }
                        }
                        finally {
                            reconnectDone.onDone();
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof Error)) break block6;
                throw e;
            }
        }
        if (err != null) {
            U.error(this.log, "Failed to reconnect, will stop node", err);
            if (!X.hasCause(err, NodeStoppingException.class)) {
                this.close();
            }
        }
    }

    private static <T extends GridComponent> T createComponent(Class<T> cls, GridKernalContext ctx) throws IgniteCheckedException {
        Constructor<?> constructor;
        assert (cls.isInterface()) : cls;
        GridComponent comp = (GridComponent)ctx.plugins().createComponent(cls);
        if (comp != null) {
            return (T)comp;
        }
        if (cls.equals(IgniteCacheObjectProcessor.class)) {
            return (T)new CacheObjectBinaryProcessorImpl(ctx);
        }
        if (cls.equals(DiscoveryNodeValidationProcessor.class)) {
            return (T)new OsDiscoveryNodeValidationProcessor(ctx);
        }
        if (cls.equals(IGridClusterStateProcessor.class)) {
            return (T)new GridClusterStateProcessor(ctx);
        }
        Class<?> implCls = null;
        try {
            String clsName = cls.equals(PlatformProcessor.class) ? (ctx.config().getPlatformConfiguration() == null ? PlatformNoopProcessor.class.getName() : cls.getName() + "Impl") : IgniteKernal.componentClassName(cls);
            implCls = Class.forName(clsName);
        }
        catch (ClassNotFoundException clsName) {
            // empty catch block
        }
        if (implCls == null) {
            throw new IgniteCheckedException("Failed to find component implementation: " + cls.getName());
        }
        if (!cls.isAssignableFrom(implCls)) {
            throw new IgniteCheckedException("Component implementation does not implement component interface [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']');
        }
        try {
            constructor = implCls.getConstructor(GridKernalContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteCheckedException("Component does not have expected constructor: " + implCls.getName(), e);
        }
        try {
            return (T)((GridComponent)constructor.newInstance(ctx));
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteCheckedException("Failed to create component [component=" + cls.getName() + ", implementation=" + implCls.getName() + ']', e);
        }
    }

    private static String componentClassName(Class<?> cls) {
        return cls.getPackage().getName() + ".os." + cls.getSimpleName().replace("Grid", "GridOs");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igniteInstanceName = U.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igniteInstanceName);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return IgnitionEx.localIgnite();
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
    }

    private boolean skipDaemon(GridComponent comp) {
        return this.ctx.isDaemon() && U.hasAnnotation(comp.getClass(), SkipDaemon.class);
    }

    @Override
    public void dumpDebugInfo() {
        try {
            ClusterNode locNode;
            GridKernalContextImpl ctx = this.ctx;
            GridDiscoveryManager discoMrg = ctx != null ? ctx.discovery() : null;
            ClusterNode clusterNode = locNode = discoMrg != null ? discoMrg.localNode() : null;
            if (ctx != null && discoMrg != null && locNode != null) {
                boolean client = ctx.clientNode();
                UUID routerId = locNode instanceof TcpDiscoveryNode ? ((TcpDiscoveryNode)locNode).clientRouterNodeId() : null;
                U.warn(ctx.cluster().diagnosticLog(), "Dumping debug info for node [id=" + locNode.id() + ", name=" + ctx.igniteInstanceName() + ", order=" + locNode.order() + ", topVer=" + discoMrg.topologyVersion() + ", client=" + client + (client && routerId != null ? ", routerId=" + routerId : "") + ']');
                ctx.cache().context().exchange().dumpDebugInfo(null);
            } else {
                U.warn(this.log, "Dumping debug info for node, context is not initialized [name=" + this.igniteInstanceName + ']');
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to dump debug info for node: " + e, e);
        }
    }

    public IgniteInternalFuture sendIoTest(ClusterNode node, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(node, payload, procFromNioThread);
    }

    public IgniteInternalFuture sendIoTest(List<ClusterNode> nodes, byte[] payload, boolean procFromNioThread) {
        return this.ctx.io().sendIoTest(nodes, payload, procFromNioThread);
    }

    @Override
    public void runIoTest(long warmup, long duration, int threads, long maxLatency, int rangesCnt, int payLoadSize, boolean procFromNioThread) {
        this.ctx.io().runIoTest(warmup, duration, threads, maxLatency, rangesCnt, payLoadSize, procFromNioThread, new ArrayList<ClusterNode>(this.ctx.cluster().get().forServers().forRemotes().nodes()));
    }

    @Override
    public void clearNodeLocalMap() {
        this.ctx.cluster().get().clearNodeMap();
    }

    public String toString() {
        return S.toString(IgniteKernal.class, this);
    }

    private class MBeansManager {
        private final Set<ObjectName> mBeanNames = new HashSet<ObjectName>();

        private MBeansManager() {
        }

        private void registerAllMBeans(ExecutorService utilityCachePool, ExecutorService execSvc, ExecutorService svcExecSvc, ExecutorService sysExecSvc, StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, ExecutorService igfsExecSvc, StripedExecutor dataStreamExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, ExecutorService qryExecSvc, ExecutorService schemaExecSvc, @Nullable Map<String, ? extends ExecutorService> customExecSvcs, WorkersRegistry workersRegistry) throws IgniteCheckedException {
            if (U.IGNITE_MBEANS_DISABLED) {
                return;
            }
            this.registerMBean("Kernal", IgniteKernal.class.getSimpleName(), IgniteKernal.this, IgniteMXBean.class);
            ClusterLocalNodeMetricsMXBeanImpl locMetricsBean = new ClusterLocalNodeMetricsMXBeanImpl(IgniteKernal.this.ctx.discovery());
            this.registerMBean("Kernal", locMetricsBean.getClass().getSimpleName(), locMetricsBean, ClusterMetricsMXBean.class);
            ClusterMetricsMXBeanImpl metricsBean = new ClusterMetricsMXBeanImpl(IgniteKernal.this.cluster());
            this.registerMBean("Kernal", metricsBean.getClass().getSimpleName(), metricsBean, ClusterMetricsMXBean.class);
            TransactionMetricsMxBeanImpl txMetricsMXBean = new TransactionMetricsMxBeanImpl(IgniteKernal.this.ctx.cache().transactions().metrics());
            this.registerMBean("TransactionMetrics", txMetricsMXBean.getClass().getSimpleName(), txMetricsMXBean, TransactionMetricsMxBean.class);
            TransactionsMXBeanImpl txMXBean = new TransactionsMXBeanImpl(IgniteKernal.this.ctx);
            this.registerMBean("Transactions", txMXBean.getClass().getSimpleName(), txMXBean, TransactionsMXBean.class);
            DataStorageMXBeanImpl dataStorageMXBean = new DataStorageMXBeanImpl(IgniteKernal.this.ctx);
            this.registerMBean("DataStorage", dataStorageMXBean.getClass().getSimpleName(), dataStorageMXBean, DataStorageMXBean.class);
            this.registerExecutorMBean("GridUtilityCacheExecutor", utilityCachePool);
            this.registerExecutorMBean("GridExecutionExecutor", execSvc);
            this.registerExecutorMBean("GridServicesExecutor", svcExecSvc);
            this.registerExecutorMBean("GridSystemExecutor", sysExecSvc);
            this.registerExecutorMBean("GridClassLoadingExecutor", p2pExecSvc);
            this.registerExecutorMBean("GridManagementExecutor", mgmtExecSvc);
            this.registerExecutorMBean("GridIgfsExecutor", igfsExecSvc);
            this.registerExecutorMBean("GridDataStreamExecutor", dataStreamExecSvc);
            this.registerExecutorMBean("GridAffinityExecutor", affExecSvc);
            this.registerExecutorMBean("GridCallbackExecutor", callbackExecSvc);
            this.registerExecutorMBean("GridQueryExecutor", qryExecSvc);
            this.registerExecutorMBean("GridSchemaExecutor", schemaExecSvc);
            if (idxExecSvc != null) {
                this.registerExecutorMBean("GridIndexingExecutor", idxExecSvc);
            }
            if (IgniteKernal.this.cfg.getConnectorConfiguration() != null) {
                this.registerExecutorMBean("GridRestExecutor", restExecSvc);
            }
            if (stripedExecSvc != null) {
                this.registerMBean("Thread Pools", "StripedExecutor", new StripedExecutorMXBeanAdapter(stripedExecSvc), StripedExecutorMXBean.class);
            }
            if (customExecSvcs != null) {
                for (Map.Entry<String, ? extends ExecutorService> entry : customExecSvcs.entrySet()) {
                    this.registerExecutorMBean(entry.getKey(), entry.getValue());
                }
            }
            if (U.IGNITE_TEST_FEATURES_ENABLED) {
                WorkersControlMXBeanImpl workerCtrlMXBean = new WorkersControlMXBeanImpl(workersRegistry);
                this.registerMBean("Kernal", workerCtrlMXBean.getClass().getSimpleName(), workerCtrlMXBean, WorkersControlMXBean.class);
            }
            FailureHandlingMxBeanImpl blockOpCtrlMXBean = new FailureHandlingMxBeanImpl(workersRegistry, IgniteKernal.this.ctx.cache().context().database());
            this.registerMBean("Kernal", blockOpCtrlMXBean.getClass().getSimpleName(), blockOpCtrlMXBean, FailureHandlingMxBean.class);
        }

        private void registerExecutorMBean(String name, ExecutorService exec) throws IgniteCheckedException {
            this.registerMBean("Thread Pools", name, new ThreadPoolMXBeanAdapter(exec), ThreadPoolMXBean.class);
        }

        private <T> void registerMBean(String grp, String name, T impl2, Class<T> itf) throws IgniteCheckedException {
            assert (!U.IGNITE_MBEANS_DISABLED);
            try {
                ObjectName objName = U.registerMBean(IgniteKernal.this.cfg.getMBeanServer(), IgniteKernal.this.cfg.getIgniteInstanceName(), grp, name, impl2, itf);
                if (IgniteKernal.this.log.isDebugEnabled()) {
                    IgniteKernal.this.log.debug("Registered MBean: " + objName);
                }
                this.mBeanNames.add(objName);
            }
            catch (JMException e) {
                throw new IgniteCheckedException("Failed to register MBean " + name, e);
            }
        }

        private boolean unregisterAllMBeans() {
            boolean success = true;
            for (ObjectName name : this.mBeanNames) {
                success = success && this.unregisterMBean(name);
            }
            return success;
        }

        private boolean unregisterMBean(ObjectName mbean) {
            assert (!U.IGNITE_MBEANS_DISABLED);
            try {
                IgniteKernal.this.cfg.getMBeanServer().unregisterMBean(mbean);
                if (IgniteKernal.this.log.isDebugEnabled()) {
                    IgniteKernal.this.log.debug("Unregistered MBean: " + mbean);
                }
                return true;
            }
            catch (JMException e) {
                U.error(IgniteKernal.this.log, "Failed to unregister MBean.", e);
                return false;
            }
        }
    }

    private class ReconnectState {
        private final GridFutureAdapter firstReconnectFut = new GridFutureAdapter();
        private GridCompoundFuture<?, Object> curReconnectFut;
        private GridFutureAdapter<?> reconnectDone;

        private ReconnectState() {
        }

        void waitFirstReconnect() throws IgniteCheckedException {
            this.firstReconnectFut.get();
        }

        void waitPreviousReconnect() {
            if (this.curReconnectFut != null && !this.curReconnectFut.isDone()) {
                assert (this.reconnectDone != null);
                this.curReconnectFut.onDone(STOP_RECONNECT);
                try {
                    this.reconnectDone.get();
                }
                catch (IgniteCheckedException igniteCheckedException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return S.toString(ReconnectState.class, this);
        }
    }
}

