/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.meter;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.netcrusher.core.meter.RateMeter;
import org.netcrusher.core.meter.RateMeterPeriod;

public class RateMeterImpl
implements RateMeter,
Serializable {
    private final long createdMs = this.nowMs();
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong periodCount = new AtomicLong(0L);
    private final AtomicLong periodMarkerNs = new AtomicLong(this.nowNs());

    @Override
    public long getTotalElapsedMs() {
        return Math.max(0L, this.nowMs() - this.createdMs);
    }

    @Override
    public long getTotalCount() {
        return this.totalCount.get();
    }

    @Override
    public RateMeterPeriod getTotal() {
        return new RateMeterPeriod(this.getTotalCount(), this.getTotalElapsedMs());
    }

    @Override
    public RateMeterPeriod getPeriod(boolean reset) {
        long nowNs = this.nowNs();
        long elapsedNs = Math.max(0L, nowNs - this.periodMarkerNs.get());
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsedNs);
        if (reset) {
            this.periodMarkerNs.set(nowNs);
            long count = this.periodCount.getAndSet(0L);
            return new RateMeterPeriod(count, elapsedMs);
        }
        long count = this.periodCount.get();
        return new RateMeterPeriod(count, elapsedMs);
    }

    public void update(long delta) {
        this.totalCount.addAndGet(delta);
        this.periodCount.addAndGet(delta);
    }

    public void increment() {
        this.update(1L);
    }

    public void decrement() {
        this.update(-1L);
    }

    protected long nowNs() {
        return System.nanoTime();
    }

    protected long nowMs() {
        return System.currentTimeMillis();
    }
}

