/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MvccTxRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectsReleaseFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.GridDeferredAckMessageSender;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheMappedVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxFinishSync;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxOnePhaseCommitAckRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.msg.MvccRecoveryFinishedMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxHandler;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxImplicitSingleStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.PartitionCountersNeighborcastFuture;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlock;
import org.apache.ignite.internal.processors.cache.transactions.TxDeadlockDetection;
import org.apache.ignite.internal.processors.cache.transactions.TxLock;
import org.apache.ignite.internal.processors.cache.transactions.TxLocksRequest;
import org.apache.ignite.internal.processors.cache.transactions.TxLocksResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridBoundedConcurrentOrderedMap;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class IgniteTxManager
extends GridCacheSharedManagerAdapter {
    private static final int DFLT_MAX_COMPLETED_TX_CNT = 262144;
    private static final int SLOW_TX_WARN_TIMEOUT = Integer.getInteger("IGNITE_SLOW_TX_WARN_TIMEOUT", 0);
    private static final int TX_SALVAGE_TIMEOUT = Integer.getInteger("IGNITE_TX_SALVAGE_TIMEOUT", 100);
    public static final int DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_TIMEOUT = Integer.getInteger("IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_TIMEOUT", 500);
    private static final int DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_BUFFER_SIZE = Integer.getInteger("IGNITE_DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_BUFFER_SIZE", 256);
    static int DEADLOCK_MAX_ITERS = IgniteSystemProperties.getInteger("IGNITE_TX_DEADLOCK_DETECTION_MAX_ITERS", 1000);
    private final ThreadLocal<IgniteInternalTx> threadCtx = new ThreadLocal();
    private final ThreadLocal<AffinityTopologyVersion> txTop = new ThreadLocal();
    private final ConcurrentMap<Long, IgniteInternalTx> threadMap = GridConcurrentFactory.newMap();
    private final ConcurrentMap<TxThreadKey, IgniteInternalTx> sysThreadMap = GridConcurrentFactory.newMap();
    private final ConcurrentMap<GridCacheVersion, IgniteInternalTx> idMap = GridConcurrentFactory.newMap();
    private final ConcurrentMap<GridCacheVersion, IgniteInternalTx> nearIdMap = GridConcurrentFactory.newMap();
    private final ConcurrentMap<Long, TxDeadlockDetection.TxDeadlockFuture> deadlockDetectFuts = new ConcurrentHashMap<Long, TxDeadlockDetection.TxDeadlockFuture>();
    private IgniteTxHandler txHnd;
    private final GridBoundedConcurrentOrderedMap<GridCacheVersion, Boolean> completedVersSorted = new GridBoundedConcurrentOrderedMap(Integer.getInteger("IGNITE_MAX_COMPLETED_TX_COUNT", 262144));
    private final ConcurrentLinkedHashMap<GridCacheVersion, Object> completedVersHashMap = new ConcurrentLinkedHashMap(Integer.getInteger("IGNITE_MAX_COMPLETED_TX_COUNT", 262144), 0.75f, Runtime.getRuntime().availableProcessors() * 2, Integer.getInteger("IGNITE_MAX_COMPLETED_TX_COUNT", 262144), ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);
    private GridDeferredAckMessageSender deferredAckMsgSnd;
    private GridCacheTxFinishSync txFinishSync;
    private boolean finishSyncDisabled;
    private int slowTxWarnTimeout = SLOW_TX_WARN_TIMEOUT;
    private final ConcurrentMap<GridCacheVersion, GridCacheVersion> mappedVers = new ConcurrentHashMap<GridCacheVersion, GridCacheVersion>(5120);
    private TxDeadlockDetection txDeadlockDetection;
    private boolean logTxRecords;

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.cctx.gridIO().removeMessageListener(GridTopic.TOPIC_TX);
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        this.txFinishSync = new GridCacheTxFinishSync(this.cctx);
        this.txHnd = new IgniteTxHandler(this.cctx);
        this.deferredAckMsgSnd = new GridDeferredAckMessageSender<GridCacheVersion>(this.cctx.time(), this.cctx.kernalContext().closure()){

            @Override
            public int getTimeout() {
                return DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_TIMEOUT;
            }

            @Override
            public int getBufferSize() {
                return DEFERRED_ONE_PHASE_COMMIT_ACK_REQUEST_BUFFER_SIZE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish(UUID nodeId, Collection<GridCacheVersion> vers) {
                GridDhtTxOnePhaseCommitAckRequest ackReq = new GridDhtTxOnePhaseCommitAckRequest(vers);
                IgniteTxManager.this.cctx.kernalContext().gateway().readLock();
                try {
                    IgniteTxManager.this.cctx.io().send(nodeId, (GridCacheMessage)ackReq, (byte)2);
                }
                catch (ClusterTopologyCheckedException ignored) {
                    if (IgniteTxManager.this.log.isDebugEnabled()) {
                        IgniteTxManager.this.log.debug("Failed to send one phase commit ack to backup node because it left grid: " + nodeId);
                    }
                }
                catch (IgniteCheckedException e) {
                    IgniteTxManager.this.log.error("Failed to send one phase commit ack to backup node [backup=" + nodeId + ']', e);
                }
                finally {
                    IgniteTxManager.this.cctx.kernalContext().gateway().readUnlock();
                }
            }
        };
        this.cctx.gridEvents().addDiscoveryEventListener(new DiscoveryEventListener(){

            @Override
            public void onEvent(DiscoveryEvent evt, DiscoCache discoCache) {
                assert (evt.type() == 12 || evt.type() == 11);
                UUID nodeId = evt.eventNode().id();
                IgniteTxManager.this.cctx.time().addTimeoutObject(new NodeFailureTimeoutObject(evt.eventNode(), discoCache.mvccCoordinator()));
                if (IgniteTxManager.this.txFinishSync != null) {
                    IgniteTxManager.this.txFinishSync.onNodeLeft(nodeId);
                }
                for (TxDeadlockDetection.TxDeadlockFuture txDeadlockFuture : IgniteTxManager.this.deadlockDetectFuts.values()) {
                    txDeadlockFuture.onNodeLeft(nodeId);
                }
                for (Map.Entry entry : IgniteTxManager.this.completedVersHashMap.entrySet()) {
                    Object obj = entry.getValue();
                    if (!(obj instanceof GridCacheReturnCompletableWrapper) || !nodeId.equals(((GridCacheReturnCompletableWrapper)obj).nodeId())) continue;
                    IgniteTxManager.this.removeTxReturn((GridCacheVersion)entry.getKey());
                }
            }
        }, 12, 11);
        this.txDeadlockDetection = new TxDeadlockDetection(this.cctx);
        this.cctx.gridIO().addMessageListener(GridTopic.TOPIC_TX, (GridMessageListener)new DeadlockDetectionListener());
        this.logTxRecords = IgniteSystemProperties.getBoolean("IGNITE_WAL_LOG_TX_RECORDS", false);
    }

    public void rollbackTransactionsForCache(int cacheId) {
        this.rollbackTransactionsForCache(cacheId, this.nearIdMap);
        this.rollbackTransactionsForCache(cacheId, this.idMap);
    }

    public void rollbackOnTopologyChange(AffinityTopologyVersion topVer) {
        for (IgniteInternalTx tx : this.activeTransactions()) {
            if (!tx.local() || !tx.near() || !this.needWaitTransaction(tx, topVer)) continue;
            U.warn(this.log, "The transaction was forcibly rolled back on partition map exchange because a timeout is reached: [tx=" + CU.txString(tx) + ", topVer=" + topVer + ']');
            ((GridNearTxLocal)tx).rollbackNearTxLocalAsync(false, false);
        }
    }

    public void rollbackMvccTxOnCoordinatorChange() {
        for (IgniteInternalTx tx : this.activeTransactions()) {
            if (tx.mvccSnapshot() == null) continue;
            ((GridNearTxLocal)tx).rollbackNearTxLocalAsync(false, false);
        }
    }

    private void rollbackTransactionsForCache(int cacheId, ConcurrentMap<?, IgniteInternalTx> txMap) {
        block0: for (Map.Entry e : txMap.entrySet()) {
            IgniteInternalTx tx = (IgniteInternalTx)e.getValue();
            for (IgniteTxEntry entry : tx.allEntries()) {
                if (entry.cacheId() != cacheId) continue;
                this.rollbackTx(tx, false, false);
                continue block0;
            }
        }
    }

    @Override
    public void onDisconnected(IgniteFuture reconnectFut) {
        this.txFinishSync.onDisconnected(reconnectFut);
        for (IgniteInternalTx tx : this.idMap.values()) {
            this.rollbackTx(tx, true, false);
            tx.state(TransactionState.ROLLING_BACK);
            tx.state(TransactionState.ROLLED_BACK);
        }
        for (IgniteInternalTx tx : this.nearIdMap.values()) {
            this.rollbackTx(tx, true, false);
            tx.state(TransactionState.ROLLING_BACK);
            tx.state(TransactionState.ROLLED_BACK);
        }
        IgniteClientDisconnectedException err = new IgniteClientDisconnectedException(reconnectFut, "Client node disconnected.");
        for (TxDeadlockDetection.TxDeadlockFuture fut : this.deadlockDetectFuts.values()) {
            fut.onDone(err);
        }
    }

    public IgniteTxHandler txHandler() {
        return this.txHnd;
    }

    public void salvageTx(IgniteInternalTx tx) {
        this.salvageTx(tx, IgniteInternalTx.FinalizationStatus.USER_FINISH);
    }

    private void salvageTx(IgniteInternalTx tx, IgniteInternalTx.FinalizationStatus status) {
        assert (tx != null);
        TransactionState state = tx.state();
        if (state == TransactionState.ACTIVE || state == TransactionState.PREPARING || state == TransactionState.PREPARED || state == TransactionState.MARKED_ROLLBACK) {
            if (!tx.markFinalizing(status)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Will not try to commit invalidate transaction (could not mark finalized): " + tx);
                }
                return;
            }
            tx.salvageTx();
            if (this.log.isInfoEnabled()) {
                this.log.info("Invalidated transaction because originating node left grid: " + CU.txString(tx));
            }
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Transaction manager memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>   threadMapSize: " + this.threadMap.size(), new Object[0]);
        X.println(">>>   idMap [size=" + this.idMap.size() + ']', new Object[0]);
        X.println(">>>   nearIdMap [size=" + this.nearIdMap.size() + ']', new Object[0]);
        X.println(">>>   completedVersSortedSize: " + this.completedVersSorted.size(), new Object[0]);
        X.println(">>>   completedVersHashMapSize: " + this.completedVersHashMap.sizex(), new Object[0]);
    }

    public int threadMapSize() {
        return this.threadMap.size();
    }

    public int idMapSize() {
        return this.idMap.size();
    }

    public int completedVersionsSize() {
        return this.completedVersHashMap.size();
    }

    private boolean isCompleted(IgniteInternalTx tx) {
        boolean completed = this.completedVersHashMap.containsKey(tx.xidVersion());
        if (!completed && tx.local() && tx.dht()) {
            return this.completedVersHashMap.containsKey(tx.nearXidVersion());
        }
        return completed;
    }

    public GridNearTxLocal newTx(boolean implicit, boolean implicitSingle, @Nullable GridCacheContext sysCacheCtx, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean storeEnabled, Boolean mvccOp, int txSize, @Nullable String lb) {
        AffinityTopologyVersion topVer;
        int taskNameHash;
        UUID subjId;
        assert (sysCacheCtx == null || sysCacheCtx.systemTx());
        GridNearTxLocal tx = new GridNearTxLocal(this.cctx, implicit, implicitSingle, sysCacheCtx != null, sysCacheCtx != null ? (byte)sysCacheCtx.ioPolicy() : (byte)2, concurrency, isolation, timeout, storeEnabled, mvccOp, txSize, subjId = null, taskNameHash = this.cctx.kernalContext().job().currentTaskNameHash(), lb);
        if (tx.system() && (topVer = this.cctx.tm().lockedTopologyVersion(Thread.currentThread().getId(), tx)) != null) {
            tx.topologyVersion(topVer);
        }
        return this.onCreated(sysCacheCtx, tx);
    }

    @Nullable
    public <T extends IgniteInternalTx> T onCreated(@Nullable GridCacheContext cacheCtx, T tx) {
        ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap = this.transactionMap(tx);
        this.resetContext();
        if (this.isCompleted(tx)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempt to create a completed transaction (will ignore): " + tx);
            }
            return null;
        }
        IgniteInternalTx t = txIdMap.putIfAbsent(tx.xidVersion(), tx);
        if (t == null) {
            if (tx.local() && !tx.dht()) {
                assert (tx instanceof GridNearTxLocal) : tx;
                if (!tx.implicit()) {
                    if (cacheCtx == null || !cacheCtx.systemTx()) {
                        this.threadMap.put(tx.threadId(), tx);
                    } else {
                        this.sysThreadMap.put(new TxThreadKey(tx.threadId(), cacheCtx.cacheId()), tx);
                    }
                }
                ((GridNearTxLocal)tx).recordStateChangedEvent(129);
            }
            if (tx instanceof GridCacheMappedVersion) {
                GridCacheMappedVersion mapped = (GridCacheMappedVersion)((Object)tx);
                GridCacheVersion from = mapped.mappedVersion();
                if (from != null) {
                    this.mappedVers.put(from, tx.xidVersion());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Added transaction version mapping [from=" + from + ", to=" + tx.xidVersion() + ", tx=" + tx + ']');
                }
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempt to create an existing transaction (will ignore) [newTx=" + tx + ", existingTx=" + t + ']');
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transaction created: " + tx);
        }
        return tx;
    }

    public IgniteInternalFuture<Boolean> finishLocalTxs(AffinityTopologyVersion topVer) {
        CacheObjectsReleaseFuture<IgniteInternalTx, Boolean> res = new CacheObjectsReleaseFuture<IgniteInternalTx, Boolean>("LocalTx", topVer, new IgniteReducer<IgniteInternalTx, Boolean>(){

            @Override
            public boolean collect(IgniteInternalTx e) {
                return true;
            }

            @Override
            public Boolean reduce() {
                return true;
            }
        });
        for (IgniteInternalTx tx : this.activeTransactions()) {
            if (!this.needWaitTransaction(tx, topVer)) continue;
            res.add(tx.finishFuture());
        }
        res.markInitialized();
        return res;
    }

    public IgniteInternalFuture<?> finishAllTxs(IgniteInternalFuture<?> finishLocalTxsFuture, AffinityTopologyVersion topVer) {
        CacheObjectsReleaseFuture finishAllTxsFuture = new CacheObjectsReleaseFuture("AllTx", topVer);
        finishLocalTxsFuture.listen(future -> {
            finishAllTxsFuture.add(this.cctx.mvcc().finishRemoteTxs(topVer));
            finishAllTxsFuture.markInitialized();
        });
        return finishAllTxsFuture;
    }

    public boolean needWaitTransaction(IgniteInternalTx tx, AffinityTopologyVersion topVer) {
        AffinityTopologyVersion txTopVer = tx.topologyVersionSnapshot();
        return txTopVer != null && txTopVer.compareTo(topVer) < 0;
    }

    public boolean onStarted(IgniteInternalTx tx) {
        assert (tx.state() == TransactionState.ACTIVE || tx.isRollbackOnly()) : "Invalid transaction state [locId=" + this.cctx.localNodeId() + ", tx=" + tx + ']';
        if (this.isCompleted(tx)) {
            ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap = this.transactionMap(tx);
            txIdMap.remove(tx.xidVersion(), tx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempt to start a completed transaction (will ignore): " + tx);
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transaction started: " + tx);
        }
        return true;
    }

    public GridCacheVersion mappedVersion(GridCacheVersion from) {
        GridCacheVersion to = (GridCacheVersion)this.mappedVers.get(from);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found mapped version [from=" + from + ", to=" + to);
        }
        return to;
    }

    public void addAlternateVersion(GridCacheVersion ver, IgniteInternalTx tx) {
        if (this.idMap.putIfAbsent(ver, tx) == null && this.log.isDebugEnabled()) {
            this.log.debug("Registered alternate transaction version [ver=" + ver + ", tx=" + tx + ']');
        }
    }

    @Nullable
    public IgniteTxLocalAdapter localTx() {
        IgniteTxLocalAdapter tx = (IgniteTxLocalAdapter)this.tx();
        return tx != null && tx.local() ? tx : null;
    }

    public GridNearTxLocal threadLocalTx(GridCacheContext cctx) {
        IgniteInternalTx tx = (IgniteInternalTx)this.tx(cctx, Thread.currentThread().getId());
        if (tx != null && tx.local() && (!tx.dht() || tx.colocated()) && !tx.implicit()) {
            assert (tx instanceof GridNearTxLocal) : tx;
            return (GridNearTxLocal)tx;
        }
        return null;
    }

    public <T> T tx() {
        IgniteInternalTx tx = this.txContext();
        return (T)(tx != null ? tx : this.tx(null, Thread.currentThread().getId()));
    }

    @Nullable
    public AffinityTopologyVersion lockedTopologyVersion(long threadId, IgniteInternalTx ignore) {
        AffinityTopologyVersion topVer;
        IgniteInternalTx tx = (IgniteInternalTx)this.threadMap.get(threadId);
        if (tx != null && (topVer = tx.topologyVersionSnapshot()) != null) {
            return topVer;
        }
        if (!this.sysThreadMap.isEmpty()) {
            for (GridCacheContext cacheCtx : this.cctx.cache().context().cacheContexts()) {
                AffinityTopologyVersion topVer2;
                if (!cacheCtx.systemTx() || (tx = (IgniteInternalTx)this.sysThreadMap.get(new TxThreadKey(threadId, cacheCtx.cacheId()))) == null || tx == ignore || (topVer2 = tx.topologyVersionSnapshot()) == null) continue;
                return topVer2;
            }
        }
        return this.txTop.get();
    }

    public boolean setTxTopologyHint(@Nullable AffinityTopologyVersion topVer) {
        if (topVer == null) {
            this.txTop.set(null);
        } else if (this.txTop.get() == null) {
            this.txTop.set(topVer);
            return true;
        }
        return false;
    }

    @Nullable
    public GridNearTxLocal userTx() {
        IgniteInternalTx tx = this.txContext();
        if (this.activeUserTx(tx)) {
            return (GridNearTxLocal)tx;
        }
        tx = (IgniteInternalTx)this.tx(null, Thread.currentThread().getId());
        if (this.activeUserTx(tx)) {
            return (GridNearTxLocal)tx;
        }
        return null;
    }

    @Nullable
    GridNearTxLocal userTx(GridCacheContext cctx) {
        IgniteInternalTx tx = (IgniteInternalTx)this.tx(cctx, Thread.currentThread().getId());
        if (this.activeUserTx(tx)) {
            return (GridNearTxLocal)tx;
        }
        return null;
    }

    private boolean activeUserTx(@Nullable IgniteInternalTx tx) {
        if (tx != null && tx.user() && tx.state() == TransactionState.ACTIVE) {
            assert (tx instanceof GridNearTxLocal) : tx;
            return true;
        }
        return false;
    }

    private <T> T tx(GridCacheContext cctx, long threadId) {
        if (cctx == null || !cctx.systemTx()) {
            return (T)this.threadMap.get(threadId);
        }
        TxThreadKey key = new TxThreadKey(threadId, cctx.cacheId());
        return (T)this.sysThreadMap.get(key);
    }

    public boolean inUserTx() {
        return this.userTx() != null;
    }

    @Nullable
    public <T extends IgniteInternalTx> T tx(GridCacheVersion txId) {
        return (T)((IgniteInternalTx)this.idMap.get(txId));
    }

    @Nullable
    public <T extends IgniteInternalTx> T nearTx(GridCacheVersion txId) {
        return (T)((IgniteInternalTx)this.nearIdMap.get(txId));
    }

    public void prepareTx(IgniteInternalTx tx, @Nullable Collection<IgniteTxEntry> entries) throws IgniteCheckedException {
        if (tx.state() == TransactionState.MARKED_ROLLBACK) {
            if (tx.remainingTime() == -1L) {
                throw new IgniteTxTimeoutCheckedException("Transaction timed out: " + this);
            }
            throw new IgniteCheckedException("Transaction is marked for rollback: " + tx);
        }
        if (tx.remainingTime() == -1L) {
            tx.setRollbackOnly();
            throw new IgniteTxTimeoutCheckedException("Transaction timed out: " + this);
        }
        if (tx.pessimistic() && tx.local()) {
            return;
        }
        assert (tx.optimistic() || !tx.local());
        if (!this.lockMultiple(tx, entries != null ? entries : tx.optimisticLockEntries())) {
            tx.setRollbackOnly();
            throw new IgniteTxOptimisticCheckedException("Failed to prepare transaction (lock conflict): " + tx);
        }
    }

    private void removeObsolete(IgniteInternalTx tx) {
        Collection<IgniteTxEntry> entries = tx.local() ? tx.allEntries() : tx.writeEntries();
        for (IgniteTxEntry entry : entries) {
            GridCacheEntryEx cached = entry.cached();
            GridCacheContext<?, ?> cacheCtx = entry.context();
            if (cached == null) {
                cached = cacheCtx.cache().peekEx(entry.key());
            }
            if (cached.detached()) continue;
            try {
                GridNearCacheAdapter<?, ?> near;
                GridNearCacheEntry e;
                if (cached.obsolete() || cached.markObsoleteIfEmpty(tx.xidVersion())) {
                    cacheCtx.cache().removeEntry(cached);
                }
                if (tx.near() || !GridCacheUtils.isNearEnabled(cacheCtx) || (e = (near = cacheCtx.isNear() ? cacheCtx.near() : cacheCtx.dht().near()).peekExx(entry.key())) == null || !e.markObsoleteIfEmpty(null)) continue;
                near.removeEntry(e);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to remove obsolete entry from cache: " + cached, e);
            }
        }
    }

    public IgnitePair<Collection<GridCacheVersion>> versions(GridCacheVersion min) {
        ArrayList committed = null;
        ArrayList rolledback = null;
        for (Map.Entry e : this.completedVersSorted.tailMap((Object)min, true).entrySet()) {
            if (((Boolean)e.getValue()).booleanValue()) {
                if (committed == null) {
                    committed = new ArrayList();
                }
                committed.add(e.getKey());
                continue;
            }
            if (rolledback == null) {
                rolledback = new ArrayList();
            }
            rolledback.add(e.getKey());
        }
        return new IgnitePair<Collection<GridCacheVersion>>((Collection<GridCacheVersion>)(committed == null ? Collections.emptyList() : committed), (Collection<GridCacheVersion>)(rolledback == null ? Collections.emptyList() : rolledback));
    }

    public Collection<IgniteInternalTx> activeTransactions() {
        return F.concat(false, this.idMap.values(), this.nearIdMap.values());
    }

    public void removeCommittedTx(IgniteInternalTx tx) {
        this.completedVersHashMap.remove(tx.xidVersion(), true);
        if (tx.needsCompletedVersions()) {
            this.completedVersSorted.remove(tx.xidVersion(), true);
        }
    }

    public void addCommittedTx(IgniteInternalTx tx) {
        this.addCommittedTx(tx, tx.xidVersion(), tx.nearXidVersion());
    }

    public void addCommittedTxReturn(IgniteInternalTx tx, GridCacheReturnCompletableWrapper ret) {
        this.addCommittedTxReturn(tx.nearXidVersion(), null, ret);
    }

    public boolean addRolledbackTx(IgniteInternalTx tx) {
        return this.addRolledbackTx(tx, tx.xidVersion());
    }

    public boolean addCommittedTx(IgniteInternalTx tx, GridCacheVersion xidVer, @Nullable GridCacheVersion nearXidVer) {
        Object committed0;
        if (nearXidVer != null) {
            xidVer = new CommittedVersion(xidVer, nearXidVer);
        }
        if ((committed0 = this.completedVersHashMap.putIfAbsent(xidVer, true)) == null && (tx == null || tx.needsCompletedVersions())) {
            Boolean b = this.completedVersSorted.putIfAbsent(xidVer, true);
            assert (b == null);
        }
        Boolean committed = committed0 != null && !committed0.equals(Boolean.FALSE);
        return committed0 == null || committed != false;
    }

    private void addCommittedTxReturn(GridCacheVersion xidVer, @Nullable GridCacheVersion nearXidVer, GridCacheReturnCompletableWrapper retVal) {
        assert (retVal != null);
        if (nearXidVer != null) {
            xidVer = new CommittedVersion(xidVer, nearXidVer);
        }
        Object prev = this.completedVersHashMap.putIfAbsent(xidVer, retVal);
        assert (prev == null || Boolean.FALSE.equals(prev)) : prev;
    }

    public boolean addRolledbackTx(IgniteInternalTx tx, GridCacheVersion xidVer) {
        Object committed0 = this.completedVersHashMap.putIfAbsent(xidVer, false);
        if (committed0 == null && (tx == null || tx.needsCompletedVersions())) {
            Boolean b = this.completedVersSorted.putIfAbsent(xidVer, false);
            assert (b == null);
        }
        Boolean committed = committed0 != null && !committed0.equals(Boolean.FALSE);
        return committed0 == null || committed == false;
    }

    public GridCacheReturnCompletableWrapper getCommittedTxReturn(GridCacheVersion xidVer) {
        Object retVal = this.completedVersHashMap.get(xidVer);
        if (!Boolean.TRUE.equals(retVal)) {
            assert (!Boolean.FALSE.equals(retVal));
            GridCacheReturnCompletableWrapper res = (GridCacheReturnCompletableWrapper)retVal;
            this.removeTxReturn(xidVer);
            return res;
        }
        return null;
    }

    public void removeTxReturn(GridCacheVersion xidVer) {
        Object prev = this.completedVersHashMap.get(xidVer);
        if (prev instanceof GridCacheReturnCompletableWrapper) {
            this.completedVersHashMap.replace(xidVer, prev, true);
        }
    }

    private void processCompletedEntries(IgniteInternalTx tx) {
        if (tx.needsCompletedVersions()) {
            GridCacheVersion min = this.minVersion(tx.readEntries(), tx.xidVersion(), tx);
            min = this.minVersion(tx.writeEntries(), min, tx);
            assert (min != null);
            IgnitePair<Collection<GridCacheVersion>> versPair = this.versions(min);
            tx.completedVersions(min, (Collection)versPair.get1(), (Collection)versPair.get2());
        }
    }

    private void collectPendingVersions(GridDhtTxLocal dhtTxLoc) {
        if (dhtTxLoc.needsCompletedVersions()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Checking for pending locks with version less then tx version: " + dhtTxLoc);
            }
            LinkedHashSet<GridCacheVersion> vers = new LinkedHashSet<GridCacheVersion>();
            this.collectPendingVersions(dhtTxLoc.readEntries(), dhtTxLoc.xidVersion(), vers);
            this.collectPendingVersions(dhtTxLoc.writeEntries(), dhtTxLoc.xidVersion(), vers);
            if (!vers.isEmpty()) {
                dhtTxLoc.pendingVersions(vers);
            }
        }
    }

    private void collectPendingVersions(Iterable<IgniteTxEntry> entries, GridCacheVersion baseVer, Set<GridCacheVersion> vers) {
        for (IgniteTxEntry txEntry : entries) {
            GridCacheEntryEx cached = txEntry.cached();
            try {
                if (cached.obsolete()) continue;
                for (GridCacheMvccCandidate cand : cached.localCandidates(new GridCacheVersion[0])) {
                    if (cand.owner() || cand.version().compareTo(baseVer) >= 0) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Adding candidate version to pending set: " + cand);
                    }
                    vers.add(cand.version());
                }
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("There are no pending locks for entry (entry was deleted in transaction): " + txEntry);
            }
        }
    }

    private GridCacheVersion minVersion(Iterable<IgniteTxEntry> entries, GridCacheVersion min, IgniteInternalTx tx) {
        for (IgniteTxEntry txEntry : entries) {
            GridCacheEntryEx cached = txEntry.cached();
            assert (txEntry.isRead() || !cached.obsolete(tx.xidVersion())) : "Invalid obsolete version for transaction [entry=" + cached + ", tx=" + tx + ']';
            for (GridCacheMvccCandidate cand : cached.remoteMvccSnapshot(new GridCacheVersion[0])) {
                if (min != null && !cand.version().isLess(min)) continue;
                min = cand.version();
            }
        }
        return min;
    }

    private boolean unlockReadEntries(IgniteInternalTx tx) {
        if (tx.pessimistic()) {
            return !tx.readCommitted();
        }
        return tx.serializable();
    }

    public void commitTx(IgniteInternalTx tx) throws IgniteCheckedException {
        Object committed0;
        Boolean committed;
        assert (tx != null);
        assert (tx.state() == TransactionState.COMMITTING) : "Invalid transaction state for commit from tm [state=" + (Object)((Object)tx.state()) + ", expected=COMMITTING, tx=" + tx + ']';
        if (this.log.isDebugEnabled()) {
            this.log.debug("Committing from TM [locNodeId=" + this.cctx.localNodeId() + ", tx=" + tx + ']');
        }
        if (!((committed = Boolean.valueOf((committed0 = this.completedVersHashMap.get(tx.xidVersion())) != null && !committed0.equals(Boolean.FALSE))).booleanValue() || tx.writeSet().isEmpty() || tx.isSystemInvalidate())) {
            this.uncommitTx(tx);
            tx.errorWhenCommitting();
            throw new IgniteCheckedException("Missing commit version (consider increasing IGNITE_MAX_COMPLETED_TX_COUNT system property) [ver=" + tx.xidVersion() + ", committed0=" + committed0 + ", tx=" + tx.getClass().getSimpleName() + ']');
        }
        ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap = this.transactionMap(tx);
        if (txIdMap.remove(tx.xidVersion(), tx)) {
            GridCacheVersion mapped;
            this.processCompletedEntries(tx);
            if (tx instanceof GridDhtTxLocal) {
                GridDhtTxLocal dhtTxLoc = (GridDhtTxLocal)tx;
                this.collectPendingVersions(dhtTxLoc);
            }
            this.unlockMultiple(tx, tx.writeEntries());
            if (this.unlockReadEntries(tx)) {
                this.unlockMultiple(tx, tx.readEntries());
            }
            this.notifyEvictions(tx);
            this.removeObsolete(tx);
            tx.endVersion(this.cctx.versions().next(tx.topologyVersion()));
            this.clearThreadMap(tx);
            if (!tx.alternateVersions().isEmpty()) {
                for (GridCacheVersion ver : tx.alternateVersions()) {
                    this.idMap.remove(ver);
                }
            }
            if (tx instanceof GridCacheMappedVersion && (mapped = ((GridCacheMappedVersion)((Object)tx)).mappedVersion()) != null) {
                this.mappedVers.remove(mapped);
            }
            this.resetContext();
            if (!tx.dht() && tx.local()) {
                if (!tx.system()) {
                    this.cctx.txMetrics().onTxCommit();
                }
                tx.txState().onTxEnd(this.cctx, tx, true);
            }
            if (this.slowTxWarnTimeout > 0 && tx.local() && U.currentTimeMillis() - tx.startTime() > (long)this.slowTxWarnTimeout) {
                U.warn(this.log, "Slow transaction detected [tx=" + tx + ", slowTxWarnTimeout=" + this.slowTxWarnTimeout + ']');
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Committed from TM [locNodeId=" + this.cctx.localNodeId() + ", tx=" + tx + ']');
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Did not commit from TM (was already committed): " + tx);
        }
    }

    public void rollbackTx(IgniteInternalTx tx, boolean clearThreadMap, boolean skipCompletedVers) {
        ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap;
        assert (tx != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Rolling back from TM [locNodeId=" + this.cctx.localNodeId() + ", tx=" + tx + ']');
        }
        if (!skipCompletedVers) {
            this.addRolledbackTx(tx);
        }
        if ((txIdMap = this.transactionMap(tx)).remove(tx.xidVersion(), tx)) {
            this.unlockMultiple(tx, tx.writeEntries());
            if (this.unlockReadEntries(tx)) {
                this.unlockMultiple(tx, tx.readEntries());
            }
            this.notifyEvictions(tx);
            this.removeObsolete(tx);
            if (clearThreadMap) {
                this.clearThreadMap(tx);
            }
            if (!tx.alternateVersions().isEmpty()) {
                for (GridCacheVersion ver : tx.alternateVersions()) {
                    this.idMap.remove(ver);
                }
            }
            if (tx instanceof GridCacheMappedVersion) {
                this.mappedVers.remove(((GridCacheMappedVersion)((Object)tx)).mappedVersion());
            }
            this.resetContext();
            if (!tx.dht() && tx.local()) {
                if (!tx.system()) {
                    this.cctx.txMetrics().onTxRollback();
                }
                tx.txState().onTxEnd(this.cctx, tx, false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rolled back from TM: " + tx);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Did not rollback from TM (was already rolled back): " + tx);
        }
    }

    public void fastFinishTx(GridNearTxLocal tx, boolean commit, boolean clearThreadMap) {
        assert (tx != null);
        tx.writeMap().isEmpty();
        assert (tx.optimistic() || tx.readMap().isEmpty());
        ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap = this.transactionMap(tx);
        if (txIdMap.remove(tx.xidVersion(), tx)) {
            this.notifyEvictions(tx);
            if (!tx.readMap().isEmpty()) {
                for (IgniteTxEntry entry : tx.readMap().values()) {
                    tx.evictNearEntry(entry, false);
                }
            }
            this.removeObsolete(tx);
            if (clearThreadMap) {
                this.clearThreadMap(tx);
            }
            this.resetContext();
            if (!tx.dht() && tx.local()) {
                if (!tx.system()) {
                    if (commit) {
                        this.cctx.txMetrics().onTxCommit();
                    } else {
                        this.cctx.txMetrics().onTxRollback();
                    }
                }
                tx.txState().onTxEnd(this.cctx, tx, commit);
            }
        }
    }

    void uncommitTx(IgniteInternalTx tx) {
        ConcurrentMap<GridCacheVersion, IgniteInternalTx> txIdMap;
        assert (tx != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Uncommiting from TM: " + tx);
        }
        if ((txIdMap = this.transactionMap(tx)).remove(tx.xidVersion(), tx)) {
            this.unlockMultiple(tx, tx.writeEntries());
            if (this.unlockReadEntries(tx)) {
                this.unlockMultiple(tx, tx.readEntries());
            }
            this.notifyEvictions(tx);
            this.clearThreadMap(tx);
            if (!tx.alternateVersions().isEmpty()) {
                for (GridCacheVersion ver : tx.alternateVersions()) {
                    this.idMap.remove(ver);
                }
            }
            if (tx instanceof GridCacheMappedVersion) {
                this.mappedVers.remove(((GridCacheMappedVersion)((Object)tx)).mappedVersion());
            }
            this.resetContext();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Uncommitted from TM: " + tx);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Did not uncommit from TM (was already committed or rolled back): " + tx);
        }
    }

    public void clearThreadMap(IgniteInternalTx tx) {
        if (tx.local() && !tx.dht()) {
            assert (tx instanceof GridNearTxLocal) : tx;
            if (!tx.system()) {
                this.threadMap.remove(tx.threadId(), tx);
            } else {
                Integer cacheId = tx.txState().firstCacheId();
                if (cacheId != null) {
                    this.sysThreadMap.remove(new TxThreadKey(tx.threadId(), cacheId), tx);
                } else {
                    Iterator it = this.sysThreadMap.values().iterator();
                    while (it.hasNext()) {
                        IgniteInternalTx txx = (IgniteInternalTx)it.next();
                        if (tx != txx) continue;
                        it.remove();
                        break;
                    }
                }
            }
        }
    }

    private ConcurrentMap<GridCacheVersion, IgniteInternalTx> transactionMap(IgniteInternalTx tx) {
        return tx.near() && !tx.local() ? this.nearIdMap : this.idMap;
    }

    private void notifyEvictions(IgniteInternalTx tx) {
        if (tx.internal()) {
            return;
        }
        for (IgniteTxEntry txEntry : tx.allEntries()) {
            txEntry.cached().context().evicts().touch(txEntry, tx.local());
        }
    }

    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (owner != null) {
            IgniteTxAdapter tx = (IgniteTxAdapter)this.tx(owner.version());
            if (tx == null) {
                tx = (IgniteTxAdapter)this.nearTx(owner.version());
            }
            if (tx != null) {
                if (!tx.local()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Found transaction for owner changed event [owner=" + owner + ", entry=" + entry + ", tx=" + tx + ']');
                    }
                    tx.onOwnerChanged(entry, owner);
                    return true;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Ignoring local transaction for owner change event: " + tx);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Transaction not found for owner changed event [owner=" + owner + ", entry=" + entry + ']');
            }
        }
        return false;
    }

    public void beforeFinishRemote(UUID rmtNodeId, long threadId) {
        if (this.finishSyncDisabled) {
            return;
        }
        assert (this.txFinishSync != null);
        this.txFinishSync.onFinishSend(rmtNodeId, threadId);
    }

    public void onFinishedRemote(UUID rmtNodeId, long threadId) {
        if (this.finishSyncDisabled) {
            return;
        }
        assert (this.txFinishSync != null);
        this.txFinishSync.onAckReceived(rmtNodeId, threadId);
    }

    @Nullable
    public IgniteInternalFuture<?> awaitFinishAckAsync(UUID rmtNodeId, long threadId) {
        if (this.finishSyncDisabled) {
            return null;
        }
        assert (this.txFinishSync != null);
        return this.txFinishSync.awaitAckAsync(rmtNodeId, threadId);
    }

    public void finishSyncDisabled(boolean finishSyncDisabled) {
        this.finishSyncDisabled = finishSyncDisabled;
    }

    /*
     * Loose catch block
     */
    private boolean lockMultiple(IgniteInternalTx tx, Iterable<IgniteTxEntry> entries) throws IgniteCheckedException {
        assert (tx.optimistic() || !tx.local());
        long remainingTime = tx.remainingTime();
        long timeout = remainingTime < 0L ? 0L : remainingTime;
        GridCacheVersion serOrder = tx.serializable() && tx.optimistic() ? tx.nearXidVersion() : null;
        block8: for (IgniteTxEntry txEntry1 : entries) {
            if (!txEntry1.markPrepared() || txEntry1.explicitVersion() != null) continue;
            GridCacheContext<?, ?> cacheCtx = txEntry1.context();
            while (true) {
                this.cctx.database().checkpointReadLock();
                try {
                    GridCacheEntryEx entry1 = txEntry1.cached();
                    assert (entry1 != null) : txEntry1;
                    assert (!entry1.detached()) : "Expected non-detached entry for near transaction [locNodeId=" + this.cctx.localNodeId() + ", entry=" + entry1 + ']';
                    GridCacheVersion serReadVer = txEntry1.entryReadVersion();
                    assert (serReadVer == null || tx.optimistic() && tx.serializable()) : txEntry1;
                    boolean read = serOrder != null && txEntry1.op() == GridCacheOperation.READ;
                    entry1.unswap();
                    if (!entry1.tmLock(tx, timeout, serOrder, serReadVer, read)) {
                        for (IgniteTxEntry txEntry2 : entries) {
                            if (txEntry2 == txEntry1) break;
                            this.txUnlock(tx, txEntry2);
                        }
                        boolean bl = false;
                        this.cctx.database().checkpointReadUnlock();
                        return bl;
                    }
                    this.cctx.database().checkpointReadUnlock();
                    continue block8;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Got removed entry in TM lockMultiple(..) method (will retry): " + txEntry1);
                    }
                    try {
                        txEntry1.cached(cacheCtx.cache().entryEx(txEntry1.key(), tx.topologyVersion()));
                    }
                    catch (GridDhtInvalidPartitionException e) {
                        assert (tx.dht()) : "Received invalid partition for non DHT transaction [tx=" + tx + ", invalidPart=" + e.partition() + ']';
                        tx.addInvalidPartition(cacheCtx, e.partition());
                        this.cctx.database().checkpointReadUnlock();
                        continue block8;
                    }
                    this.cctx.database().checkpointReadUnlock();
                    continue;
                }
                catch (GridDistributedLockCancelledException ignore) {
                    tx.setRollbackOnly();
                    throw new IgniteCheckedException("Entry lock has been cancelled for transaction: " + tx);
                    {
                        catch (Throwable throwable) {
                            this.cctx.database().checkpointReadUnlock();
                            throw throwable;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    private void txUnlock(IgniteInternalTx tx, IgniteTxEntry txEntry) {
        while (true) {
            try {
                GridCacheEntryEx entry = txEntry.cached();
                assert (entry != null);
                if (entry.detached()) break;
                entry.txUnlock(tx);
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Got removed entry in TM txUnlock(..) method (will retry): " + txEntry);
                }
                txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), tx.topologyVersion()));
                continue;
            }
            break;
        }
    }

    private void unlockMultiple(IgniteInternalTx tx, Iterable<IgniteTxEntry> entries) {
        for (IgniteTxEntry txEntry : entries) {
            this.txUnlock(tx, txEntry);
        }
    }

    public void txContext(IgniteInternalTx tx) {
        this.threadCtx.set(tx);
    }

    private IgniteInternalTx txContext() {
        return this.threadCtx.get();
    }

    @Nullable
    public GridCacheVersion txContextVersion() {
        IgniteInternalTx tx = this.txContext();
        return tx == null ? null : tx.xidVersion();
    }

    public void resetContext() {
        this.threadCtx.set(null);
    }

    public int slowTxWarnTimeout() {
        return this.slowTxWarnTimeout;
    }

    public void slowTxWarnTimeout(int slowTxWarnTimeout) {
        this.slowTxWarnTimeout = slowTxWarnTimeout;
    }

    @Nullable
    public IgniteInternalFuture<Boolean> txsPreparedOrCommitted(GridCacheVersion nearVer, int txNum) {
        return this.txsPreparedOrCommitted(nearVer, txNum, null, null);
    }

    public IgniteInternalFuture<Boolean> txCommitted(GridCacheVersion xidVer) {
        final GridFutureAdapter<Boolean> resFut = new GridFutureAdapter<Boolean>();
        final Object tx = this.cctx.tm().tx(xidVer);
        if (tx != null) {
            assert (tx.near() && tx.local()) : tx;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found near transaction, will wait for completion: " + tx);
            }
            tx.finishFuture().listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                @Override
                public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                    TransactionState state = tx.state();
                    if (IgniteTxManager.this.log.isDebugEnabled()) {
                        IgniteTxManager.this.log.debug("Near transaction finished with state: " + (Object)((Object)state));
                    }
                    resFut.onDone(state == TransactionState.COMMITTED);
                }
            });
            return resFut;
        }
        boolean committed = false;
        for (Map.Entry<GridCacheVersion, Object> entry : this.completedVersHashMap.entrySet()) {
            CommittedVersion comm;
            if (!(entry.getKey() instanceof CommittedVersion) || !(comm = (CommittedVersion)entry.getKey()).nearVer.equals(xidVer)) continue;
            committed = !entry.getValue().equals(Boolean.FALSE);
            break;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Near transaction committed: " + committed);
        }
        resFut.onDone(committed);
        return resFut;
    }

    public IgniteInternalFuture<?> remoteTxFinishFuture(GridCacheVersion nearVer) {
        GridCompoundFuture fut = new GridCompoundFuture();
        for (IgniteInternalTx tx : this.activeTransactions()) {
            if (tx.local() || !nearVer.equals(tx.nearXidVersion())) continue;
            fut.add(tx.finishFuture());
        }
        fut.markInitialized();
        return fut;
    }

    @Nullable
    private IgniteInternalFuture<Boolean> txsPreparedOrCommitted(final GridCacheVersion nearVer, int txNum, @Nullable GridFutureAdapter<Boolean> fut, @Nullable Collection<GridCacheVersion> processedVers) {
        for (final IgniteInternalTx igniteInternalTx : this.activeTransactions()) {
            if (!nearVer.equals(igniteInternalTx.nearXidVersion())) continue;
            IgniteInternalFuture<?> prepFut = igniteInternalTx.currentPrepareFuture();
            if (prepFut != null && !prepFut.isDone()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Transaction is preparing (will wait): " + igniteInternalTx);
                }
                final GridFutureAdapter<Boolean> fut0 = fut != null ? fut : new GridFutureAdapter<Boolean>();
                final int txNum0 = txNum;
                final Collection<GridCacheVersion> processedVers0 = processedVers;
                prepFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> prepFut) {
                        if (IgniteTxManager.this.log.isDebugEnabled()) {
                            IgniteTxManager.this.log.debug("Transaction prepare future finished: " + igniteInternalTx);
                        }
                        IgniteInternalFuture fut = IgniteTxManager.this.txsPreparedOrCommitted(nearVer, txNum0, fut0, processedVers0);
                        assert (fut == fut0);
                    }
                });
                return fut0;
            }
            TransactionState state = igniteInternalTx.state();
            if (state == TransactionState.PREPARED || state == TransactionState.COMMITTING || state == TransactionState.COMMITTED) {
                if (--txNum == 0) {
                    if (fut != null) {
                        fut.onDone(true);
                    }
                    return fut;
                }
            } else {
                if (igniteInternalTx.state(TransactionState.MARKED_ROLLBACK) || igniteInternalTx.state() == TransactionState.UNKNOWN) {
                    igniteInternalTx.rollbackAsync();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Transaction was not prepared (rolled back): " + igniteInternalTx);
                    }
                    if (fut == null) {
                        fut = new GridFutureAdapter();
                    }
                    fut.onDone(false);
                    return fut;
                }
                if (igniteInternalTx.state() == TransactionState.COMMITTED) {
                    if (--txNum == 0) {
                        if (fut != null) {
                            fut.onDone(true);
                        }
                        return fut;
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Transaction is not prepared: " + igniteInternalTx);
                    }
                    if (fut == null) {
                        fut = new GridFutureAdapter();
                    }
                    fut.onDone(false);
                    return fut;
                }
            }
            if (processedVers == null) {
                processedVers = new HashSet<GridCacheVersion>(txNum, 1.0f);
            }
            processedVers.add(igniteInternalTx.xidVersion());
        }
        for (Map.Entry entry : this.completedVersHashMap.entrySet()) {
            CommittedVersion commitVer;
            if (entry.getValue().equals(Boolean.FALSE)) continue;
            GridCacheVersion ver = (GridCacheVersion)entry.getKey();
            if (processedVers != null && processedVers.contains(ver) || !(ver instanceof CommittedVersion) || !(commitVer = (CommittedVersion)ver).nearVer.equals(nearVer) || --txNum != 0) continue;
            if (fut != null) {
                fut.onDone(true);
            }
            return fut;
        }
        if (fut == null) {
            fut = new GridFutureAdapter();
        }
        fut.onDone(false);
        return fut;
    }

    public void finishTxOnRecovery(IgniteInternalTx tx, boolean commit) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Finishing prepared transaction [commit=" + commit + ", tx=" + tx + ']');
        }
        if (!tx.markFinalizing(IgniteInternalTx.FinalizationStatus.RECOVERY_FINISH)) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Will not try to commit prepared transaction (could not mark finalized): " + tx);
            }
            return;
        }
        if (tx instanceof IgniteTxRemoteEx) {
            IgniteTxRemoteEx rmtTx = (IgniteTxRemoteEx)tx;
            rmtTx.doneRemote(tx.xidVersion(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (commit) {
            tx.commitAsync().listen(new CommitListener(tx));
        } else if (tx.mvccSnapshot() != null && !tx.local()) {
            this.neighborcastPartitionCountersAndRollback(tx);
        } else {
            tx.rollbackAsync();
        }
    }

    private void neighborcastPartitionCountersAndRollback(IgniteInternalTx tx) {
        TxCounters txCounters = tx.txCounters(false);
        if (txCounters == null || txCounters.updateCounters() == null) {
            tx.rollbackAsync();
        }
        PartitionCountersNeighborcastFuture fut = new PartitionCountersNeighborcastFuture(tx, this.cctx);
        fut.listen(fut0 -> tx.rollbackAsync());
        fut.init();
    }

    public void commitIfPrepared(IgniteInternalTx tx, Set<UUID> failedNodeIds) {
        assert (tx instanceof GridDhtTxLocal || tx instanceof GridDhtTxRemote) : tx;
        assert (!F.isEmpty(tx.transactionNodes())) : tx;
        assert (tx.nearXidVersion() != null) : tx;
        GridCacheTxRecoveryFuture fut = new GridCacheTxRecoveryFuture(this.cctx, tx, failedNodeIds, tx.transactionNodes());
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        if (this.log.isInfoEnabled()) {
            this.log.info("Checking optimistic transaction state on remote nodes [tx=" + tx + ", fut=" + fut + ']');
        }
        fut.prepare();
    }

    public boolean deadlockDetectionEnabled() {
        return DEADLOCK_MAX_ITERS > 0;
    }

    public IgniteInternalFuture<TxDeadlock> detectDeadlock(IgniteInternalTx tx, Set<IgniteTxKey> keys) {
        return this.txDeadlockDetection.detectDeadlock(tx, keys);
    }

    void txLocksInfo(UUID nodeId, TxDeadlockDetection.TxDeadlockFuture fut, Set<IgniteTxKey> txKeys) {
        ClusterNode node = this.cctx.node(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to finish deadlock detection, node left: " + nodeId);
            }
            fut.onDone();
            return;
        }
        TxLocksRequest req = new TxLocksRequest(fut.futureId(), txKeys);
        try {
            if (!this.cctx.localNodeId().equals(nodeId)) {
                req.prepareMarshal(this.cctx);
            }
            this.cctx.gridIO().sendToGridTopic(node, GridTopic.TOPIC_TX, (Message)req, (byte)2);
        }
        catch (IgniteCheckedException e) {
            if (e instanceof ClusterTopologyCheckedException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to finish deadlock detection, node left: " + nodeId);
                }
            } else {
                U.warn(this.log, "Failed to finish deadlock detection: " + e, e);
            }
            fut.onDone();
        }
    }

    private boolean hasKeys(IgniteInternalTx tx, Collection<IgniteTxKey> txKeys) {
        for (IgniteTxKey key : txKeys) {
            if (tx.txState().entry(key) == null) continue;
            return true;
        }
        return false;
    }

    private TxLocksResponse txLocksInfo(Collection<IgniteTxKey> txKeys) {
        TxLocksResponse res = new TxLocksResponse();
        Collection<IgniteInternalTx> txs = this.activeTransactions();
        for (IgniteInternalTx tx : txs) {
            boolean nearTxLoc = tx instanceof GridNearTxLocal;
            if (!nearTxLoc && !(tx instanceof GridDhtTxLocal) || !this.hasKeys(tx, txKeys)) continue;
            IgniteTxState state = tx.txState();
            assert (state instanceof IgniteTxStateImpl || state instanceof IgniteTxImplicitSingleStateImpl);
            Collection<IgniteTxEntry> txEntries = state instanceof IgniteTxStateImpl ? ((IgniteTxStateImpl)state).allEntriesCopy() : state.allEntries();
            Set<IgniteTxKey> requestedKeys = null;
            if (nearTxLoc) {
                GridCompoundFuture fut;
                if (tx.pessimistic()) {
                    Set<IgniteTxKey> nearRequestedKeys;
                    GridNearLockFuture nearFut;
                    fut = (GridDhtColocatedLockFuture)this.mvccFuture(tx, GridDhtColocatedLockFuture.class);
                    if (fut != null) {
                        requestedKeys = ((GridDhtColocatedLockFuture)fut).requestedKeys();
                    }
                    if ((nearFut = (GridNearLockFuture)this.mvccFuture(tx, GridNearLockFuture.class)) != null && (nearRequestedKeys = nearFut.requestedKeys()) != null) {
                        requestedKeys = requestedKeys == null ? nearRequestedKeys : nearRequestedKeys;
                    }
                } else {
                    fut = (GridNearOptimisticTxPrepareFuture)this.mvccFuture(tx, GridNearOptimisticTxPrepareFuture.class);
                    if (fut != null) {
                        requestedKeys = ((GridNearOptimisticTxPrepareFuture)fut).requestedKeys();
                    }
                }
            }
            block1: for (IgniteTxEntry txEntry : txEntries) {
                IgniteTxKey txKey = txEntry.txKey();
                if (res.txLocks(txKey) != null) continue;
                GridCacheMapEntry e = (GridCacheMapEntry)txEntry.cached();
                List<GridCacheMvccCandidate> locs = e.mvccAllLocal();
                if (locs != null) {
                    boolean owner = false;
                    for (GridCacheMvccCandidate loc : locs) {
                        if (!owner && loc.owner() && loc.tx()) {
                            owner = true;
                        }
                        if (!owner) continue block1;
                        if (!loc.tx()) continue;
                        UUID nearNodeId = loc.otherNodeId();
                        GridCacheVersion txId = loc.otherVersion();
                        TxLock txLock = new TxLock(txId == null ? loc.version() : txId, nearNodeId == null ? loc.nodeId() : nearNodeId, loc.threadId(), loc.owner() ? (byte)1 : 2);
                        res.addTxLock(txKey, txLock);
                    }
                    continue;
                }
                if (nearTxLoc && requestedKeys != null && requestedKeys.contains(txKey)) {
                    TxLock txLock = new TxLock(tx.nearXidVersion(), tx.nodeId(), tx.threadId(), 3);
                    res.addTxLock(txKey, txLock);
                    continue;
                }
                res.addKey(txKey);
            }
        }
        return res;
    }

    private IgniteInternalFuture mvccFuture(IgniteInternalTx tx, Class<? extends IgniteInternalFuture> cls) {
        assert (tx instanceof GridNearTxLocal) : tx;
        Collection<GridCacheVersionedFuture<?>> futs = this.cctx.mvcc().futuresForVersion(tx.nearXidVersion());
        if (futs != null) {
            for (GridCacheVersionedFuture<?> fut : futs) {
                if (!fut.getClass().equals(cls)) continue;
                return fut;
            }
        }
        return null;
    }

    public void addFuture(TxDeadlockDetection.TxDeadlockFuture fut) {
        TxDeadlockDetection.TxDeadlockFuture old = this.deadlockDetectFuts.put(fut.futureId(), fut);
        assert (old == null) : old;
    }

    @Nullable
    public TxDeadlockDetection.TxDeadlockFuture future(long futId) {
        return (TxDeadlockDetection.TxDeadlockFuture)this.deadlockDetectFuts.get(futId);
    }

    public void removeFuture(long futId) {
        this.deadlockDetectFuts.remove(futId);
    }

    public void sendDeferredAckResponse(UUID nodeId, GridCacheVersion ver) {
        this.deferredAckMsgSnd.sendDeferredAckMessage(nodeId, ver);
    }

    public Collection<IgniteInternalFuture<?>> deadlockDetectionFutures() {
        Collection<IgniteInternalFuture<?>> values = this.deadlockDetectFuts.values();
        return values;
    }

    public void suspendTx(GridNearTxLocal tx) throws IgniteCheckedException {
        assert (tx != null && !tx.system()) : tx;
        if (!tx.state(TransactionState.SUSPENDED)) {
            throw new IgniteCheckedException("Trying to suspend transaction with incorrect state [expected=" + (Object)((Object)TransactionState.ACTIVE) + ", actual=" + (Object)((Object)tx.state()) + ']');
        }
        this.clearThreadMap(tx);
        this.transactionMap(tx).remove(tx.xidVersion(), tx);
    }

    public void resumeTx(GridNearTxLocal tx, long threadId) throws IgniteCheckedException {
        assert (tx != null && !tx.system()) : tx;
        if (!tx.state(TransactionState.ACTIVE)) {
            throw new IgniteCheckedException("Trying to resume transaction with incorrect state [expected=" + (Object)((Object)TransactionState.SUSPENDED) + ", actual=" + (Object)((Object)tx.state()) + ']');
        }
        assert (!this.threadMap.containsValue(tx)) : tx;
        assert (!this.transactionMap(tx).containsValue(tx)) : tx;
        assert (!this.haveSystemTxForThread(Thread.currentThread().getId()));
        if (this.threadMap.putIfAbsent(threadId, tx) != null) {
            throw new IgniteCheckedException("Thread already has started a transaction.");
        }
        if (this.transactionMap(tx).putIfAbsent(tx.xidVersion(), tx) != null) {
            throw new IgniteCheckedException("Thread already has started a transaction.");
        }
        tx.threadId(threadId);
    }

    private boolean haveSystemTxForThread(long threadId) {
        if (!this.sysThreadMap.isEmpty()) {
            for (GridCacheContext cacheCtx : this.cctx.cache().context().cacheContexts()) {
                if (!cacheCtx.systemTx() || !this.sysThreadMap.containsKey(new TxThreadKey(threadId, cacheCtx.cacheId()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean logTxRecords() {
        return this.logTxRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mvccFinish(IgniteTxAdapter tx, boolean commit) throws IgniteCheckedException {
        if (!(this.cctx.kernalContext().clientNode() || tx.mvccSnapshot == null || tx.near() && tx.remote())) {
            WALPointer ptr = null;
            this.cctx.database().checkpointReadLock();
            try {
                if (this.cctx.wal() != null) {
                    ptr = this.cctx.wal().log(this.newTxRecord(tx));
                }
                this.cctx.coordinators().updateState(tx.mvccSnapshot, commit ? (byte)3 : 2, tx.local());
            }
            finally {
                this.cctx.database().checkpointReadUnlock();
            }
            if (ptr != null) {
                this.cctx.wal().flush(ptr, true);
            }
        }
    }

    public void mvccPrepare(IgniteTxAdapter tx) throws IgniteCheckedException {
        if (!(this.cctx.kernalContext().clientNode() || tx.mvccSnapshot == null || tx.near() && tx.remote())) {
            this.cctx.database().checkpointReadLock();
            try {
                if (this.cctx.wal() != null) {
                    this.cctx.wal().log(this.newTxRecord(tx));
                }
                this.cctx.coordinators().updateState(tx.mvccSnapshot, (byte)1);
            }
            finally {
                this.cctx.database().checkpointReadUnlock();
            }
        }
    }

    @Nullable
    WALPointer logTxRecord(IgniteTxAdapter tx) {
        if (this.cctx.wal() != null && this.logTxRecords) {
            TxRecord txRecord = this.newTxRecord(tx);
            try {
                return this.cctx.wal().log(txRecord);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to log TxRecord: " + txRecord, e);
                throw new IgniteException("Failed to log TxRecord: " + txRecord, e);
            }
        }
        return null;
    }

    private TxRecord newTxRecord(IgniteTxAdapter tx) {
        BaselineTopology baselineTop = this.cctx.kernalContext().state().clusterState().baselineTopology();
        Map<Short, Collection<Short>> nodes = tx.consistentIdMapper.mapToCompactIds(tx.topVer, tx.txNodes, baselineTop);
        if (tx.txState().mvccEnabled()) {
            return new MvccTxRecord(tx.state(), tx.nearXidVersion(), tx.writeVersion(), nodes, tx.mvccSnapshot());
        }
        return new TxRecord(tx.state(), tx.nearXidVersion(), tx.writeVersion(), nodes);
    }

    private class DeadlockDetectionListener
    implements GridMessageListener {
        private DeadlockDetectionListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            GridCacheMessage cacheMsg = (GridCacheMessage)msg;
            Exception err = null;
            try {
                this.unmarshall(nodeId, cacheMsg);
            }
            catch (Exception e) {
                err = e;
            }
            if (err != null || cacheMsg.classError() != null) {
                try {
                    this.processFailedMessage(nodeId, cacheMsg, err);
                    return;
                }
                catch (Throwable e) {
                    U.error(IgniteTxManager.this.log, "Failed to process message [senderId=" + nodeId + ", messageType=" + cacheMsg.getClass() + ']', e);
                    if (!(e instanceof Error)) return;
                    throw (Error)e;
                }
            } else {
                if (IgniteTxManager.this.log.isDebugEnabled()) {
                    IgniteTxManager.this.log.debug("Message received [locNodeId=" + IgniteTxManager.this.cctx.localNodeId() + ", rmtNodeId=" + nodeId + ", msg=" + msg + ']');
                }
                if (msg instanceof TxLocksRequest) {
                    TxLocksRequest req = (TxLocksRequest)msg;
                    TxLocksResponse res = IgniteTxManager.this.txLocksInfo(req.txKeys());
                    res.futureId(req.futureId());
                    try {
                        if (!IgniteTxManager.this.cctx.localNodeId().equals(nodeId)) {
                            res.prepareMarshal(IgniteTxManager.this.cctx);
                        }
                        IgniteTxManager.this.cctx.gridIO().sendToGridTopic(nodeId, GridTopic.TOPIC_TX, (Message)res, (byte)2);
                        return;
                    }
                    catch (ClusterTopologyCheckedException e) {
                        if (!IgniteTxManager.this.log.isDebugEnabled()) return;
                        IgniteTxManager.this.log.debug("Failed to send response, node failed: " + nodeId);
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteTxManager.this.log, "Failed to send response to node [node=" + nodeId + ", res=" + res + ']', e);
                    }
                    return;
                } else {
                    if (!(msg instanceof TxLocksResponse)) throw new IllegalArgumentException("Unknown message [msg=" + msg + ']');
                    TxLocksResponse res = (TxLocksResponse)msg;
                    long futId = res.futureId();
                    TxDeadlockDetection.TxDeadlockFuture fut = IgniteTxManager.this.future(futId);
                    if (fut != null) {
                        fut.onResult(nodeId, res);
                        return;
                    } else {
                        U.warn(IgniteTxManager.this.log, "Unexpected response received " + res);
                    }
                }
            }
        }

        private void processFailedMessage(UUID nodeId, GridCacheMessage msg, Throwable err) throws IgniteCheckedException {
            switch (msg.directType()) {
                case -24: {
                    TxLocksRequest req = (TxLocksRequest)msg;
                    TxLocksResponse res = new TxLocksResponse();
                    res.futureId(req.futureId());
                    try {
                        IgniteTxManager.this.cctx.gridIO().sendToGridTopic(nodeId, GridTopic.TOPIC_TX, (Message)res, (byte)2);
                    }
                    catch (ClusterTopologyCheckedException e) {
                        if (!IgniteTxManager.this.log.isDebugEnabled()) break;
                        IgniteTxManager.this.log.debug("Failed to send response, node failed: " + nodeId);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteTxManager.this.log, "Failed to send response to node (is node still alive?) [nodeId=" + nodeId + ", res=" + res + ']', e);
                    }
                    break;
                }
                case -23: {
                    TxLocksResponse res = (TxLocksResponse)msg;
                    TxDeadlockDetection.TxDeadlockFuture fut = IgniteTxManager.this.future(res.futureId());
                    if (fut == null) {
                        if (IgniteTxManager.this.log.isDebugEnabled()) {
                            IgniteTxManager.this.log.debug("Failed to find future for response [sender=" + nodeId + ", res=" + res + ']');
                        }
                        return;
                    }
                    if (err == null) {
                        fut.onResult(nodeId, res);
                        break;
                    }
                    fut.onDone(null, err);
                    break;
                }
                default: {
                    throw new IgniteCheckedException("Failed to process message. Unsupported direct type [msg=" + msg + ']', msg.classError());
                }
            }
        }

        private void unmarshall(UUID nodeId, GridCacheMessage cacheMsg) {
            if (IgniteTxManager.this.cctx.localNodeId().equals(nodeId)) {
                return;
            }
            try {
                cacheMsg.finishUnmarshal(IgniteTxManager.this.cctx, IgniteTxManager.this.cctx.deploy().globalLoader());
            }
            catch (IgniteCheckedException e) {
                cacheMsg.onClassError(e);
            }
            catch (BinaryObjectException e) {
                cacheMsg.onClassError(new IgniteCheckedException(e));
            }
            catch (Error e) {
                if (cacheMsg.ignoreClassErrors() && X.hasCause(e, NoClassDefFoundError.class, UnsupportedClassVersionError.class)) {
                    cacheMsg.onClassError(new IgniteCheckedException("Failed to load class during unmarshalling: " + e, e));
                }
                throw e;
            }
        }
    }

    private class CommitListener
    implements CI1<IgniteInternalFuture<IgniteInternalTx>> {
        private static final long serialVersionUID = 0L;
        private final IgniteInternalTx tx;

        private CommitListener(IgniteInternalTx tx) {
            this.tx = tx;
        }

        @Override
        public void apply(IgniteInternalFuture<IgniteInternalTx> t) {
            try {
                t.get();
            }
            catch (IgniteTxOptimisticCheckedException ignore) {
                if (IgniteTxManager.this.log.isDebugEnabled()) {
                    IgniteTxManager.this.log.debug("Optimistic failure while committing prepared transaction (will rollback): " + this.tx);
                }
                try {
                    this.tx.rollbackAsync();
                }
                catch (Throwable e) {
                    U.error(IgniteTxManager.this.log, "Failed to automatically rollback transaction: " + this.tx, e);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(IgniteTxManager.this.log, "Failed to commit transaction during failover: " + this.tx, e);
            }
        }
    }

    private static class CommittedVersion
    extends GridCacheVersion {
        private static final long serialVersionUID = 0L;
        private GridCacheVersion nearVer;

        public CommittedVersion() {
        }

        private CommittedVersion(GridCacheVersion ver, GridCacheVersion nearVer) {
            super(ver.topologyVersion(), ver.order(), ver.nodeOrder(), ver.dataCenterId());
            assert (nearVer != null);
            this.nearVer = nearVer;
        }
    }

    private static class TxThreadKey {
        private long threadId;
        private int cacheId;

        private TxThreadKey(long threadId, int cacheId) {
            this.threadId = threadId;
            this.cacheId = cacheId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TxThreadKey)) {
                return false;
            }
            TxThreadKey that = (TxThreadKey)o;
            return this.cacheId == that.cacheId && this.threadId == that.threadId;
        }

        public int hashCode() {
            int res = (int)(this.threadId ^ this.threadId >>> 32);
            res = 31 * res + this.cacheId;
            return res;
        }
    }

    private final class NodeFailureTimeoutObject
    extends GridTimeoutObjectAdapter {
        private final ClusterNode node;
        private final MvccCoordinator mvccCrd;

        private NodeFailureTimeoutObject(ClusterNode node, MvccCoordinator mvccCrd) {
            super(IgniteUuid.fromUuid(IgniteTxManager.this.cctx.localNodeId()), TX_SALVAGE_TIMEOUT);
            this.node = node;
            this.mvccCrd = mvccCrd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTimeout0() {
            try {
                IgniteTxManager.this.cctx.kernalContext().gateway().readLock();
            }
            catch (IllegalStateException | IgniteClientDisconnectedException e) {
                if (IgniteTxManager.this.log.isDebugEnabled()) {
                    IgniteTxManager.this.log.debug("Failed to acquire kernal gateway [err=" + e + ']');
                }
                return;
            }
            UUID evtNodeId = this.node.id();
            try {
                if (IgniteTxManager.this.log.isDebugEnabled()) {
                    IgniteTxManager.this.log.debug("Processing node failed event [locNodeId=" + IgniteTxManager.this.cctx.localNodeId() + ", failedNodeId=" + evtNodeId + ']');
                }
                GridCompoundFuture allTxFinFut = this.node.isClient() && this.mvccCrd != null ? new GridCompoundFuture() : null;
                for (IgniteInternalTx tx : IgniteTxManager.this.activeTransactions()) {
                    if (tx.near() && !tx.local() || tx.storeWriteThrough() && tx.masterNodeIds().contains(evtNodeId)) {
                        IgniteTxManager.this.salvageTx(tx, IgniteInternalTx.FinalizationStatus.RECOVERY_FINISH);
                        continue;
                    }
                    if (tx.originatingNodeId().equals(evtNodeId)) {
                        if (tx.state() == TransactionState.PREPARED) {
                            IgniteTxManager.this.commitIfPrepared(tx, Collections.singleton(evtNodeId));
                        } else {
                            IgniteInternalFuture<?> prepFut = tx.currentPrepareFuture();
                            if (prepFut != null) {
                                prepFut.listen(fut -> {
                                    if (tx.state() == TransactionState.PREPARED) {
                                        IgniteTxManager.this.commitIfPrepared(tx, Collections.singleton(evtNodeId));
                                    } else if (tx.setRollbackOnly()) {
                                        tx.rollbackAsync();
                                    }
                                });
                            } else if (tx.setRollbackOnly()) {
                                tx.rollbackAsync();
                            }
                        }
                    }
                    if (allTxFinFut == null || !tx.eventNodeId().equals(evtNodeId) || tx.mvccSnapshot() == null) continue;
                    allTxFinFut.add(tx.finishFuture());
                }
                if (allTxFinFut == null) {
                    return;
                }
                allTxFinFut.markInitialized();
                allTxFinFut.listen(fut -> {
                    try {
                        IgniteTxManager.this.cctx.kernalContext().io().sendToGridTopic(this.mvccCrd.nodeId(), GridTopic.TOPIC_CACHE_COORDINATOR, (Message)new MvccRecoveryFinishedMessage(evtNodeId), (byte)2);
                    }
                    catch (ClusterTopologyCheckedException e) {
                        if (IgniteTxManager.this.log.isInfoEnabled()) {
                            IgniteTxManager.this.log.info("Mvcc coordinator issued snapshots for recovering transactions has left the cluster (will ignore) [locNodeId=" + IgniteTxManager.this.cctx.localNodeId() + ", failedNodeId=" + evtNodeId + ", mvccCrdNodeId=" + this.mvccCrd.nodeId() + ']');
                        }
                    }
                    catch (IgniteCheckedException e) {
                        IgniteTxManager.this.log.warning("Failed to notify mvcc coordinator that all recovering transactions were finished [locNodeId=" + IgniteTxManager.this.cctx.localNodeId() + ", failedNodeId=" + evtNodeId + ", mvccCrdNodeId=" + this.mvccCrd.nodeId() + ']', e);
                    }
                });
            }
            finally {
                IgniteTxManager.this.cctx.kernalContext().gateway().readUnlock();
            }
        }

        @Override
        public void onTimeout() {
            IgniteTxManager.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    NodeFailureTimeoutObject.this.onTimeout0();
                }
            });
        }
    }
}

